/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.api;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.cyclos.web.rest.api.PhonesApiImpl;
import org.cyclos.web.rest.model.CodeVerificationStatusEnum;
import org.cyclos.web.rest.model.Error;
import org.cyclos.web.rest.model.PasswordInput;
import org.cyclos.web.rest.model.PhoneDataForEdit;
import org.cyclos.web.rest.model.PhoneDataForNew;
import org.cyclos.web.rest.model.PhoneEdit;
import org.cyclos.web.rest.model.PhoneKind;
import org.cyclos.web.rest.model.PhoneNew;
import org.cyclos.web.rest.model.PhoneResult;
import org.cyclos.web.rest.model.PhoneView;
import org.cyclos.web.rest.model.UserPhonesListData;
import org.cyclos.web.utils.ServletHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(produces={"application/json"})
public class PhonesApi {
    @Autowired
    private PhonesApiImpl impl;
    public static final String CREATE_PHONE = "/{user}/phones";
    public static final String DELETE_PHONE = "/phones/{idOrNumber}";
    public static final String DISABLE_PHONE_FOR_SMS = "/phones/{idOrNumber}/disable-for-sms";
    public static final String ENABLE_PHONE_FOR_SMS = "/phones/{idOrNumber}/enable-for-sms";
    public static final String GET_PASSWORD_INPUT_FOR_DISABLE_PHONE_FOR_SMS = "/phones/{idOrNumber}/password-for-disable-sms";
    public static final String GET_PASSWORD_INPUT_FOR_REMOVE_PHONE = "/phones/{idOrNumber}/password-for-remove";
    public static final String GET_PHONE_DATA_FOR_EDIT = "/phones/{idOrNumber}/data-for-edit";
    public static final String GET_PHONE_DATA_FOR_NEW = "/{user}/phones/data-for-new";
    public static final String GET_USER_PHONES_LIST_DATA = "/{user}/phones/list-data";
    public static final String LIST_PHONES_BY_USER = "/{user}/phones";
    public static final String SEND_PHONE_VERIFICATION_CODE = "/phones/{idOrNumber}/send-verification-code";
    public static final String UPDATE_PHONE = "/phones/{idOrNumber}";
    public static final String VERIFY_PHONE = "/phones/{idOrNumber}/verify";
    public static final String VIEW_PHONE = "/phones/{idOrNumber}";

    @RequestMapping(value={"/api/{user:.*}/phones"}, produces={"text/plain", "application/json"}, consumes={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<String> createPhone(@PathVariable(value="user") String string, @RequestBody(required=true) PhoneNew phoneNew, @RequestHeader(value="confirmationPassword", required=false) String string2, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /{user}/phones");
        httpServletRequest.setAttribute("errorType", Error.class);
        return this.impl.createPhone(string, phoneNew, string2);
    }

    @RequestMapping(value={"/api/phones/{idOrNumber}"}, produces={"application/json"}, method={RequestMethod.DELETE})
    public ResponseEntity<Void> deletePhone(@PathVariable(value="idOrNumber") String string, @RequestHeader(value="confirmationPassword", required=false) String string2, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"DELETE /phones/{idOrNumber}");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.deletePhone(string, string2);
    }

    @RequestMapping(value={"/api/phones/{idOrNumber}/disable-for-sms"}, produces={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<Void> disablePhoneForSms(@PathVariable(value="idOrNumber") String string, @RequestHeader(value="confirmationPassword", required=false) String string2, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /phones/{idOrNumber}/disable-for-sms");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.disablePhoneForSms(string, string2);
    }

    @RequestMapping(value={"/api/phones/{idOrNumber}/enable-for-sms"}, produces={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<Void> enablePhoneForSms(@PathVariable(value="idOrNumber") String string, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /phones/{idOrNumber}/enable-for-sms");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.enablePhoneForSms(string);
    }

    @RequestMapping(value={"/api/phones/{idOrNumber}/password-for-disable-sms"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<PasswordInput> getPasswordInputForDisablePhoneForSms(@PathVariable(value="idOrNumber") String string, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /phones/{idOrNumber}/password-for-disable-sms");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.getPasswordInputForDisablePhoneForSms(string, list);
    }

    @RequestMapping(value={"/api/phones/{idOrNumber}/password-for-remove"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<PasswordInput> getPasswordInputForRemovePhone(@PathVariable(value="idOrNumber") String string, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /phones/{idOrNumber}/password-for-remove");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.getPasswordInputForRemovePhone(string, list);
    }

    @RequestMapping(value={"/api/phones/{idOrNumber}/data-for-edit"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<PhoneDataForEdit> getPhoneDataForEdit(@PathVariable(value="idOrNumber") String string, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /phones/{idOrNumber}/data-for-edit");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.getPhoneDataForEdit(string, list);
    }

    @RequestMapping(value={"/api/{user:.*}/phones/data-for-new"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<PhoneDataForNew> getPhoneDataForNew(@PathVariable(value="user") String string, @RequestParam(value="type", required=true) PhoneKind phoneKind, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /{user}/phones/data-for-new");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.getPhoneDataForNew(string, phoneKind, list);
    }

    @RequestMapping(value={"/api/{user:.*}/phones/list-data"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<UserPhonesListData> getUserPhonesListData(@PathVariable(value="user") String string, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /{user}/phones/list-data");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.getUserPhonesListData(string, list);
    }

    @RequestMapping(value={"/api/{user:.*}/phones"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<List<PhoneResult>> listPhonesByUser(@PathVariable(value="user") String string, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /{user}/phones");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.listPhonesByUser(string, list);
    }

    @RequestMapping(value={"/api/phones/{idOrNumber}/send-verification-code"}, produces={"text/plain", "application/json"}, method={RequestMethod.POST})
    public ResponseEntity<String> sendPhoneVerificationCode(@PathVariable(value="idOrNumber") String string, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /phones/{idOrNumber}/send-verification-code");
        httpServletRequest.setAttribute("errorType", Error.class);
        return this.impl.sendPhoneVerificationCode(string);
    }

    @RequestMapping(value={"/api/phones/{idOrNumber}"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.PUT})
    public ResponseEntity<Void> updatePhone(@PathVariable(value="idOrNumber") String string, @RequestBody(required=true) PhoneEdit phoneEdit, @RequestHeader(value="confirmationPassword", required=false) String string2, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"PUT /phones/{idOrNumber}");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.updatePhone(string, phoneEdit, string2);
    }

    @RequestMapping(value={"/api/phones/{idOrNumber}/verify"}, produces={"text/plain", "application/json"}, method={RequestMethod.POST})
    public ResponseEntity<CodeVerificationStatusEnum> verifyPhone(@PathVariable(value="idOrNumber") String string, @RequestParam(value="code", required=true) String string2, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /phones/{idOrNumber}/verify");
        httpServletRequest.setAttribute("errorType", Error.class);
        return this.impl.verifyPhone(string, string2);
    }

    @RequestMapping(value={"/api/phones/{idOrNumber}"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<PhoneView> viewPhone(@PathVariable(value="idOrNumber") String string, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /phones/{idOrNumber}");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.viewPhone(string, list);
    }
}

