/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.api;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.cyclos.web.rest.api.ProductAssignmentApiImpl;
import org.cyclos.web.rest.model.Error;
import org.cyclos.web.rest.model.UserProductAssignmentData;
import org.cyclos.web.utils.ServletHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(produces={"application/json"})
public class ProductAssignmentApi {
    @Autowired
    private ProductAssignmentApiImpl impl;
    public static final String ASSIGN_INDIVIDUAL_PRODUCT = "/{user}/products/{product}";
    public static final String GET_USER_PRODUCTS_DATA = "/{user}/products";
    public static final String UNASSIGN_INDIVIDUAL_PRODUCT = "/{user}/products/{product}";

    @RequestMapping(value={"/api/{user:.*}/products/{product}"}, produces={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<Void> assignIndividualProduct(@PathVariable(value="user") String string, @PathVariable(value="product") String string2, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /{user}/products/{product}");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.assignIndividualProduct(string, string2);
    }

    @RequestMapping(value={"/api/{user:.*}/products"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<UserProductAssignmentData> getUserProductsData(@PathVariable(value="user") String string, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /{user}/products");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.getUserProductsData(string, list);
    }

    @RequestMapping(value={"/api/{user:.*}/products/{product}"}, produces={"application/json"}, method={RequestMethod.DELETE})
    public ResponseEntity<Void> unassignIndividualProduct(@PathVariable(value="user") String string, @PathVariable(value="product") String string2, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"DELETE /{user}/products/{product}");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.unassignIndividualProduct(string, string2);
    }
}

