/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.api;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.cyclos.model.ValidationException;
import org.cyclos.model.utils.PushNotificationEventFilter;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.web.rest.api.BaseApiImpl;
import org.cyclos.web.rest.api.PushApi;
import org.cyclos.web.rest.helpers.PushApiHelper;
import org.cyclos.web.utils.ServletHelper;
import org.cyclos.web.utils.SseEmitterHandler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

@Component
public class PushApiImpl
extends BaseApiImpl {
    public static final Logger LOG = LogManager.getLogger(PushApiImpl.class);
    @Autowired
    private SseEmitterHandler sseEmitterHandler;
    @Autowired
    private PushApiHelper pushApiHelper;

    public ResponseEntity<SseEmitter> subscribeForPushNotifications(PushApi.SubscribeForPushNotificationsParams subscribeForPushNotificationsParams) throws IOException {
        if (CollectionHelper.isEmpty(subscribeForPushNotificationsParams.kinds)) {
            throw new ValidationException("No event kinds specified");
        }
        HttpServletRequest httpServletRequest = ServletHelper.getRequest();
        HttpServletResponse httpServletResponse = ServletHelper.getResponse();
        PushNotificationEventFilter pushNotificationEventFilter = this.pushApiHelper.toPushNotificationEventFilter(subscribeForPushNotificationsParams);
        SseEmitter sseEmitter = this.sseEmitterHandler.subscribe(httpServletRequest, httpServletResponse, subscribeForPushNotificationsParams.clientId, pushNotificationEventFilter, this.pushApiHelper::getData);
        return new ResponseEntity((Object)sseEmitter, HttpStatus.OK);
    }
}

