/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.api;

import java.io.InputStream;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.cyclos.utils.DateTime;
import org.cyclos.web.rest.api.RecordsApiImpl;
import org.cyclos.web.rest.model.Error;
import org.cyclos.web.rest.model.GeneralRecordsDataForSearch;
import org.cyclos.web.rest.model.OwnerRecordData;
import org.cyclos.web.rest.model.PasswordInput;
import org.cyclos.web.rest.model.RecordDataForEdit;
import org.cyclos.web.rest.model.RecordDataForNew;
import org.cyclos.web.rest.model.RecordDataForSearch;
import org.cyclos.web.rest.model.RecordEdit;
import org.cyclos.web.rest.model.RecordNew;
import org.cyclos.web.rest.model.RecordResult;
import org.cyclos.web.rest.model.RecordType;
import org.cyclos.web.rest.model.RecordView;
import org.cyclos.web.rest.model.RecordWithOwnerResult;
import org.cyclos.web.rest.model.SharedRecordsDataForSearch;
import org.cyclos.web.rest.model.UserStatusEnum;
import org.cyclos.web.utils.ServletHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(produces={"application/json"})
public class RecordsApi {
    @Autowired
    private RecordsApiImpl impl;
    public static final String CREATE_RECORD = "/{owner}/records/{type}";
    public static final String DELETE_RECORD = "/records/{id}";
    public static final String EXPORT_GENERAL_RECORDS = "/general-records/{type}/export/{format}";
    public static final String EXPORT_OWNER_RECORDS = "/{owner}/records/{type}/export/{format}";
    public static final String EXPORT_SHARED_RECORDS = "/shared-records/export/{format}";
    public static final String GET_PASSWORD_INPUT_FOR_REMOVE_RECORD = "/records/{id}/password-for-remove";
    public static final String GET_RECORD_DATA_FOR_EDIT = "/records/{id}/data-for-edit";
    public static final String GET_RECORD_DATA_FOR_GENERAL_SEARCH = "/general-records/{type}/data-for-search";
    public static final String GET_RECORD_DATA_FOR_NEW = "/{owner}/records/{type}/data-for-new";
    public static final String GET_RECORD_DATA_FOR_OWNER_SEARCH = "/{owner}/records/{type}/data-for-search";
    public static final String GET_RECORD_DATA_FOR_SHARED_SEARCH = "/shared-records/data-for-search";
    public static final String GET_RECORD_TYPE_BY_OWNER = "/{owner}/record-types/{type}";
    public static final String LIST_RECORD_TYPES_BY_OWNER = "/{owner}/record-types";
    public static final String LIST_RECORD_TYPES_FOR_GENERAL_SEARCH = "/general-records/record-types";
    public static final String SEARCH_GENERAL_RECORDS = "/general-records/{type}";
    public static final String SEARCH_OWNER_RECORDS = "/{owner}/records/{type}";
    public static final String SEARCH_SHARED_RECORDS = "/shared-records";
    public static final String UPDATE_RECORD = "/records/{id}";
    public static final String VIEW_RECORD = "/records/{id}";

    @RequestMapping(value={"/api/{owner:.*}/records/{type}"}, produces={"text/plain", "application/json"}, consumes={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<String> createRecord(@PathVariable(value="owner") String string, @PathVariable(value="type") String string2, @RequestBody(required=true) RecordNew recordNew, @RequestHeader(value="confirmationPassword", required=false) String string3, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /{owner}/records/{type}");
        httpServletRequest.setAttribute("errorType", Error.class);
        CreateRecordParams createRecordParams = new CreateRecordParams();
        createRecordParams.owner = string;
        createRecordParams.type = string2;
        createRecordParams.recordNew = recordNew;
        createRecordParams.confirmationPassword = string3;
        return this.impl.createRecord(createRecordParams);
    }

    @RequestMapping(value={"/api/records/{id}"}, produces={"application/json"}, method={RequestMethod.DELETE})
    public ResponseEntity<Void> deleteRecord(@PathVariable(value="id") String string, @RequestHeader(value="confirmationPassword", required=false) String string2, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"DELETE /records/{id}");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.deleteRecord(string, string2);
    }

    @RequestMapping(value={"/api/general-records/{type}/export/{format}"}, produces={"*/*", "application/json"}, method={RequestMethod.GET})
    public ResponseEntity<InputStream> exportGeneralRecords(@PathVariable(value="type") String string, @PathVariable(value="format") String string2, @RequestParam(value="brokers", required=false) List<String> list, @RequestParam(value="createdBy", required=false) String string3, @RequestParam(value="creationPeriod", required=false) List<DateTime> list2, @RequestParam(value="customFields", required=false) List<String> list3, @RequestParam(value="groups", required=false) List<String> list4, @RequestParam(value="keywords", required=false) String string4, @RequestParam(value="page", required=false) Integer n, @RequestParam(value="pageSize", required=false) Integer n2, @RequestParam(value="profileFields", required=false) List<String> list5, @RequestParam(value="skipTotalCount", required=false) Boolean bl, @RequestParam(value="user", required=false) String string5, @RequestParam(value="userStatuses", required=false) List<UserStatusEnum> list6, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /general-records/{type}/export/{format}");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        ExportGeneralRecordsParams exportGeneralRecordsParams = new ExportGeneralRecordsParams();
        exportGeneralRecordsParams.type = string;
        exportGeneralRecordsParams.format = string2;
        exportGeneralRecordsParams.brokers = list;
        exportGeneralRecordsParams.createdBy = string3;
        exportGeneralRecordsParams.creationPeriod = list2;
        exportGeneralRecordsParams.customFields = list3;
        exportGeneralRecordsParams.groups = list4;
        exportGeneralRecordsParams.keywords = string4;
        exportGeneralRecordsParams.page = n;
        exportGeneralRecordsParams.pageSize = n2;
        exportGeneralRecordsParams.profileFields = list5;
        exportGeneralRecordsParams.skipTotalCount = bl;
        exportGeneralRecordsParams.user = string5;
        exportGeneralRecordsParams.userStatuses = list6;
        return this.impl.exportGeneralRecords(exportGeneralRecordsParams);
    }

    @RequestMapping(value={"/api/{owner:.*}/records/{type}/export/{format}"}, produces={"*/*", "application/json"}, method={RequestMethod.GET})
    public ResponseEntity<InputStream> exportOwnerRecords(@PathVariable(value="owner") String string, @PathVariable(value="type") String string2, @PathVariable(value="format") String string3, @RequestParam(value="createdBy", required=false) String string4, @RequestParam(value="creationPeriod", required=false) List<DateTime> list, @RequestParam(value="customFields", required=false) List<String> list2, @RequestParam(value="keywords", required=false) String string5, @RequestParam(value="page", required=false) Integer n, @RequestParam(value="pageSize", required=false) Integer n2, @RequestParam(value="profileFields", required=false) List<String> list3, @RequestParam(value="skipTotalCount", required=false) Boolean bl, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /{owner}/records/{type}/export/{format}");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        ExportOwnerRecordsParams exportOwnerRecordsParams = new ExportOwnerRecordsParams();
        exportOwnerRecordsParams.owner = string;
        exportOwnerRecordsParams.type = string2;
        exportOwnerRecordsParams.format = string3;
        exportOwnerRecordsParams.createdBy = string4;
        exportOwnerRecordsParams.creationPeriod = list;
        exportOwnerRecordsParams.customFields = list2;
        exportOwnerRecordsParams.keywords = string5;
        exportOwnerRecordsParams.page = n;
        exportOwnerRecordsParams.pageSize = n2;
        exportOwnerRecordsParams.profileFields = list3;
        exportOwnerRecordsParams.skipTotalCount = bl;
        return this.impl.exportOwnerRecords(exportOwnerRecordsParams);
    }

    @RequestMapping(value={"/api/shared-records/export/{format}"}, produces={"*/*", "application/json"}, method={RequestMethod.GET})
    public ResponseEntity<InputStream> exportSharedRecords(@PathVariable(value="format") String string, @RequestParam(value="brokers", required=false) List<String> list, @RequestParam(value="createdBy", required=false) String string2, @RequestParam(value="creationPeriod", required=false) List<DateTime> list2, @RequestParam(value="customFields", required=false) List<String> list3, @RequestParam(value="groups", required=false) List<String> list4, @RequestParam(value="keywords", required=false) String string3, @RequestParam(value="page", required=false) Integer n, @RequestParam(value="pageSize", required=false) Integer n2, @RequestParam(value="profileFields", required=false) List<String> list5, @RequestParam(value="skipTotalCount", required=false) Boolean bl, @RequestParam(value="types", required=false) List<String> list6, @RequestParam(value="user", required=false) String string4, @RequestParam(value="userStatuses", required=false) List<UserStatusEnum> list7, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /shared-records/export/{format}");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        ExportSharedRecordsParams exportSharedRecordsParams = new ExportSharedRecordsParams();
        exportSharedRecordsParams.format = string;
        exportSharedRecordsParams.brokers = list;
        exportSharedRecordsParams.createdBy = string2;
        exportSharedRecordsParams.creationPeriod = list2;
        exportSharedRecordsParams.customFields = list3;
        exportSharedRecordsParams.groups = list4;
        exportSharedRecordsParams.keywords = string3;
        exportSharedRecordsParams.page = n;
        exportSharedRecordsParams.pageSize = n2;
        exportSharedRecordsParams.profileFields = list5;
        exportSharedRecordsParams.skipTotalCount = bl;
        exportSharedRecordsParams.types = list6;
        exportSharedRecordsParams.user = string4;
        exportSharedRecordsParams.userStatuses = list7;
        return this.impl.exportSharedRecords(exportSharedRecordsParams);
    }

    @RequestMapping(value={"/api/records/{id}/password-for-remove"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<PasswordInput> getPasswordInputForRemoveRecord(@PathVariable(value="id") String string, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /records/{id}/password-for-remove");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.getPasswordInputForRemoveRecord(string, list);
    }

    @RequestMapping(value={"/api/records/{id}/data-for-edit"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<RecordDataForEdit> getRecordDataForEdit(@PathVariable(value="id") String string, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /records/{id}/data-for-edit");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.getRecordDataForEdit(string, list);
    }

    @RequestMapping(value={"/api/general-records/{type}/data-for-search"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<GeneralRecordsDataForSearch> getRecordDataForGeneralSearch(@PathVariable(value="type") String string, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /general-records/{type}/data-for-search");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.getRecordDataForGeneralSearch(string, list);
    }

    @RequestMapping(value={"/api/{owner:.*}/records/{type}/data-for-new"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<RecordDataForNew> getRecordDataForNew(@PathVariable(value="owner") String string, @PathVariable(value="type") String string2, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /{owner}/records/{type}/data-for-new");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.getRecordDataForNew(string, string2, list);
    }

    @RequestMapping(value={"/api/{owner:.*}/records/{type}/data-for-search"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<RecordDataForSearch> getRecordDataForOwnerSearch(@PathVariable(value="owner") String string, @PathVariable(value="type") String string2, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /{owner}/records/{type}/data-for-search");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.getRecordDataForOwnerSearch(string, string2, list);
    }

    @RequestMapping(value={"/api/shared-records/data-for-search"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<SharedRecordsDataForSearch> getRecordDataForSharedSearch(@RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /shared-records/data-for-search");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.getRecordDataForSharedSearch(list);
    }

    @RequestMapping(value={"/api/{owner:.*}/record-types/{type}"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<OwnerRecordData> getRecordTypeByOwner(@PathVariable(value="owner") String string, @PathVariable(value="type") String string2, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /{owner}/record-types/{type}");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.getRecordTypeByOwner(string, string2, list);
    }

    @RequestMapping(value={"/api/{owner:.*}/record-types"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<List<OwnerRecordData>> listRecordTypesByOwner(@PathVariable(value="owner") String string, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /{owner}/record-types");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.listRecordTypesByOwner(string, list);
    }

    @RequestMapping(value={"/api/general-records/record-types"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<List<RecordType>> listRecordTypesForGeneralSearch(@RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /general-records/record-types");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.listRecordTypesForGeneralSearch(list);
    }

    @RequestMapping(value={"/api/general-records/{type}"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<List<RecordWithOwnerResult>> searchGeneralRecords(@PathVariable(value="type") String string, @RequestParam(value="fields", required=false) List<String> list, @RequestParam(value="brokers", required=false) List<String> list2, @RequestParam(value="createdBy", required=false) String string2, @RequestParam(value="creationPeriod", required=false) List<DateTime> list3, @RequestParam(value="customFields", required=false) List<String> list4, @RequestParam(value="groups", required=false) List<String> list5, @RequestParam(value="keywords", required=false) String string3, @RequestParam(value="page", required=false) Integer n, @RequestParam(value="pageSize", required=false) Integer n2, @RequestParam(value="profileFields", required=false) List<String> list6, @RequestParam(value="skipTotalCount", required=false) Boolean bl, @RequestParam(value="user", required=false) String string4, @RequestParam(value="userStatuses", required=false) List<UserStatusEnum> list7, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /general-records/{type}");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        SearchGeneralRecordsParams searchGeneralRecordsParams = new SearchGeneralRecordsParams();
        searchGeneralRecordsParams.type = string;
        searchGeneralRecordsParams.fields = list;
        searchGeneralRecordsParams.brokers = list2;
        searchGeneralRecordsParams.createdBy = string2;
        searchGeneralRecordsParams.creationPeriod = list3;
        searchGeneralRecordsParams.customFields = list4;
        searchGeneralRecordsParams.groups = list5;
        searchGeneralRecordsParams.keywords = string3;
        searchGeneralRecordsParams.page = n;
        searchGeneralRecordsParams.pageSize = n2;
        searchGeneralRecordsParams.profileFields = list6;
        searchGeneralRecordsParams.skipTotalCount = bl;
        searchGeneralRecordsParams.user = string4;
        searchGeneralRecordsParams.userStatuses = list7;
        return this.impl.searchGeneralRecords(searchGeneralRecordsParams);
    }

    @RequestMapping(value={"/api/{owner:.*}/records/{type}"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<List<RecordResult>> searchOwnerRecords(@PathVariable(value="owner") String string, @PathVariable(value="type") String string2, @RequestParam(value="fields", required=false) List<String> list, @RequestParam(value="createdBy", required=false) String string3, @RequestParam(value="creationPeriod", required=false) List<DateTime> list2, @RequestParam(value="customFields", required=false) List<String> list3, @RequestParam(value="keywords", required=false) String string4, @RequestParam(value="page", required=false) Integer n, @RequestParam(value="pageSize", required=false) Integer n2, @RequestParam(value="profileFields", required=false) List<String> list4, @RequestParam(value="skipTotalCount", required=false) Boolean bl, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /{owner}/records/{type}");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        SearchOwnerRecordsParams searchOwnerRecordsParams = new SearchOwnerRecordsParams();
        searchOwnerRecordsParams.owner = string;
        searchOwnerRecordsParams.type = string2;
        searchOwnerRecordsParams.fields = list;
        searchOwnerRecordsParams.createdBy = string3;
        searchOwnerRecordsParams.creationPeriod = list2;
        searchOwnerRecordsParams.customFields = list3;
        searchOwnerRecordsParams.keywords = string4;
        searchOwnerRecordsParams.page = n;
        searchOwnerRecordsParams.pageSize = n2;
        searchOwnerRecordsParams.profileFields = list4;
        searchOwnerRecordsParams.skipTotalCount = bl;
        return this.impl.searchOwnerRecords(searchOwnerRecordsParams);
    }

    @RequestMapping(value={"/api/shared-records"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<List<RecordWithOwnerResult>> searchSharedRecords(@RequestParam(value="fields", required=false) List<String> list, @RequestParam(value="brokers", required=false) List<String> list2, @RequestParam(value="createdBy", required=false) String string, @RequestParam(value="creationPeriod", required=false) List<DateTime> list3, @RequestParam(value="customFields", required=false) List<String> list4, @RequestParam(value="groups", required=false) List<String> list5, @RequestParam(value="keywords", required=false) String string2, @RequestParam(value="page", required=false) Integer n, @RequestParam(value="pageSize", required=false) Integer n2, @RequestParam(value="profileFields", required=false) List<String> list6, @RequestParam(value="skipTotalCount", required=false) Boolean bl, @RequestParam(value="types", required=false) List<String> list7, @RequestParam(value="user", required=false) String string3, @RequestParam(value="userStatuses", required=false) List<UserStatusEnum> list8, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /shared-records");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        SearchSharedRecordsParams searchSharedRecordsParams = new SearchSharedRecordsParams();
        searchSharedRecordsParams.fields = list;
        searchSharedRecordsParams.brokers = list2;
        searchSharedRecordsParams.createdBy = string;
        searchSharedRecordsParams.creationPeriod = list3;
        searchSharedRecordsParams.customFields = list4;
        searchSharedRecordsParams.groups = list5;
        searchSharedRecordsParams.keywords = string2;
        searchSharedRecordsParams.page = n;
        searchSharedRecordsParams.pageSize = n2;
        searchSharedRecordsParams.profileFields = list6;
        searchSharedRecordsParams.skipTotalCount = bl;
        searchSharedRecordsParams.types = list7;
        searchSharedRecordsParams.user = string3;
        searchSharedRecordsParams.userStatuses = list8;
        return this.impl.searchSharedRecords(searchSharedRecordsParams);
    }

    @RequestMapping(value={"/api/records/{id}"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.PUT})
    public ResponseEntity<Void> updateRecord(@PathVariable(value="id") String string, @RequestBody(required=true) RecordEdit recordEdit, @RequestHeader(value="confirmationPassword", required=false) String string2, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"PUT /records/{id}");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.updateRecord(string, recordEdit, string2);
    }

    @RequestMapping(value={"/api/records/{id}"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<RecordView> viewRecord(@PathVariable(value="id") String string, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /records/{id}");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.viewRecord(string, list);
    }

    public static class CreateRecordParams {
        public String owner;
        public static final String OWNER = "owner";
        public String type;
        public static final String TYPE = "type";
        public RecordNew recordNew;
        public static final String RECORD_NEW = "recordNew";
        public String confirmationPassword;
        public static final String CONFIRMATION_PASSWORD = "confirmationPassword";
    }

    public static class ExportGeneralRecordsParams {
        public String type;
        public static final String TYPE = "type";
        public String format;
        public static final String FORMAT = "format";
        public List<String> brokers;
        public static final String BROKERS = "brokers";
        public String createdBy;
        public static final String CREATED_BY = "createdBy";
        public List<DateTime> creationPeriod;
        public static final String CREATION_PERIOD = "creationPeriod";
        public List<String> customFields;
        public static final String CUSTOM_FIELDS = "customFields";
        public List<String> groups;
        public static final String GROUPS = "groups";
        public String keywords;
        public static final String KEYWORDS = "keywords";
        public Integer page;
        public static final String PAGE = "page";
        public Integer pageSize;
        public static final String PAGE_SIZE = "pageSize";
        public List<String> profileFields;
        public static final String PROFILE_FIELDS = "profileFields";
        public Boolean skipTotalCount;
        public static final String SKIP_TOTAL_COUNT = "skipTotalCount";
        public String user;
        public static final String USER = "user";
        public List<UserStatusEnum> userStatuses;
        public static final String USER_STATUSES = "userStatuses";
    }

    public static class ExportOwnerRecordsParams {
        public String owner;
        public static final String OWNER = "owner";
        public String type;
        public static final String TYPE = "type";
        public String format;
        public static final String FORMAT = "format";
        public String createdBy;
        public static final String CREATED_BY = "createdBy";
        public List<DateTime> creationPeriod;
        public static final String CREATION_PERIOD = "creationPeriod";
        public List<String> customFields;
        public static final String CUSTOM_FIELDS = "customFields";
        public String keywords;
        public static final String KEYWORDS = "keywords";
        public Integer page;
        public static final String PAGE = "page";
        public Integer pageSize;
        public static final String PAGE_SIZE = "pageSize";
        public List<String> profileFields;
        public static final String PROFILE_FIELDS = "profileFields";
        public Boolean skipTotalCount;
        public static final String SKIP_TOTAL_COUNT = "skipTotalCount";
    }

    public static class ExportSharedRecordsParams {
        public String format;
        public static final String FORMAT = "format";
        public List<String> brokers;
        public static final String BROKERS = "brokers";
        public String createdBy;
        public static final String CREATED_BY = "createdBy";
        public List<DateTime> creationPeriod;
        public static final String CREATION_PERIOD = "creationPeriod";
        public List<String> customFields;
        public static final String CUSTOM_FIELDS = "customFields";
        public List<String> groups;
        public static final String GROUPS = "groups";
        public String keywords;
        public static final String KEYWORDS = "keywords";
        public Integer page;
        public static final String PAGE = "page";
        public Integer pageSize;
        public static final String PAGE_SIZE = "pageSize";
        public List<String> profileFields;
        public static final String PROFILE_FIELDS = "profileFields";
        public Boolean skipTotalCount;
        public static final String SKIP_TOTAL_COUNT = "skipTotalCount";
        public List<String> types;
        public static final String TYPES = "types";
        public String user;
        public static final String USER = "user";
        public List<UserStatusEnum> userStatuses;
        public static final String USER_STATUSES = "userStatuses";
    }

    public static class SearchGeneralRecordsParams {
        public String type;
        public static final String TYPE = "type";
        public List<String> fields;
        public static final String FIELDS = "fields";
        public List<String> brokers;
        public static final String BROKERS = "brokers";
        public String createdBy;
        public static final String CREATED_BY = "createdBy";
        public List<DateTime> creationPeriod;
        public static final String CREATION_PERIOD = "creationPeriod";
        public List<String> customFields;
        public static final String CUSTOM_FIELDS = "customFields";
        public List<String> groups;
        public static final String GROUPS = "groups";
        public String keywords;
        public static final String KEYWORDS = "keywords";
        public Integer page;
        public static final String PAGE = "page";
        public Integer pageSize;
        public static final String PAGE_SIZE = "pageSize";
        public List<String> profileFields;
        public static final String PROFILE_FIELDS = "profileFields";
        public Boolean skipTotalCount;
        public static final String SKIP_TOTAL_COUNT = "skipTotalCount";
        public String user;
        public static final String USER = "user";
        public List<UserStatusEnum> userStatuses;
        public static final String USER_STATUSES = "userStatuses";
    }

    public static class SearchOwnerRecordsParams {
        public String owner;
        public static final String OWNER = "owner";
        public String type;
        public static final String TYPE = "type";
        public List<String> fields;
        public static final String FIELDS = "fields";
        public String createdBy;
        public static final String CREATED_BY = "createdBy";
        public List<DateTime> creationPeriod;
        public static final String CREATION_PERIOD = "creationPeriod";
        public List<String> customFields;
        public static final String CUSTOM_FIELDS = "customFields";
        public String keywords;
        public static final String KEYWORDS = "keywords";
        public Integer page;
        public static final String PAGE = "page";
        public Integer pageSize;
        public static final String PAGE_SIZE = "pageSize";
        public List<String> profileFields;
        public static final String PROFILE_FIELDS = "profileFields";
        public Boolean skipTotalCount;
        public static final String SKIP_TOTAL_COUNT = "skipTotalCount";
    }

    public static class SearchSharedRecordsParams {
        public List<String> fields;
        public static final String FIELDS = "fields";
        public List<String> brokers;
        public static final String BROKERS = "brokers";
        public String createdBy;
        public static final String CREATED_BY = "createdBy";
        public List<DateTime> creationPeriod;
        public static final String CREATION_PERIOD = "creationPeriod";
        public List<String> customFields;
        public static final String CUSTOM_FIELDS = "customFields";
        public List<String> groups;
        public static final String GROUPS = "groups";
        public String keywords;
        public static final String KEYWORDS = "keywords";
        public Integer page;
        public static final String PAGE = "page";
        public Integer pageSize;
        public static final String PAGE_SIZE = "pageSize";
        public List<String> profileFields;
        public static final String PROFILE_FIELDS = "profileFields";
        public Boolean skipTotalCount;
        public static final String SKIP_TOTAL_COUNT = "skipTotalCount";
        public List<String> types;
        public static final String TYPES = "types";
        public String user;
        public static final String USER = "user";
        public List<UserStatusEnum> userStatuses;
        public static final String USER_STATUSES = "userStatuses";
    }
}

