/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.api;

import java.net.URI;
import java.util.List;
import org.cyclos.model.banking.transactions.InstallmentActionDTO;
import org.cyclos.model.banking.transactions.ScheduledPaymentActionDTO;
import org.cyclos.model.banking.transfers.TransferVO;
import org.cyclos.services.banking.ScheduledPaymentService;
import org.cyclos.web.rest.api.BaseApiImpl;
import org.cyclos.web.rest.helpers.InstallmentsApiHelper;
import org.cyclos.web.rest.helpers.ScheduledPaymentsApiHelper;
import org.cyclos.web.rest.helpers.TransfersApiHelper;
import org.cyclos.web.rest.model.Transfer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component
public class ScheduledPaymentsApiImpl
extends BaseApiImpl {
    @Autowired
    private ScheduledPaymentService scheduledPaymentService;
    @Autowired
    private ScheduledPaymentsApiHelper scheduledPaymentsApiHelper;
    @Autowired
    private TransfersApiHelper transfersApiHelper;
    @Autowired
    private InstallmentsApiHelper installmentsApiHelper;

    public ResponseEntity<Void> blockScheduledPayment(String string, String string2) {
        ScheduledPaymentActionDTO scheduledPaymentActionDTO = this.scheduledPaymentsApiHelper.toScheduledPaymentActionDTO(string, string2);
        this.scheduledPaymentService.block(scheduledPaymentActionDTO);
        return ResponseEntity.noContent().build();
    }

    public ResponseEntity<Void> cancelScheduledPayment(String string, String string2) {
        ScheduledPaymentActionDTO scheduledPaymentActionDTO = this.scheduledPaymentsApiHelper.toScheduledPaymentActionDTO(string, string2);
        this.scheduledPaymentService.cancel(scheduledPaymentActionDTO);
        return ResponseEntity.noContent().build();
    }

    public ResponseEntity<Transfer> processScheduledPaymentInstallment(String string, List<String> list, String string2) {
        InstallmentActionDTO installmentActionDTO = this.installmentsApiHelper.toInstallmentActionDTO(string, string2);
        TransferVO transferVO = this.scheduledPaymentService.processInstallment(installmentActionDTO);
        Transfer transfer = this.transfersApiHelper.toTransfer(transferVO);
        this.fields().apply((Object)transfer);
        return ResponseEntity.created((URI)this.apiHelper.uriFromApi("transfers", transfer.getId())).body((Object)transfer);
    }

    public ResponseEntity<Void> settleScheduledPayment(String string, String string2) {
        ScheduledPaymentActionDTO scheduledPaymentActionDTO = this.scheduledPaymentsApiHelper.toScheduledPaymentActionDTO(string, string2);
        this.scheduledPaymentService.settleRemaining(scheduledPaymentActionDTO);
        return ResponseEntity.noContent().build();
    }

    public ResponseEntity<Void> settleScheduledPaymentInstallment(String string, String string2) {
        InstallmentActionDTO installmentActionDTO = this.installmentsApiHelper.toInstallmentActionDTO(string, string2);
        this.scheduledPaymentService.settleInstallment(installmentActionDTO);
        return ResponseEntity.noContent().build();
    }

    public ResponseEntity<Void> unblockScheduledPayment(String string, String string2) {
        ScheduledPaymentActionDTO scheduledPaymentActionDTO = this.scheduledPaymentsApiHelper.toScheduledPaymentActionDTO(string, string2);
        this.scheduledPaymentService.unblock(scheduledPaymentActionDTO);
        return ResponseEntity.noContent().build();
    }
}

