/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.api;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.cyclos.model.banking.transactions.ApproveTicketDTO;
import org.cyclos.model.banking.transactions.ApproveTicketPreviewVO;
import org.cyclos.model.banking.transactions.CreateTicketDTO;
import org.cyclos.model.banking.transactions.CreateTicketData;
import org.cyclos.model.banking.transactions.ProcessTicketDTO;
import org.cyclos.model.banking.transactions.TicketBarcodeParams;
import org.cyclos.model.banking.transactions.TicketData;
import org.cyclos.model.banking.transactions.TicketPaymentTypeData;
import org.cyclos.model.banking.transactions.TicketProcessResult;
import org.cyclos.model.banking.transactions.TicketVO;
import org.cyclos.model.banking.transactions.TransactionData;
import org.cyclos.model.banking.transactions.TransactionDetailedVO;
import org.cyclos.model.banking.transfertypes.TransferTypeVO;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.server.utils.SerializableInputStream;
import org.cyclos.services.banking.TicketService;
import org.cyclos.utils.ContentType;
import org.cyclos.web.rest.api.BaseApiImpl;
import org.cyclos.web.rest.api.TicketsApi;
import org.cyclos.web.rest.helpers.ApiHelper;
import org.cyclos.web.rest.helpers.TicketsApiHelper;
import org.cyclos.web.rest.helpers.TransactionsApiHelper;
import org.cyclos.web.rest.model.DataForTransaction;
import org.cyclos.web.rest.model.ImageSizeEnum;
import org.cyclos.web.rest.model.TicketApprovalResult;
import org.cyclos.web.rest.model.TicketNew;
import org.cyclos.web.rest.model.TicketPreview;
import org.cyclos.web.rest.model.TransactionView;
import org.cyclos.web.utils.ServletHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component
public class TicketsApiImpl
extends BaseApiImpl {
    @Autowired
    private TicketsApiHelper ticketsApiHelper;
    @Autowired
    private TransactionsApiHelper transactionsApiHelper;
    @Autowired
    private TicketService ticketService;
    @Autowired
    private ApiHelper apiHelper;

    public ResponseEntity<TicketApprovalResult> approveTicket(String string, List<String> list, String string2) {
        ApproveTicketDTO approveTicketDTO = this.ticketsApiHelper.toApproveTicketDTO(string, string2);
        TicketVO ticketVO = this.ticketService.approve(approveTicketDTO);
        return this.ok(this.ticketsApiHelper.toTicketApprovalResult(ticketVO));
    }

    public ResponseEntity<Void> cancelTicket(String string) {
        TicketVO ticketVO = (TicketVO)ModelHelper.voFromString(TicketVO.class, (String)string);
        this.ticketService.cancel(ticketVO);
        return ResponseEntity.noContent().build();
    }

    public ResponseEntity<DataForTransaction> dataForNewTicket(TicketsApi.DataForNewTicketParams dataForNewTicketParams) {
        DataForTransaction dataForTransaction;
        TransferTypeVO transferTypeVO = (TransferTypeVO)ModelHelper.voFromString(TransferTypeVO.class, (String)dataForNewTicketParams.type);
        UserLocatorVO userLocatorVO = (UserLocatorVO)ModelHelper.voFromString(UserLocatorVO.class, (String)dataForNewTicketParams.user);
        if (transferTypeVO == null) {
            UserLocatorVO userLocatorVO2 = (UserLocatorVO)ModelHelper.voFromString(UserLocatorVO.class, (String)dataForNewTicketParams.payer);
            CreateTicketData createTicketData = this.ticketService.getCreateData(userLocatorVO, userLocatorVO2);
            dataForTransaction = this.transactionsApiHelper.toDataForTransaction(createTicketData);
        } else {
            TicketPaymentTypeData ticketPaymentTypeData = this.ticketService.getTicketPaymentTypeData(userLocatorVO, transferTypeVO);
            dataForTransaction = this.transactionsApiHelper.toDataForTransaction(ticketPaymentTypeData);
        }
        return this.ok(dataForTransaction);
    }

    public ResponseEntity<DataForTransaction> dataForNewTicketDeprecated(List<String> list, String string, String string2) {
        TicketsApi.DataForNewTicketParams dataForNewTicketParams = new TicketsApi.DataForNewTicketParams();
        dataForNewTicketParams.type = string;
        dataForNewTicketParams.payer = string2;
        dataForNewTicketParams.fields = list;
        return this.dataForNewTicket(dataForNewTicketParams);
    }

    public ResponseEntity<InputStream> getTicketQrCode(String string, ImageSizeEnum imageSizeEnum) throws IOException {
        HttpServletResponse httpServletResponse = ServletHelper.getResponse();
        TicketBarcodeParams ticketBarcodeParams = this.ticketsApiHelper.toTicketBarcodeParams(string, imageSizeEnum);
        SerializableInputStream serializableInputStream = this.ticketService.barcode(ticketBarcodeParams);
        ServletHelper.setContentType(httpServletResponse, ContentType.PNG);
        ServletHelper.writeContents(httpServletResponse, (InputStream)serializableInputStream);
        httpServletResponse.flushBuffer();
        return null;
    }

    public ResponseEntity<TransactionView> newTicket(String string, TicketNew ticketNew, List<String> list) {
        CreateTicketDTO createTicketDTO = this.ticketsApiHelper.toCreateTicketDTO(string, ticketNew);
        TicketVO ticketVO = this.ticketService.create(createTicketDTO);
        TransactionView transactionView = this.transactionsApiHelper.toTransactionView((TransactionDetailedVO)ticketVO);
        this.fields().apply((Object)transactionView);
        return ResponseEntity.created((URI)this.apiHelper.uriFromApi("tickets", ticketVO.getTicketNumber())).body((Object)transactionView);
    }

    public ResponseEntity<TransactionView> newTicketDeprecated(TicketNew ticketNew, List<String> list) {
        return this.newTicket(null, ticketNew, list);
    }

    public ResponseEntity<TicketPreview> previewTicket(String string, List<String> list) {
        ApproveTicketPreviewVO approveTicketPreviewVO = this.ticketService.previewApprove((TicketVO)ModelHelper.voFromString(TicketVO.class, (String)string));
        TicketPreview ticketPreview = this.ticketsApiHelper.toTicketPreview(approveTicketPreviewVO);
        return this.ok(ticketPreview);
    }

    public ResponseEntity<org.cyclos.web.rest.model.TicketProcessResult> processTicket(String string, List<String> list, String string2) {
        ProcessTicketDTO processTicketDTO = this.ticketsApiHelper.toProcessTicketDTO(string, string2);
        TicketProcessResult ticketProcessResult = this.ticketService.process(processTicketDTO);
        org.cyclos.web.rest.model.TicketProcessResult ticketProcessResult2 = this.ticketsApiHelper.toTicketProcessResult(list, ticketProcessResult);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().location(this.apiHelper.uriFromApi("transactions", string))).body((Object)ticketProcessResult2);
    }

    public ResponseEntity<TransactionView> viewTicket(String string, List<String> list) {
        TicketData ticketData = this.ticketService.getData((TicketVO)ModelHelper.voFromString(TicketVO.class, (String)string));
        return this.ok(this.transactionsApiHelper.toTransactionView((TransactionData)ticketData));
    }
}

