/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.api;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.cyclos.model.EntityDTO;
import org.cyclos.model.access.principaltypes.TokenPrincipalTypeVO;
import org.cyclos.model.access.tokens.TokenActionDTO;
import org.cyclos.model.access.tokens.TokenBarcodeParams;
import org.cyclos.model.access.tokens.TokenDTO;
import org.cyclos.model.access.tokens.TokenData;
import org.cyclos.model.access.tokens.TokenDataParams;
import org.cyclos.model.access.tokens.TokenQuery;
import org.cyclos.model.access.tokens.TokenSearchData;
import org.cyclos.model.access.tokens.TokensListData;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.server.utils.SerializableInputStream;
import org.cyclos.services.access.PrincipalTypeService;
import org.cyclos.services.access.TokenService;
import org.cyclos.utils.ContentType;
import org.cyclos.utils.DateTime;
import org.cyclos.utils.Page;
import org.cyclos.utils.StringHelper;
import org.cyclos.web.rest.api.BaseApiImpl;
import org.cyclos.web.rest.api.TokensApi;
import org.cyclos.web.rest.helpers.ApiHelper;
import org.cyclos.web.rest.helpers.TokensApiHelper;
import org.cyclos.web.rest.model.ImageSizeEnum;
import org.cyclos.web.rest.model.TokenDataForNew;
import org.cyclos.web.rest.model.TokenDataForSearch;
import org.cyclos.web.rest.model.TokenNew;
import org.cyclos.web.rest.model.TokenPermissions;
import org.cyclos.web.rest.model.TokenResult;
import org.cyclos.web.rest.model.TokenView;
import org.cyclos.web.rest.model.UserTokensListData;
import org.cyclos.web.utils.ServletHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component
public class TokensApiImpl
extends BaseApiImpl {
    @Autowired
    private TokensApiHelper tokensApiHelper;
    @Autowired
    private ApiHelper apiHelper;
    @Autowired
    private TokenService tokenService;
    @Autowired
    private PrincipalTypeService principalTypeService;

    public ResponseEntity<Void> activatePendingToken(String string) {
        this.tokenService.activatePending(this.apiHelper.fromId(string));
        return ResponseEntity.noContent().build();
    }

    public ResponseEntity<String> activateToken(String string, String string2, String string3) {
        TokenActionDTO tokenActionDTO = new TokenActionDTO();
        tokenActionDTO.setTokenType((TokenPrincipalTypeVO)ModelHelper.voFromString(TokenPrincipalTypeVO.class, (String)string2));
        tokenActionDTO.setTokenValue(StringHelper.trimToNull((Object)string3));
        Long l = this.tokenService.activate(tokenActionDTO, (UserLocatorVO)ModelHelper.voFromString(UserLocatorVO.class, (String)string));
        return ResponseEntity.ok().contentType(MediaType.TEXT_PLAIN).body((Object)ApiHelper.toId(l));
    }

    public ResponseEntity<Void> assignToken(String string, String string2) {
        this.tokenService.assign(this.apiHelper.fromId(string), (UserLocatorVO)ModelHelper.voFromString(UserLocatorVO.class, (String)string2));
        return ResponseEntity.noContent().build();
    }

    public ResponseEntity<Void> blockToken(String string) {
        this.tokenService.block(this.apiHelper.fromId(string));
        return ResponseEntity.noContent().build();
    }

    public ResponseEntity<Void> cancelToken(String string) {
        this.tokenService.cancel(this.apiHelper.fromId(string));
        return ResponseEntity.noContent().build();
    }

    public ResponseEntity<String> createToken(String string, TokenNew tokenNew) {
        TokenDTO tokenDTO = this.tokensApiHelper.toTokenDTO(string, tokenNew);
        String string2 = ApiHelper.toId(this.tokenService.save((EntityDTO)tokenDTO));
        return this.created(this.apiHelper.uriFromApi("tokens", string2), string2);
    }

    public ResponseEntity<TokenDataForSearch> getGeneralTokensDataForSearch(String string, List<String> list) {
        TokenSearchData tokenSearchData = this.tokenService.getSearchData((TokenPrincipalTypeVO)ModelHelper.voFromString(TokenPrincipalTypeVO.class, (String)string));
        TokenDataForSearch tokenDataForSearch = this.tokensApiHelper.toTokenDataForSearch(tokenSearchData);
        return this.ok(tokenDataForSearch);
    }

    public ResponseEntity<TokenDataForNew> getTokenDataForNew(String string, List<String> list, String string2) {
        TokenDataParams tokenDataParams = this.tokensApiHelper.toTokenDataParams(string, string2);
        TokenData tokenData = (TokenData)this.tokenService.getDataForNew((Object)tokenDataParams);
        TokenDataForNew tokenDataForNew = this.tokensApiHelper.toTokenDataForNew(tokenData);
        return this.ok(tokenDataForNew);
    }

    public ResponseEntity<InputStream> getTokenQrCode(String string, ImageSizeEnum imageSizeEnum) throws IOException {
        HttpServletResponse httpServletResponse = ServletHelper.getResponse();
        TokenBarcodeParams tokenBarcodeParams = this.tokensApiHelper.toTokenBarcodeParams(string, imageSizeEnum);
        SerializableInputStream serializableInputStream = this.tokenService.barcode(tokenBarcodeParams);
        ServletHelper.setContentType(httpServletResponse, ContentType.PNG);
        ServletHelper.writeContents(httpServletResponse, (InputStream)serializableInputStream);
        httpServletResponse.flushBuffer();
        return null;
    }

    public ResponseEntity<UserTokensListData> getUserTokens(String string, String string2, List<String> list) {
        TokensListData tokensListData = this.tokenService.getListData((TokenPrincipalTypeVO)ModelHelper.voFromString(TokenPrincipalTypeVO.class, (String)string2), (UserLocatorVO)ModelHelper.voFromString(UserLocatorVO.class, (String)string));
        UserTokensListData userTokensListData = this.tokensApiHelper.toUserTokensListData(tokensListData);
        return this.ok(userTokensListData);
    }

    public ResponseEntity<List<TokenPermissions>> listUserTokenTypes(String string, List<String> list) {
        List list2 = this.principalTypeService.listUserTokenPermissions((UserLocatorVO)ModelHelper.voFromString(UserLocatorVO.class, (String)string));
        List list3 = list2.stream().map(this.tokensApiHelper::toTokenPermissions).collect(Collectors.toList());
        return this.ok(list3);
    }

    public ResponseEntity<List<TokenResult>> searchGeneralTokens(TokensApi.SearchGeneralTokensParams searchGeneralTokensParams) {
        TokenQuery tokenQuery = this.tokensApiHelper.toTokenQuery(searchGeneralTokensParams);
        Page page = this.tokenService.search(tokenQuery);
        return this.pageResponse(page, this.tokensApiHelper::toTokenResult);
    }

    public ResponseEntity<Void> setTokenActivationDeadline(String string, DateTime dateTime) {
        this.tokenService.setActivationDeadline(this.apiHelper.fromId(string), dateTime);
        return ResponseEntity.noContent().build();
    }

    public ResponseEntity<Void> setTokenExpiryDate(String string, DateTime dateTime) {
        this.tokenService.setExpiryDate(this.apiHelper.fromId(string), dateTime);
        return ResponseEntity.noContent().build();
    }

    public ResponseEntity<Void> unblockToken(String string) {
        this.tokenService.unblock(this.apiHelper.fromId(string));
        return ResponseEntity.noContent().build();
    }

    public ResponseEntity<TokenView> viewToken(String string, List<String> list) {
        TokenData tokenData = (TokenData)this.tokenService.getData(this.apiHelper.fromId(string));
        TokenView tokenView = this.tokensApiHelper.toTokenView(tokenData);
        return this.ok(tokenView);
    }
}

