/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.api;

import java.io.InputStream;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.cyclos.utils.DateTime;
import org.cyclos.web.rest.api.UsersApiImpl;
import org.cyclos.web.rest.model.DataForEditFullProfile;
import org.cyclos.web.rest.model.Error;
import org.cyclos.web.rest.model.FullProfileEdit;
import org.cyclos.web.rest.model.FullProfileEditResult;
import org.cyclos.web.rest.model.GroupForRegistration;
import org.cyclos.web.rest.model.NestedError;
import org.cyclos.web.rest.model.RoleEnum;
import org.cyclos.web.rest.model.User;
import org.cyclos.web.rest.model.UserAddressResultEnum;
import org.cyclos.web.rest.model.UserDataForEdit;
import org.cyclos.web.rest.model.UserDataForMap;
import org.cyclos.web.rest.model.UserDataForNew;
import org.cyclos.web.rest.model.UserDataForSearch;
import org.cyclos.web.rest.model.UserEdit;
import org.cyclos.web.rest.model.UserNew;
import org.cyclos.web.rest.model.UserOrderByEnum;
import org.cyclos.web.rest.model.UserRegistrationResult;
import org.cyclos.web.rest.model.UserResult;
import org.cyclos.web.rest.model.UserStatusEnum;
import org.cyclos.web.rest.model.UserView;
import org.cyclos.web.utils.ServletHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(produces={"application/json"})
public class UsersApi {
    @Autowired
    private UsersApiImpl impl;
    public static final String CREATE_USER = "/users";
    public static final String DELETE_PENDING_USER = "/users/{user}";
    public static final String EXPORT_USERS = "/users/export/{format}";
    public static final String GET_DATA_FOR_EDIT_FULL_PROFILE = "/users/{user}/data-for-edit-profile";
    public static final String GET_DATA_FOR_MAP_DIRECTORY = "/users/map/data-for-search";
    public static final String GET_GROUPS_FOR_USER_REGISTRATION = "/users/groups-for-registration";
    public static final String GET_USER_DATA_FOR_EDIT = "/users/{user}/data-for-edit";
    public static final String GET_USER_DATA_FOR_NEW = "/users/data-for-new";
    public static final String GET_USER_DATA_FOR_SEARCH = "/users/data-for-search";
    public static final String LOCATE_USER = "/users/{user}/locate";
    public static final String SAVE_USER_FULL_PROFILE = "/users/{user}/profile";
    public static final String SEARCH_MAP_DIRECTORY = "/users/map";
    public static final String SEARCH_USERS = "/users";
    public static final String UPDATE_USER = "/users/{user}";
    public static final String VALIDATE_USER_REGISTRATION_FIELD = "/users/validate/{group}/{field}";
    public static final String VIEW_USER = "/users/{user}";

    @RequestMapping(value={"/api/users"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<UserRegistrationResult> createUser(@RequestBody(required=true) UserNew userNew, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /users");
        httpServletRequest.setAttribute("errorType", Error.class);
        return this.impl.createUser(userNew);
    }

    @RequestMapping(value={"/api/users/{user:.*}"}, produces={"application/json"}, method={RequestMethod.DELETE})
    public ResponseEntity<Void> deletePendingUser(@PathVariable(value="user") String string, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"DELETE /users/{user}");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.deletePendingUser(string);
    }

    @RequestMapping(value={"/api/users/export/{format}"}, produces={"*/*", "application/json"}, method={RequestMethod.GET})
    public ResponseEntity<InputStream> exportUsers(@PathVariable(value="format") String string, @RequestParam(value="acceptedAgreements", required=false) List<String> list, @RequestParam(value="activationPeriod", required=false) List<DateTime> list2, @RequestParam(value="addressResult", required=false) UserAddressResultEnum userAddressResultEnum, @RequestParam(value="brokers", required=false) List<String> list3, @RequestParam(value="contactsOwner", required=false) String string2, @RequestParam(value="creationPeriod", required=false) List<DateTime> list4, @RequestParam(value="excludeContacts", required=false) Boolean bl, @RequestParam(value="fromMenu", required=false) Boolean bl2, @RequestParam(value="groups", required=false) List<String> list5, @RequestParam(value="hasBroker", required=false) Boolean bl3, @RequestParam(value="ignoreProfileFieldsInList", required=false) Boolean bl4, @RequestParam(value="includeGlobal", required=false) Boolean bl5, @RequestParam(value="includeGroup", required=false) Boolean bl6, @RequestParam(value="includeGroupSet", required=false) Boolean bl7, @RequestParam(value="invitedBy", required=false) String string3, @RequestParam(value="keywords", required=false) String string4, @RequestParam(value="lastLoginPeriod", required=false) List<DateTime> list6, @RequestParam(value="latitude", required=false) Double d, @RequestParam(value="longitude", required=false) Double d2, @RequestParam(value="mainBrokerOnly", required=false) Boolean bl8, @RequestParam(value="maxDistance", required=false) Double d3, @RequestParam(value="notAcceptedAgreements", required=false) List<String> list7, @RequestParam(value="orderBy", required=false) UserOrderByEnum userOrderByEnum, @RequestParam(value="page", required=false) Integer n, @RequestParam(value="pageSize", required=false) Integer n2, @RequestParam(value="products", required=false) List<String> list8, @RequestParam(value="productsIndividuallyAssigned", required=false) Boolean bl9, @RequestParam(value="profileFields", required=false) List<String> list9, @RequestParam(value="roles", required=false) List<RoleEnum> list10, @RequestParam(value="skipTotalCount", required=false) Boolean bl10, @RequestParam(value="statuses", required=false) List<UserStatusEnum> list11, @RequestParam(value="usersToExclude", required=false) List<String> list12, @RequestParam(value="usersToInclude", required=false) List<String> list13, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /users/export/{format}");
        httpServletRequest.setAttribute("errorType", Error.class);
        ExportUsersParams exportUsersParams = new ExportUsersParams();
        exportUsersParams.format = string;
        exportUsersParams.acceptedAgreements = list;
        exportUsersParams.activationPeriod = list2;
        exportUsersParams.addressResult = userAddressResultEnum;
        exportUsersParams.brokers = list3;
        exportUsersParams.contactsOwner = string2;
        exportUsersParams.creationPeriod = list4;
        exportUsersParams.excludeContacts = bl;
        exportUsersParams.fromMenu = bl2;
        exportUsersParams.groups = list5;
        exportUsersParams.hasBroker = bl3;
        exportUsersParams.ignoreProfileFieldsInList = bl4;
        exportUsersParams.includeGlobal = bl5;
        exportUsersParams.includeGroup = bl6;
        exportUsersParams.includeGroupSet = bl7;
        exportUsersParams.invitedBy = string3;
        exportUsersParams.keywords = string4;
        exportUsersParams.lastLoginPeriod = list6;
        exportUsersParams.latitude = d;
        exportUsersParams.longitude = d2;
        exportUsersParams.mainBrokerOnly = bl8;
        exportUsersParams.maxDistance = d3;
        exportUsersParams.notAcceptedAgreements = list7;
        exportUsersParams.orderBy = userOrderByEnum;
        exportUsersParams.page = n;
        exportUsersParams.pageSize = n2;
        exportUsersParams.products = list8;
        exportUsersParams.productsIndividuallyAssigned = bl9;
        exportUsersParams.profileFields = list9;
        exportUsersParams.roles = list10;
        exportUsersParams.skipTotalCount = bl10;
        exportUsersParams.statuses = list11;
        exportUsersParams.usersToExclude = list12;
        exportUsersParams.usersToInclude = list13;
        return this.impl.exportUsers(exportUsersParams);
    }

    @RequestMapping(value={"/api/users/{user:.*}/data-for-edit-profile"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<DataForEditFullProfile> getDataForEditFullProfile(@PathVariable(value="user") String string, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /users/{user}/data-for-edit-profile");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.getDataForEditFullProfile(string, list);
    }

    @RequestMapping(value={"/api/users/map/data-for-search"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<UserDataForMap> getDataForMapDirectory(@RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /users/map/data-for-search");
        httpServletRequest.setAttribute("errorType", Error.class);
        return this.impl.getDataForMapDirectory(list);
    }

    @RequestMapping(value={"/api/users/groups-for-registration"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<List<GroupForRegistration>> getGroupsForUserRegistration(@RequestParam(value="fields", required=false) List<String> list, @RequestParam(value="asMember", required=false) Boolean bl, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /users/groups-for-registration");
        httpServletRequest.setAttribute("errorType", Error.class);
        return this.impl.getGroupsForUserRegistration(list, bl);
    }

    @RequestMapping(value={"/api/users/{user:.*}/data-for-edit"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<UserDataForEdit> getUserDataForEdit(@PathVariable(value="user") String string, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /users/{user}/data-for-edit");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.getUserDataForEdit(string, list);
    }

    @RequestMapping(value={"/api/users/data-for-new"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<UserDataForNew> getUserDataForNew(@RequestParam(value="group", required=true) String string, @RequestParam(value="fields", required=false) List<String> list, @RequestParam(value="broker", required=false) String string2, @RequestParam(value="inviteToken", required=false) String string3, @RequestParam(value="externalPaymentToken", required=false) String string4, @RequestParam(value="asMember", required=false) Boolean bl, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /users/data-for-new");
        httpServletRequest.setAttribute("errorType", Error.class);
        GetUserDataForNewParams getUserDataForNewParams = new GetUserDataForNewParams();
        getUserDataForNewParams.group = string;
        getUserDataForNewParams.fields = list;
        getUserDataForNewParams.broker = string2;
        getUserDataForNewParams.inviteToken = string3;
        getUserDataForNewParams.externalPaymentToken = string4;
        getUserDataForNewParams.asMember = bl;
        return this.impl.getUserDataForNew(getUserDataForNewParams);
    }

    @RequestMapping(value={"/api/users/data-for-search"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<UserDataForSearch> getUserDataForSearch(@RequestParam(value="fields", required=false) List<String> list, @RequestParam(value="broker", required=false) String string, @RequestParam(value="fromMenu", required=false) Boolean bl, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /users/data-for-search");
        httpServletRequest.setAttribute("errorType", Error.class);
        return this.impl.getUserDataForSearch(list, string, bl);
    }

    @RequestMapping(value={"/api/users/{user:.*}/locate"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<User> locateUser(@PathVariable(value="user") String string, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /users/{user}/locate");
        httpServletRequest.setAttribute("errorType", Error.class);
        return this.impl.locateUser(string, list);
    }

    @RequestMapping(value={"/api/users/{user:.*}/profile"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<FullProfileEditResult> saveUserFullProfile(@PathVariable(value="user") String string, @RequestBody(required=true) FullProfileEdit fullProfileEdit, @RequestParam(value="fields", required=false) List<String> list, @RequestHeader(value="confirmationPassword", required=false) String string2, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /users/{user}/profile");
        httpServletRequest.setAttribute("errorType", NestedError.class);
        ServletHelper.denyGuest(httpServletRequest);
        SaveUserFullProfileParams saveUserFullProfileParams = new SaveUserFullProfileParams();
        saveUserFullProfileParams.user = string;
        saveUserFullProfileParams.fullProfileEdit = fullProfileEdit;
        saveUserFullProfileParams.fields = list;
        saveUserFullProfileParams.confirmationPassword = string2;
        return this.impl.saveUserFullProfile(saveUserFullProfileParams);
    }

    @RequestMapping(value={"/api/users/map"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<List<UserResult>> searchMapDirectory(@RequestParam(value="fields", required=false) List<String> list, @RequestParam(value="acceptedAgreements", required=false) List<String> list2, @RequestParam(value="activationPeriod", required=false) List<DateTime> list3, @RequestParam(value="addressResult", required=false) UserAddressResultEnum userAddressResultEnum, @RequestParam(value="brokers", required=false) List<String> list4, @RequestParam(value="contactsOwner", required=false) String string, @RequestParam(value="creationPeriod", required=false) List<DateTime> list5, @RequestParam(value="excludeContacts", required=false) Boolean bl, @RequestParam(value="fromMenu", required=false) Boolean bl2, @RequestParam(value="groups", required=false) List<String> list6, @RequestParam(value="hasBroker", required=false) Boolean bl3, @RequestParam(value="ignoreProfileFieldsInList", required=false) Boolean bl4, @RequestParam(value="includeGlobal", required=false) Boolean bl5, @RequestParam(value="includeGroup", required=false) Boolean bl6, @RequestParam(value="includeGroupSet", required=false) Boolean bl7, @RequestParam(value="invitedBy", required=false) String string2, @RequestParam(value="keywords", required=false) String string3, @RequestParam(value="lastLoginPeriod", required=false) List<DateTime> list7, @RequestParam(value="latitude", required=false) Double d, @RequestParam(value="longitude", required=false) Double d2, @RequestParam(value="mainBrokerOnly", required=false) Boolean bl8, @RequestParam(value="maxDistance", required=false) Double d3, @RequestParam(value="notAcceptedAgreements", required=false) List<String> list8, @RequestParam(value="orderBy", required=false) UserOrderByEnum userOrderByEnum, @RequestParam(value="page", required=false) Integer n, @RequestParam(value="pageSize", required=false) Integer n2, @RequestParam(value="products", required=false) List<String> list9, @RequestParam(value="productsIndividuallyAssigned", required=false) Boolean bl9, @RequestParam(value="profileFields", required=false) List<String> list10, @RequestParam(value="roles", required=false) List<RoleEnum> list11, @RequestParam(value="skipTotalCount", required=false) Boolean bl10, @RequestParam(value="statuses", required=false) List<UserStatusEnum> list12, @RequestParam(value="usersToExclude", required=false) List<String> list13, @RequestParam(value="usersToInclude", required=false) List<String> list14, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /users/map");
        httpServletRequest.setAttribute("errorType", Error.class);
        SearchMapDirectoryParams searchMapDirectoryParams = new SearchMapDirectoryParams();
        searchMapDirectoryParams.fields = list;
        searchMapDirectoryParams.acceptedAgreements = list2;
        searchMapDirectoryParams.activationPeriod = list3;
        searchMapDirectoryParams.addressResult = userAddressResultEnum;
        searchMapDirectoryParams.brokers = list4;
        searchMapDirectoryParams.contactsOwner = string;
        searchMapDirectoryParams.creationPeriod = list5;
        searchMapDirectoryParams.excludeContacts = bl;
        searchMapDirectoryParams.fromMenu = bl2;
        searchMapDirectoryParams.groups = list6;
        searchMapDirectoryParams.hasBroker = bl3;
        searchMapDirectoryParams.ignoreProfileFieldsInList = bl4;
        searchMapDirectoryParams.includeGlobal = bl5;
        searchMapDirectoryParams.includeGroup = bl6;
        searchMapDirectoryParams.includeGroupSet = bl7;
        searchMapDirectoryParams.invitedBy = string2;
        searchMapDirectoryParams.keywords = string3;
        searchMapDirectoryParams.lastLoginPeriod = list7;
        searchMapDirectoryParams.latitude = d;
        searchMapDirectoryParams.longitude = d2;
        searchMapDirectoryParams.mainBrokerOnly = bl8;
        searchMapDirectoryParams.maxDistance = d3;
        searchMapDirectoryParams.notAcceptedAgreements = list8;
        searchMapDirectoryParams.orderBy = userOrderByEnum;
        searchMapDirectoryParams.page = n;
        searchMapDirectoryParams.pageSize = n2;
        searchMapDirectoryParams.products = list9;
        searchMapDirectoryParams.productsIndividuallyAssigned = bl9;
        searchMapDirectoryParams.profileFields = list10;
        searchMapDirectoryParams.roles = list11;
        searchMapDirectoryParams.skipTotalCount = bl10;
        searchMapDirectoryParams.statuses = list12;
        searchMapDirectoryParams.usersToExclude = list13;
        searchMapDirectoryParams.usersToInclude = list14;
        return this.impl.searchMapDirectory(searchMapDirectoryParams);
    }

    @RequestMapping(value={"/api/users"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<List<UserResult>> searchUsers(@RequestParam(value="fields", required=false) List<String> list, @RequestParam(value="acceptedAgreements", required=false) List<String> list2, @RequestParam(value="activationPeriod", required=false) List<DateTime> list3, @RequestParam(value="addressResult", required=false) UserAddressResultEnum userAddressResultEnum, @RequestParam(value="brokers", required=false) List<String> list4, @RequestParam(value="contactsOwner", required=false) String string, @RequestParam(value="creationPeriod", required=false) List<DateTime> list5, @RequestParam(value="excludeContacts", required=false) Boolean bl, @RequestParam(value="fromMenu", required=false) Boolean bl2, @RequestParam(value="groups", required=false) List<String> list6, @RequestParam(value="hasBroker", required=false) Boolean bl3, @RequestParam(value="ignoreProfileFieldsInList", required=false) Boolean bl4, @RequestParam(value="includeGlobal", required=false) Boolean bl5, @RequestParam(value="includeGroup", required=false) Boolean bl6, @RequestParam(value="includeGroupSet", required=false) Boolean bl7, @RequestParam(value="invitedBy", required=false) String string2, @RequestParam(value="keywords", required=false) String string3, @RequestParam(value="lastLoginPeriod", required=false) List<DateTime> list7, @RequestParam(value="latitude", required=false) Double d, @RequestParam(value="longitude", required=false) Double d2, @RequestParam(value="mainBrokerOnly", required=false) Boolean bl8, @RequestParam(value="maxDistance", required=false) Double d3, @RequestParam(value="notAcceptedAgreements", required=false) List<String> list8, @RequestParam(value="orderBy", required=false) UserOrderByEnum userOrderByEnum, @RequestParam(value="page", required=false) Integer n, @RequestParam(value="pageSize", required=false) Integer n2, @RequestParam(value="products", required=false) List<String> list9, @RequestParam(value="productsIndividuallyAssigned", required=false) Boolean bl9, @RequestParam(value="profileFields", required=false) List<String> list10, @RequestParam(value="roles", required=false) List<RoleEnum> list11, @RequestParam(value="skipTotalCount", required=false) Boolean bl10, @RequestParam(value="statuses", required=false) List<UserStatusEnum> list12, @RequestParam(value="usersToExclude", required=false) List<String> list13, @RequestParam(value="usersToInclude", required=false) List<String> list14, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /users");
        httpServletRequest.setAttribute("errorType", Error.class);
        SearchUsersParams searchUsersParams = new SearchUsersParams();
        searchUsersParams.fields = list;
        searchUsersParams.acceptedAgreements = list2;
        searchUsersParams.activationPeriod = list3;
        searchUsersParams.addressResult = userAddressResultEnum;
        searchUsersParams.brokers = list4;
        searchUsersParams.contactsOwner = string;
        searchUsersParams.creationPeriod = list5;
        searchUsersParams.excludeContacts = bl;
        searchUsersParams.fromMenu = bl2;
        searchUsersParams.groups = list6;
        searchUsersParams.hasBroker = bl3;
        searchUsersParams.ignoreProfileFieldsInList = bl4;
        searchUsersParams.includeGlobal = bl5;
        searchUsersParams.includeGroup = bl6;
        searchUsersParams.includeGroupSet = bl7;
        searchUsersParams.invitedBy = string2;
        searchUsersParams.keywords = string3;
        searchUsersParams.lastLoginPeriod = list7;
        searchUsersParams.latitude = d;
        searchUsersParams.longitude = d2;
        searchUsersParams.mainBrokerOnly = bl8;
        searchUsersParams.maxDistance = d3;
        searchUsersParams.notAcceptedAgreements = list8;
        searchUsersParams.orderBy = userOrderByEnum;
        searchUsersParams.page = n;
        searchUsersParams.pageSize = n2;
        searchUsersParams.products = list9;
        searchUsersParams.productsIndividuallyAssigned = bl9;
        searchUsersParams.profileFields = list10;
        searchUsersParams.roles = list11;
        searchUsersParams.skipTotalCount = bl10;
        searchUsersParams.statuses = list12;
        searchUsersParams.usersToExclude = list13;
        searchUsersParams.usersToInclude = list14;
        return this.impl.searchUsers(searchUsersParams);
    }

    @RequestMapping(value={"/api/users/{user:.*}"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.PUT})
    public ResponseEntity<Void> updateUser(@PathVariable(value="user") String string, @RequestBody(required=true) UserEdit userEdit, @RequestHeader(value="confirmationPassword", required=false) String string2, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"PUT /users/{user}");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.updateUser(string, userEdit, string2);
    }

    @RequestMapping(value={"/api/users/validate/{group}/{field}"}, produces={"text/plain", "application/json"}, method={RequestMethod.GET})
    public ResponseEntity<String> validateUserRegistrationField(@PathVariable(value="group") String string, @PathVariable(value="field") String string2, @RequestParam(value="value", required=true) String string3, @RequestParam(value="asMember", required=false) Boolean bl, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /users/validate/{group}/{field}");
        httpServletRequest.setAttribute("errorType", Error.class);
        ValidateUserRegistrationFieldParams validateUserRegistrationFieldParams = new ValidateUserRegistrationFieldParams();
        validateUserRegistrationFieldParams.group = string;
        validateUserRegistrationFieldParams.field = string2;
        validateUserRegistrationFieldParams.value = string3;
        validateUserRegistrationFieldParams.asMember = bl;
        return this.impl.validateUserRegistrationField(validateUserRegistrationFieldParams);
    }

    @RequestMapping(value={"/api/users/{user:.*}"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<UserView> viewUser(@PathVariable(value="user") String string, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /users/{user}");
        httpServletRequest.setAttribute("errorType", Error.class);
        return this.impl.viewUser(string, list);
    }

    public static class ExportUsersParams {
        public String format;
        public static final String FORMAT = "format";
        public List<String> acceptedAgreements;
        public static final String ACCEPTED_AGREEMENTS = "acceptedAgreements";
        public List<DateTime> activationPeriod;
        public static final String ACTIVATION_PERIOD = "activationPeriod";
        public UserAddressResultEnum addressResult;
        public static final String ADDRESS_RESULT = "addressResult";
        public List<String> brokers;
        public static final String BROKERS = "brokers";
        public String contactsOwner;
        public static final String CONTACTS_OWNER = "contactsOwner";
        public List<DateTime> creationPeriod;
        public static final String CREATION_PERIOD = "creationPeriod";
        public Boolean excludeContacts;
        public static final String EXCLUDE_CONTACTS = "excludeContacts";
        public Boolean fromMenu;
        public static final String FROM_MENU = "fromMenu";
        public List<String> groups;
        public static final String GROUPS = "groups";
        public Boolean hasBroker;
        public static final String HAS_BROKER = "hasBroker";
        public Boolean ignoreProfileFieldsInList;
        public static final String IGNORE_PROFILE_FIELDS_IN_LIST = "ignoreProfileFieldsInList";
        public Boolean includeGlobal;
        public static final String INCLUDE_GLOBAL = "includeGlobal";
        public Boolean includeGroup;
        public static final String INCLUDE_GROUP = "includeGroup";
        public Boolean includeGroupSet;
        public static final String INCLUDE_GROUP_SET = "includeGroupSet";
        public String invitedBy;
        public static final String INVITED_BY = "invitedBy";
        public String keywords;
        public static final String KEYWORDS = "keywords";
        public List<DateTime> lastLoginPeriod;
        public static final String LAST_LOGIN_PERIOD = "lastLoginPeriod";
        public Double latitude;
        public static final String LATITUDE = "latitude";
        public Double longitude;
        public static final String LONGITUDE = "longitude";
        public Boolean mainBrokerOnly;
        public static final String MAIN_BROKER_ONLY = "mainBrokerOnly";
        public Double maxDistance;
        public static final String MAX_DISTANCE = "maxDistance";
        public List<String> notAcceptedAgreements;
        public static final String NOT_ACCEPTED_AGREEMENTS = "notAcceptedAgreements";
        public UserOrderByEnum orderBy;
        public static final String ORDER_BY = "orderBy";
        public Integer page;
        public static final String PAGE = "page";
        public Integer pageSize;
        public static final String PAGE_SIZE = "pageSize";
        public List<String> products;
        public static final String PRODUCTS = "products";
        public Boolean productsIndividuallyAssigned;
        public static final String PRODUCTS_INDIVIDUALLY_ASSIGNED = "productsIndividuallyAssigned";
        public List<String> profileFields;
        public static final String PROFILE_FIELDS = "profileFields";
        public List<RoleEnum> roles;
        public static final String ROLES = "roles";
        public Boolean skipTotalCount;
        public static final String SKIP_TOTAL_COUNT = "skipTotalCount";
        public List<UserStatusEnum> statuses;
        public static final String STATUSES = "statuses";
        public List<String> usersToExclude;
        public static final String USERS_TO_EXCLUDE = "usersToExclude";
        public List<String> usersToInclude;
        public static final String USERS_TO_INCLUDE = "usersToInclude";
    }

    public static class GetUserDataForNewParams {
        public String group;
        public static final String GROUP = "group";
        public List<String> fields;
        public static final String FIELDS = "fields";
        public String broker;
        public static final String BROKER = "broker";
        public String inviteToken;
        public static final String INVITE_TOKEN = "inviteToken";
        public String externalPaymentToken;
        public static final String EXTERNAL_PAYMENT_TOKEN = "externalPaymentToken";
        public Boolean asMember;
        public static final String AS_MEMBER = "asMember";
    }

    public static class SaveUserFullProfileParams {
        public String user;
        public static final String USER = "user";
        public FullProfileEdit fullProfileEdit;
        public static final String FULL_PROFILE_EDIT = "fullProfileEdit";
        public List<String> fields;
        public static final String FIELDS = "fields";
        public String confirmationPassword;
        public static final String CONFIRMATION_PASSWORD = "confirmationPassword";
    }

    public static class SearchMapDirectoryParams {
        public List<String> fields;
        public static final String FIELDS = "fields";
        public List<String> acceptedAgreements;
        public static final String ACCEPTED_AGREEMENTS = "acceptedAgreements";
        public List<DateTime> activationPeriod;
        public static final String ACTIVATION_PERIOD = "activationPeriod";
        public UserAddressResultEnum addressResult;
        public static final String ADDRESS_RESULT = "addressResult";
        public List<String> brokers;
        public static final String BROKERS = "brokers";
        public String contactsOwner;
        public static final String CONTACTS_OWNER = "contactsOwner";
        public List<DateTime> creationPeriod;
        public static final String CREATION_PERIOD = "creationPeriod";
        public Boolean excludeContacts;
        public static final String EXCLUDE_CONTACTS = "excludeContacts";
        public Boolean fromMenu;
        public static final String FROM_MENU = "fromMenu";
        public List<String> groups;
        public static final String GROUPS = "groups";
        public Boolean hasBroker;
        public static final String HAS_BROKER = "hasBroker";
        public Boolean ignoreProfileFieldsInList;
        public static final String IGNORE_PROFILE_FIELDS_IN_LIST = "ignoreProfileFieldsInList";
        public Boolean includeGlobal;
        public static final String INCLUDE_GLOBAL = "includeGlobal";
        public Boolean includeGroup;
        public static final String INCLUDE_GROUP = "includeGroup";
        public Boolean includeGroupSet;
        public static final String INCLUDE_GROUP_SET = "includeGroupSet";
        public String invitedBy;
        public static final String INVITED_BY = "invitedBy";
        public String keywords;
        public static final String KEYWORDS = "keywords";
        public List<DateTime> lastLoginPeriod;
        public static final String LAST_LOGIN_PERIOD = "lastLoginPeriod";
        public Double latitude;
        public static final String LATITUDE = "latitude";
        public Double longitude;
        public static final String LONGITUDE = "longitude";
        public Boolean mainBrokerOnly;
        public static final String MAIN_BROKER_ONLY = "mainBrokerOnly";
        public Double maxDistance;
        public static final String MAX_DISTANCE = "maxDistance";
        public List<String> notAcceptedAgreements;
        public static final String NOT_ACCEPTED_AGREEMENTS = "notAcceptedAgreements";
        public UserOrderByEnum orderBy;
        public static final String ORDER_BY = "orderBy";
        public Integer page;
        public static final String PAGE = "page";
        public Integer pageSize;
        public static final String PAGE_SIZE = "pageSize";
        public List<String> products;
        public static final String PRODUCTS = "products";
        public Boolean productsIndividuallyAssigned;
        public static final String PRODUCTS_INDIVIDUALLY_ASSIGNED = "productsIndividuallyAssigned";
        public List<String> profileFields;
        public static final String PROFILE_FIELDS = "profileFields";
        public List<RoleEnum> roles;
        public static final String ROLES = "roles";
        public Boolean skipTotalCount;
        public static final String SKIP_TOTAL_COUNT = "skipTotalCount";
        public List<UserStatusEnum> statuses;
        public static final String STATUSES = "statuses";
        public List<String> usersToExclude;
        public static final String USERS_TO_EXCLUDE = "usersToExclude";
        public List<String> usersToInclude;
        public static final String USERS_TO_INCLUDE = "usersToInclude";
    }

    public static class SearchUsersParams {
        public List<String> fields;
        public static final String FIELDS = "fields";
        public List<String> acceptedAgreements;
        public static final String ACCEPTED_AGREEMENTS = "acceptedAgreements";
        public List<DateTime> activationPeriod;
        public static final String ACTIVATION_PERIOD = "activationPeriod";
        public UserAddressResultEnum addressResult;
        public static final String ADDRESS_RESULT = "addressResult";
        public List<String> brokers;
        public static final String BROKERS = "brokers";
        public String contactsOwner;
        public static final String CONTACTS_OWNER = "contactsOwner";
        public List<DateTime> creationPeriod;
        public static final String CREATION_PERIOD = "creationPeriod";
        public Boolean excludeContacts;
        public static final String EXCLUDE_CONTACTS = "excludeContacts";
        public Boolean fromMenu;
        public static final String FROM_MENU = "fromMenu";
        public List<String> groups;
        public static final String GROUPS = "groups";
        public Boolean hasBroker;
        public static final String HAS_BROKER = "hasBroker";
        public Boolean ignoreProfileFieldsInList;
        public static final String IGNORE_PROFILE_FIELDS_IN_LIST = "ignoreProfileFieldsInList";
        public Boolean includeGlobal;
        public static final String INCLUDE_GLOBAL = "includeGlobal";
        public Boolean includeGroup;
        public static final String INCLUDE_GROUP = "includeGroup";
        public Boolean includeGroupSet;
        public static final String INCLUDE_GROUP_SET = "includeGroupSet";
        public String invitedBy;
        public static final String INVITED_BY = "invitedBy";
        public String keywords;
        public static final String KEYWORDS = "keywords";
        public List<DateTime> lastLoginPeriod;
        public static final String LAST_LOGIN_PERIOD = "lastLoginPeriod";
        public Double latitude;
        public static final String LATITUDE = "latitude";
        public Double longitude;
        public static final String LONGITUDE = "longitude";
        public Boolean mainBrokerOnly;
        public static final String MAIN_BROKER_ONLY = "mainBrokerOnly";
        public Double maxDistance;
        public static final String MAX_DISTANCE = "maxDistance";
        public List<String> notAcceptedAgreements;
        public static final String NOT_ACCEPTED_AGREEMENTS = "notAcceptedAgreements";
        public UserOrderByEnum orderBy;
        public static final String ORDER_BY = "orderBy";
        public Integer page;
        public static final String PAGE = "page";
        public Integer pageSize;
        public static final String PAGE_SIZE = "pageSize";
        public List<String> products;
        public static final String PRODUCTS = "products";
        public Boolean productsIndividuallyAssigned;
        public static final String PRODUCTS_INDIVIDUALLY_ASSIGNED = "productsIndividuallyAssigned";
        public List<String> profileFields;
        public static final String PROFILE_FIELDS = "profileFields";
        public List<RoleEnum> roles;
        public static final String ROLES = "roles";
        public Boolean skipTotalCount;
        public static final String SKIP_TOTAL_COUNT = "skipTotalCount";
        public List<UserStatusEnum> statuses;
        public static final String STATUSES = "statuses";
        public List<String> usersToExclude;
        public static final String USERS_TO_EXCLUDE = "usersToExclude";
        public List<String> usersToInclude;
        public static final String USERS_TO_INCLUDE = "usersToInclude";
    }

    public static class ValidateUserRegistrationFieldParams {
        public String group;
        public static final String GROUP = "group";
        public String field;
        public static final String FIELD = "field";
        public String value;
        public static final String VALUE = "value";
        public Boolean asMember;
        public static final String AS_MEMBER = "asMember";
    }
}

