/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.api;

import java.util.List;
import org.cyclos.model.system.wizards.CustomWizardBackParams;
import org.cyclos.model.system.wizards.CustomWizardExecutionData;
import org.cyclos.model.system.wizards.CustomWizardTransitionParams;
import org.cyclos.model.system.wizards.CustomWizardVerificationCodeParams;
import org.cyclos.model.system.wizards.RunExternalRedirectCallbackParams;
import org.cyclos.model.system.wizards.StartCustomWizardParams;
import org.cyclos.services.system.CustomWizardService;
import org.cyclos.web.rest.api.BaseApiImpl;
import org.cyclos.web.rest.api.WizardsApi;
import org.cyclos.web.rest.helpers.WizardsApiHelper;
import org.cyclos.web.rest.model.HttpRequestData;
import org.cyclos.web.rest.model.WizardExecutionData;
import org.cyclos.web.rest.model.WizardTransitionParams;
import org.cyclos.web.rest.model.WizardVerificationCodeParams;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component
public class WizardsApiImpl
extends BaseApiImpl {
    @Autowired
    private CustomWizardService customWizardService;
    @Autowired
    private WizardsApiHelper wizardsApiHelper;

    public ResponseEntity<WizardExecutionData> backWizardExecution(String string, List<String> list, Integer n) {
        CustomWizardBackParams customWizardBackParams = this.wizardsApiHelper.toCustomWizardBackParams(string, n);
        CustomWizardExecutionData customWizardExecutionData = this.customWizardService.back(customWizardBackParams);
        WizardExecutionData wizardExecutionData = this.wizardsApiHelper.toWizardExecutionData(customWizardExecutionData);
        return this.ok(wizardExecutionData);
    }

    public ResponseEntity<Void> cancelWizardExecution(String string) {
        this.customWizardService.cancel(string);
        return ResponseEntity.noContent().build();
    }

    public ResponseEntity<WizardExecutionData> getCurrentWizardExecution(String string, List<String> list) {
        CustomWizardExecutionData customWizardExecutionData = this.customWizardService.current(string);
        WizardExecutionData wizardExecutionData = this.wizardsApiHelper.toWizardExecutionData(customWizardExecutionData);
        return this.ok(wizardExecutionData);
    }

    public ResponseEntity<String> redirectWizardExecution(String string, WizardTransitionParams wizardTransitionParams) {
        CustomWizardTransitionParams customWizardTransitionParams = this.wizardsApiHelper.toWizardTransitionParams(string, wizardTransitionParams, null);
        String string2 = this.customWizardService.externalRedirect(customWizardTransitionParams);
        return this.ok(string2);
    }

    public ResponseEntity<WizardExecutionData> runWizardCallback(String string, List<String> list, HttpRequestData httpRequestData) {
        RunExternalRedirectCallbackParams runExternalRedirectCallbackParams = this.wizardsApiHelper.toRunExternalRedirectCallbackParams(string, httpRequestData);
        CustomWizardExecutionData customWizardExecutionData = this.customWizardService.runExternalRedirectCallback(runExternalRedirectCallbackParams);
        WizardExecutionData wizardExecutionData = this.wizardsApiHelper.toWizardExecutionData(customWizardExecutionData);
        return this.ok(wizardExecutionData);
    }

    public ResponseEntity<Void> sendWizardVerificationCode(String string, WizardVerificationCodeParams wizardVerificationCodeParams) {
        CustomWizardVerificationCodeParams customWizardVerificationCodeParams = this.wizardsApiHelper.toCustomWizardVerificationCodeParams(string, wizardVerificationCodeParams);
        this.customWizardService.sendVerificationCode(customWizardVerificationCodeParams);
        return ResponseEntity.noContent().build();
    }

    public ResponseEntity<WizardExecutionData> startMenuWizard(String string, List<String> list) {
        return this.doStartWizard(null, null, string, list, null, null, null);
    }

    public ResponseEntity<WizardExecutionData> startUserWizard(String string, String string2, List<String> list) {
        return this.doStartWizard(string2, string, null, list, null, null, null);
    }

    public ResponseEntity<WizardExecutionData> startWizard(WizardsApi.StartWizardParams startWizardParams) {
        return this.doStartWizard(startWizardParams.key, null, null, startWizardParams.fields, startWizardParams.inviteToken, startWizardParams.externalPaymentToken, startWizardParams.userAgentId);
    }

    public ResponseEntity<WizardExecutionData> transitionWizardExecution(WizardsApi.TransitionWizardExecutionParams transitionWizardExecutionParams) {
        CustomWizardTransitionParams customWizardTransitionParams = this.wizardsApiHelper.toWizardTransitionParams(transitionWizardExecutionParams.key, transitionWizardExecutionParams.wizardTransitionParams, transitionWizardExecutionParams.transition);
        CustomWizardExecutionData customWizardExecutionData = this.customWizardService.transition(customWizardTransitionParams);
        WizardExecutionData wizardExecutionData = this.wizardsApiHelper.toWizardExecutionData(customWizardExecutionData);
        return this.ok(wizardExecutionData);
    }

    private ResponseEntity<WizardExecutionData> doStartWizard(String string, String string2, String string3, List<String> list, String string4, String string5, String string6) {
        StartCustomWizardParams startCustomWizardParams = this.wizardsApiHelper.toStartCustomWizardParams(string, string2, string3, string4, string5, string6);
        CustomWizardExecutionData customWizardExecutionData = this.customWizardService.start(startCustomWizardParams);
        WizardExecutionData wizardExecutionData = this.wizardsApiHelper.toWizardExecutionData(customWizardExecutionData);
        return this.ok(wizardExecutionData);
    }
}

