/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.exceptions;

import org.cyclos.web.rest.exceptions.ExceptionHelper;
import org.cyclos.web.rest.exceptions.RestErrorHandler;
import org.cyclos.web.rest.model.Error;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class BaseErrorHandler<E extends Error>
implements RestErrorHandler<E> {
    @Autowired
    private ExceptionHelper exceptionHelper;
    private Class<E> errorType;

    public BaseErrorHandler(Class<E> clazz) {
        this.errorType = clazz;
    }

    @Override
    public E getError(Throwable throwable) {
        E e = this.exceptionHelper.toError(this.errorType, throwable);
        this.fill(e, throwable);
        return e;
    }

    @Override
    public Class<E> getErrorType() {
        return this.errorType;
    }

    protected void fill(E e, Throwable throwable) {
    }
}

