/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.exceptions;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.cyclos.model.ConstraintViolatedOnRemoveException;
import org.cyclos.model.CredentialsNotSuppliedException;
import org.cyclos.model.CyclosException;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.MaxItemsException;
import org.cyclos.model.QueryParseException;
import org.cyclos.model.StaleEntityException;
import org.cyclos.model.ValidationException;
import org.cyclos.model.access.InvalidAccessTokenException;
import org.cyclos.model.access.LoginException;
import org.cyclos.model.access.PermissionDeniedException;
import org.cyclos.model.messaging.EmailSendingException;
import org.cyclos.model.messaging.sms.SmsSendingException;
import org.cyclos.server.model.AggregatedFrameworkExceptions;
import org.cyclos.services.access.GuestInvocationData;
import org.cyclos.services.access.InvocationData;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.StringHelper;
import org.cyclos.utils.coercion.CoercionException;
import org.cyclos.web.rest.exceptions.ExceptionHelper;
import org.cyclos.web.rest.exceptions.HttpStatusMappedErrorHolder;
import org.cyclos.web.rest.exceptions.RestErrorHandler;
import org.cyclos.web.rest.model.BadRequestError;
import org.cyclos.web.rest.model.ConflictError;
import org.cyclos.web.rest.model.Error;
import org.cyclos.web.rest.model.ForbiddenError;
import org.cyclos.web.rest.model.InputError;
import org.cyclos.web.rest.model.NotFoundError;
import org.cyclos.web.rest.model.UnauthorizedError;
import org.cyclos.web.rest.model.UnavailableError;
import org.cyclos.web.utils.ServletHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.core.convert.ConversionFailedException;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.context.request.async.AsyncRequestTimeoutException;
import org.springframework.web.method.annotation.MethodArgumentTypeMismatchException;
import org.springframework.web.multipart.MaxUploadSizeExceededException;
import org.springframework.web.servlet.NoHandlerFoundException;

@RestControllerAdvice
public class ExceptionResolver {
    private static final Logger LOG = LogManager.getLogger(ExceptionResolver.class);
    private Map<Class<? extends Error>, RestErrorHandler<?>> errorHandlerMap = new HashMap();
    @Autowired
    private ExceptionHelper exceptionHelper;
    @Autowired
    private ApplicationContext applicationContext;

    @ExceptionHandler(value={AggregatedFrameworkExceptions.class})
    public ResponseEntity<?> aggregatedFrameworkExceptions(AggregatedFrameworkExceptions aggregatedFrameworkExceptions) {
        InputError inputError = this.exceptionHelper.toInputError(aggregatedFrameworkExceptions);
        return ResponseEntity.unprocessableEntity().contentType(MediaType.APPLICATION_JSON).body((Object)inputError);
    }

    @ExceptionHandler(value={AsyncRequestTimeoutException.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public void asyncRequestTimeout(HttpServletRequest httpServletRequest, AsyncRequestTimeoutException asyncRequestTimeoutException) {
    }

    @ExceptionHandler(value={CoercionException.class})
    public ResponseEntity<InputError> coercion(HttpServletRequest httpServletRequest, CoercionException coercionException) {
        InputError inputError = this.exceptionHelper.toInputError(coercionException);
        return ResponseEntity.unprocessableEntity().contentType(MediaType.APPLICATION_JSON).body((Object)inputError);
    }

    @ExceptionHandler(value={ConversionFailedException.class})
    public ResponseEntity<InputError> conversionFailed(HttpServletRequest httpServletRequest, ConversionFailedException conversionFailedException) {
        InputError inputError = this.exceptionHelper.toInputError(conversionFailedException);
        return ResponseEntity.unprocessableEntity().contentType(MediaType.APPLICATION_JSON).body((Object)inputError);
    }

    @ExceptionHandler(value={CredentialsNotSuppliedException.class})
    public ResponseEntity<UnauthorizedError> credentialsNotSupplied(HttpServletRequest httpServletRequest, CredentialsNotSuppliedException credentialsNotSuppliedException) {
        UnauthorizedError unauthorizedError = this.exceptionHelper.toUnauthorizedError(credentialsNotSuppliedException);
        return ResponseEntity.status((HttpStatus)HttpStatus.UNAUTHORIZED).body((Object)unauthorizedError);
    }

    @ExceptionHandler(value={CyclosException.class})
    public ResponseEntity<?> cyclosException(HttpServletRequest httpServletRequest, CyclosException cyclosException) {
        HttpStatusMappedErrorHolder httpStatusMappedErrorHolder = this.exceptionHelper.toHttpStatusMappedErrorHolder(cyclosException);
        if (httpStatusMappedErrorHolder.getStatus() != null) {
            return ResponseEntity.status((HttpStatus)httpStatusMappedErrorHolder.getStatus()).contentType(MediaType.APPLICATION_JSON).body(httpStatusMappedErrorHolder.getError());
        }
        Error error = this.handleInternalServerError(httpServletRequest, (Throwable)cyclosException);
        return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).contentType(MediaType.APPLICATION_JSON).body((Object)error);
    }

    @ExceptionHandler(value={EmailSendingException.class})
    public ResponseEntity<UnavailableError> emailSending(HttpServletRequest httpServletRequest, EmailSendingException emailSendingException) {
        UnavailableError unavailableError = this.exceptionHelper.toUnavailableError(emailSendingException);
        return ResponseEntity.status((HttpStatus)HttpStatus.SERVICE_UNAVAILABLE).contentType(MediaType.APPLICATION_JSON).body((Object)unavailableError);
    }

    @ExceptionHandler(value={EntityNotFoundException.class})
    public ResponseEntity<NotFoundError> entityNotFound(HttpServletRequest httpServletRequest, EntityNotFoundException entityNotFoundException) {
        NotFoundError notFoundError = this.exceptionHelper.toNotFoundError(entityNotFoundException);
        return ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).contentType(MediaType.APPLICATION_JSON).body((Object)notFoundError);
    }

    @ExceptionHandler(value={HttpMessageNotReadableException.class})
    public ResponseEntity<?> httpMessageNotReadable(HttpServletRequest httpServletRequest, HttpMessageNotReadableException httpMessageNotReadableException) {
        int n = ExceptionUtils.indexOfType((Throwable)httpMessageNotReadableException, InvalidFormatException.class);
        if (n >= 0) {
            InvalidFormatException invalidFormatException = (InvalidFormatException)ExceptionUtils.getThrowableList((Throwable)httpMessageNotReadableException).get(n);
            ResponseEntity<InputError> responseEntity = this.invalidFormat(httpServletRequest, invalidFormatException);
            return ResponseEntity.unprocessableEntity().contentType(MediaType.APPLICATION_JSON).body(responseEntity);
        }
        n = ExceptionUtils.indexOfType((Throwable)httpMessageNotReadableException, JsonParseException.class);
        if (n >= 0) {
            JsonParseException jsonParseException = (JsonParseException)ExceptionUtils.getThrowableList((Throwable)httpMessageNotReadableException).get(n);
            return this.jsonParse(httpServletRequest, jsonParseException);
        }
        if (StringHelper.trim((Object)httpMessageNotReadableException.getMessage()).contains("Required request body is missing")) {
            return ResponseEntity.unprocessableEntity().body((Object)this.exceptionHelper.toMissingRequiredParameterError("requestBody"));
        }
        BadRequestError badRequestError = this.exceptionHelper.badRequest(httpServletRequest, httpMessageNotReadableException);
        return ResponseEntity.badRequest().contentType(MediaType.APPLICATION_JSON).body((Object)badRequestError);
    }

    @ExceptionHandler(value={Throwable.class})
    public ResponseEntity<Error> internalServerError(HttpServletRequest httpServletRequest, Throwable throwable) {
        Error error = this.handleInternalServerError(httpServletRequest, throwable);
        return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).contentType(MediaType.APPLICATION_JSON).body((Object)error);
    }

    @ExceptionHandler(value={InvalidAccessTokenException.class})
    public ResponseEntity<UnauthorizedError> invalidAccessTokenException(HttpServletRequest httpServletRequest, InvalidAccessTokenException invalidAccessTokenException) {
        UnauthorizedError unauthorizedError = this.exceptionHelper.toUnauthorizedError(invalidAccessTokenException);
        return ResponseEntity.status((HttpStatus)HttpStatus.UNAUTHORIZED).contentType(MediaType.APPLICATION_JSON).body((Object)unauthorizedError);
    }

    @ExceptionHandler(value={InvalidFormatException.class})
    public ResponseEntity<InputError> invalidFormat(HttpServletRequest httpServletRequest, InvalidFormatException invalidFormatException) {
        InputError inputError = this.exceptionHelper.toInputError(invalidFormatException);
        return ResponseEntity.unprocessableEntity().contentType(MediaType.APPLICATION_JSON).body((Object)inputError);
    }

    @ExceptionHandler(value={LoginException.class})
    public ResponseEntity<UnauthorizedError> login(HttpServletRequest httpServletRequest, LoginException loginException) {
        UnauthorizedError unauthorizedError = this.exceptionHelper.toUnauthorizedError(loginException);
        return ResponseEntity.status((HttpStatus)HttpStatus.UNAUTHORIZED).contentType(MediaType.APPLICATION_JSON).body((Object)unauthorizedError);
    }

    @ExceptionHandler(value={MaxItemsException.class})
    public ResponseEntity<InputError> maxItems(HttpServletRequest httpServletRequest, MaxItemsException maxItemsException) {
        InputError inputError = this.exceptionHelper.toInputError(maxItemsException);
        return ResponseEntity.unprocessableEntity().contentType(MediaType.APPLICATION_JSON).body((Object)inputError);
    }

    @ExceptionHandler(value={MaxUploadSizeExceededException.class})
    public ResponseEntity<InputError> maxUploadSizeExceededException(MaxUploadSizeExceededException maxUploadSizeExceededException) {
        InputError inputError = this.exceptionHelper.toInputError(maxUploadSizeExceededException);
        return ResponseEntity.unprocessableEntity().body((Object)inputError);
    }

    @ExceptionHandler(value={MethodArgumentTypeMismatchException.class})
    public ResponseEntity<InputError> methodArgumentTypeMismatch(HttpServletRequest httpServletRequest, MethodArgumentTypeMismatchException methodArgumentTypeMismatchException) {
        int n = ExceptionUtils.indexOfType((Throwable)methodArgumentTypeMismatchException, CoercionException.class);
        if (n >= 0) {
            CoercionException coercionException = (CoercionException)ExceptionUtils.getThrowableList((Throwable)methodArgumentTypeMismatchException).get(n);
            return this.coercion(httpServletRequest, coercionException);
        }
        n = ExceptionUtils.indexOfType((Throwable)methodArgumentTypeMismatchException, ConversionFailedException.class);
        if (n >= 0) {
            ConversionFailedException conversionFailedException = (ConversionFailedException)ExceptionUtils.getThrowableList((Throwable)methodArgumentTypeMismatchException).get(n);
            return this.conversionFailed(httpServletRequest, conversionFailedException);
        }
        InputError inputError = this.exceptionHelper.toInputError(methodArgumentTypeMismatchException);
        return ResponseEntity.unprocessableEntity().body((Object)inputError);
    }

    @ExceptionHandler(value={MissingServletRequestParameterException.class})
    public ResponseEntity<InputError> missingRequiredParameter(HttpServletRequest httpServletRequest, MissingServletRequestParameterException missingServletRequestParameterException) {
        InputError inputError = this.exceptionHelper.toMissingRequiredParameterError(missingServletRequestParameterException);
        return ResponseEntity.unprocessableEntity().body((Object)inputError);
    }

    @ExceptionHandler(value={NoHandlerFoundException.class})
    public ResponseEntity<NotFoundError> noHandlerFound(HttpServletRequest httpServletRequest, NoHandlerFoundException noHandlerFoundException) {
        NotFoundError notFoundError = this.exceptionHelper.toNotFoundError(noHandlerFoundException);
        return ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).body((Object)notFoundError);
    }

    @ExceptionHandler(value={PermissionDeniedException.class})
    public ResponseEntity<?> permissionDenied(HttpServletRequest httpServletRequest, PermissionDeniedException permissionDeniedException) {
        InvocationData invocationData = ServletHelper.resolveInvocationData(httpServletRequest);
        if (invocationData == null || invocationData instanceof GuestInvocationData) {
            UnauthorizedError unauthorizedError = this.exceptionHelper.toUnauthorizedError(permissionDeniedException);
            return ResponseEntity.status((HttpStatus)HttpStatus.UNAUTHORIZED).contentType(MediaType.APPLICATION_JSON).body((Object)unauthorizedError);
        }
        ForbiddenError forbiddenError = this.exceptionHelper.toForbiddenError(permissionDeniedException);
        return ResponseEntity.status((HttpStatus)HttpStatus.FORBIDDEN).contentType(MediaType.APPLICATION_JSON).body((Object)forbiddenError);
    }

    @ExceptionHandler(value={QueryParseException.class})
    public ResponseEntity<InputError> queryParse(HttpServletRequest httpServletRequest, QueryParseException queryParseException) {
        InputError inputError = this.exceptionHelper.toInputError(queryParseException);
        return ResponseEntity.unprocessableEntity().contentType(MediaType.APPLICATION_JSON).body((Object)inputError);
    }

    @ExceptionHandler(value={SmsSendingException.class})
    public ResponseEntity<UnavailableError> smsSending(HttpServletRequest httpServletRequest, SmsSendingException smsSendingException) {
        UnavailableError unavailableError = this.exceptionHelper.toUnavailableError(smsSendingException);
        return ResponseEntity.status((HttpStatus)HttpStatus.SERVICE_UNAVAILABLE).contentType(MediaType.APPLICATION_JSON).body((Object)unavailableError);
    }

    @ExceptionHandler(value={ConstraintViolatedOnRemoveException.class})
    public ResponseEntity<ConflictError> staleEntity(HttpServletRequest httpServletRequest, ConstraintViolatedOnRemoveException constraintViolatedOnRemoveException) {
        ConflictError conflictError = this.exceptionHelper.toConflictError(constraintViolatedOnRemoveException);
        return ResponseEntity.status((HttpStatus)HttpStatus.CONFLICT).contentType(MediaType.APPLICATION_JSON).body((Object)conflictError);
    }

    @ExceptionHandler(value={StaleEntityException.class})
    public ResponseEntity<ConflictError> staleEntity(HttpServletRequest httpServletRequest, StaleEntityException staleEntityException) {
        ConflictError conflictError = this.exceptionHelper.toConflictError(staleEntityException);
        return ResponseEntity.status((HttpStatus)HttpStatus.CONFLICT).contentType(MediaType.APPLICATION_JSON).body((Object)conflictError);
    }

    @ExceptionHandler(value={ValidationException.class})
    public ResponseEntity<InputError> validation(HttpServletRequest httpServletRequest, ValidationException validationException) {
        InputError inputError = this.exceptionHelper.toInputError(validationException);
        return ResponseEntity.unprocessableEntity().contentType(MediaType.APPLICATION_JSON).body((Object)inputError);
    }

    private Error handleInternalServerError(HttpServletRequest httpServletRequest, Throwable throwable) {
        LOG.error("Error on REST service", throwable);
        Class clazz = (Class)ObjectHelper.coalesce((Object[])new Class[]{(Class)httpServletRequest.getAttribute("errorType"), Error.class});
        RestErrorHandler<?> restErrorHandler = this.errorHandlerMap.get(clazz);
        Objects.requireNonNull(restErrorHandler, "Missing error handler for type: " + String.valueOf(clazz));
        Object obj = restErrorHandler.getError(throwable);
        return obj;
    }

    @PostConstruct
    private void initialize() {
        this.errorHandlerMap = this.applicationContext.getBeansOfType(RestErrorHandler.class).values().stream().collect(Collectors.toMap(RestErrorHandler::getErrorType, restErrorHandler -> restErrorHandler));
    }

    @ExceptionHandler(value={JsonParseException.class})
    private ResponseEntity<BadRequestError> jsonParse(HttpServletRequest httpServletRequest, JsonParseException jsonParseException) {
        BadRequestError badRequestError = this.exceptionHelper.badRequest(jsonParseException);
        return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).contentType(MediaType.APPLICATION_JSON).body((Object)badRequestError);
    }
}

