/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.exceptions;

import org.cyclos.model.FrameworkException;
import org.cyclos.server.model.NestedFrameworkException;
import org.cyclos.web.rest.exceptions.BaseErrorHandler;
import org.cyclos.web.rest.exceptions.ExceptionHelper;
import org.cyclos.web.rest.model.Error;
import org.cyclos.web.rest.model.NestedError;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class NestedErrorHandler
extends BaseErrorHandler<NestedError> {
    @Autowired
    private ExceptionHelper exceptionHelper;

    public NestedErrorHandler() {
        super(NestedError.class);
    }

    @Override
    protected void fill(NestedError nestedError, Throwable throwable) {
        super.fill(nestedError, throwable);
        if (throwable instanceof NestedFrameworkException) {
            NestedFrameworkException nestedFrameworkException = (NestedFrameworkException)throwable;
            nestedError.setProperty(nestedFrameworkException.getPropertyName());
            nestedError.setIndex(nestedFrameworkException.getIndex());
            FrameworkException frameworkException = nestedFrameworkException.getException();
            nestedError.setInputError(this.exceptionHelper.toInputError((Exception)frameworkException, true));
            nestedError.setConflictError(this.exceptionHelper.toConflictError((Exception)frameworkException));
            nestedError.setNotFoundError(this.exceptionHelper.toNotFoundError((Exception)frameworkException));
            nestedError.setForbiddenError(this.exceptionHelper.toForbiddenError((Exception)frameworkException));
            nestedError.setUnauthorizedError(this.exceptionHelper.toUnauthorizedError((Exception)frameworkException));
            nestedError.setError(this.exceptionHelper.toError(Error.class, (Throwable)frameworkException));
        }
    }
}

