/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.exceptions;

import java.util.Map;
import org.cyclos.services.access.OidcException;
import org.cyclos.services.access.OidcRegisterException;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.StringHelper;
import org.cyclos.web.rest.exceptions.BaseErrorHandler;
import org.cyclos.web.rest.model.OidcError;
import org.springframework.stereotype.Component;

@Component
public class OidcErrorHandler
extends BaseErrorHandler<OidcError> {
    public OidcErrorHandler() {
        super(OidcError.class);
    }

    @Override
    protected void fill(OidcError oidcError, Throwable throwable) {
        if (throwable instanceof OidcException) {
            OidcException oidcException = (OidcException)throwable;
            Map map = CollectionHelper.orEmpty(oidcException.getResponse() == null ? null : oidcException.getResponse().getParameters());
            oidcError.setError(StringHelper.trimToNull(map.get("error")));
            oidcError.setErrorDescription(StringHelper.trimToNull(map.get("error_description")));
        } else if (throwable instanceof OidcRegisterException) {
            OidcRegisterException oidcRegisterException = (OidcRegisterException)throwable;
            oidcError.setError(oidcRegisterException.getError());
            oidcError.setErrorDescription(oidcRegisterException.getDescription());
        }
    }
}

