/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.exceptions;

import org.cyclos.model.access.TokenAlreadyInUseException;
import org.cyclos.web.rest.exceptions.BaseErrorHandler;
import org.cyclos.web.rest.helpers.TokensApiHelper;
import org.cyclos.web.rest.model.PersonalizeNfcError;
import org.cyclos.web.rest.model.PersonalizeNfcErrorCode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PersonalizeNfcErrorHandler
extends BaseErrorHandler<PersonalizeNfcError> {
    @Autowired
    private TokensApiHelper tokensApiHelper;

    public PersonalizeNfcErrorHandler() {
        super(PersonalizeNfcError.class);
    }

    @Override
    protected void fill(PersonalizeNfcError personalizeNfcError, Throwable throwable) {
        if (throwable instanceof TokenAlreadyInUseException) {
            personalizeNfcError.setCode(PersonalizeNfcErrorCode.TOKEN_IN_USE);
            personalizeNfcError.setToken(this.tokensApiHelper.toTokenDetailed(((TokenAlreadyInUseException)throwable).getToken()));
        } else {
            personalizeNfcError.setCode(PersonalizeNfcErrorCode.UNEXPECTED);
        }
    }
}

