/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.exceptions;

import org.cyclos.model.banking.PosPayerInaccessiblePrincipalException;
import org.cyclos.model.banking.PosPayerNotInChannelException;
import org.cyclos.model.banking.PosPayerNotOperativeException;
import org.cyclos.web.rest.exceptions.BaseErrorHandler;
import org.cyclos.web.rest.model.PosError;
import org.cyclos.web.rest.model.PosErrorCode;
import org.springframework.stereotype.Component;

@Component
public class PosErrorHandler
extends BaseErrorHandler<PosError> {
    public PosErrorHandler() {
        super(PosError.class);
    }

    @Override
    protected void fill(PosError posError, Throwable throwable) {
        PosErrorCode posErrorCode = PosErrorCode.UNEXPECTED;
        Class<?> clazz = throwable.getClass();
        if (clazz == PosPayerNotInChannelException.class) {
            posErrorCode = PosErrorCode.PAYER_NOT_IN_CHANNEL;
        } else if (clazz == PosPayerNotOperativeException.class) {
            posErrorCode = PosErrorCode.PAYER_NOT_OPERATIVE;
        } else if (clazz == PosPayerInaccessiblePrincipalException.class) {
            posErrorCode = PosErrorCode.PAYER_INACCESSIBLE_PRINCIPAL;
        }
        posError.setCode(posErrorCode);
    }
}

