/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.exceptions;

import java.util.List;
import org.cyclos.model.banking.TransferException;
import org.cyclos.model.banking.vouchers.InsufficientVoucherBalanceException;
import org.cyclos.model.banking.vouchers.RedeemingNotAllowedForUserException;
import org.cyclos.model.banking.vouchers.RedeemingNotAllowedForVoucherException;
import org.cyclos.model.banking.vouchers.RedeemingNotAllowedTodayException;
import org.cyclos.model.banking.vouchers.RedeemingNotAllowedYetException;
import org.cyclos.model.banking.vouchers.RedeemingUserBlockedException;
import org.cyclos.model.utils.CurrencyAmountDTO;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.web.rest.exceptions.BaseErrorHandler;
import org.cyclos.web.rest.exceptions.PaymentErrorHandler;
import org.cyclos.web.rest.helpers.AccountsApiHelper;
import org.cyclos.web.rest.helpers.ApiHelper;
import org.cyclos.web.rest.helpers.VouchersApiHelper;
import org.cyclos.web.rest.model.PaymentError;
import org.cyclos.web.rest.model.RedeemVoucherError;
import org.cyclos.web.rest.model.RedeemVoucherErrorCode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RedeemVoucherErrorHandler
extends BaseErrorHandler<RedeemVoucherError> {
    @Autowired
    private ApiHelper apiHelper;
    @Autowired
    private VouchersApiHelper vouchersApiHelper;
    @Autowired
    private AccountsApiHelper accountsApiHelper;
    @Autowired
    private PaymentErrorHandler paymentErrorHandler;

    public RedeemVoucherErrorHandler() {
        super(RedeemVoucherError.class);
    }

    @Override
    protected void fill(RedeemVoucherError redeemVoucherError, Throwable throwable) {
        RedeemVoucherErrorCode redeemVoucherErrorCode = RedeemVoucherErrorCode.UNEXPECTED;
        Class<?> clazz = throwable.getClass();
        if (clazz == RedeemingNotAllowedForVoucherException.class) {
            redeemVoucherErrorCode = RedeemVoucherErrorCode.NOT_ALLOWED_FOR_VOUCHER;
        } else if (clazz == RedeemingNotAllowedForUserException.class) {
            redeemVoucherErrorCode = RedeemVoucherErrorCode.NOT_ALLOWED_FOR_USER;
        } else if (clazz == RedeemingNotAllowedTodayException.class) {
            redeemVoucherErrorCode = RedeemVoucherErrorCode.NOT_ALLOWED_TODAY;
        } else if (clazz == RedeemingNotAllowedYetException.class) {
            redeemVoucherErrorCode = RedeemVoucherErrorCode.NOT_ALLOWED_YET;
        } else if (clazz == InsufficientVoucherBalanceException.class) {
            redeemVoucherErrorCode = RedeemVoucherErrorCode.INSUFFICIENT_BALANCE;
        } else if (clazz == RedeemingUserBlockedException.class) {
            redeemVoucherErrorCode = RedeemVoucherErrorCode.USER_BLOCKED;
        } else if (TransferException.class.isAssignableFrom(clazz)) {
            redeemVoucherErrorCode = RedeemVoucherErrorCode.PAYMENT;
        }
        redeemVoucherError.setCode(redeemVoucherErrorCode);
        if (throwable instanceof InsufficientVoucherBalanceException) {
            InsufficientVoucherBalanceException insufficientVoucherBalanceException = (InsufficientVoucherBalanceException)throwable;
            CurrencyAmountDTO currencyAmountDTO = insufficientVoucherBalanceException.getBalance();
            if (currencyAmountDTO != null) {
                redeemVoucherError.setBalance(currencyAmountDTO.getAmount());
                redeemVoucherError.setCurrency(this.accountsApiHelper.toCurrency(currencyAmountDTO));
            }
        } else if (throwable instanceof RedeemingNotAllowedForVoucherException) {
            RedeemingNotAllowedForVoucherException redeemingNotAllowedForVoucherException = (RedeemingNotAllowedForVoucherException)throwable;
            redeemVoucherError.setVoucherStatus(this.vouchersApiHelper.toVoucherStatusEnum(redeemingNotAllowedForVoucherException.getStatus()));
        } else if (throwable instanceof RedeemingNotAllowedTodayException) {
            RedeemingNotAllowedTodayException redeemingNotAllowedTodayException = (RedeemingNotAllowedTodayException)throwable;
            CollectionHelper.orEmpty((List)redeemingNotAllowedTodayException.getAllowedDays()).stream().map(this.apiHelper::toWeekDayEnum).forEach(redeemVoucherError.getAllowedDays()::add);
        } else if (throwable instanceof RedeemingNotAllowedYetException) {
            RedeemingNotAllowedYetException redeemingNotAllowedYetException = (RedeemingNotAllowedYetException)throwable;
            redeemVoucherError.setRedeemAfterDate(redeemingNotAllowedYetException.getRedeemAfterDate());
        } else if (throwable instanceof TransferException) {
            redeemVoucherError.setPaymentError((PaymentError)this.paymentErrorHandler.getError(throwable));
        }
        if (!(throwable instanceof RedeemingNotAllowedTodayException)) {
            redeemVoucherError.setAllowedDays(null);
        }
    }
}

