/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.exceptions;

import org.cyclos.model.banking.InsufficientBalanceException;
import org.cyclos.web.rest.exceptions.BaseErrorHandler;
import org.cyclos.web.rest.exceptions.ShoppingCartErrorHandler;
import org.cyclos.web.rest.model.ShoppingCartCheckoutError;
import org.cyclos.web.rest.model.ShoppingCartCheckoutErrorCode;
import org.cyclos.web.rest.model.ShoppingCartError;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ShoppingCartCheckoutErrorHandler
extends BaseErrorHandler<ShoppingCartCheckoutError> {
    @Autowired
    private ShoppingCartErrorHandler shoppingCartErrorHandler;

    public ShoppingCartCheckoutErrorHandler() {
        super(ShoppingCartCheckoutError.class);
    }

    @Override
    protected void fill(ShoppingCartCheckoutError shoppingCartCheckoutError, Throwable throwable) {
        if (throwable instanceof InsufficientBalanceException) {
            shoppingCartCheckoutError.setCode(ShoppingCartCheckoutErrorCode.INSUFFICIENT_BALANCE);
        } else if (this.shoppingCartErrorHandler.isHandled(throwable)) {
            shoppingCartCheckoutError.setCode(ShoppingCartCheckoutErrorCode.PRODUCTS);
            shoppingCartCheckoutError.setShoppingCartError((ShoppingCartError)this.shoppingCartErrorHandler.getError(throwable));
        } else {
            shoppingCartCheckoutError.setCode(ShoppingCartCheckoutErrorCode.UNEXPECTED);
        }
    }
}

