/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.helpers;

import java.util.List;
import java.util.Map;
import org.cyclos.model.Bean;
import org.cyclos.model.EntityModel;
import org.cyclos.model.EntityVO;
import org.cyclos.model.IEntity;
import org.cyclos.model.banking.accounts.AccountBalanceHistoryParams;
import org.cyclos.model.banking.accounts.AccountBalanceHistoryVO;
import org.cyclos.model.banking.accounts.AccountHistoryData;
import org.cyclos.model.banking.accounts.AccountHistoryEntryVO;
import org.cyclos.model.banking.accounts.AccountHistoryQuery;
import org.cyclos.model.banking.accounts.AccountHistoryStatusVO;
import org.cyclos.model.banking.accounts.AccountOwner;
import org.cyclos.model.banking.accounts.AccountStatusVO;
import org.cyclos.model.banking.accounts.AccountVO;
import org.cyclos.model.banking.accounts.AccountWithCurrencyVO;
import org.cyclos.model.banking.accounts.AccountWithHistoryStatusVO;
import org.cyclos.model.banking.accounts.AccountWithStatusVO;
import org.cyclos.model.banking.accounts.BalanceEntryVO;
import org.cyclos.model.banking.accounts.BalanceLevel;
import org.cyclos.model.banking.accounts.BaseTransferQuery;
import org.cyclos.model.banking.accounts.SystemAccountOwner;
import org.cyclos.model.banking.accounts.TransferSearchData;
import org.cyclos.model.banking.accounts.UserWithBalanceOrderBy;
import org.cyclos.model.banking.accounts.UserWithBalanceQuery;
import org.cyclos.model.banking.accounts.UserWithBalanceSearchData;
import org.cyclos.model.banking.accounts.UserWithBalanceVO;
import org.cyclos.model.banking.accounts.UsersWithBalancesOverview;
import org.cyclos.model.banking.accounttypes.AccountTypeNature;
import org.cyclos.model.banking.accounttypes.AccountTypeVO;
import org.cyclos.model.banking.accounttypes.AccountTypeWithCurrencyVO;
import org.cyclos.model.banking.accounttypes.AccountTypeWithDefaultYellowBalanceRangeVO;
import org.cyclos.model.banking.currencies.CurrencyVO;
import org.cyclos.model.banking.transferfilters.TransferFilterVO;
import org.cyclos.model.banking.transferfilters.TransferFilterWithAccountTypeVO;
import org.cyclos.model.banking.transferstatus.TransferStatusWithFlowVO;
import org.cyclos.model.banking.transfertypes.TransferTypeVO;
import org.cyclos.model.banking.transfertypes.TransferTypeWithCurrencyVO;
import org.cyclos.model.users.users.AbstractUserQuery;
import org.cyclos.model.users.users.AbstractUserSearchData;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.model.users.users.IUser;
import org.cyclos.model.users.users.IUserWithFieldsVO;
import org.cyclos.model.users.users.UserAccountData;
import org.cyclos.model.users.users.UserVO;
import org.cyclos.model.utils.AmountSummaryVO;
import org.cyclos.model.utils.CurrencyAmountDTO;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.server.utils.ClassHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.web.rest.api.AccountsApi;
import org.cyclos.web.rest.helpers.ApiHelper;
import org.cyclos.web.rest.helpers.ImagesApiHelper;
import org.cyclos.web.rest.helpers.TransactionsApiHelper;
import org.cyclos.web.rest.helpers.TransfersApiHelper;
import org.cyclos.web.rest.helpers.UsersApiHelper;
import org.cyclos.web.rest.model.Account;
import org.cyclos.web.rest.model.AccountActivityStatus;
import org.cyclos.web.rest.model.AccountBalanceEntry;
import org.cyclos.web.rest.model.AccountBalanceHistoryResult;
import org.cyclos.web.rest.model.AccountHistoryQueryFilters;
import org.cyclos.web.rest.model.AccountHistoryResult;
import org.cyclos.web.rest.model.AccountHistoryStatus;
import org.cyclos.web.rest.model.AccountKind;
import org.cyclos.web.rest.model.AccountStatus;
import org.cyclos.web.rest.model.AccountType;
import org.cyclos.web.rest.model.AccountTypeWithDefaultMediumBalanceRange;
import org.cyclos.web.rest.model.AccountWithCurrency;
import org.cyclos.web.rest.model.AccountWithHistoryStatus;
import org.cyclos.web.rest.model.AccountWithOwner;
import org.cyclos.web.rest.model.AccountWithOwnerAndCurrency;
import org.cyclos.web.rest.model.AccountWithStatus;
import org.cyclos.web.rest.model.AmountSummary;
import org.cyclos.web.rest.model.BalanceLevelEnum;
import org.cyclos.web.rest.model.Currency;
import org.cyclos.web.rest.model.CurrencyAmountSummary;
import org.cyclos.web.rest.model.DataForAccountHistory;
import org.cyclos.web.rest.model.DataForUserBalancesSearch;
import org.cyclos.web.rest.model.OwnerAccountsListData;
import org.cyclos.web.rest.model.RelatedTransferType;
import org.cyclos.web.rest.model.TransferFilter;
import org.cyclos.web.rest.model.TransferType;
import org.cyclos.web.rest.model.TransferTypeWithCurrency;
import org.cyclos.web.rest.model.User;
import org.cyclos.web.rest.model.UserWithBalanceResult;
import org.cyclos.web.rest.model.UsersWithBalanceOrderByEnum;
import org.cyclos.web.rest.model.UsersWithBalanceQueryFilters;
import org.cyclos.web.rest.model.UsersWithBalanceSummary;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AccountsApiHelper {
    @Autowired
    private ApiHelper apiHelper;
    @Autowired
    private TransfersApiHelper transfersApiHelper;
    @Autowired
    private TransactionsApiHelper transactionsApiHelper;
    @Autowired
    private UsersApiHelper usersApiHelper;
    @Autowired
    private ImagesApiHelper imagesApiHelper;

    public String identifier(AccountOwner accountOwner) {
        return ModelHelper.identifier((AccountOwner)accountOwner, (boolean)false);
    }

    public <R extends AccountBalanceHistoryResult> R newAccountBalanceHistoryResult(Class<R> clazz, AccountBalanceHistoryVO accountBalanceHistoryVO) {
        AccountBalanceHistoryResult accountBalanceHistoryResult = (AccountBalanceHistoryResult)ClassHelper.instantiate(clazz);
        accountBalanceHistoryResult.setAccount(this.toAccountWithHistoryStatus(accountBalanceHistoryVO.getAccount(), accountBalanceHistoryVO.getStatus()));
        accountBalanceHistoryResult.setInterval(this.apiHelper.toTimeInterval(accountBalanceHistoryVO.getInterval()));
        CollectionHelper.orEmpty((List)accountBalanceHistoryVO.getBalances()).stream().map(this::toAccountBalanceEntry).forEach(accountBalanceHistoryResult.getBalances()::add);
        return (R)accountBalanceHistoryResult;
    }

    public AccountBalanceEntry toAccountBalanceEntry(BalanceEntryVO balanceEntryVO) {
        if (balanceEntryVO == null) {
            return null;
        }
        AccountBalanceEntry accountBalanceEntry = new AccountBalanceEntry();
        accountBalanceEntry.setDate(balanceEntryVO.getDate());
        accountBalanceEntry.setAmount(balanceEntryVO.getAmount());
        return accountBalanceEntry;
    }

    public AccountBalanceHistoryParams toAccountBalanceHistoryParams(AccountsApi.GetAccountBalanceHistoryParams getAccountBalanceHistoryParams) {
        AccountBalanceHistoryParams accountBalanceHistoryParams = new AccountBalanceHistoryParams();
        accountBalanceHistoryParams.setAccount(this.toAccountVO(getAccountBalanceHistoryParams.owner, getAccountBalanceHistoryParams.accountType));
        accountBalanceHistoryParams.setPeriod(this.apiHelper.toDatePeriodDTO(getAccountBalanceHistoryParams.datePeriod));
        accountBalanceHistoryParams.setInterval(this.apiHelper.toTimeIntervalDTO(getAccountBalanceHistoryParams.intervalCount, getAccountBalanceHistoryParams.intervalUnit));
        return accountBalanceHistoryParams;
    }

    public AccountBalanceHistoryResult toAccountBalanceHistoryResult(AccountBalanceHistoryVO accountBalanceHistoryVO) {
        if (accountBalanceHistoryVO == null) {
            return null;
        }
        return this.newAccountBalanceHistoryResult(AccountBalanceHistoryResult.class, accountBalanceHistoryVO);
    }

    public AccountHistoryQuery toAccountHistoryQuery(String string, String string2, AccountHistoryQueryFilters accountHistoryQueryFilters) {
        AccountHistoryQuery accountHistoryQuery = this.transfersApiHelper.newBaseTransferQuery(AccountHistoryQuery.class, accountHistoryQueryFilters);
        accountHistoryQuery.setAccount(this.toAccountVO(string, string2));
        accountHistoryQuery.setDirection(this.transfersApiHelper.toTransferDirection(accountHistoryQueryFilters.getDirection()));
        accountHistoryQuery.setDescription(accountHistoryQueryFilters.getDescription());
        return accountHistoryQuery;
    }

    public AccountHistoryQueryFilters toAccountHistoryQueryFilters(AccountHistoryQuery accountHistoryQuery) {
        AccountHistoryQueryFilters accountHistoryQueryFilters = this.transfersApiHelper.newBaseTransferQueryFilters(AccountHistoryQueryFilters.class, (BaseTransferQuery)accountHistoryQuery);
        accountHistoryQueryFilters.setDirection(this.transfersApiHelper.toTransferDirectionEnum(accountHistoryQuery.getDirection()));
        accountHistoryQueryFilters.setDescription(accountHistoryQuery.getDescription());
        return accountHistoryQueryFilters;
    }

    public AccountHistoryResult toAccountHistoryResult(AccountHistoryEntryVO accountHistoryEntryVO) {
        if (accountHistoryEntryVO == null) {
            return null;
        }
        AccountHistoryResult accountHistoryResult = this.apiHelper.newEntity(AccountHistoryResult.class, accountHistoryEntryVO);
        accountHistoryResult.setDate(accountHistoryEntryVO.getDate());
        accountHistoryResult.setAmount(accountHistoryEntryVO.getAmount());
        accountHistoryResult.setRelatedAccount(this.toAccountWithOwner(accountHistoryEntryVO.getRelatedAccount()));
        accountHistoryResult.setRelatedName(accountHistoryEntryVO.getRelatedName());
        accountHistoryResult.setCustomValues(this.apiHelper.toCustomFieldValuesMap(accountHistoryEntryVO.getCustomValues()));
        accountHistoryResult.setType(this.apiHelper.toReference((EntityModel)accountHistoryEntryVO.getType()));
        accountHistoryResult.setTransaction(this.transactionsApiHelper.toTransaction(accountHistoryEntryVO.getTransactionId(), accountHistoryEntryVO.getTransactionNature(), accountHistoryEntryVO.getTransactionTransactionNumber()));
        accountHistoryResult.setTransactionNumber(accountHistoryEntryVO.getTransactionNumber());
        accountHistoryResult.setDescription(accountHistoryEntryVO.getDescription());
        accountHistoryResult.setImage(this.imagesApiHelper.toImage(accountHistoryEntryVO.getImage()));
        if (CollectionHelper.isEmpty((Iterable)accountHistoryEntryVO.getStatuses())) {
            accountHistoryResult.setStatuses(null);
        } else {
            for (TransferStatusWithFlowVO transferStatusWithFlowVO : accountHistoryEntryVO.getStatuses()) {
                String string = ModelHelper.unqualifiedInternalNameOrId((IEntity)transferStatusWithFlowVO.getFlow());
                accountHistoryResult.getStatuses().put(string, ModelHelper.unqualifiedInternalNameOrId((IEntity)transferStatusWithFlowVO));
            }
        }
        return accountHistoryResult;
    }

    public AccountHistoryStatus toAccountHistoryStatus(AccountHistoryStatusVO accountHistoryStatusVO) {
        if (accountHistoryStatusVO == null) {
            return null;
        }
        AccountHistoryStatus accountHistoryStatus = this.newAccountStatus(AccountHistoryStatus.class, (AccountStatusVO)accountHistoryStatusVO);
        accountHistoryStatus.setBeginDate(accountHistoryStatusVO.getBeginDate());
        accountHistoryStatus.setBalanceAtBegin(accountHistoryStatusVO.getBalanceAtBegin());
        accountHistoryStatus.setEndDate(accountHistoryStatusVO.getEndDate());
        accountHistoryStatus.setBalanceAtEnd(accountHistoryStatusVO.getBalanceAtEnd());
        accountHistoryStatus.setIncoming(this.toAmountSummary(accountHistoryStatusVO.getIncoming()));
        accountHistoryStatus.setOutgoing(this.toAmountSummary(accountHistoryStatusVO.getOutgoing()));
        accountHistoryStatus.setNetInflow(accountHistoryStatusVO.getNetInflow());
        return accountHistoryStatus;
    }

    public AccountKind toAccountKind(AccountOwner accountOwner) {
        if (accountOwner instanceof SystemAccountOwner) {
            return AccountKind.SYSTEM;
        }
        if (accountOwner instanceof IUser) {
            return AccountKind.USER;
        }
        return null;
    }

    public AccountKind toAccountKind(AccountTypeNature accountTypeNature) {
        if (accountTypeNature != null) {
            switch (accountTypeNature) {
                case SYSTEM: {
                    return AccountKind.SYSTEM;
                }
                case USER: {
                    return AccountKind.USER;
                }
            }
        }
        return null;
    }

    public AccountActivityStatus toAccountStatus(AccountStatusVO accountStatusVO) {
        if (accountStatusVO == null) {
            return null;
        }
        return this.newAccountStatus(AccountActivityStatus.class, accountStatusVO);
    }

    public AccountType toAccountType(AccountTypeVO accountTypeVO) {
        if (accountTypeVO == null) {
            return null;
        }
        AccountType accountType = this.apiHelper.newEntity(AccountType.class, accountTypeVO);
        if (accountTypeVO instanceof AccountTypeWithCurrencyVO) {
            accountType.setCurrency(this.toCurrency(((AccountTypeWithCurrencyVO)accountTypeVO).getCurrency()));
        }
        return accountType;
    }

    public AccountTypeWithDefaultMediumBalanceRange toAccountTypeWithDefaultMediumBalanceRange(AccountTypeWithDefaultYellowBalanceRangeVO accountTypeWithDefaultYellowBalanceRangeVO) {
        if (accountTypeWithDefaultYellowBalanceRangeVO == null) {
            return null;
        }
        AccountTypeWithDefaultMediumBalanceRange accountTypeWithDefaultMediumBalanceRange = this.apiHelper.newEntity(AccountTypeWithDefaultMediumBalanceRange.class, accountTypeWithDefaultYellowBalanceRangeVO);
        accountTypeWithDefaultMediumBalanceRange.setCurrency(this.toCurrency(accountTypeWithDefaultYellowBalanceRangeVO.getCurrency()));
        if (accountTypeWithDefaultYellowBalanceRangeVO.getDefaultYellowBalanceRange() != null) {
            accountTypeWithDefaultMediumBalanceRange.setDefaultMediumBalanceRange(this.apiHelper.toIntegerRange(accountTypeWithDefaultYellowBalanceRangeVO.getDefaultYellowBalanceRange()));
        }
        return accountTypeWithDefaultMediumBalanceRange;
    }

    public AccountVO toAccountVO(String string, String string2) {
        if (string == null || string2 == null) {
            return null;
        }
        AccountVO accountVO = new AccountVO();
        accountVO.setOwner(ModelHelper.accountOwner((String)string));
        accountVO.setType((AccountTypeVO)ModelHelper.voFromString(AccountTypeVO.class, (String)string2));
        return accountVO;
    }

    public AccountWithCurrency toAccountWithCurrency(AccountVO accountVO, CurrencyVO currencyVO) {
        if (accountVO == null) {
            return null;
        }
        AccountWithCurrency accountWithCurrency = this.newAccount(AccountWithCurrency.class, accountVO);
        accountWithCurrency.setCurrency(this.toCurrency(currencyVO));
        return accountWithCurrency;
    }

    public AccountWithCurrency toAccountWithCurrency(AccountWithCurrencyVO accountWithCurrencyVO) {
        if (accountWithCurrencyVO == null) {
            return null;
        }
        return this.newAccount(AccountWithCurrency.class, (AccountVO)accountWithCurrencyVO);
    }

    public AccountWithHistoryStatus toAccountWithHistoryStatus(AccountWithHistoryStatusVO accountWithHistoryStatusVO) {
        if (accountWithHistoryStatusVO == null) {
            return null;
        }
        return this.toAccountWithHistoryStatus((AccountWithCurrencyVO)accountWithHistoryStatusVO, accountWithHistoryStatusVO.getStatus());
    }

    public AccountWithOwner toAccountWithOwner(AccountVO accountVO) {
        if (accountVO == null) {
            return null;
        }
        return this.newAccount(AccountWithOwner.class, accountVO);
    }

    public AccountWithOwnerAndCurrency toAccountWithOwnerAndCurrency(AccountVO accountVO, CurrencyVO currencyVO) {
        if (accountVO == null) {
            return null;
        }
        AccountWithOwnerAndCurrency accountWithOwnerAndCurrency = this.newAccount(AccountWithOwnerAndCurrency.class, accountVO);
        accountWithOwnerAndCurrency.setCurrency(this.toCurrency(currencyVO));
        return accountWithOwnerAndCurrency;
    }

    public AccountWithStatus toAccountWithStatus(AccountVO accountVO) {
        if (accountVO == null) {
            return null;
        }
        AccountWithStatus accountWithStatus = this.newAccount(AccountWithStatus.class, accountVO);
        if (accountVO instanceof AccountWithStatusVO) {
            AccountStatusVO accountStatusVO = ((AccountWithStatusVO)accountVO).getStatus();
            accountWithStatus.setStatus(this.toAccountStatus(accountStatusVO));
        }
        return accountWithStatus;
    }

    public AccountWithStatus toAccountWithStatus(AccountVO accountVO, CurrencyVO currencyVO, AccountStatusVO accountStatusVO) {
        if (accountVO == null) {
            return null;
        }
        AccountWithStatusVO accountWithStatusVO = new AccountWithStatusVO();
        accountVO.copyPropertiesTo((Bean)accountWithStatusVO);
        accountWithStatusVO.setCurrency(currencyVO);
        accountWithStatusVO.setStatus(accountStatusVO);
        return this.toAccountWithStatus((AccountVO)accountWithStatusVO);
    }

    public AccountWithStatus toAccountWithStatus(UserAccountData userAccountData) {
        AccountWithStatus accountWithStatus = this.toAccountWithStatus(userAccountData.getAccount(), userAccountData.getCurrency(), userAccountData.getStatus());
        if (accountWithStatus != null && userAccountData.getTransactionsAllTime() != null) {
            if (accountWithStatus.getStatus() == null) {
                accountWithStatus.setStatus(new AccountActivityStatus());
            }
            AccountActivityStatus accountActivityStatus = accountWithStatus.getStatus();
            accountActivityStatus.setPaidAllTime(userAccountData.getPaidAllTime());
            accountActivityStatus.setPaidInPeriod(userAccountData.getPaidInPeriod());
            accountActivityStatus.setReceivedAllTime(userAccountData.getReceivedAllTime());
            accountActivityStatus.setReceivedInPeriod(userAccountData.getReceivedInPeriod());
            accountActivityStatus.setTransactionsAllTime(userAccountData.getTransactionsAllTime());
            accountActivityStatus.setTransactionsInPeriod(userAccountData.getTransactionsInPeriod());
        }
        return accountWithStatus;
    }

    public AmountSummary toAmountSummary(AmountSummaryVO amountSummaryVO) {
        if (amountSummaryVO == null) {
            return null;
        }
        return this.newAmountSummary(AmountSummary.class, amountSummaryVO);
    }

    public BalanceLevelEnum toBalanceLevelEnum(BalanceLevel balanceLevel) {
        if (balanceLevel != null) {
            switch (balanceLevel) {
                case LOW: {
                    return BalanceLevelEnum.LOW;
                }
                case MEDIUM: {
                    return BalanceLevelEnum.MEDIUM;
                }
                case HIGH: {
                    return BalanceLevelEnum.HIGH;
                }
            }
        }
        return null;
    }

    public Currency toCurrency(CurrencyAmountDTO currencyAmountDTO) {
        return this.toCurrency(currencyAmountDTO == null ? null : currencyAmountDTO.getCurrency());
    }

    public Currency toCurrency(CurrencyVO currencyVO) {
        if (currencyVO == null) {
            return null;
        }
        Currency currency = this.apiHelper.newEntity(Currency.class, currencyVO);
        currency.setPrefix(currencyVO.getPrefix());
        currency.setSuffix(currencyVO.getSuffix());
        currency.setSymbol(currencyVO.getSymbol());
        currency.setDecimalDigits(currencyVO.getPrecision());
        currency.setTransactionNumberPattern(currencyVO.getTransactionNumberPattern());
        return currency;
    }

    public CurrencyAmountSummary toCurrencyAmountSummary(AmountSummaryVO amountSummaryVO) {
        if (amountSummaryVO == null) {
            return null;
        }
        CurrencyAmountSummary currencyAmountSummary = this.newAmountSummary(CurrencyAmountSummary.class, amountSummaryVO);
        currencyAmountSummary.setCurrency(this.toCurrency(amountSummaryVO.getCurrency()));
        return currencyAmountSummary;
    }

    public DataForAccountHistory toDataForAccountHistory(AccountHistoryData accountHistoryData) {
        DataForAccountHistory dataForAccountHistory = this.transfersApiHelper.newBaseTransferSearchData(DataForAccountHistory.class, (TransferSearchData)accountHistoryData);
        dataForAccountHistory.setAccount(this.toAccountWithOwnerAndCurrency(accountHistoryData.getAccount(), accountHistoryData.getCurrency()));
        CollectionHelper.orEmpty((List)accountHistoryData.getAccessClients()).stream().map(this.apiHelper::toReference).forEach(dataForAccountHistory.getAccessClients()::add);
        CollectionHelper.orEmpty((List)accountHistoryData.getOperators()).stream().map(this.usersApiHelper::toUser).forEach(dataForAccountHistory.getOperators()::add);
        dataForAccountHistory.setShowDescriptionInFilters(accountHistoryData.isShowDescriptionInFilters());
        dataForAccountHistory.setShowDescriptionInList(accountHistoryData.isShowDescriptionInList());
        dataForAccountHistory.setTransactionNumberMask(accountHistoryData.getTransactionNumberMask());
        dataForAccountHistory.setCanFilterByDirection(accountHistoryData.isCanFilterByDirection());
        dataForAccountHistory.setQuery(this.toAccountHistoryQueryFilters((AccountHistoryQuery)accountHistoryData.getQuery()));
        return dataForAccountHistory;
    }

    public DataForUserBalancesSearch toDataForUserBalancesSearch(UserWithBalanceSearchData userWithBalanceSearchData) {
        DataForUserBalancesSearch dataForUserBalancesSearch = this.usersApiHelper.newBaseDataForSearch(DataForUserBalancesSearch.class, (AbstractUserSearchData)userWithBalanceSearchData);
        userWithBalanceSearchData.getAccountTypes().stream().map(this::toAccountTypeWithDefaultMediumBalanceRange).forEach(dataForUserBalancesSearch.getAccountTypes()::add);
        dataForUserBalancesSearch.setQuery(this.toUsersWithBalanceQueryFilters((UserWithBalanceQuery)userWithBalanceSearchData.getQuery()));
        return dataForUserBalancesSearch;
    }

    public OwnerAccountsListData toOwnerAccountsListData(List<AccountWithStatusVO> list) {
        if (list == null) {
            return null;
        }
        OwnerAccountsListData ownerAccountsListData = new OwnerAccountsListData();
        CollectionHelper.orEmpty(list).stream().map(this::toAccountWithStatus).forEach(ownerAccountsListData.getAccounts()::add);
        AccountWithStatusVO accountWithStatusVO = (AccountWithStatusVO)CollectionHelper.first(list);
        if (accountWithStatusVO != null && accountWithStatusVO.getOwner() instanceof UserVO) {
            ownerAccountsListData.setUser(this.usersApiHelper.toUser((BasicUserVO)((UserVO)accountWithStatusVO.getOwner())));
        }
        return ownerAccountsListData;
    }

    public RelatedTransferType toRelatedTransferType(TransferTypeVO transferTypeVO, AccountTypeVO accountTypeVO) {
        if (transferTypeVO == null) {
            return null;
        }
        RelatedTransferType relatedTransferType = this.apiHelper.newEntity(RelatedTransferType.class, transferTypeVO);
        AccountTypeVO accountTypeVO2 = accountTypeVO.equals((Object)transferTypeVO.getFrom()) ? transferTypeVO.getTo() : transferTypeVO.getFrom();
        relatedTransferType.setRelated(this.apiHelper.toReference((EntityModel)accountTypeVO2));
        return relatedTransferType;
    }

    public TransferFilter toTransferFilter(TransferFilterVO transferFilterVO) {
        if (transferFilterVO == null) {
            return null;
        }
        TransferFilter transferFilter = this.apiHelper.newEntity(TransferFilter.class, transferFilterVO);
        if (transferFilterVO instanceof TransferFilterWithAccountTypeVO) {
            TransferFilterWithAccountTypeVO transferFilterWithAccountTypeVO = (TransferFilterWithAccountTypeVO)transferFilterVO;
            transferFilter.setAccountType(this.apiHelper.toReference((EntityModel)transferFilterWithAccountTypeVO.getAccountType()));
        }
        return transferFilter;
    }

    public TransferType toTransferType(TransferTypeVO transferTypeVO) {
        if (transferTypeVO == null) {
            return null;
        }
        return this.newTransferType(TransferType.class, transferTypeVO);
    }

    public TransferTypeWithCurrency toTransferTypeWithCurrency(TransferTypeWithCurrencyVO transferTypeWithCurrencyVO) {
        if (transferTypeWithCurrencyVO == null) {
            return null;
        }
        TransferTypeWithCurrency transferTypeWithCurrency = this.newTransferType(TransferTypeWithCurrency.class, (TransferTypeVO)transferTypeWithCurrencyVO);
        transferTypeWithCurrency.setCurrency(this.toCurrency(transferTypeWithCurrencyVO.getCurrency()));
        transferTypeWithCurrency.setTo(this.apiHelper.toReference((EntityModel)transferTypeWithCurrencyVO.getTo()));
        return transferTypeWithCurrency;
    }

    public User toUser(AccountOwner accountOwner) {
        if (accountOwner instanceof BasicUserVO) {
            return this.usersApiHelper.toUser((BasicUserVO)accountOwner);
        }
        return null;
    }

    public UsersWithBalanceQueryFilters toUsersWithBalanceQueryFilters(UserWithBalanceQuery userWithBalanceQuery) {
        UsersWithBalanceQueryFilters usersWithBalanceQueryFilters = this.usersApiHelper.newBasicUserQueryFilters(UsersWithBalanceQueryFilters.class, (AbstractUserQuery)userWithBalanceQuery);
        usersWithBalanceQueryFilters.setAccountType(ModelHelper.stringOrIdFromVO((EntityVO)userWithBalanceQuery.getAccountType()));
        usersWithBalanceQueryFilters.setBalanceRange(this.apiHelper.toFilter(userWithBalanceQuery.getBalanceRange()));
        usersWithBalanceQueryFilters.setNegativeSincePeriod(this.apiHelper.toFilter(userWithBalanceQuery.getNegativeSince()));
        usersWithBalanceQueryFilters.setMediumBalanceRange(this.apiHelper.toFilter(userWithBalanceQuery.getYellowBalanceRange()));
        usersWithBalanceQueryFilters.setOrderBy(this.toUserWithBalanceOrderByEnum(userWithBalanceQuery.getOrderBy()));
        return usersWithBalanceQueryFilters;
    }

    public UsersWithBalanceSummary toUsersWithBalanceSummary(UsersWithBalancesOverview usersWithBalancesOverview) {
        if (usersWithBalancesOverview == null) {
            return null;
        }
        UsersWithBalanceSummary usersWithBalanceSummary = new UsersWithBalanceSummary();
        Map map = CollectionHelper.orEmpty((Map)usersWithBalancesOverview.getOverviewByRange());
        usersWithBalanceSummary.setLow(this.toAmountSummary((AmountSummaryVO)map.get(BalanceLevel.LOW)));
        usersWithBalanceSummary.setMedium(this.toAmountSummary((AmountSummaryVO)map.get(BalanceLevel.MEDIUM)));
        usersWithBalanceSummary.setHigh(this.toAmountSummary((AmountSummaryVO)map.get(BalanceLevel.HIGH)));
        usersWithBalanceSummary.setTotal(this.toAmountSummary(usersWithBalancesOverview.getGeneralOverview()));
        return usersWithBalanceSummary;
    }

    public UserWithBalanceOrderBy toUserWithBalanceOrderBy(UsersWithBalanceOrderByEnum usersWithBalanceOrderByEnum) {
        if (usersWithBalanceOrderByEnum != null) {
            switch (usersWithBalanceOrderByEnum) {
                case ALPHABETICALLY_ASC: {
                    return UserWithBalanceOrderBy.ALPHABETICALLY_ASC;
                }
                case ALPHABETICALLY_DESC: {
                    return UserWithBalanceOrderBy.ALPHABETICALLY_DESC;
                }
                case BALANCE_ASC: {
                    return UserWithBalanceOrderBy.BALANCE_ASC;
                }
                case BALANCE_DESC: {
                    return UserWithBalanceOrderBy.BALANCE_DESC;
                }
            }
        }
        return null;
    }

    public UsersWithBalanceOrderByEnum toUserWithBalanceOrderByEnum(UserWithBalanceOrderBy userWithBalanceOrderBy) {
        if (userWithBalanceOrderBy != null) {
            switch (userWithBalanceOrderBy) {
                case ALPHABETICALLY_ASC: {
                    return UsersWithBalanceOrderByEnum.ALPHABETICALLY_ASC;
                }
                case ALPHABETICALLY_DESC: {
                    return UsersWithBalanceOrderByEnum.ALPHABETICALLY_DESC;
                }
                case BALANCE_ASC: {
                    return UsersWithBalanceOrderByEnum.BALANCE_ASC;
                }
                case BALANCE_DESC: {
                    return UsersWithBalanceOrderByEnum.BALANCE_DESC;
                }
            }
        }
        return null;
    }

    public UserWithBalanceQuery toUserWithBalanceQuery(UsersWithBalanceQueryFilters usersWithBalanceQueryFilters) {
        UserWithBalanceQuery userWithBalanceQuery = this.usersApiHelper.newBasicUserQuery(UserWithBalanceQuery.class, usersWithBalanceQueryFilters);
        userWithBalanceQuery.setAccountType((AccountTypeVO)ModelHelper.voFromString(AccountTypeVO.class, (String)usersWithBalanceQueryFilters.getAccountType()));
        userWithBalanceQuery.setBalanceRange(this.apiHelper.toDecimalRangeDTO(usersWithBalanceQueryFilters.getBalanceRange()));
        userWithBalanceQuery.setNegativeSince(this.apiHelper.toDatePeriodDTO(usersWithBalanceQueryFilters.getNegativeSincePeriod()));
        userWithBalanceQuery.setYellowBalanceRange(this.apiHelper.toIntegerRangeDTO(usersWithBalanceQueryFilters.getMediumBalanceRange()));
        userWithBalanceQuery.setOrderBy(this.toUserWithBalanceOrderBy(usersWithBalanceQueryFilters.getOrderBy()));
        return userWithBalanceQuery;
    }

    public UserWithBalanceResult toUserWithBalanceResult(UserWithBalanceVO userWithBalanceVO) {
        if (userWithBalanceVO == null) {
            return null;
        }
        UserWithBalanceResult userWithBalanceResult = this.usersApiHelper.newUserResult(UserWithBalanceResult.class, (IUserWithFieldsVO)userWithBalanceVO);
        userWithBalanceResult.setBalance(userWithBalanceVO.getBalance());
        userWithBalanceResult.setBalanceLevel(this.toBalanceLevelEnum(userWithBalanceVO.getBalanceLevel()));
        userWithBalanceResult.setNegativeSince(userWithBalanceVO.getNegativeSince());
        return userWithBalanceResult;
    }

    private <A extends Account> A newAccount(Class<A> clazz, AccountVO accountVO) {
        AccountWithOwner accountWithOwner;
        Account account = (Account)this.apiHelper.newEntity(clazz, accountVO);
        if (account.getId() == null) {
            account.setId(ModelHelper.stringOrIdFromVO((EntityVO)accountVO));
        }
        account.setType(this.apiHelper.toReference((EntityModel)accountVO.getType()));
        account.setNumber(accountVO.getNumber());
        if (account instanceof AccountWithOwner) {
            accountWithOwner = (AccountWithOwner)account;
            accountWithOwner.setUser(this.toUser((AccountOwner)accountVO.getOwner()));
            accountWithOwner.setKind(this.toAccountKind((AccountOwner)accountVO.getOwner()));
        }
        if (accountVO instanceof AccountWithCurrencyVO) {
            accountWithOwner = (AccountWithCurrencyVO)accountVO;
            if (account instanceof AccountWithCurrency) {
                ((AccountWithCurrency)account).setCurrency(this.toCurrency(accountWithOwner.getCurrency()));
            } else if (account instanceof AccountWithOwnerAndCurrency) {
                ((AccountWithOwnerAndCurrency)account).setCurrency(this.toCurrency(accountWithOwner.getCurrency()));
            }
        }
        return (A)account;
    }

    private <S extends AccountStatus> S newAccountStatus(Class<S> clazz, AccountStatusVO accountStatusVO) {
        AccountStatus accountStatus = (AccountStatus)ClassHelper.instantiate(clazz);
        accountStatus.setBalance(accountStatusVO.getBalance());
        accountStatus.setCreditLimit(accountStatusVO.getCreditLimit());
        accountStatus.setUpperCreditLimit(accountStatusVO.getUpperCreditLimit());
        accountStatus.setReservedAmount(accountStatusVO.getReservedAmount());
        accountStatus.setAvailableBalance(accountStatusVO.getAvailableBalance());
        accountStatus.setNegativeSince(accountStatusVO.getNegativeSince());
        accountStatus.setaRate(accountStatusVO.getARate());
        accountStatus.setdRate(accountStatusVO.getDRate());
        accountStatus.setRateBalanceCorrection(accountStatusVO.getRateBalanceCorrection());
        accountStatus.setVirtualRatedBalance(accountStatusVO.getVirtualRatedBalance());
        return (S)accountStatus;
    }

    private <S extends AmountSummary> S newAmountSummary(Class<S> clazz, AmountSummaryVO amountSummaryVO) {
        AmountSummary amountSummary = (AmountSummary)ClassHelper.instantiate(clazz);
        amountSummary.setCount(amountSummaryVO.getCount());
        amountSummary.setSum(amountSummaryVO.getSum());
        amountSummary.setAverage(amountSummaryVO.getAverage());
        return (S)amountSummary;
    }

    private <TT extends TransferType> TT newTransferType(Class<TT> clazz, TransferTypeVO transferTypeVO) {
        TransferType transferType = (TransferType)this.apiHelper.newEntity(clazz, transferTypeVO);
        transferType.setFrom(this.apiHelper.toReference((EntityModel)transferTypeVO.getFrom()));
        transferType.setTo(this.apiHelper.toReference((EntityModel)transferTypeVO.getTo()));
        return (TT)transferType;
    }

    private AccountWithHistoryStatus toAccountWithHistoryStatus(AccountWithCurrencyVO accountWithCurrencyVO, AccountHistoryStatusVO accountHistoryStatusVO) {
        AccountWithHistoryStatus accountWithHistoryStatus = this.newAccount(AccountWithHistoryStatus.class, (AccountVO)accountWithCurrencyVO);
        accountWithHistoryStatus.setStatus(this.toAccountHistoryStatus(accountHistoryStatusVO));
        return accountWithHistoryStatus;
    }
}

