/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.helpers;

import java.util.List;
import org.cyclos.model.EntityModel;
import org.cyclos.model.access.clients.AccessClientActionParams;
import org.cyclos.model.access.clients.AccessClientDTO;
import org.cyclos.model.access.clients.AccessClientData;
import org.cyclos.model.access.clients.AccessClientLocatorVO;
import org.cyclos.model.access.clients.AccessClientStatus;
import org.cyclos.model.access.clients.AccessClientTypeData;
import org.cyclos.model.access.clients.AccessClientsActivationData;
import org.cyclos.model.access.clients.ActivateAccessClientDTO;
import org.cyclos.model.access.clients.CreateAccessClientParams;
import org.cyclos.model.access.principaltypes.PrincipalTypeVO;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.services.access.AccessClientService;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.web.rest.helpers.ApiHelper;
import org.cyclos.web.rest.helpers.AuthApiHelper;
import org.cyclos.web.rest.helpers.UsersApiHelper;
import org.cyclos.web.rest.model.ActivateClientResult;
import org.cyclos.web.rest.model.ClientStatusEnum;
import org.cyclos.web.rest.model.ClientView;
import org.cyclos.web.rest.model.CreateClientParams;
import org.cyclos.web.rest.model.DataForClientActivation;
import org.cyclos.web.rest.model.UserClientTypePermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ClientsApiHelper {
    @Autowired
    private AccessClientService accessClientService;
    @Autowired
    private ApiHelper apiHelper;
    @Autowired
    private AuthApiHelper authApiHelper;
    @Autowired
    private UsersApiHelper usersApiHelper;

    public Long ensureId(String string) {
        try {
            return Long.parseLong(string);
        }
        catch (Exception exception) {
            AccessClientLocatorVO accessClientLocatorVO = new AccessClientLocatorVO();
            accessClientLocatorVO.setToken(ModelHelper.locatorText((String)string));
            return this.accessClientService.locate(accessClientLocatorVO).getId();
        }
    }

    public AccessClientActionParams toActionParams(String string, String string2) {
        AccessClientActionParams accessClientActionParams = new AccessClientActionParams();
        accessClientActionParams.setAccessClient((AccessClientLocatorVO)ModelHelper.voFromString(AccessClientLocatorVO.class, (String)string));
        accessClientActionParams.setConfirmationPassword(string2);
        return accessClientActionParams;
    }

    public ActivateClientResult toActivateClientResult(ActivateAccessClientDTO activateAccessClientDTO) {
        ActivateClientResult activateClientResult = new ActivateClientResult();
        activateClientResult.setToken(activateAccessClientDTO.getToken());
        activateClientResult.setAccessClient(this.apiHelper.toReference((EntityModel)activateAccessClientDTO.getAccessClient()));
        activateClientResult.setAccessClientType(this.apiHelper.toReference((EntityModel)activateAccessClientDTO.getType()));
        return activateClientResult;
    }

    public ClientView toClientView(AccessClientData accessClientData) {
        AccessClientDTO accessClientDTO = (AccessClientDTO)accessClientData.getDto();
        ClientView clientView = this.apiHelper.newEntity(ClientView.class, accessClientDTO);
        clientView.setStatus(this.toStatus(accessClientDTO.getStatus()));
        clientView.setActivationDate(accessClientDTO.getActivationDate());
        clientView.setConfirmationPasswordInput(this.authApiHelper.toPasswordInput(accessClientData.getConfirmationPasswordInput()));
        clientView.setCanGetActivationCode(accessClientData.isCanGetActivationCode());
        clientView.setCanBlock(accessClientData.isCanBlock());
        clientView.setCanUnblock(accessClientData.isCanUnblock());
        clientView.setCanUnassign(accessClientData.isCanUnassign());
        clientView.setUser(this.usersApiHelper.toUser((BasicUserVO)((AccessClientDTO)accessClientData.getDto()).getUser()));
        return clientView;
    }

    public CreateAccessClientParams toCreateAccessClientParameter(String string, CreateClientParams createClientParams) {
        if (createClientParams == null) {
            return null;
        }
        CreateAccessClientParams createAccessClientParams = new CreateAccessClientParams();
        createAccessClientParams.setCode(createClientParams.getCode());
        createAccessClientParams.setName(createClientParams.getName());
        createAccessClientParams.setPrefix(createClientParams.getPrefix());
        createAccessClientParams.setType((PrincipalTypeVO)ModelHelper.voFromString(PrincipalTypeVO.class, (String)string));
        return createAccessClientParams;
    }

    public DataForClientActivation toDataForClientActivation(AccessClientsActivationData accessClientsActivationData) {
        if (accessClientsActivationData == null) {
            return null;
        }
        DataForClientActivation dataForClientActivation = new DataForClientActivation();
        dataForClientActivation.setDataForSendingOtp(this.authApiHelper.toDataForSendingOtp(accessClientsActivationData.getSendOtpData()));
        CollectionHelper.orEmpty((List)accessClientsActivationData.getAccessClientsTypeData()).stream().map(this::toUserClientTypePermissions).forEach(dataForClientActivation.getTypes()::add);
        return dataForClientActivation;
    }

    public UserClientTypePermissions toUserClientTypePermissions(AccessClientTypeData accessClientTypeData) {
        UserClientTypePermissions userClientTypePermissions = this.apiHelper.newEntity(UserClientTypePermissions.class, accessClientTypeData.getType());
        userClientTypePermissions.setCanCreateNew(accessClientTypeData.isCanCreateNew());
        userClientTypePermissions.setCanActivateNew(accessClientTypeData.isCanActivateNew());
        userClientTypePermissions.setCanManage(accessClientTypeData.isCanManage());
        userClientTypePermissions.setHasUnassigned(accessClientTypeData.isHasUnassigned());
        return userClientTypePermissions;
    }

    private ClientStatusEnum toStatus(AccessClientStatus accessClientStatus) {
        if (accessClientStatus != null) {
            switch (accessClientStatus) {
                case ACTIVE: {
                    return ClientStatusEnum.ACTIVE;
                }
                case BLOCKED: {
                    return ClientStatusEnum.BLOCKED;
                }
                case REMOVED: {
                    return ClientStatusEnum.REMOVED;
                }
                case UNASSIGNED: {
                    return ClientStatusEnum.UNASSIGNED;
                }
            }
        }
        return null;
    }
}

