/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.helpers;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.cyclos.model.EntityModel;
import org.cyclos.model.QueryParameters;
import org.cyclos.model.users.contacts.ContactDTO;
import org.cyclos.model.users.contacts.ContactData;
import org.cyclos.model.users.contacts.ContactOrderBy;
import org.cyclos.model.users.contacts.ContactQuery;
import org.cyclos.model.users.contacts.ContactSearchData;
import org.cyclos.model.users.contacts.ContactVO;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.users.users.UserVO;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.server.utils.ClassHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.web.rest.helpers.ApiHelper;
import org.cyclos.web.rest.helpers.OperationsApiHelper;
import org.cyclos.web.rest.helpers.UsersApiHelper;
import org.cyclos.web.rest.model.Contact;
import org.cyclos.web.rest.model.ContactBasicData;
import org.cyclos.web.rest.model.ContactDataForEdit;
import org.cyclos.web.rest.model.ContactDataForNew;
import org.cyclos.web.rest.model.ContactEdit;
import org.cyclos.web.rest.model.ContactListDataForSearch;
import org.cyclos.web.rest.model.ContactListQueryFilters;
import org.cyclos.web.rest.model.ContactManage;
import org.cyclos.web.rest.model.ContactNew;
import org.cyclos.web.rest.model.ContactOrderByEnum;
import org.cyclos.web.rest.model.ContactResult;
import org.cyclos.web.rest.model.ContactView;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ContactsApiHelper {
    @Autowired
    private ApiHelper apiHelper;
    @Autowired
    private UsersApiHelper usersApiHelper;
    @Autowired
    private OperationsApiHelper operationsApiHelper;

    public Contact toContact(ContactVO contactVO) {
        if (contactVO == null) {
            return null;
        }
        return this.newContact(Contact.class, contactVO);
    }

    public ContactDataForEdit toContactDataForEdit(ContactData contactData) {
        ContactDataForEdit contactDataForEdit = this.newContactBasicData(ContactDataForEdit.class, contactData);
        contactDataForEdit.setContact(this.toContactEdit((ContactDTO)contactData.getDto()));
        Map<Long, String> map = CollectionHelper.orEmpty((List)contactData.getCustomFields()).stream().collect(Collectors.toMap(EntityModel::getId, ModelHelper::unqualifyInternalName));
        CollectionHelper.orEmpty((Set)contactData.getEditableCustomFieldIds()).stream().map(map::get).forEach(contactDataForEdit.getEditableFields()::add);
        contactDataForEdit.setBinaryValues(this.apiHelper.toCustomFieldBinaryValues(((ContactDTO)contactData.getDto()).getCustomValues()));
        return contactDataForEdit;
    }

    public ContactDataForNew toContactDataForNew(String string, ContactData contactData) {
        ContactDataForNew contactDataForNew = this.newContactBasicData(ContactDataForNew.class, contactData);
        contactDataForNew.setContact(this.toContactNew(string, (ContactDTO)contactData.getDto()));
        return contactDataForNew;
    }

    public ContactDTO toContactDTO(String string, String string2, ContactManage contactManage) {
        if (contactManage == null) {
            return null;
        }
        ContactDTO contactDTO = new ContactDTO();
        contactDTO.setOwner((UserVO)ModelHelper.voFromString(UserVO.class, (String)string2));
        if (contactManage instanceof ContactNew) {
            String string3 = ((ContactNew)contactManage).getContact();
            contactDTO.setContact((UserVO)ModelHelper.voFromString(UserVO.class, (String)string3));
        } else if (contactManage instanceof ContactEdit) {
            contactDTO.setId(this.apiHelper.fromId(string));
            contactDTO.setVersion(((ContactEdit)contactManage).getVersion());
        }
        contactDTO.setCustomValues(this.apiHelper.toCustomFieldValuesDTO(contactManage.getCustomValues()));
        return contactDTO;
    }

    public ContactEdit toContactEdit(ContactDTO contactDTO) {
        if (contactDTO == null) {
            return null;
        }
        ContactEdit contactEdit = this.newContactManage(ContactEdit.class, contactDTO);
        contactEdit.setVersion(contactDTO.getVersion());
        return contactEdit;
    }

    public ContactListDataForSearch toContactListDataForSearch(ContactSearchData contactSearchData) {
        if (contactSearchData == null) {
            return null;
        }
        List list = CollectionHelper.orEmpty((List)contactSearchData.getFieldsForSearch());
        List list2 = CollectionHelper.orEmpty((List)contactSearchData.getFieldsForList());
        ContactListDataForSearch contactListDataForSearch = new ContactListDataForSearch();
        LinkedHashSet linkedHashSet = new LinkedHashSet(list);
        linkedHashSet.addAll(list2);
        linkedHashSet.stream().map(this.apiHelper::toCustomFieldDetailed).forEach(contactListDataForSearch.getCustomFields()::add);
        list.stream().map(ModelHelper::unqualifiedInternalNameOrId).forEach(contactListDataForSearch.getFieldsInSearch()::add);
        list2.stream().map(ModelHelper::unqualifiedInternalNameOrId).forEach(contactListDataForSearch.getFieldsInList()::add);
        contactListDataForSearch.setQuery(this.toContactListQueryFilters((ContactQuery)contactSearchData.getQuery()));
        contactListDataForSearch.setHasVisibleFields(contactSearchData.isHasVisibleFields());
        contactListDataForSearch.setHasEditableFields(contactSearchData.isHasEditableFields());
        contactListDataForSearch.setUser(this.usersApiHelper.toUser((BasicUserVO)contactSearchData.getOwner()));
        contactListDataForSearch.setAllowKeywords(contactSearchData.isAllowKeywords());
        return contactListDataForSearch;
    }

    public ContactListQueryFilters toContactListQueryFilters(ContactQuery contactQuery) {
        if (contactQuery == null) {
            return null;
        }
        ContactListQueryFilters contactListQueryFilters = this.apiHelper.newQueryFilters(ContactListQueryFilters.class, (QueryParameters)contactQuery);
        contactListQueryFilters.setKeywords(contactQuery.getKeywords());
        contactListQueryFilters.setCustomFields(this.apiHelper.toFilters(contactQuery.getCustomValues()));
        contactListQueryFilters.setOrderBy(this.toContactOrderByEnum(contactQuery.getOrderBy()));
        CollectionHelper.orEmpty((Set)contactQuery.getUsersToExclude()).stream().map(ModelHelper::stringOrIdFromVO).forEach(contactListQueryFilters.getUsersToExclude()::add);
        return contactListQueryFilters;
    }

    public ContactNew toContactNew(String string, ContactDTO contactDTO) {
        if (contactDTO == null) {
            return null;
        }
        ContactNew contactNew = this.newContactManage(ContactNew.class, contactDTO);
        contactNew.setContact(string);
        return contactNew;
    }

    public ContactOrderBy toContactOrderBy(ContactOrderByEnum contactOrderByEnum) {
        if (contactOrderByEnum != null) {
            switch (contactOrderByEnum) {
                case ALPHABETICALLY_ASC: {
                    return ContactOrderBy.ALPHABETICALLY_ASC;
                }
                case ALPHABETICALLY_DESC: {
                    return ContactOrderBy.ALPHABETICALLY_DESC;
                }
                case RELEVANCE: {
                    return ContactOrderBy.RELEVANCE;
                }
            }
        }
        return null;
    }

    public ContactOrderByEnum toContactOrderByEnum(ContactOrderBy contactOrderBy) {
        if (contactOrderBy != null) {
            switch (contactOrderBy) {
                case ALPHABETICALLY_ASC: {
                    return ContactOrderByEnum.ALPHABETICALLY_ASC;
                }
                case ALPHABETICALLY_DESC: {
                    return ContactOrderByEnum.ALPHABETICALLY_DESC;
                }
                case RELEVANCE: {
                    return ContactOrderByEnum.RELEVANCE;
                }
            }
        }
        return null;
    }

    public ContactQuery toContactQuery(String string, ContactListQueryFilters contactListQueryFilters) {
        ContactQuery contactQuery = this.apiHelper.newQuery(ContactQuery.class, contactListQueryFilters);
        contactQuery.setOwner((UserLocatorVO)ModelHelper.voFromString(UserLocatorVO.class, (String)string));
        contactQuery.setKeywords(contactListQueryFilters.getKeywords());
        contactQuery.setCustomValues(this.apiHelper.toCustomFieldValuesForSearch(contactListQueryFilters.getCustomFields()));
        contactQuery.setOrderBy(this.toContactOrderBy(contactListQueryFilters.getOrderBy()));
        contactQuery.setUsersToExclude(ModelHelper.vosFromString(UserVO.class, contactListQueryFilters.getUsersToExclude()));
        return contactQuery;
    }

    public ContactResult toContactResult(ContactVO contactVO) {
        if (contactVO == null) {
            return null;
        }
        ContactResult contactResult = this.newContact(ContactResult.class, contactVO);
        contactResult.setCustomValues(this.apiHelper.toCustomFieldValuesMap(contactVO.getCustomValues()));
        return contactResult;
    }

    public ContactView toContactView(ContactData contactData) {
        if (contactData == null) {
            return null;
        }
        ContactDTO contactDTO = (ContactDTO)contactData.getDto();
        ContactView contactView = this.apiHelper.newEntity(ContactView.class, contactDTO);
        contactView.setContact(this.usersApiHelper.toUser((BasicUserVO)contactDTO.getContact()));
        contactView.setCustomValues(this.apiHelper.toCustomFieldValuesList(contactDTO.getCustomValues()));
        contactView.setCanEdit(contactData.isEditable());
        contactView.setUser(this.usersApiHelper.toUser((BasicUserVO)contactDTO.getOwner()));
        CollectionHelper.orEmpty((List)contactData.getCustomOperations()).stream().map(this.operationsApiHelper::toOperation).forEach(contactView.getOperations()::add);
        return contactView;
    }

    private <R extends Contact> R newContact(Class<R> clazz, ContactVO contactVO) {
        Contact contact = (Contact)this.apiHelper.newEntity(clazz, contactVO);
        contact.setContact(this.usersApiHelper.toUser((BasicUserVO)contactVO.getContact()));
        return (R)contact;
    }

    private <D extends ContactBasicData> D newContactBasicData(Class<D> clazz, ContactData contactData) {
        ContactBasicData contactBasicData = (ContactBasicData)ClassHelper.instantiate(clazz);
        ContactDTO contactDTO = (ContactDTO)contactData.getDto();
        contactBasicData.setContactUser(this.usersApiHelper.toUser((BasicUserVO)contactDTO.getContact()));
        contactBasicData.setUser(this.usersApiHelper.toUser((BasicUserVO)contactDTO.getOwner()));
        CollectionHelper.orEmpty((List)contactData.getCustomFields()).stream().filter(customFieldDetailedVO -> contactBasicData instanceof ContactDataForEdit || contactData.getEditableCustomFieldIds().contains(customFieldDetailedVO.getId())).map(this.apiHelper::toCustomFieldDetailed).forEach(contactBasicData.getCustomFields()::add);
        return (D)contactBasicData;
    }

    private <R extends ContactManage> R newContactManage(Class<R> clazz, ContactDTO contactDTO) {
        ContactManage contactManage = (ContactManage)ClassHelper.instantiate(clazz);
        contactManage.setCustomValues(this.apiHelper.toCustomFieldValuesMap(contactDTO.getCustomValues()));
        return (R)contactManage;
    }
}

