/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.helpers;

import java.util.List;
import org.cyclos.model.users.groups.BasicChangeGroupData;
import org.cyclos.model.users.groups.BasicGroupVO;
import org.cyclos.model.users.groups.ChangeGroupDTO;
import org.cyclos.model.users.groups.ChangeGroupData;
import org.cyclos.model.users.groups.UserGroupLogVO;
import org.cyclos.model.users.operatorgroups.ChangeOperatorGroupData;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.users.users.UserVO;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.web.rest.helpers.ApiHelper;
import org.cyclos.web.rest.helpers.GroupsApiHelper;
import org.cyclos.web.rest.helpers.UserStatusApiHelper;
import org.cyclos.web.rest.helpers.UsersApiHelper;
import org.cyclos.web.rest.model.ChangeGroupMembershipParams;
import org.cyclos.web.rest.model.GroupMembershipData;
import org.cyclos.web.rest.model.GroupMembershipLog;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GroupMembershipApiHelper {
    @Autowired
    private ApiHelper apiHelper;
    @Autowired
    private GroupsApiHelper groupsApiHelper;
    @Autowired
    private UsersApiHelper usersApiHelper;
    @Autowired
    private UserStatusApiHelper userStatusApiHelper;

    public ChangeGroupDTO toChangeGroupDTO(String string, ChangeGroupMembershipParams changeGroupMembershipParams) {
        ChangeGroupDTO changeGroupDTO = new ChangeGroupDTO();
        changeGroupDTO.setUser((BasicUserVO)ModelHelper.voFromString(UserLocatorVO.class, (String)string));
        changeGroupDTO.setGroup((BasicGroupVO)ModelHelper.voFromString(BasicGroupVO.class, (String)changeGroupMembershipParams.getGroup()));
        changeGroupDTO.setComment(changeGroupMembershipParams.getComment());
        return changeGroupDTO;
    }

    public GroupMembershipData toGroupMembershipData(BasicChangeGroupData basicChangeGroupData) {
        GroupMembershipData groupMembershipData = new GroupMembershipData();
        UserVO userVO = null;
        List list = null;
        if (basicChangeGroupData instanceof ChangeGroupData) {
            ChangeGroupData changeGroupData = (ChangeGroupData)basicChangeGroupData;
            userVO = changeGroupData.getUser();
            list = changeGroupData.getGroupSets();
        } else if (basicChangeGroupData instanceof ChangeOperatorGroupData) {
            userVO = ((ChangeOperatorGroupData)basicChangeGroupData).getOperator();
        }
        groupMembershipData.setUser(this.usersApiHelper.toUser((BasicUserVO)userVO));
        groupMembershipData.setStatus(this.userStatusApiHelper.toUserStatusEnum(basicChangeGroupData.getStatus()));
        groupMembershipData.setGroup(this.groupsApiHelper.toGroup(basicChangeGroupData.getCurrentGroup()));
        if (list == null) {
            groupMembershipData.setGroupSets(null);
        } else {
            list.stream().map(this.apiHelper::toReference).forEach(groupMembershipData.getGroupSets()::add);
        }
        CollectionHelper.orEmpty((List)basicChangeGroupData.getPossibleNewGroups()).stream().map(this.groupsApiHelper::toGroup).forEach(groupMembershipData.getPossibleNewGroups()::add);
        CollectionHelper.orEmpty((List)basicChangeGroupData.getLogs()).stream().map(this::toGroupMembershipLog).forEach(groupMembershipData.getHistory()::add);
        return groupMembershipData;
    }

    public GroupMembershipLog toGroupMembershipLog(UserGroupLogVO userGroupLogVO) {
        GroupMembershipLog groupMembershipLog = new GroupMembershipLog();
        groupMembershipLog.setBy(this.usersApiHelper.toUser(userGroupLogVO.getBy()));
        groupMembershipLog.setGroup(this.groupsApiHelper.toGroup(userGroupLogVO.getGroup()));
        groupMembershipLog.setPeriod(this.apiHelper.toDatePeriod(userGroupLogVO.getStartDate(), userGroupLogVO.getEndDate()));
        groupMembershipLog.setComment(userGroupLogVO.getComment());
        return groupMembershipLog;
    }
}

