/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.helpers;

import org.cyclos.model.IEntity;
import org.cyclos.model.users.groups.BasicGroupNature;
import org.cyclos.model.users.groups.BasicGroupVO;
import org.cyclos.model.users.groups.GroupSetVO;
import org.cyclos.model.users.groups.UserGroupVO;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.web.rest.helpers.ApiHelper;
import org.cyclos.web.rest.model.Group;
import org.cyclos.web.rest.model.GroupKind;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GroupsApiHelper {
    @Autowired
    private ApiHelper apiHelper;

    public Group toGroup(BasicGroupVO basicGroupVO) {
        if (basicGroupVO == null) {
            return null;
        }
        Group group = this.apiHelper.newEntity(Group.class, basicGroupVO);
        group.setKind(this.toGroupKindEnum(basicGroupVO.getNature()));
        if (basicGroupVO instanceof UserGroupVO) {
            GroupSetVO groupSetVO = ((UserGroupVO)basicGroupVO).getGroupSet();
            group.setGroupSet(ModelHelper.internalNameOrId((IEntity)groupSetVO));
        }
        return group;
    }

    public GroupKind toGroupKindEnum(BasicGroupNature basicGroupNature) {
        if (basicGroupNature != null) {
            switch (basicGroupNature) {
                case GROUP_SET: {
                    return GroupKind.GROUP_SET;
                }
                case ADMIN_GROUP: {
                    return GroupKind.ADMIN_GROUP;
                }
                case BROKER_GROUP: {
                    return GroupKind.BROKER_GROUP;
                }
                case MEMBER_GROUP: {
                    return GroupKind.MEMBER_GROUP;
                }
            }
        }
        return null;
    }
}

