/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.helpers;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.cyclos.model.EntityModel;
import org.cyclos.model.IEntity;
import org.cyclos.model.IInternalNamedEntity;
import org.cyclos.model.QueryParameters;
import org.cyclos.model.banking.currencies.CurrencyVO;
import org.cyclos.model.marketplace.advertisements.AdDetailsData;
import org.cyclos.model.marketplace.advertisements.AdInitialSearchType;
import org.cyclos.model.marketplace.advertisements.AdOrderBy;
import org.cyclos.model.marketplace.advertisements.AdSearchData;
import org.cyclos.model.marketplace.advertisements.AdStatus;
import org.cyclos.model.marketplace.advertisements.AdType;
import org.cyclos.model.marketplace.advertisements.AdViewData;
import org.cyclos.model.marketplace.advertisements.AdWebShopDTO;
import org.cyclos.model.marketplace.advertisements.AdWebShopStockType;
import org.cyclos.model.marketplace.advertisements.AdWebShopVO;
import org.cyclos.model.marketplace.advertisements.AdvertisementDTO;
import org.cyclos.model.marketplace.advertisements.BasicAdDTO;
import org.cyclos.model.marketplace.advertisements.BasicAdQuery;
import org.cyclos.model.marketplace.advertisements.BasicAdVO;
import org.cyclos.model.marketplace.advertisements.UserAdsSearchData;
import org.cyclos.model.marketplace.advertisements.UserFavoriteAdsListData;
import org.cyclos.model.marketplace.advertisements.WebShopAdDetailsData;
import org.cyclos.model.marketplace.categories.AdCategoryDetailedVO;
import org.cyclos.model.marketplace.categories.AdCategoryResultType;
import org.cyclos.model.marketplace.categories.AdCategoryVO;
import org.cyclos.model.marketplace.fields.AdCustomFieldActions;
import org.cyclos.model.marketplace.webshopdeliverymethods.AdDeliveryMethodVO;
import org.cyclos.model.system.fields.CustomFieldDetailedVO;
import org.cyclos.model.system.images.ImageVO;
import org.cyclos.model.users.addresses.GeoLocatedAddressVO;
import org.cyclos.model.users.addresses.UserAddressVO;
import org.cyclos.model.users.groups.BasicGroupVO;
import org.cyclos.model.users.users.BasicProfileField;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.model.users.users.DataWithBasicProfileFields;
import org.cyclos.model.users.users.UserVO;
import org.cyclos.model.utils.CurrencyAmountDTO;
import org.cyclos.model.utils.DecimalRangeDTO;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.server.utils.ClassHelper;
import org.cyclos.utils.BigDecimalHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.Pair;
import org.cyclos.web.rest.helpers.AccountsApiHelper;
import org.cyclos.web.rest.helpers.AdQuestionsApiHelper;
import org.cyclos.web.rest.helpers.AddressesApiHelper;
import org.cyclos.web.rest.helpers.ApiHelper;
import org.cyclos.web.rest.helpers.DeliveryMethodsApiHelper;
import org.cyclos.web.rest.helpers.GroupsApiHelper;
import org.cyclos.web.rest.helpers.ImagesApiHelper;
import org.cyclos.web.rest.helpers.OperationsApiHelper;
import org.cyclos.web.rest.helpers.UsersApiHelper;
import org.cyclos.web.rest.helpers.WebshopSettingsApiHelper;
import org.cyclos.web.rest.model.Ad;
import org.cyclos.web.rest.model.AdBasicData;
import org.cyclos.web.rest.model.AdCategoriesDisplayEnum;
import org.cyclos.web.rest.model.AdCategoryWithChildren;
import org.cyclos.web.rest.model.AdCategoryWithParent;
import org.cyclos.web.rest.model.AdDataForEdit;
import org.cyclos.web.rest.model.AdDataForNew;
import org.cyclos.web.rest.model.AdDataForSearch;
import org.cyclos.web.rest.model.AdEdit;
import org.cyclos.web.rest.model.AdInitialSearchTypeEnum;
import org.cyclos.web.rest.model.AdKind;
import org.cyclos.web.rest.model.AdManage;
import org.cyclos.web.rest.model.AdNew;
import org.cyclos.web.rest.model.AdOrderByEnum;
import org.cyclos.web.rest.model.AdQueryFilters;
import org.cyclos.web.rest.model.AdResult;
import org.cyclos.web.rest.model.AdStatusEnum;
import org.cyclos.web.rest.model.AdView;
import org.cyclos.web.rest.model.AdWithUser;
import org.cyclos.web.rest.model.BaseAdDataForSearch;
import org.cyclos.web.rest.model.BasicAdQueryFilters;
import org.cyclos.web.rest.model.Image;
import org.cyclos.web.rest.model.UserAdsDataForSearch;
import org.cyclos.web.rest.model.UserAdsQueryFilters;
import org.cyclos.web.rest.model.WebshopAd;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MarketplaceApiHelper {
    @Autowired
    private ApiHelper apiHelper;
    @Autowired
    private UsersApiHelper usersApiHelper;
    @Autowired
    private AddressesApiHelper addressesApiHelper;
    @Autowired
    private GroupsApiHelper groupsApiHelper;
    @Autowired
    private AccountsApiHelper accountsApiHelper;
    @Autowired
    private ImagesApiHelper imagesApiHelper;
    @Autowired
    private OperationsApiHelper operationsApiHelper;
    @Autowired
    private AdQuestionsApiHelper adQuestionsApiHelper;
    @Autowired
    private DeliveryMethodsApiHelper deliveryMethodsApiHelper;
    @Autowired
    private WebshopSettingsApiHelper webshopSettingsApiHelper;

    public Ad toAd(BasicAdVO basicAdVO) {
        if (basicAdVO == null) {
            return null;
        }
        return this.newAd(Ad.class, (EntityModel)basicAdVO, basicAdVO.getType(), basicAdVO.getImage());
    }

    public AdCategoriesDisplayEnum toAdCategoriesDisplayEnum(AdCategoryResultType adCategoryResultType) {
        if (adCategoryResultType != null) {
            switch (adCategoryResultType) {
                case BULLET_LIST: {
                    return AdCategoriesDisplayEnum.SIMPLE;
                }
                case IMAGE_LIST: {
                    return AdCategoriesDisplayEnum.IMAGES;
                }
            }
        }
        return null;
    }

    public List<AdCategoryWithChildren> toAdCategoryList(List<AdCategoryDetailedVO> list) {
        ArrayList<AdCategoryWithChildren> arrayList = new ArrayList<AdCategoryWithChildren>();
        HashMap<Long, AdCategoryWithChildren> hashMap = new HashMap<Long, AdCategoryWithChildren>();
        for (AdCategoryDetailedVO adCategoryDetailedVO : list) {
            AdCategoryWithChildren adCategoryWithChildren = (AdCategoryWithChildren)hashMap.get(adCategoryDetailedVO.getId());
            if (adCategoryWithChildren == null) {
                adCategoryWithChildren = this.apiHelper.newEntity(AdCategoryWithChildren.class, adCategoryDetailedVO);
                adCategoryWithChildren.setImage(this.imagesApiHelper.toImage(adCategoryDetailedVO.getImage()));
                adCategoryWithChildren.setSvgIcon(adCategoryDetailedVO.getSvgIcon());
                adCategoryWithChildren.setSvgIconColor(adCategoryDetailedVO.getSvgIconColor());
                hashMap.put(adCategoryDetailedVO.getId(), adCategoryWithChildren);
            }
            if (adCategoryDetailedVO.getParent() == null) {
                arrayList.add(adCategoryWithChildren);
                continue;
            }
            AdCategoryWithChildren adCategoryWithChildren2 = (AdCategoryWithChildren)hashMap.get(adCategoryDetailedVO.getParent().getId());
            if (adCategoryWithChildren2 == null) {
                throw new IllegalStateException("The ad category list had an unexpected order");
            }
            adCategoryWithChildren2.getChildren().add(adCategoryWithChildren);
        }
        return arrayList;
    }

    public AdCategoryWithParent toAdCategoryWithParent(AdCategoryVO adCategoryVO) {
        if (adCategoryVO == null) {
            return null;
        }
        AdCategoryWithParent adCategoryWithParent = this.apiHelper.newEntity(AdCategoryWithParent.class, adCategoryVO);
        if (adCategoryVO instanceof AdCategoryDetailedVO) {
            adCategoryWithParent.setParent(this.toAdCategoryWithParent((AdCategoryVO)((AdCategoryDetailedVO)adCategoryVO).getParent()));
        }
        return adCategoryWithParent;
    }

    public AdDataForEdit toAdDataForEdit(AdDetailsData adDetailsData) {
        AdDataForEdit adDataForEdit = this.newAdBasicData(AdDataForEdit.class, adDetailsData);
        adDataForEdit.setCreationDate(((BasicAdDTO)adDetailsData.getDto()).getCreationDate());
        adDataForEdit.setStatus(this.toAdStatusEnum(((BasicAdDTO)adDetailsData.getDto()).getStatus()));
        adDataForEdit.setCanEdit(adDetailsData.isEditable());
        adDataForEdit.setCanRemove(adDetailsData.isRemovable());
        adDataForEdit.setCurrencyNotAvailable(adDetailsData.isCurrencyNotAvailable());
        adDataForEdit.setAdvertisement(this.toAdEdit((BasicAdDTO)adDetailsData.getDto(), adDetailsData.getCustomFieldActions()));
        adDataForEdit.setBinaryValues(this.apiHelper.toCustomFieldBinaryValues(((BasicAdDTO)adDetailsData.getDto()).getCustomValues()));
        return adDataForEdit;
    }

    public AdDataForNew toAdDataForNew(AdDetailsData adDetailsData) {
        AdDataForNew adDataForNew = this.newAdBasicData(AdDataForNew.class, adDetailsData);
        adDataForNew.setAdvertisement(this.toAdNew((BasicAdDTO)adDetailsData.getDto(), adDetailsData.getCustomFieldActions()));
        return adDataForNew;
    }

    public AdDataForSearch toAdDataForSearch(AdSearchData adSearchData) {
        if (adSearchData == null) {
            return null;
        }
        AdDataForSearch adDataForSearch = this.newAdDataForSearch(AdDataForSearch.class, adSearchData);
        if (CollectionHelper.isNotEmpty((Iterable)adSearchData.getGroups())) {
            adSearchData.getGroups().stream().map(this.groupsApiHelper::toGroup).map(group -> group).forEach(adDataForSearch.getGroups()::add);
        }
        adDataForSearch.setQuery(this.toAdQueryFilters((BasicAdQuery)adSearchData.getQuery()));
        adDataForSearch.setHideOwner(adSearchData.isHideOwner());
        adDataForSearch.setHidePrice(adSearchData.isHidePrice());
        adDataForSearch.setAdInitialSearchType(this.toAdInitialSearchTypeEnum(adSearchData.getAdInitialSearchType()));
        adDataForSearch.setResultType(this.apiHelper.toResultTypeEnum(adSearchData.getResultType()));
        return adDataForSearch;
    }

    public AdEdit toAdEdit(BasicAdDTO basicAdDTO, List<AdCustomFieldActions> list) {
        AdEdit adEdit = this.newAdManage(AdEdit.class, basicAdDTO, list);
        adEdit.setVersion(basicAdDTO.getVersion());
        return adEdit;
    }

    public AdInitialSearchType toAdInitialSearchType(AdInitialSearchTypeEnum adInitialSearchTypeEnum) {
        if (adInitialSearchTypeEnum != null) {
            switch (adInitialSearchTypeEnum) {
                case CATEGORIES: {
                    return AdInitialSearchType.CATEGORIES;
                }
                case ADS: {
                    return AdInitialSearchType.ADS;
                }
            }
        }
        return null;
    }

    public AdInitialSearchTypeEnum toAdInitialSearchTypeEnum(AdInitialSearchType adInitialSearchType) {
        if (adInitialSearchType != null) {
            switch (adInitialSearchType) {
                case CATEGORIES: {
                    return AdInitialSearchTypeEnum.CATEGORIES;
                }
                case ADS: {
                    return AdInitialSearchTypeEnum.ADS;
                }
            }
        }
        return null;
    }

    public AdKind toAdKind(AdType adType) {
        if (adType != null) {
            switch (adType) {
                case ADVERTISEMENT: {
                    return AdKind.SIMPLE;
                }
                case WEB_SHOP: {
                    return AdKind.WEBSHOP;
                }
            }
        }
        return null;
    }

    public AdNew toAdNew(BasicAdDTO basicAdDTO, List<AdCustomFieldActions> list) {
        AdNew adNew = this.newAdManage(AdNew.class, basicAdDTO, list);
        adNew.setKind(basicAdDTO instanceof AdWebShopDTO ? AdKind.WEBSHOP : AdKind.SIMPLE);
        return adNew;
    }

    public AdOrderBy toAdOrderBy(AdOrderByEnum adOrderByEnum) {
        if (adOrderByEnum != null) {
            switch (adOrderByEnum) {
                case DATE: {
                    return AdOrderBy.DATE;
                }
                case DISTANCE: {
                    return AdOrderBy.DISTANCE;
                }
                case PRICE_ASC: {
                    return AdOrderBy.PRICE_LOWEST;
                }
                case PRICE_DESC: {
                    return AdOrderBy.PRICE_HIGHEST;
                }
                case RELEVANCE: {
                    return AdOrderBy.RELEVANCE;
                }
                case RANDOM: {
                    return AdOrderBy.RANDOM;
                }
            }
        }
        return null;
    }

    public AdOrderByEnum toAdOrderByEnum(AdOrderBy adOrderBy) {
        if (adOrderBy != null) {
            switch (adOrderBy) {
                case DATE: {
                    return AdOrderByEnum.DATE;
                }
                case DISTANCE: {
                    return AdOrderByEnum.DISTANCE;
                }
                case PRICE_LOWEST: {
                    return AdOrderByEnum.PRICE_ASC;
                }
                case PRICE_HIGHEST: {
                    return AdOrderByEnum.PRICE_DESC;
                }
                case RELEVANCE: {
                    return AdOrderByEnum.RELEVANCE;
                }
                case RANDOM: {
                    return AdOrderByEnum.RANDOM;
                }
            }
        }
        return null;
    }

    public AdQueryFilters toAdQueryFilters(BasicAdQuery basicAdQuery) {
        if (basicAdQuery == null) {
            return null;
        }
        AdQueryFilters adQueryFilters = this.newBasicAdQueryFilters(AdQueryFilters.class, basicAdQuery);
        adQueryFilters.setUser(ModelHelper.internalNameOrId((IEntity)basicAdQuery.getOwner()));
        CollectionHelper.orEmpty((Set)basicAdQuery.getBrokers()).stream().map(ModelHelper::internalNameOrId).forEach(adQueryFilters.getBrokers()::add);
        CollectionHelper.orEmpty((Set)basicAdQuery.getGroups()).stream().map(ModelHelper::internalNameOrId).forEach(adQueryFilters.getGroups()::add);
        if (basicAdQuery.isReturnEditable()) {
            adQueryFilters.setReturnEditable(true);
        }
        return adQueryFilters;
    }

    public AdResult toAdResult(BasicAdVO basicAdVO) {
        AdWebShopVO adWebShopVO;
        AdResult adResult = this.newAd(AdResult.class, (EntityModel)basicAdVO, basicAdVO.getType(), basicAdVO.getImage());
        adResult.setDescription(basicAdVO.getDescription());
        adResult.setUser(this.usersApiHelper.toUser((BasicUserVO)basicAdVO.getOwner()));
        adResult.setImage(this.imagesApiHelper.toImage(basicAdVO.getImage()));
        adResult.setPrice(this.apiHelper.getAmount(basicAdVO.getPrice()));
        adResult.setPromotionalPrice(basicAdVO.isPromotionalPeriodActive() ? basicAdVO.getPromotionalPrice() : null);
        adResult.setPublicationPeriod(this.apiHelper.toDatePeriod(basicAdVO.getPublicationPeriod()));
        adResult.setCurrency(ModelHelper.internalNameOrId((IEntity)this.apiHelper.getCurrency(basicAdVO.getPrice())));
        adResult.setCategories(CollectionHelper.orEmpty((Set)basicAdVO.getCategories()).stream().map(ModelHelper::internalNameOrId).collect(Collectors.toList()));
        adResult.setStatus(this.toAdStatusEnum(basicAdVO.getStatus()));
        adResult.setFavoriteForViewer(basicAdVO.isFavoriteForViewer());
        adResult.setCreationDate(basicAdVO.getCreationDate());
        if (basicAdVO instanceof AdWebShopVO) {
            adWebShopVO = (AdWebShopVO)basicAdVO;
            adResult.setMaxAllowedInCart(adWebShopVO.getMaxAllowedInCart());
            adResult.setMinAllowedInCart(adWebShopVO.getMinAllowedInCart());
            Pair<Boolean, BigDecimal> pair = this.getStockData(adWebShopVO.getStockType(), adWebShopVO.getStockQuantity());
            adResult.setUnlimitedStock((Boolean)pair.getFirst());
            adResult.setStockQuantity((BigDecimal)pair.getSecond());
            adResult.setCanAddToCart(adWebShopVO.isCanAddToCart());
            adResult.setProductNumber(adWebShopVO.getProductNumber());
        }
        if ((adWebShopVO = basicAdVO.getAddress()) != null) {
            adResult.setAddress(this.addressesApiHelper.toAddress((GeoLocatedAddressVO)adWebShopVO));
            if (adWebShopVO.getCurrentDistance() != null) {
                adResult.setDistance((double)adWebShopVO.getCurrentDistance());
            }
        }
        if (basicAdVO.isEditable()) {
            adResult.setEditable(basicAdVO.isEditable());
        }
        return adResult;
    }

    public AdStatus toAdStatus(AdStatusEnum adStatusEnum) {
        if (adStatusEnum != null) {
            switch (adStatusEnum) {
                case ACTIVE: {
                    return AdStatus.ACTIVE;
                }
                case DISABLED: {
                    return AdStatus.DISABLED;
                }
                case DRAFT: {
                    return AdStatus.DRAFT;
                }
                case EXPIRED: {
                    return AdStatus.EXPIRED;
                }
                case HIDDEN: {
                    return AdStatus.HIDDEN;
                }
                case PENDING: {
                    return AdStatus.PENDING;
                }
                case SCHEDULED: {
                    return AdStatus.SCHEDULED;
                }
            }
        }
        return null;
    }

    public AdStatusEnum toAdStatusEnum(AdStatus adStatus) {
        if (adStatus != null) {
            switch (adStatus) {
                case ACTIVE: {
                    return AdStatusEnum.ACTIVE;
                }
                case DISABLED: {
                    return AdStatusEnum.DISABLED;
                }
                case DRAFT: {
                    return AdStatusEnum.DRAFT;
                }
                case EXPIRED: {
                    return AdStatusEnum.EXPIRED;
                }
                case HIDDEN: {
                    return AdStatusEnum.HIDDEN;
                }
                case PENDING: {
                    return AdStatusEnum.PENDING;
                }
                case SCHEDULED: {
                    return AdStatusEnum.SCHEDULED;
                }
            }
        }
        return null;
    }

    public AdType toAdType(AdKind adKind) {
        if (adKind != null) {
            switch (adKind) {
                case SIMPLE: {
                    return AdType.ADVERTISEMENT;
                }
                case WEBSHOP: {
                    return AdType.WEB_SHOP;
                }
            }
        }
        return null;
    }

    public AdView toAdView(AdViewData adViewData) {
        Pair<Boolean, BigDecimal> pair;
        if (adViewData == null) {
            return null;
        }
        BasicAdDTO basicAdDTO = (BasicAdDTO)adViewData.getDto();
        AdType adType = basicAdDTO instanceof AdWebShopDTO ? AdType.WEB_SHOP : AdType.ADVERTISEMENT;
        AdView adView = this.newAd(AdView.class, (EntityModel)basicAdDTO, adType, (ImageVO)CollectionHelper.first((Iterable)adViewData.getImages()));
        adView.setUser(this.usersApiHelper.toUser((BasicUserVO)basicAdDTO.getOwner()));
        adView.setStatus(this.toAdStatusEnum(basicAdDTO.getStatus()));
        adView.setDescription(basicAdDTO.getDescription());
        adView.setPublicationPeriod(this.apiHelper.toDatePeriod(basicAdDTO.getPublicationPeriod()));
        CollectionHelper.orEmpty((List)adViewData.getCategories()).stream().map(this::toAdCategoryWithParent).forEach(adView.getCategories()::add);
        CurrencyAmountDTO currencyAmountDTO = basicAdDTO.getPrice();
        if (currencyAmountDTO != null) {
            adView.setCurrency(this.accountsApiHelper.toCurrency(currencyAmountDTO));
            adView.setPrice(currencyAmountDTO.getAmount());
        }
        adView.setPromotionalPrice(basicAdDTO.getPromotionalPrice());
        adView.setPromotionalPeriod(this.apiHelper.toDatePeriod(basicAdDTO.getPromotionalPeriod()));
        adView.setPromotionalPeriodActive(adViewData.isPromotionalPeriodActive());
        CollectionHelper.orEmpty((Set)basicAdDTO.getAddresses()).stream().map(this.addressesApiHelper::toAddress).forEach(adView.getUserAddresses()::add);
        CollectionHelper.orEmpty((List)adViewData.getAddressListData().getAddresses()).stream().map(this.addressesApiHelper::toAddress).forEach(adView.getAdAddresses()::add);
        if (CollectionHelper.isNotEmpty((Iterable)adViewData.getImages())) {
            for (int i = 1; i < adViewData.getImages().size(); ++i) {
                pair = (Pair<Boolean, BigDecimal>)adViewData.getImages().get(i);
                Image image = this.imagesApiHelper.toImage((ImageVO)pair);
                adView.getAdditionalImages().add(image);
            }
        }
        adView.setCustomValues(this.apiHelper.toCustomFieldValuesList(basicAdDTO.getCustomValues()));
        CollectionHelper.orEmpty((List)adViewData.getExportFormats()).stream().map(this.apiHelper::toExportFormat).forEach(adView.getExportFormats()::add);
        adView.setCanEdit(adViewData.isEditable());
        adView.setCanRemove(adViewData.isRemovable());
        adView.setCanAsk(adViewData.isCanAskQuestion());
        adView.setCanBuy(adViewData.isCanBuy());
        adView.setQuestionsEnabled(adViewData.isQuestionsEnabled());
        adView.setCanSetAsFavorite(adViewData.isCanSetAsFavorite());
        adView.setFavorite(adViewData.isFavorite());
        if (adView.getQuestionsEnabled().booleanValue()) {
            CollectionHelper.orEmpty((List)adViewData.getQuestions()).stream().map(this.adQuestionsApiHelper::toAdQuestion).forEach(adView.getQuestions()::add);
        } else {
            adView.setQuestions(null);
        }
        adView.setLastAuthorizationComments(adViewData.isCanViewAuthorizationNotes() ? basicAdDTO.getAuthorizationNotes() : null);
        if (basicAdDTO instanceof AdWebShopDTO) {
            AdWebShopDTO adWebShopDTO = (AdWebShopDTO)basicAdDTO;
            adView.setAllowDecimal(adWebShopDTO.isAllowDecimal());
            CollectionHelper.orEmpty((Set)adWebShopDTO.getDeliveryMethods()).stream().map(this.deliveryMethodsApiHelper::toDeliveryMethod).forEach(adView.getDeliveryMethods()::add);
            adView.setMaxAllowedInCart(adWebShopDTO.getMaxAllowedInCart());
            adView.setMinAllowedInCart(adWebShopDTO.getMinAllowedInCart());
            adView.setProductNumber(adWebShopDTO.getProductNumber());
            pair = this.getStockData(adWebShopDTO.getStockType(), adWebShopDTO.getStockQuantity());
            adView.setUnlimitedStock((Boolean)pair.getFirst());
            adView.setStockQuantity((BigDecimal)pair.getSecond());
        } else {
            adView.setDeliveryMethods(null);
        }
        CollectionHelper.orEmpty((List)adViewData.getCustomOperations()).stream().map(this.operationsApiHelper::toOperation).forEach(adView.getOperations()::add);
        adView.setHideOwner(adViewData.isHideOwner());
        adView.setHidePrice(adViewData.isHidePrice());
        if (adViewData.isCanSetHidden()) {
            adView.setCanHide(basicAdDTO.getStatus() != AdStatus.HIDDEN);
            adView.setCanUnhide(basicAdDTO.getStatus() == AdStatus.HIDDEN);
        } else {
            adView.setCanHide(false);
            adView.setCanUnhide(false);
        }
        adView.setCanRequestAuthorization(adViewData.isCanSubmitForAuthorization());
        adView.setCanSetAsDraft(adViewData.isCanSetAsDraft());
        adView.setCanApprove(adViewData.isCanManagePendingAds() && basicAdDTO.getStatus() == AdStatus.PENDING);
        adView.setCanReject(adView.getCanApprove() != false && adViewData.isAdRequiresAuthorization());
        return adView;
    }

    public AdWithUser toAdWithOwner(BasicAdVO basicAdVO) {
        if (basicAdVO == null) {
            return null;
        }
        AdWithUser adWithUser = this.newAd(AdWithUser.class, (EntityModel)basicAdVO, basicAdVO.getType(), basicAdVO.getImage());
        adWithUser.setUser(this.usersApiHelper.toUser((BasicUserVO)basicAdVO.getOwner()));
        return adWithUser;
    }

    public BasicAdDTO toBasicAdDTO(AdManage adManage, AdKind adKind) {
        Object object;
        AdvertisementDTO advertisementDTO = adKind == AdKind.SIMPLE ? new AdvertisementDTO() : new AdWebShopDTO();
        advertisementDTO.setName(adManage.getName());
        advertisementDTO.setDescription(adManage.getDescription());
        advertisementDTO.setCategories(CollectionHelper.orEmpty(adManage.getCategories()).stream().map(string -> (AdCategoryVO)ModelHelper.voFromString(AdCategoryVO.class, (String)string)).collect(Collectors.toSet()));
        advertisementDTO.setAddresses(CollectionHelper.orEmpty(adManage.getAddresses()).stream().map(string -> (UserAddressVO)ModelHelper.voFromString(UserAddressVO.class, (String)string)).collect(Collectors.toSet()));
        advertisementDTO.setCustomValues(this.apiHelper.toCustomFieldValuesDTO(adManage.getCustomValues()));
        advertisementDTO.setPublicationPeriod(this.apiHelper.toDatePeriodDTO(adManage.getPublicationPeriod()));
        advertisementDTO.setPrice(this.apiHelper.toCurrencyAmountDTO(adManage.getCurrency(), adManage.getPrice()));
        advertisementDTO.setPromotionalPrice(adManage.getPromotionalPrice());
        advertisementDTO.setPromotionalPeriod(this.apiHelper.toDatePeriodDTO(adManage.getPromotionalPeriod()));
        if (adKind == AdKind.WEBSHOP) {
            object = (AdWebShopDTO)advertisementDTO;
            object.setStockType(this.toAdStockType(adManage.getUnlimitedStock(), adManage.getStockQuantity()));
            object.setStockQuantity(adManage.getStockQuantity());
            object.setMinimumStockLimit(adManage.getMinStockQuantityToNotify());
            object.setAllowDecimal(Boolean.TRUE.equals(adManage.getAllowDecimalQuantity()));
            object.setDeliveryMethods(CollectionHelper.orEmpty(adManage.getDeliveryMethods()).stream().map(string -> (AdDeliveryMethodVO)ModelHelper.voFromString(AdDeliveryMethodVO.class, (String)string)).collect(Collectors.toSet()));
            object.setProductNumber(adManage.getProductNumber());
            object.setMinAllowedInCart(adManage.getMinAllowedInCart());
            object.setMaxAllowedInCart(adManage.getMaxAllowedInCart());
        }
        if (adManage.getSubmitForAuthorization() == null) {
            advertisementDTO.setStatus(Boolean.TRUE.equals(adManage.getHidden()) ? AdStatus.HIDDEN : AdStatus.ACTIVE);
        } else {
            advertisementDTO.setStatus(adManage.getSubmitForAuthorization() != false ? AdStatus.PENDING : AdStatus.DRAFT);
        }
        if (adManage instanceof AdNew) {
            object = (AdNew)adManage;
            advertisementDTO.setUploadedImages(CollectionHelper.orEmpty(((AdNew)object).getImages()).stream().map(string -> (ImageVO)ModelHelper.voFromString(ImageVO.class, (String)string)).collect(Collectors.toList()));
        } else {
            object = (AdEdit)adManage;
            advertisementDTO.setVersion(((AdEdit)object).getVersion());
        }
        return advertisementDTO;
    }

    public BasicAdQuery toBasicAdQuery(BasicAdQueryFilters basicAdQueryFilters) {
        BasicAdQuery basicAdQuery = this.apiHelper.newQuery(BasicAdQuery.class, basicAdQueryFilters);
        basicAdQuery.setType(this.toAdType(basicAdQueryFilters.getKind()));
        basicAdQuery.setStatuses(CollectionHelper.orEmpty(basicAdQueryFilters.getStatuses()).stream().map(this::toAdStatus).collect(Collectors.toSet()));
        basicAdQuery.setKeywords(basicAdQueryFilters.getKeywords());
        basicAdQuery.setUserProfileFields(this.usersApiHelper.toProfileFieldsForSearch(basicAdQueryFilters.getProfileFields()));
        basicAdQuery.setAdCustomValues(this.apiHelper.toCustomFieldValuesForSearch(basicAdQueryFilters.getCustomFields()));
        basicAdQuery.setCategory((AdCategoryVO)ModelHelper.voFromString(AdCategoryVO.class, (String)basicAdQueryFilters.getCategory()));
        basicAdQuery.setCurrency((CurrencyVO)ModelHelper.voFromString(CurrencyVO.class, (String)basicAdQueryFilters.getCurrency()));
        basicAdQuery.setPriceRange(this.apiHelper.toCurrencyAmountRangeDTO(basicAdQueryFilters.getCurrency(), basicAdQueryFilters.getPriceRange()));
        basicAdQuery.setProductNumber(basicAdQueryFilters.getProductNumber());
        basicAdQuery.setHasImages(Boolean.TRUE.equals(basicAdQueryFilters.getHasImages()));
        basicAdQuery.setPublicationPeriod(this.apiHelper.toDatePeriodDTO(basicAdQueryFilters.getPublicationPeriod()));
        basicAdQuery.setExpirationPeriod(this.apiHelper.toDatePeriodDTO(basicAdQueryFilters.getExpirationPeriod()));
        basicAdQuery.setDistance(this.addressesApiHelper.toDistanceDTO(basicAdQueryFilters.getLatitude(), basicAdQueryFilters.getLongitude(), basicAdQueryFilters.getMaxDistance()));
        basicAdQuery.setAddressResult(this.addressesApiHelper.toAdAddressResult(basicAdQueryFilters.getAddressResult()));
        basicAdQuery.setOrderBy(this.toAdOrderBy(basicAdQueryFilters.getOrderBy()));
        basicAdQuery.setFavoritesFor((UserVO)ModelHelper.voFromString(UserVO.class, (String)basicAdQueryFilters.getFavoriteFor()));
        if (basicAdQueryFilters instanceof AdQueryFilters) {
            AdQueryFilters adQueryFilters = (AdQueryFilters)basicAdQueryFilters;
            basicAdQuery.setOwner((UserVO)ModelHelper.voFromString(UserVO.class, (String)adQueryFilters.getUser()));
            basicAdQuery.setBrokers(ModelHelper.vosFromString(UserVO.class, adQueryFilters.getBrokers()));
            basicAdQuery.setGroups(ModelHelper.vosFromString(BasicGroupVO.class, adQueryFilters.getGroups()));
            basicAdQuery.setReturnEditable(Boolean.TRUE.equals(adQueryFilters.getReturnEditable()));
        }
        return basicAdQuery;
    }

    public UserAdsDataForSearch toUserAdsDataForSearch(UserAdsSearchData userAdsSearchData) {
        if (userAdsSearchData == null) {
            return null;
        }
        UserAdsDataForSearch userAdsDataForSearch = this.newAdDataForSearch(UserAdsDataForSearch.class, (AdSearchData)userAdsSearchData);
        userAdsDataForSearch.setUser(this.usersApiHelper.toUser((BasicUserVO)userAdsSearchData.getUser()));
        userAdsDataForSearch.setMaxAds(userAdsSearchData.getMaxAds());
        userAdsDataForSearch.setCreateNew(userAdsSearchData.isCanCreateNew());
        userAdsDataForSearch.setRequiresAuthorization(userAdsSearchData.isRequiresAuthorization());
        userAdsDataForSearch.setQuery(this.toUserAdsQueryFilters((BasicAdQuery)userAdsSearchData.getQuery()));
        return userAdsDataForSearch;
    }

    public UserAdsQueryFilters toUserAdsQueryFilters(BasicAdQuery basicAdQuery) {
        if (basicAdQuery == null) {
            return null;
        }
        return this.newBasicAdQueryFilters(UserAdsQueryFilters.class, basicAdQuery);
    }

    public org.cyclos.web.rest.model.UserFavoriteAdsListData toUserFavoriteAdsListData(UserFavoriteAdsListData userFavoriteAdsListData) {
        org.cyclos.web.rest.model.UserFavoriteAdsListData userFavoriteAdsListData2 = new org.cyclos.web.rest.model.UserFavoriteAdsListData();
        userFavoriteAdsListData2.setUser(this.usersApiHelper.toUser((BasicUserVO)userFavoriteAdsListData.getUser()));
        userFavoriteAdsListData2.setCanEdit(userFavoriteAdsListData.isManage());
        CollectionHelper.orEmpty((List)userFavoriteAdsListData.getCurrencies()).stream().map(this.accountsApiHelper::toCurrency).forEach(userFavoriteAdsListData2.getCurrencies()::add);
        return userFavoriteAdsListData2;
    }

    public WebshopAd toWebshopAd(AdWebShopVO adWebShopVO) {
        if (adWebShopVO == null) {
            return null;
        }
        WebshopAd webshopAd = this.newAd(WebshopAd.class, (EntityModel)adWebShopVO, adWebShopVO.getType(), adWebShopVO.getImage());
        webshopAd.setProductNumber(adWebShopVO.getProductNumber());
        webshopAd.setStatus(this.toAdStatusEnum(adWebShopVO.getStatus()));
        webshopAd.setAllowDecimalQuantity(adWebShopVO.isAllowDecimal());
        webshopAd.setMinAllowedInCart(adWebShopVO.getMinAllowedInCart());
        webshopAd.setMaxAllowedInCart(adWebShopVO.getMaxAllowedInCart());
        Pair<Boolean, BigDecimal> pair = this.getStockData(adWebShopVO.getStockType(), adWebShopVO.getStockQuantity());
        webshopAd.setUnlimitedStock((Boolean)pair.getFirst());
        webshopAd.setStockQuantity((BigDecimal)pair.getSecond());
        webshopAd.setPrice(adWebShopVO.getCurrentPrice());
        return webshopAd;
    }

    private Pair<Boolean, BigDecimal> getStockData(AdWebShopStockType adWebShopStockType, BigDecimal bigDecimal) {
        boolean bl = adWebShopStockType == AdWebShopStockType.AVAILABLE;
        BigDecimal bigDecimal2 = null;
        if (!bl) {
            bigDecimal2 = adWebShopStockType == AdWebShopStockType.NOT_AVAILABLE ? null : BigDecimalHelper.zeroWhenNull((BigDecimal)bigDecimal);
        }
        return Pair.create((Object)bl, bigDecimal2);
    }

    private <A extends Ad> A newAd(Class<A> clazz, EntityModel entityModel, AdType adType, ImageVO imageVO) {
        Ad ad = (Ad)this.apiHelper.newEntity(clazz, entityModel);
        ad.setKind(this.toAdKind(adType));
        ad.setImage(this.imagesApiHelper.toImage(imageVO));
        return (A)ad;
    }

    private <D extends AdBasicData> D newAdBasicData(Class<D> clazz, AdDetailsData adDetailsData) {
        AdBasicData adBasicData = (AdBasicData)ClassHelper.instantiate(clazz);
        adBasicData.setCanCreateNew(adDetailsData.isCanCreateNew());
        adBasicData.setCanSaveAsDraft(adDetailsData.isCanSaveAsDraft());
        adBasicData.setCanRequestAuthorization(adDetailsData.isCanSubmitForAuthorization());
        adBasicData.setRequiresAuthorization(adDetailsData.isAdsRequireAuthorization());
        adBasicData.setMaxCategoriesPerAd(adDetailsData.getMaxCategoriesPerAd());
        AdKind adKind = adDetailsData.getDto() instanceof AdWebShopDTO ? AdKind.WEBSHOP : AdKind.SIMPLE;
        adBasicData.setKind(adKind);
        adBasicData.setUser(this.usersApiHelper.toUser((BasicUserVO)((BasicAdDTO)adDetailsData.getDto()).getOwner()));
        adBasicData.setMaxImages(adDetailsData.getMaxImages());
        adBasicData.setCategories(this.toAdCategoryList(adDetailsData.getCategories()));
        CollectionHelper.orEmpty((List)adDetailsData.getCurrencies()).stream().map(this.accountsApiHelper::toCurrency).forEach(adBasicData.getCurrencies()::add);
        CollectionHelper.orEmpty((List)adDetailsData.getCustomFieldActions()).stream().filter(AdCustomFieldActions::isManage).map(AdCustomFieldActions::getCustomField).map(this.apiHelper::toCustomFieldDetailed).forEach(adBasicData.getCustomFields()::add);
        CollectionHelper.orEmpty((List)adDetailsData.getAddresses()).stream().map(this.addressesApiHelper::toAddress).forEach(adBasicData.getAddresses()::add);
        if (adKind == AdKind.WEBSHOP) {
            WebShopAdDetailsData webShopAdDetailsData = (WebShopAdDetailsData)adDetailsData;
            adBasicData.setWebshopSettings(this.webshopSettingsApiHelper.toWebshopSettings(webShopAdDetailsData.getSetting()));
            CollectionHelper.orEmpty((List)webShopAdDetailsData.getDeliveryMethods()).stream().map(this.deliveryMethodsApiHelper::toDeliveryMethod).forEach(adBasicData.getDeliveryMethods()::add);
        }
        return (D)adBasicData;
    }

    private <D extends BaseAdDataForSearch> D newAdDataForSearch(Class<D> clazz, AdSearchData adSearchData) {
        BaseAdDataForSearch baseAdDataForSearch = (BaseAdDataForSearch)ClassHelper.instantiate(clazz);
        if (adSearchData.isAllowViewUserAd()) {
            baseAdDataForSearch.getVisibleKinds().add(AdKind.SIMPLE);
        }
        if (adSearchData.isAllowViewUserWebShop()) {
            baseAdDataForSearch.getVisibleKinds().add(AdKind.WEBSHOP);
        }
        baseAdDataForSearch.setCategories(this.toAdCategoryList(adSearchData.getCategories()));
        LinkedHashSet<CustomFieldDetailedVO> linkedHashSet = new LinkedHashSet<CustomFieldDetailedVO>();
        for (CustomFieldDetailedVO customFieldDetailedVO : adSearchData.getSimpleViewAdCustomFields()) {
            linkedHashSet.add(customFieldDetailedVO);
            baseAdDataForSearch.getFieldsInBasicSearch().add(ModelHelper.unqualifyInternalName((IInternalNamedEntity)customFieldDetailedVO));
        }
        for (CustomFieldDetailedVO customFieldDetailedVO : adSearchData.getAdvancedViewAdCustomFields()) {
            linkedHashSet.add(customFieldDetailedVO);
            baseAdDataForSearch.getFieldsInAdvancedSearch().add(ModelHelper.unqualifyInternalName((IInternalNamedEntity)customFieldDetailedVO));
        }
        linkedHashSet.stream().map(this.apiHelper::toCustomFieldDetailed).forEach(baseAdDataForSearch.getCustomFields()::add);
        for (CustomFieldDetailedVO customFieldDetailedVO : adSearchData.getProfileFields()) {
            if (customFieldDetailedVO instanceof BasicProfileField) {
                baseAdDataForSearch.getBasicProfileFields().add(this.usersApiHelper.toBasicProfileFieldInput((BasicProfileField)customFieldDetailedVO, (DataWithBasicProfileFields)adSearchData));
                continue;
            }
            if (!(customFieldDetailedVO instanceof CustomFieldDetailedVO)) continue;
            baseAdDataForSearch.getCustomProfileFields().add(this.apiHelper.toCustomFieldDetailed(customFieldDetailedVO));
        }
        CollectionHelper.orEmpty((List)adSearchData.getCurrencies()).stream().map(this.accountsApiHelper::toCurrency).forEach(baseAdDataForSearch.getCurrencies()::add);
        baseAdDataForSearch.setSearchByDistanceData(this.addressesApiHelper.toSearchByDistanceData(adSearchData.getSearchByDistanceData()));
        baseAdDataForSearch.setCategoriesDisplay(this.toAdCategoriesDisplayEnum(adSearchData.getAdCategoriesResultType()));
        return (D)baseAdDataForSearch;
    }

    private <A extends AdManage> A newAdManage(Class<A> clazz, BasicAdDTO basicAdDTO, List<AdCustomFieldActions> list) {
        AdManage adManage = (AdManage)ClassHelper.instantiate(clazz);
        adManage.setName(basicAdDTO.getName());
        adManage.setDescription(basicAdDTO.getDescription());
        adManage.setPublicationPeriod(this.apiHelper.toDatePeriod(basicAdDTO.getPublicationPeriod()));
        CollectionHelper.orEmpty((Set)basicAdDTO.getCategories()).stream().map(ModelHelper::internalNameOrId).forEach(adManage.getCategories()::add);
        if (basicAdDTO.getPrice() != null) {
            adManage.setCurrency(ModelHelper.internalNameOrId((IEntity)basicAdDTO.getPrice().getCurrency()));
            adManage.setPrice(basicAdDTO.getPrice().getAmount());
        }
        adManage.setPromotionalPrice(basicAdDTO.getPromotionalPrice());
        adManage.setPromotionalPeriod(this.apiHelper.toDatePeriod(basicAdDTO.getPromotionalPeriod()));
        List list2 = CollectionHelper.orEmpty(list).stream().filter(AdCustomFieldActions::isManage).map(adCustomFieldActions -> adCustomFieldActions.getCustomField().getId()).collect(Collectors.toList());
        List list3 = CollectionHelper.orEmpty((List)basicAdDTO.getCustomValues()).stream().filter(customFieldValueDTO -> list2.contains(customFieldValueDTO.getField().getId())).collect(Collectors.toList());
        adManage.setCustomValues(this.apiHelper.toCustomFieldValuesMap(list3));
        CollectionHelper.orEmpty((Set)basicAdDTO.getAddresses()).stream().map(userAddressVO -> ApiHelper.toId(userAddressVO.getId())).forEach(adManage.getAddresses()::add);
        if (basicAdDTO instanceof AdWebShopDTO) {
            AdWebShopDTO adWebShopDTO = (AdWebShopDTO)basicAdDTO;
            adManage.setUnlimitedStock(adWebShopDTO.getStockType() == AdWebShopStockType.AVAILABLE);
            adManage.setStockQuantity(adWebShopDTO.getStockQuantity());
            adManage.setMinStockQuantityToNotify(adWebShopDTO.getMinimumStockLimit());
            adManage.setAllowDecimalQuantity(adWebShopDTO.isAllowDecimal());
            CollectionHelper.orEmpty((Set)adWebShopDTO.getDeliveryMethods()).stream().map(ModelHelper::internalNameOrId).forEach(adManage.getDeliveryMethods()::add);
            adManage.setProductNumber(adWebShopDTO.getProductNumber());
            adManage.setMinAllowedInCart(adWebShopDTO.getMinAllowedInCart());
            adManage.setMaxAllowedInCart(adWebShopDTO.getMaxAllowedInCart());
        }
        return (A)adManage;
    }

    private <F extends BasicAdQueryFilters> F newBasicAdQueryFilters(Class<F> clazz, BasicAdQuery basicAdQuery) {
        BasicAdQueryFilters basicAdQueryFilters = (BasicAdQueryFilters)this.apiHelper.newQueryFilters(clazz, (QueryParameters)basicAdQuery);
        basicAdQueryFilters.setKeywords(basicAdQuery.getKeywords());
        basicAdQueryFilters.setProfileFields(this.apiHelper.toFilters(basicAdQuery.getUserProfileFields()));
        basicAdQueryFilters.setAddressResult(this.addressesApiHelper.toAdAddressResultEnum(basicAdQuery.getAddressResult()));
        basicAdQueryFilters.setKind(this.toAdKind(basicAdQuery.getType()));
        CollectionHelper.orEmpty((Set)basicAdQuery.getStatuses()).stream().map(this::toAdStatusEnum).forEach(basicAdQueryFilters.getStatuses()::add);
        basicAdQueryFilters.setKeywords(basicAdQuery.getKeywords());
        basicAdQueryFilters.setProfileFields(this.apiHelper.toFilters(basicAdQuery.getUserProfileFields()));
        basicAdQueryFilters.setCustomFields(this.apiHelper.toFilters(basicAdQuery.getAdCustomValues()));
        basicAdQueryFilters.setCategory(ModelHelper.internalNameOrId((IEntity)basicAdQuery.getCategory()));
        basicAdQueryFilters.setCurrency(ModelHelper.internalNameOrId((IEntity)basicAdQuery.getCurrency()));
        basicAdQueryFilters.setPriceRange(this.apiHelper.toFilter((DecimalRangeDTO)basicAdQuery.getPriceRange()));
        basicAdQueryFilters.setFavoriteFor(ModelHelper.internalNameOrId((IEntity)basicAdQuery.getFavoritesFor()));
        if (basicAdQuery.isHasImages()) {
            basicAdQueryFilters.setHasImages(true);
        }
        basicAdQueryFilters.setProductNumber(basicAdQuery.getProductNumber());
        basicAdQueryFilters.setPublicationPeriod(this.apiHelper.toFilter(basicAdQuery.getPublicationPeriod()));
        basicAdQueryFilters.setExpirationPeriod(this.apiHelper.toFilter(basicAdQuery.getExpirationPeriod()));
        this.addressesApiHelper.fillDistance(basicAdQueryFilters, basicAdQuery.getDistance());
        basicAdQueryFilters.setAddressResult(this.addressesApiHelper.toAdAddressResultEnum(basicAdQuery.getAddressResult()));
        basicAdQueryFilters.setOrderBy(this.toAdOrderByEnum(basicAdQuery.getOrderBy()));
        return (F)basicAdQueryFilters;
    }

    private AdWebShopStockType toAdStockType(Boolean bl, BigDecimal bigDecimal) {
        if (Boolean.TRUE.equals(bl)) {
            return AdWebShopStockType.AVAILABLE;
        }
        return BigDecimalHelper.isPositive((BigDecimal)bigDecimal) ? AdWebShopStockType.QUANTITY : AdWebShopStockType.NOT_AVAILABLE;
    }
}

