/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.helpers;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.cyclos.model.IEntity;
import org.cyclos.model.banking.accounttypes.AccountTypeVO;
import org.cyclos.model.banking.accounttypes.AccountTypeWithCurrencyVO;
import org.cyclos.model.banking.transfertypes.TransferTypeVO;
import org.cyclos.model.banking.voucherconfigurations.VoucherConfigurationVO;
import org.cyclos.model.messaging.messagecategories.MessageCategoryVO;
import org.cyclos.model.messaging.notifications.AccountNotificationType;
import org.cyclos.model.messaging.notifications.AdminNotificationType;
import org.cyclos.model.messaging.notifications.BrokeringNotificationType;
import org.cyclos.model.messaging.notifications.FeedbackAndReferenceNotificationType;
import org.cyclos.model.messaging.notifications.INotificationType;
import org.cyclos.model.messaging.notifications.MarketplaceBuyerNotificationType;
import org.cyclos.model.messaging.notifications.MarketplaceSellerNotificationType;
import org.cyclos.model.messaging.notifications.PersonalNotificationType;
import org.cyclos.model.messaging.notificationsettings.AccountNotificationSettingsDTO;
import org.cyclos.model.messaging.notificationsettings.AdminNotificationSettingsDTO;
import org.cyclos.model.messaging.notificationsettings.AdminNotificationSettingsData;
import org.cyclos.model.messaging.notificationsettings.EmailUnsubscribeData;
import org.cyclos.model.messaging.notificationsettings.EmailUnsubscribeType;
import org.cyclos.model.messaging.notificationsettings.NotificationSettingsDTO;
import org.cyclos.model.messaging.notificationsettings.NotificationSettingsData;
import org.cyclos.model.messaging.notificationsettings.NotificationTypeSettingsDTO;
import org.cyclos.model.messaging.notificationsettings.UserNotificationSettingsDTO;
import org.cyclos.model.messaging.notificationsettings.UserNotificationSettingsData;
import org.cyclos.model.system.images.ImageVO;
import org.cyclos.model.users.groups.GroupVO;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.server.utils.ClassHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.web.rest.helpers.AccountsApiHelper;
import org.cyclos.web.rest.helpers.AlertsApiHelper;
import org.cyclos.web.rest.helpers.ApiHelper;
import org.cyclos.web.rest.helpers.AuthApiHelper;
import org.cyclos.web.rest.helpers.GroupsApiHelper;
import org.cyclos.web.rest.helpers.ImagesApiHelper;
import org.cyclos.web.rest.helpers.NotificationsApiHelper;
import org.cyclos.web.rest.helpers.UsersApiHelper;
import org.cyclos.web.rest.model.AccountNotificationSettings;
import org.cyclos.web.rest.model.AccountNotificationSettingsView;
import org.cyclos.web.rest.model.BaseNotificationSettings;
import org.cyclos.web.rest.model.DataForEmailUnsubscribe;
import org.cyclos.web.rest.model.EmailUnsubscribeKind;
import org.cyclos.web.rest.model.NotificationKind;
import org.cyclos.web.rest.model.NotificationSettingsDataForEdit;
import org.cyclos.web.rest.model.NotificationSettingsEdit;
import org.cyclos.web.rest.model.NotificationSettingsView;
import org.cyclos.web.rest.model.NotificationTypeMediums;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class NotificationSettingsApiHelper {
    @Autowired
    private ApiHelper apiHelper;
    @Autowired
    private UsersApiHelper usersApiHelper;
    @Autowired
    private AccountsApiHelper accountsApiHelper;
    @Autowired
    private AuthApiHelper authApiHelper;
    @Autowired
    private GroupsApiHelper groupsApiHelper;
    @Autowired
    private AlertsApiHelper alertsApiHelper;
    @Autowired
    private ImagesApiHelper imagesApiHelper;
    @Autowired
    private NotificationsApiHelper notificationsApiHelper;

    public AdminNotificationSettingsDTO toAdminNotificationSettingsDTO(String string2, NotificationSettingsEdit notificationSettingsEdit) {
        AdminNotificationSettingsDTO adminNotificationSettingsDTO = this.newNotificationSettingsDTO(AdminNotificationSettingsDTO.class, string2, notificationSettingsEdit);
        adminNotificationSettingsDTO.setAuthorizablePayments(CollectionHelper.orEmpty(notificationSettingsEdit.getAuthorizablePayments()).stream().map(string -> (TransferTypeVO)ModelHelper.voFromString(TransferTypeVO.class, (String)string)).collect(Collectors.toSet()));
        adminNotificationSettingsDTO.setExternalPaymentsExpired(CollectionHelper.orEmpty(notificationSettingsEdit.getExternalPaymentsExpired()).stream().map(string -> (TransferTypeVO)ModelHelper.voFromString(TransferTypeVO.class, (String)string)).collect(Collectors.toSet()));
        adminNotificationSettingsDTO.setExternalPaymentsFailed(CollectionHelper.orEmpty(notificationSettingsEdit.getExternalPaymentsFailed()).stream().map(string -> (TransferTypeVO)ModelHelper.voFromString(TransferTypeVO.class, (String)string)).collect(Collectors.toSet()));
        adminNotificationSettingsDTO.setFwdMessageCategoriesToEmail(CollectionHelper.orEmpty(notificationSettingsEdit.getForwardMessageCategories()).stream().map(string -> (MessageCategoryVO)ModelHelper.voFromString(MessageCategoryVO.class, (String)string)).collect(Collectors.toSet()));
        adminNotificationSettingsDTO.setPayments(CollectionHelper.orEmpty(notificationSettingsEdit.getPayments()).stream().map(string -> (TransferTypeVO)ModelHelper.voFromString(TransferTypeVO.class, (String)string)).collect(Collectors.toSet()));
        adminNotificationSettingsDTO.setSystemAlerts(CollectionHelper.orEmpty(notificationSettingsEdit.getSystemAlerts()).stream().map(this.alertsApiHelper::toSystemAlertType).collect(Collectors.toSet()));
        adminNotificationSettingsDTO.setUserAlerts(CollectionHelper.orEmpty(notificationSettingsEdit.getUserAlerts()).stream().map(this.alertsApiHelper::toUserAlertType).collect(Collectors.toSet()));
        adminNotificationSettingsDTO.setUserGroups(CollectionHelper.orEmpty(notificationSettingsEdit.getUserGroups()).stream().map(string -> (GroupVO)ModelHelper.voFromString(GroupVO.class, (String)string)).collect(Collectors.toSet()));
        adminNotificationSettingsDTO.setVoucherConfigurations(CollectionHelper.orEmpty(notificationSettingsEdit.getVoucherConfigurations()).stream().map(string -> (VoucherConfigurationVO)ModelHelper.voFromString(VoucherConfigurationVO.class, (String)string)).collect(Collectors.toSet()));
        adminNotificationSettingsDTO.setVoucherConfigurationsBuying(CollectionHelper.orEmpty(notificationSettingsEdit.getVoucherConfigurationsBuying()).stream().map(string -> (VoucherConfigurationVO)ModelHelper.voFromString(VoucherConfigurationVO.class, (String)string)).collect(Collectors.toSet()));
        return adminNotificationSettingsDTO;
    }

    public DataForEmailUnsubscribe toDataForEmailUnsubscribe(EmailUnsubscribeData emailUnsubscribeData) {
        if (emailUnsubscribeData == null) {
            return null;
        }
        DataForEmailUnsubscribe dataForEmailUnsubscribe = new DataForEmailUnsubscribe();
        dataForEmailUnsubscribe.setUser(this.usersApiHelper.toUser(emailUnsubscribeData.getUser()));
        dataForEmailUnsubscribe.setEmail(emailUnsubscribeData.getEmail());
        dataForEmailUnsubscribe.setKind(this.toEmailUnsubscribeKind(emailUnsubscribeData.getType()));
        dataForEmailUnsubscribe.setApplicationName(emailUnsubscribeData.getApplicationName());
        dataForEmailUnsubscribe.setApplicationLogo(this.imagesApiHelper.toImage((ImageVO)emailUnsubscribeData.getApplicationLogo()));
        dataForEmailUnsubscribe.setShortcutIcon(this.imagesApiHelper.toImage((ImageVO)emailUnsubscribeData.getShortcutIcon()));
        dataForEmailUnsubscribe.setLocale(emailUnsubscribeData.getLocale());
        dataForEmailUnsubscribe.setCountry(emailUnsubscribeData.getCountry());
        dataForEmailUnsubscribe.setResourceCacheKey(emailUnsubscribeData.getResourceCacheKey());
        dataForEmailUnsubscribe.setRootUrl(emailUnsubscribeData.getRootUrl());
        dataForEmailUnsubscribe.setNotificationSettingsUrl(emailUnsubscribeData.getNotificationSettingsUrl());
        dataForEmailUnsubscribe.setHomeUrl(emailUnsubscribeData.getHomeUrl());
        return dataForEmailUnsubscribe;
    }

    public EmailUnsubscribeKind toEmailUnsubscribeKind(EmailUnsubscribeType emailUnsubscribeType) {
        if (emailUnsubscribeType != null) {
            switch (emailUnsubscribeType) {
                case NOTIFICATION: {
                    return EmailUnsubscribeKind.NOTIFICATION;
                }
                case MESSAGE: {
                    return EmailUnsubscribeKind.MESSAGE;
                }
                case MAILING: {
                    return EmailUnsubscribeKind.MAILING;
                }
            }
        }
        return null;
    }

    public NotificationKind toNotificationKind(AccountNotificationType accountNotificationType) {
        if (accountNotificationType != null) {
            switch (accountNotificationType) {
                case ALL_NON_SMS_PERFORMED_PAYMENTS: {
                    return NotificationKind.ACCOUNT_ALL_NON_SMS_PERFORMED_PAYMENTS;
                }
                case AUTHORIZED_PAYMENT_CANCELED: {
                    return NotificationKind.ACCOUNT_AUTHORIZED_PAYMENT_CANCELED;
                }
                case AUTHORIZED_PAYMENT_DENIED: {
                    return NotificationKind.ACCOUNT_AUTHORIZED_PAYMENT_DENIED;
                }
                case AUTHORIZED_PAYMENT_EXPIRED: {
                    return NotificationKind.ACCOUNT_AUTHORIZED_PAYMENT_EXPIRED;
                }
                case AUTHORIZED_PAYMENT_SUCCEEDED: {
                    return NotificationKind.ACCOUNT_AUTHORIZED_PAYMENT_SUCCEEDED;
                }
                case VOUCHER_ASSIGNED: {
                    return NotificationKind.ACCOUNT_VOUCHER_ASSIGNED;
                }
                case VOUCHER_ABOUT_TO_EXPIRE: {
                    return NotificationKind.ACCOUNT_VOUCHER_ABOUT_TO_EXPIRE;
                }
                case VOUCHER_EXPIRATION_DATE_CHANGED: {
                    return NotificationKind.ACCOUNT_VOUCHER_EXPIRATION_DATE_CHANGED;
                }
                case VOUCHER_EXPIRED: {
                    return NotificationKind.ACCOUNT_VOUCHER_EXPIRED;
                }
                case VOUCHER_PIN_BLOCKED: {
                    return NotificationKind.ACCOUNT_VOUCHER_PIN_BLOCKED;
                }
                case VOUCHER_REDEEM: {
                    return NotificationKind.ACCOUNT_VOUCHER_REDEEM;
                }
                case VOUCHER_TOP_UP: {
                    return NotificationKind.ACCOUNT_VOUCHER_TOP_UP;
                }
                case EXTERNAL_PAYMENT_EXPIRED: {
                    return NotificationKind.ACCOUNT_EXTERNAL_PAYMENT_EXPIRED;
                }
                case EXTERNAL_PAYMENT_PERFORMED_FAILED: {
                    return NotificationKind.ACCOUNT_EXTERNAL_PAYMENT_PERFORMED_FAILED;
                }
                case EXTERNAL_PAYMENT_RECEIVED_FAILED: {
                    return NotificationKind.ACCOUNT_EXTERNAL_PAYMENT_RECEIVED_FAILED;
                }
                case INCOMING_RECURRING_PAYMENT_CANCELED: {
                    return NotificationKind.ACCOUNT_INCOMING_RECURRING_PAYMENT_CANCELED;
                }
                case INCOMING_RECURRING_PAYMENT_FAILED: {
                    return NotificationKind.ACCOUNT_INCOMING_RECURRING_PAYMENT_FAILED;
                }
                case INCOMING_RECURRING_PAYMENT_RECEIVED: {
                    return NotificationKind.ACCOUNT_INCOMING_RECURRING_PAYMENT_RECEIVED;
                }
                case INCOMING_SCHEDULED_PAYMENT_CANCELED: {
                    return NotificationKind.ACCOUNT_INCOMING_SCHEDULED_PAYMENT_CANCELED;
                }
                case INCOMING_SCHEDULED_PAYMENT_FAILED: {
                    return NotificationKind.ACCOUNT_INCOMING_SCHEDULED_PAYMENT_FAILED;
                }
                case INCOMING_SCHEDULED_PAYMENT_RECEIVED: {
                    return NotificationKind.ACCOUNT_INCOMING_SCHEDULED_PAYMENT_RECEIVED;
                }
                case LIMIT_CHANGE: {
                    return NotificationKind.ACCOUNT_LIMIT_CHANGE;
                }
                case OPERATOR_AUTHORIZED_PAYMENT_APPROVED_STILL_PENDING: {
                    return NotificationKind.ACCOUNT_OPERATOR_AUTHORIZED_PAYMENT_APPROVED_STILL_PENDING;
                }
                case OPERATOR_AUTHORIZED_PAYMENT_CANCELED: {
                    return NotificationKind.ACCOUNT_OPERATOR_AUTHORIZED_PAYMENT_CANCELED;
                }
                case OPERATOR_AUTHORIZED_PAYMENT_DENIED: {
                    return NotificationKind.ACCOUNT_OPERATOR_AUTHORIZED_PAYMENT_DENIED;
                }
                case OPERATOR_AUTHORIZED_PAYMENT_EXPIRED: {
                    return NotificationKind.ACCOUNT_OPERATOR_AUTHORIZED_PAYMENT_EXPIRED;
                }
                case OPERATOR_AUTHORIZED_PAYMENT_SUCCEEDED: {
                    return NotificationKind.ACCOUNT_OPERATOR_AUTHORIZED_PAYMENT_SUCCEEDED;
                }
                case OPERATOR_PAYMENT_AWAITING_AUTHORIZATION: {
                    return NotificationKind.ACCOUNT_OPERATOR_PAYMENT_AWAITING_AUTHORIZATION;
                }
                case PAYMENT_AWAITING_AUTHORIZATION: {
                    return NotificationKind.ACCOUNT_PAYMENT_AWAITING_AUTHORIZATION;
                }
                case PAYMENT_RECEIVED: {
                    return NotificationKind.ACCOUNT_PAYMENT_RECEIVED;
                }
                case PAYMENT_REQUEST_CANCELED: {
                    return NotificationKind.ACCOUNT_PAYMENT_REQUEST_CANCELED;
                }
                case PAYMENT_REQUEST_DENIED: {
                    return NotificationKind.ACCOUNT_PAYMENT_REQUEST_DENIED;
                }
                case PAYMENT_REQUEST_EXPIRATION_DATE_CHANGED: {
                    return NotificationKind.ACCOUNT_PAYMENT_REQUEST_EXPIRATION_DATE_CHANGED;
                }
                case PAYMENT_REQUEST_EXPIRED: {
                    return NotificationKind.ACCOUNT_PAYMENT_REQUEST_EXPIRED;
                }
                case PAYMENT_REQUEST_PROCESSED: {
                    return NotificationKind.ACCOUNT_PAYMENT_REQUEST_PROCESSED;
                }
                case PAYMENT_REQUEST_RECEIVED: {
                    return NotificationKind.ACCOUNT_PAYMENT_REQUEST_RECEIVED;
                }
                case RECURRING_PAYMENT_FAILED: {
                    return NotificationKind.ACCOUNT_RECURRING_PAYMENT_FAILED;
                }
                case RECURRING_PAYMENT_OCCURRENCE_PROCESSED: {
                    return NotificationKind.ACCOUNT_RECURRING_PAYMENT_OCCURRENCE_PROCESSED;
                }
                case SCHEDULED_PAYMENT_FAILED: {
                    return NotificationKind.ACCOUNT_SCHEDULED_PAYMENT_FAILED;
                }
                case SCHEDULED_PAYMENT_INSTALLMENT_PROCESSED: {
                    return NotificationKind.ACCOUNT_SCHEDULED_PAYMENT_INSTALLMENT_PROCESSED;
                }
                case SCHEDULED_PAYMENT_REQUEST_FAILED: {
                    return NotificationKind.ACCOUNT_SCHEDULED_PAYMENT_REQUEST_FAILED;
                }
                case SENT_PAYMENT_REQUEST_EXPIRATION_DATE_CHANGED: {
                    return NotificationKind.ACCOUNT_SENT_PAYMENT_REQUEST_EXPIRATION_DATE_CHANGED;
                }
                case SMS_PERFORMED_PAYMENT: {
                    return NotificationKind.ACCOUNT_SMS_PERFORMED_PAYMENT;
                }
                case TICKET_WEBHOOK_FAILED: {
                    return NotificationKind.ACCOUNT_TICKET_WEBHOOK_FAILED;
                }
                case PAYMENT_PERFORMED_CHARGED_BACK: 
                case PAYMENT_RECEIVED_CHARGED_BACK: {
                    return null;
                }
            }
        }
        return null;
    }

    public NotificationKind toNotificationKind(AdminNotificationType adminNotificationType) {
        if (adminNotificationType != null) {
            switch (adminNotificationType) {
                case AD_PENDING_AUTHORIZATION: {
                    return NotificationKind.ADMIN_AD_PENDING_AUTHORIZATION;
                }
                case APPLICATION_ERROR: {
                    return NotificationKind.ADMIN_APPLICATION_ERROR;
                }
                case EXTERNAL_PAYMENT_EXPIRED: {
                    return NotificationKind.ADMIN_EXTERNAL_PAYMENT_EXPIRED;
                }
                case EXTERNAL_PAYMENT_PERFORMED_FAILED: {
                    return NotificationKind.ADMIN_EXTERNAL_PAYMENT_PERFORMED_FAILED;
                }
                case GENERATED_VOUCHERS_ABOUT_TO_EXPIRE: {
                    return NotificationKind.ADMIN_GENERATED_VOUCHERS_ABOUT_TO_EXPIRE;
                }
                case GENERATED_VOUCHERS_EXPIRED: {
                    return NotificationKind.ADMIN_GENERATED_VOUCHERS_EXPIRED;
                }
                case NETWORK_CREATED: {
                    return NotificationKind.ADMIN_NETWORK_CREATED;
                }
                case PAYMENT_AWAITING_AUTHORIZATION: {
                    return NotificationKind.ADMIN_PAYMENT_AWAITING_AUTHORIZATION;
                }
                case PAYMENT_PERFORMED: {
                    return NotificationKind.ADMIN_PAYMENT_PERFORMED;
                }
                case SYSTEM_ALERT: {
                    return NotificationKind.ADMIN_SYSTEM_ALERT;
                }
                case USER_ALERT: {
                    return NotificationKind.ADMIN_USER_ALERT;
                }
                case USER_IMPORT_REGISTRATION: {
                    return NotificationKind.ADMIN_USER_IMPORT_REGISTRATION;
                }
                case USER_REGISTRATION: {
                    return NotificationKind.ADMIN_USER_REGISTRATION;
                }
                case VOUCHER_BUYING_ABOUT_TO_EXPIRE: {
                    return NotificationKind.ADMIN_VOUCHER_BUYING_ABOUT_TO_EXPIRE;
                }
            }
        }
        return null;
    }

    public NotificationKind toNotificationKind(BrokeringNotificationType brokeringNotificationType) {
        if (brokeringNotificationType != null) {
            switch (brokeringNotificationType) {
                case AD_PENDING_AUTHORIZATION: {
                    return NotificationKind.BROKERING_AD_PENDING_AUTHORIZATION;
                }
                case MEMBER_ASSIGNED: {
                    return NotificationKind.BROKERING_MEMBER_ASSIGNED;
                }
                case MEMBER_UNASSIGNED: {
                    return NotificationKind.BROKERING_MEMBER_UNASSIGNED;
                }
            }
        }
        return null;
    }

    public NotificationKind toNotificationKind(FeedbackAndReferenceNotificationType feedbackAndReferenceNotificationType) {
        if (feedbackAndReferenceNotificationType != null) {
            switch (feedbackAndReferenceNotificationType) {
                case FEEDBACK_CHANGED: {
                    return NotificationKind.FEEDBACK_CHANGED;
                }
                case FEEDBACK_CREATED: {
                    return NotificationKind.FEEDBACK_CREATED;
                }
                case FEEDBACK_EXPIRATION_REMINDER: {
                    return NotificationKind.FEEDBACK_EXPIRATION_REMINDER;
                }
                case FEEDBACK_OPTIONAL: {
                    return NotificationKind.FEEDBACK_OPTIONAL;
                }
                case FEEDBACK_REPLY_CREATED: {
                    return NotificationKind.FEEDBACK_REPLY_CREATED;
                }
                case FEEDBACK_REQUIRED: {
                    return NotificationKind.FEEDBACK_REQUIRED;
                }
                case REFERENCE_CHANGED: {
                    return NotificationKind.REFERENCE_CHANGED;
                }
                case REFERENCE_CREATED: {
                    return NotificationKind.REFERENCE_CREATED;
                }
            }
        }
        return null;
    }

    public NotificationKind toNotificationKind(INotificationType iNotificationType) {
        if (iNotificationType instanceof AdminNotificationType) {
            return this.toNotificationKind((AdminNotificationType)iNotificationType);
        }
        if (iNotificationType instanceof AccountNotificationType) {
            return this.toNotificationKind((AccountNotificationType)iNotificationType);
        }
        if (iNotificationType instanceof BrokeringNotificationType) {
            return this.toNotificationKind((BrokeringNotificationType)iNotificationType);
        }
        if (iNotificationType instanceof FeedbackAndReferenceNotificationType) {
            return this.toNotificationKind((FeedbackAndReferenceNotificationType)iNotificationType);
        }
        if (iNotificationType instanceof MarketplaceBuyerNotificationType) {
            return this.toNotificationKind((MarketplaceBuyerNotificationType)iNotificationType);
        }
        if (iNotificationType instanceof MarketplaceSellerNotificationType) {
            return this.toNotificationKind((MarketplaceSellerNotificationType)iNotificationType);
        }
        if (iNotificationType instanceof PersonalNotificationType) {
            return this.toNotificationKind((PersonalNotificationType)iNotificationType);
        }
        return null;
    }

    public NotificationKind toNotificationKind(MarketplaceBuyerNotificationType marketplaceBuyerNotificationType) {
        if (marketplaceBuyerNotificationType != null) {
            switch (marketplaceBuyerNotificationType) {
                case AD_INTEREST_NOTIFICATION: {
                    return NotificationKind.BUYER_AD_INTEREST_NOTIFICATION;
                }
                case AD_QUESTION_ANSWERED: {
                    return NotificationKind.BUYER_AD_QUESTION_ANSWERED;
                }
                case ORDER_CANCELED_BUYER: {
                    return NotificationKind.BUYER_ORDER_CANCELED;
                }
                case ORDER_PAYMENT_CANCELED_BUYER: {
                    return NotificationKind.BUYER_ORDER_PAYMENT_CANCELED;
                }
                case ORDER_PAYMENT_DENIED_BUYER: {
                    return NotificationKind.BUYER_ORDER_PAYMENT_DENIED;
                }
                case ORDER_PAYMENT_EXPIRED_BUYER: {
                    return NotificationKind.BUYER_ORDER_PAYMENT_EXPIRED;
                }
                case ORDER_PENDING_AUTHORIZATION_BUYER: {
                    return NotificationKind.BUYER_ORDER_PENDING_AUTHORIZATION;
                }
                case ORDER_PENDING_BUYER: {
                    return NotificationKind.BUYER_ORDER_PENDING;
                }
                case ORDER_PENDING_DELIVERY_DATA_BUYER: {
                    return NotificationKind.BUYER_ORDER_PENDING_DELIVERY_DATA;
                }
                case ORDER_REALIZED_SELLER: {
                    return NotificationKind.BUYER_ORDER_PROCESSED_BY_SELLER;
                }
                case ORDER_REJECTED_BY_SELLER: {
                    return NotificationKind.BUYER_ORDER_REJECTED_BY_SELLER;
                }
                case SALE_PENDING_BUYER: {
                    return NotificationKind.BUYER_SALE_PENDING;
                }
                case SALE_REJECTED_SELLER: {
                    return NotificationKind.BUYER_SALE_REJECTED_BY_SELLER;
                }
            }
        }
        return null;
    }

    public NotificationKind toNotificationKind(MarketplaceSellerNotificationType marketplaceSellerNotificationType) {
        if (marketplaceSellerNotificationType != null) {
            switch (marketplaceSellerNotificationType) {
                case AD_AUTHORIZED: {
                    return NotificationKind.SELLER_AD_AUTHORIZED;
                }
                case AD_EXPIRED: {
                    return NotificationKind.SELLER_AD_EXPIRED;
                }
                case AD_QUESTION_CREATED: {
                    return NotificationKind.SELLER_AD_QUESTION_CREATED;
                }
                case AD_REJECTED: {
                    return NotificationKind.SELLER_AD_REJECTED;
                }
                case ARTICLE_OUT_OF_STOCK: {
                    return NotificationKind.SELLER_AD_OUT_OF_STOCK;
                }
                case LOW_STOCK_QUANTITY: {
                    return NotificationKind.SELLER_AD_LOW_STOCK;
                }
                case ORDER_CANCELED_SELLER: {
                    return NotificationKind.SELLER_ORDER_CANCELED;
                }
                case ORDER_CREATED: {
                    return NotificationKind.SELLER_ORDER_CREATED;
                }
                case ORDER_PAYMENT_CANCELED_SELLER: {
                    return NotificationKind.SELLER_ORDER_PAYMENT_CANCELED;
                }
                case ORDER_PAYMENT_DENIED_SELLER: {
                    return NotificationKind.SELLER_ORDER_PAYMENT_DENIED;
                }
                case ORDER_PAYMENT_EXPIRED_SELLER: {
                    return NotificationKind.SELLER_ORDER_PAYMENT_EXPIRED;
                }
                case ORDER_PENDING_AUTHORIZATION_SELLER: {
                    return NotificationKind.SELLER_ORDER_PENDING_AUTHORIZATION;
                }
                case ORDER_PENDING_DELIVERY_DATA_SELLER: {
                    return NotificationKind.SELLER_ORDER_PENDING_DELIVERY_DATA;
                }
                case ORDER_REALIZED_BUYER: {
                    return NotificationKind.SELLER_ORDER_PROCESSED_BY_BUYER;
                }
                case ORDER_REJECTED_BY_BUYER: {
                    return NotificationKind.SELLER_ORDER_REJECTED_BY_BUYER;
                }
                case SALE_REALIZED_BUYER: {
                    return NotificationKind.SELLER_SALE_PROCESSED_BY_BUYER;
                }
            }
        }
        return null;
    }

    public NotificationKind toNotificationKind(PersonalNotificationType personalNotificationType) {
        if (personalNotificationType != null) {
            switch (personalNotificationType) {
                case BROKER_ASSIGNED: {
                    return NotificationKind.PERSONAL_BROKER_ASSIGNED;
                }
                case BROKER_UNASSIGNED: {
                    return NotificationKind.PERSONAL_BROKER_UNASSIGNED;
                }
                case MAX_SMS_PER_MONTH_REACHED: {
                    return NotificationKind.PERSONAL_MAX_SMS_PER_MONTH_REACHED;
                }
                case NEW_TOKEN: {
                    return NotificationKind.PERSONAL_NEW_TOKEN;
                }
                case NEW_TOKEN_PENDING_ACTIVATION: {
                    return NotificationKind.PERSONAL_NEW_TOKEN_PENDING_ACTIVATION;
                }
                case PASSWORD_STATUS_CHANGED: {
                    return NotificationKind.PERSONAL_PASSWORD_STATUS_CHANGED;
                }
                case TOKEN_STATUS_CHANGED: {
                    return NotificationKind.PERSONAL_TOKEN_STATUS_CHANGED;
                }
                case USER_STATUS_CHANGED: {
                    return NotificationKind.PERSONAL_USER_STATUS_CHANGED;
                }
            }
        }
        return null;
    }

    public NotificationSettingsDataForEdit toNotificationSettingsDataForEdit(NotificationSettingsData notificationSettingsData) {
        AdminNotificationSettingsDTO adminNotificationSettingsDTO;
        NotificationSettingsDataForEdit notificationSettingsDataForEdit = this.newBaseNotificationSettings(NotificationSettingsDataForEdit.class, notificationSettingsData);
        if (notificationSettingsData instanceof AdminNotificationSettingsData) {
            AdminNotificationSettingsData adminNotificationSettingsData = (AdminNotificationSettingsData)notificationSettingsData;
            adminNotificationSettingsDTO = adminNotificationSettingsData.getNotificationSettings();
            CollectionHelper.orEmpty((List)adminNotificationSettingsData.getPayments()).stream().map(this.accountsApiHelper::toTransferType).forEach(notificationSettingsDataForEdit.getPayments()::add);
            CollectionHelper.orEmpty((List)adminNotificationSettingsData.getNewPendingPayments()).stream().map(this.accountsApiHelper::toTransferType).forEach(notificationSettingsDataForEdit.getAuthorizablePayments()::add);
            CollectionHelper.orEmpty((List)adminNotificationSettingsData.getExternalPayments()).stream().map(this.accountsApiHelper::toTransferType).forEach(notificationSettingsDataForEdit.getExternalPayments()::add);
            CollectionHelper.orEmpty((List)adminNotificationSettingsData.getVoucherConfigurations()).stream().map(this.apiHelper::toReference).forEach(notificationSettingsDataForEdit.getVoucherConfigurations()::add);
            CollectionHelper.orEmpty((List)adminNotificationSettingsData.getNewUsers()).stream().map(this.groupsApiHelper::toGroup).forEach(notificationSettingsDataForEdit.getUserGroups()::add);
            CollectionHelper.orEmpty((List)adminNotificationSettingsData.getMessageCategories()).stream().map(this.apiHelper::toReference).forEach(notificationSettingsDataForEdit.getMessageCategories()::add);
        } else if (notificationSettingsData instanceof UserNotificationSettingsData) {
            UserNotificationSettingsData userNotificationSettingsData = (UserNotificationSettingsData)notificationSettingsData;
            adminNotificationSettingsDTO = userNotificationSettingsData.getNotificationSettings();
            CollectionHelper.orEmpty((List)userNotificationSettingsData.getNotificationSettings().getAccountNotificationSettings()).stream().map(AccountNotificationSettingsDTO::getAccountType).map(this.accountsApiHelper::toAccountType).forEach(notificationSettingsDataForEdit.getUserAccounts()::add);
            notificationSettingsDataForEdit.setForwardMessages(((UserNotificationSettingsDTO)adminNotificationSettingsDTO).isFwdMessageToEmail());
        } else {
            throw new IllegalStateException("Unhandled data: " + String.valueOf(notificationSettingsData));
        }
        notificationSettingsDataForEdit.setSettings(this.toNotificationSettingsEdit((NotificationSettingsDTO)adminNotificationSettingsDTO));
        return notificationSettingsDataForEdit;
    }

    public NotificationSettingsView toNotificationSettingsView(NotificationSettingsData notificationSettingsData) {
        NotificationSettingsView notificationSettingsView = this.newBaseNotificationSettings(NotificationSettingsView.class, notificationSettingsData);
        List<NotificationTypeSettingsDTO> list = null;
        if (notificationSettingsData instanceof AdminNotificationSettingsData) {
            list = this.fill((AdminNotificationSettingsData)notificationSettingsData, notificationSettingsView);
        } else if (notificationSettingsData instanceof UserNotificationSettingsData) {
            list = this.fill((UserNotificationSettingsData)notificationSettingsData, notificationSettingsView);
        }
        CollectionHelper.orEmpty(list).stream().map(this::toNotificationTypeMediums).forEach(notificationSettingsView.getNotifications()::add);
        return notificationSettingsView;
    }

    public INotificationType toNotificationType(NotificationKind notificationKind) {
        if (notificationKind != null) {
            switch (notificationKind) {
                case ACCOUNT_ALL_NON_SMS_PERFORMED_PAYMENTS: {
                    return AccountNotificationType.ALL_NON_SMS_PERFORMED_PAYMENTS;
                }
                case ACCOUNT_AUTHORIZED_PAYMENT_CANCELED: {
                    return AccountNotificationType.AUTHORIZED_PAYMENT_CANCELED;
                }
                case ACCOUNT_AUTHORIZED_PAYMENT_DENIED: {
                    return AccountNotificationType.AUTHORIZED_PAYMENT_DENIED;
                }
                case ACCOUNT_AUTHORIZED_PAYMENT_EXPIRED: {
                    return AccountNotificationType.AUTHORIZED_PAYMENT_EXPIRED;
                }
                case ACCOUNT_AUTHORIZED_PAYMENT_SUCCEEDED: {
                    return AccountNotificationType.AUTHORIZED_PAYMENT_SUCCEEDED;
                }
                case ACCOUNT_EXTERNAL_PAYMENT_EXPIRED: {
                    return AccountNotificationType.EXTERNAL_PAYMENT_EXPIRED;
                }
                case ACCOUNT_EXTERNAL_PAYMENT_PERFORMED_FAILED: {
                    return AccountNotificationType.EXTERNAL_PAYMENT_PERFORMED_FAILED;
                }
                case ACCOUNT_EXTERNAL_PAYMENT_RECEIVED_FAILED: {
                    return AccountNotificationType.EXTERNAL_PAYMENT_RECEIVED_FAILED;
                }
                case ACCOUNT_INCOMING_RECURRING_PAYMENT_CANCELED: {
                    return AccountNotificationType.INCOMING_RECURRING_PAYMENT_CANCELED;
                }
                case ACCOUNT_INCOMING_RECURRING_PAYMENT_FAILED: {
                    return AccountNotificationType.INCOMING_RECURRING_PAYMENT_FAILED;
                }
                case ACCOUNT_INCOMING_RECURRING_PAYMENT_RECEIVED: {
                    return AccountNotificationType.INCOMING_RECURRING_PAYMENT_RECEIVED;
                }
                case ACCOUNT_INCOMING_SCHEDULED_PAYMENT_CANCELED: {
                    return AccountNotificationType.INCOMING_SCHEDULED_PAYMENT_CANCELED;
                }
                case ACCOUNT_INCOMING_SCHEDULED_PAYMENT_FAILED: {
                    return AccountNotificationType.INCOMING_SCHEDULED_PAYMENT_FAILED;
                }
                case ACCOUNT_INCOMING_SCHEDULED_PAYMENT_RECEIVED: {
                    return AccountNotificationType.INCOMING_SCHEDULED_PAYMENT_RECEIVED;
                }
                case ACCOUNT_LIMIT_CHANGE: {
                    return AccountNotificationType.LIMIT_CHANGE;
                }
                case ACCOUNT_OPERATOR_AUTHORIZED_PAYMENT_APPROVED_STILL_PENDING: {
                    return AccountNotificationType.OPERATOR_AUTHORIZED_PAYMENT_APPROVED_STILL_PENDING;
                }
                case ACCOUNT_OPERATOR_AUTHORIZED_PAYMENT_CANCELED: {
                    return AccountNotificationType.OPERATOR_AUTHORIZED_PAYMENT_CANCELED;
                }
                case ACCOUNT_OPERATOR_AUTHORIZED_PAYMENT_DENIED: {
                    return AccountNotificationType.OPERATOR_AUTHORIZED_PAYMENT_DENIED;
                }
                case ACCOUNT_OPERATOR_AUTHORIZED_PAYMENT_EXPIRED: {
                    return AccountNotificationType.OPERATOR_AUTHORIZED_PAYMENT_EXPIRED;
                }
                case ACCOUNT_OPERATOR_AUTHORIZED_PAYMENT_SUCCEEDED: {
                    return AccountNotificationType.OPERATOR_AUTHORIZED_PAYMENT_SUCCEEDED;
                }
                case ACCOUNT_OPERATOR_PAYMENT_AWAITING_AUTHORIZATION: {
                    return AccountNotificationType.OPERATOR_PAYMENT_AWAITING_AUTHORIZATION;
                }
                case ACCOUNT_PAYMENT_AWAITING_AUTHORIZATION: {
                    return AccountNotificationType.PAYMENT_AWAITING_AUTHORIZATION;
                }
                case ACCOUNT_PAYMENT_RECEIVED: {
                    return AccountNotificationType.PAYMENT_RECEIVED;
                }
                case ACCOUNT_PAYMENT_REQUEST_CANCELED: {
                    return AccountNotificationType.PAYMENT_REQUEST_CANCELED;
                }
                case ACCOUNT_PAYMENT_REQUEST_DENIED: {
                    return AccountNotificationType.PAYMENT_REQUEST_DENIED;
                }
                case ACCOUNT_PAYMENT_REQUEST_EXPIRATION_DATE_CHANGED: {
                    return AccountNotificationType.PAYMENT_REQUEST_EXPIRATION_DATE_CHANGED;
                }
                case ACCOUNT_PAYMENT_REQUEST_EXPIRED: {
                    return AccountNotificationType.PAYMENT_REQUEST_EXPIRED;
                }
                case ACCOUNT_PAYMENT_REQUEST_PROCESSED: {
                    return AccountNotificationType.PAYMENT_REQUEST_PROCESSED;
                }
                case ACCOUNT_PAYMENT_REQUEST_RECEIVED: {
                    return AccountNotificationType.PAYMENT_REQUEST_RECEIVED;
                }
                case ACCOUNT_RECURRING_PAYMENT_FAILED: {
                    return AccountNotificationType.RECURRING_PAYMENT_FAILED;
                }
                case ACCOUNT_RECURRING_PAYMENT_OCCURRENCE_PROCESSED: {
                    return AccountNotificationType.RECURRING_PAYMENT_OCCURRENCE_PROCESSED;
                }
                case ACCOUNT_SCHEDULED_PAYMENT_FAILED: {
                    return AccountNotificationType.SCHEDULED_PAYMENT_FAILED;
                }
                case ACCOUNT_SCHEDULED_PAYMENT_INSTALLMENT_PROCESSED: {
                    return AccountNotificationType.SCHEDULED_PAYMENT_INSTALLMENT_PROCESSED;
                }
                case ACCOUNT_SCHEDULED_PAYMENT_REQUEST_FAILED: {
                    return AccountNotificationType.SCHEDULED_PAYMENT_REQUEST_FAILED;
                }
                case ACCOUNT_SENT_PAYMENT_REQUEST_EXPIRATION_DATE_CHANGED: {
                    return AccountNotificationType.SENT_PAYMENT_REQUEST_EXPIRATION_DATE_CHANGED;
                }
                case ACCOUNT_SMS_PERFORMED_PAYMENT: {
                    return AccountNotificationType.SMS_PERFORMED_PAYMENT;
                }
                case ACCOUNT_TICKET_WEBHOOK_FAILED: {
                    return AccountNotificationType.TICKET_WEBHOOK_FAILED;
                }
                case ACCOUNT_VOUCHER_ASSIGNED: {
                    return AccountNotificationType.VOUCHER_ASSIGNED;
                }
                case ACCOUNT_VOUCHER_ABOUT_TO_EXPIRE: {
                    return AccountNotificationType.VOUCHER_ABOUT_TO_EXPIRE;
                }
                case ACCOUNT_VOUCHER_EXPIRATION_DATE_CHANGED: {
                    return AccountNotificationType.VOUCHER_EXPIRATION_DATE_CHANGED;
                }
                case ACCOUNT_VOUCHER_EXPIRED: {
                    return AccountNotificationType.VOUCHER_EXPIRED;
                }
                case ACCOUNT_VOUCHER_PIN_BLOCKED: {
                    return AccountNotificationType.VOUCHER_PIN_BLOCKED;
                }
                case ACCOUNT_VOUCHER_REDEEM: {
                    return AccountNotificationType.VOUCHER_REDEEM;
                }
                case ACCOUNT_VOUCHER_TOP_UP: {
                    return AccountNotificationType.VOUCHER_TOP_UP;
                }
                case ADMIN_AD_PENDING_AUTHORIZATION: {
                    return AdminNotificationType.AD_PENDING_AUTHORIZATION;
                }
                case ADMIN_APPLICATION_ERROR: {
                    return AdminNotificationType.APPLICATION_ERROR;
                }
                case ADMIN_EXTERNAL_PAYMENT_EXPIRED: {
                    return AdminNotificationType.EXTERNAL_PAYMENT_EXPIRED;
                }
                case ADMIN_EXTERNAL_PAYMENT_PERFORMED_FAILED: {
                    return AdminNotificationType.EXTERNAL_PAYMENT_PERFORMED_FAILED;
                }
                case ADMIN_GENERATED_VOUCHERS_ABOUT_TO_EXPIRE: {
                    return AdminNotificationType.GENERATED_VOUCHERS_ABOUT_TO_EXPIRE;
                }
                case ADMIN_GENERATED_VOUCHERS_EXPIRED: {
                    return AdminNotificationType.GENERATED_VOUCHERS_EXPIRED;
                }
                case ADMIN_NETWORK_CREATED: {
                    return AdminNotificationType.NETWORK_CREATED;
                }
                case ADMIN_PAYMENT_AWAITING_AUTHORIZATION: {
                    return AdminNotificationType.PAYMENT_AWAITING_AUTHORIZATION;
                }
                case ADMIN_PAYMENT_PERFORMED: {
                    return AdminNotificationType.PAYMENT_PERFORMED;
                }
                case ADMIN_SYSTEM_ALERT: {
                    return AdminNotificationType.SYSTEM_ALERT;
                }
                case ADMIN_USER_ALERT: {
                    return AdminNotificationType.USER_ALERT;
                }
                case ADMIN_USER_IMPORT_REGISTRATION: {
                    return AdminNotificationType.USER_IMPORT_REGISTRATION;
                }
                case ADMIN_USER_REGISTRATION: {
                    return AdminNotificationType.USER_REGISTRATION;
                }
                case ADMIN_VOUCHER_BUYING_ABOUT_TO_EXPIRE: {
                    return AdminNotificationType.VOUCHER_BUYING_ABOUT_TO_EXPIRE;
                }
                case BROKERING_AD_PENDING_AUTHORIZATION: {
                    return BrokeringNotificationType.AD_PENDING_AUTHORIZATION;
                }
                case BROKERING_MEMBER_ASSIGNED: {
                    return BrokeringNotificationType.MEMBER_ASSIGNED;
                }
                case BROKERING_MEMBER_UNASSIGNED: {
                    return BrokeringNotificationType.MEMBER_UNASSIGNED;
                }
                case BUYER_AD_INTEREST_NOTIFICATION: {
                    return MarketplaceBuyerNotificationType.AD_INTEREST_NOTIFICATION;
                }
                case BUYER_AD_QUESTION_ANSWERED: {
                    return MarketplaceBuyerNotificationType.AD_QUESTION_ANSWERED;
                }
                case BUYER_ORDER_CANCELED: {
                    return MarketplaceBuyerNotificationType.ORDER_CANCELED_BUYER;
                }
                case BUYER_ORDER_PAYMENT_CANCELED: {
                    return MarketplaceBuyerNotificationType.ORDER_PAYMENT_CANCELED_BUYER;
                }
                case BUYER_ORDER_PAYMENT_DENIED: {
                    return MarketplaceBuyerNotificationType.ORDER_PAYMENT_DENIED_BUYER;
                }
                case BUYER_ORDER_PAYMENT_EXPIRED: {
                    return MarketplaceBuyerNotificationType.ORDER_PAYMENT_EXPIRED_BUYER;
                }
                case BUYER_ORDER_PENDING: {
                    return MarketplaceBuyerNotificationType.ORDER_PENDING_BUYER;
                }
                case BUYER_ORDER_PENDING_AUTHORIZATION: {
                    return MarketplaceBuyerNotificationType.ORDER_PENDING_AUTHORIZATION_BUYER;
                }
                case BUYER_ORDER_PENDING_DELIVERY_DATA: {
                    return MarketplaceBuyerNotificationType.ORDER_PENDING_DELIVERY_DATA_BUYER;
                }
                case BUYER_ORDER_PROCESSED_BY_SELLER: {
                    return MarketplaceBuyerNotificationType.ORDER_REALIZED_SELLER;
                }
                case BUYER_ORDER_REJECTED_BY_SELLER: {
                    return MarketplaceBuyerNotificationType.ORDER_REJECTED_BY_SELLER;
                }
                case BUYER_SALE_PENDING: {
                    return MarketplaceBuyerNotificationType.SALE_PENDING_BUYER;
                }
                case BUYER_SALE_REJECTED_BY_SELLER: {
                    return MarketplaceBuyerNotificationType.SALE_REJECTED_SELLER;
                }
                case FEEDBACK_CHANGED: {
                    return FeedbackAndReferenceNotificationType.FEEDBACK_CHANGED;
                }
                case FEEDBACK_CREATED: {
                    return FeedbackAndReferenceNotificationType.FEEDBACK_CREATED;
                }
                case FEEDBACK_EXPIRATION_REMINDER: {
                    return FeedbackAndReferenceNotificationType.FEEDBACK_EXPIRATION_REMINDER;
                }
                case FEEDBACK_OPTIONAL: {
                    return FeedbackAndReferenceNotificationType.FEEDBACK_OPTIONAL;
                }
                case FEEDBACK_REPLY_CREATED: {
                    return FeedbackAndReferenceNotificationType.FEEDBACK_REPLY_CREATED;
                }
                case FEEDBACK_REQUIRED: {
                    return FeedbackAndReferenceNotificationType.FEEDBACK_REQUIRED;
                }
                case PERSONAL_BROKER_ASSIGNED: {
                    return PersonalNotificationType.BROKER_ASSIGNED;
                }
                case PERSONAL_BROKER_UNASSIGNED: {
                    return PersonalNotificationType.BROKER_UNASSIGNED;
                }
                case PERSONAL_MAX_SMS_PER_MONTH_REACHED: {
                    return PersonalNotificationType.MAX_SMS_PER_MONTH_REACHED;
                }
                case PERSONAL_NEW_TOKEN: {
                    return PersonalNotificationType.NEW_TOKEN;
                }
                case PERSONAL_NEW_TOKEN_PENDING_ACTIVATION: {
                    return PersonalNotificationType.NEW_TOKEN_PENDING_ACTIVATION;
                }
                case PERSONAL_PASSWORD_STATUS_CHANGED: {
                    return PersonalNotificationType.PASSWORD_STATUS_CHANGED;
                }
                case PERSONAL_TOKEN_STATUS_CHANGED: {
                    return PersonalNotificationType.TOKEN_STATUS_CHANGED;
                }
                case PERSONAL_USER_STATUS_CHANGED: {
                    return PersonalNotificationType.USER_STATUS_CHANGED;
                }
                case REFERENCE_CHANGED: {
                    return FeedbackAndReferenceNotificationType.REFERENCE_CHANGED;
                }
                case REFERENCE_CREATED: {
                    return FeedbackAndReferenceNotificationType.REFERENCE_CREATED;
                }
                case SELLER_AD_AUTHORIZED: {
                    return MarketplaceSellerNotificationType.AD_AUTHORIZED;
                }
                case SELLER_AD_EXPIRED: {
                    return MarketplaceSellerNotificationType.AD_EXPIRED;
                }
                case SELLER_AD_LOW_STOCK: {
                    return MarketplaceSellerNotificationType.LOW_STOCK_QUANTITY;
                }
                case SELLER_AD_OUT_OF_STOCK: {
                    return MarketplaceSellerNotificationType.ARTICLE_OUT_OF_STOCK;
                }
                case SELLER_AD_QUESTION_CREATED: {
                    return MarketplaceSellerNotificationType.AD_QUESTION_CREATED;
                }
                case SELLER_AD_REJECTED: {
                    return MarketplaceSellerNotificationType.AD_REJECTED;
                }
                case SELLER_ORDER_CANCELED: {
                    return MarketplaceSellerNotificationType.ORDER_CANCELED_SELLER;
                }
                case SELLER_ORDER_CREATED: {
                    return MarketplaceSellerNotificationType.ORDER_CREATED;
                }
                case SELLER_ORDER_PAYMENT_CANCELED: {
                    return MarketplaceSellerNotificationType.ORDER_PAYMENT_CANCELED_SELLER;
                }
                case SELLER_ORDER_PAYMENT_DENIED: {
                    return MarketplaceSellerNotificationType.ORDER_PAYMENT_DENIED_SELLER;
                }
                case SELLER_ORDER_PAYMENT_EXPIRED: {
                    return MarketplaceSellerNotificationType.ORDER_PAYMENT_EXPIRED_SELLER;
                }
                case SELLER_ORDER_PENDING_AUTHORIZATION: {
                    return MarketplaceSellerNotificationType.ORDER_PENDING_AUTHORIZATION_SELLER;
                }
                case SELLER_ORDER_PENDING_DELIVERY_DATA: {
                    return MarketplaceSellerNotificationType.ORDER_PENDING_DELIVERY_DATA_SELLER;
                }
                case SELLER_ORDER_PROCESSED_BY_BUYER: {
                    return MarketplaceSellerNotificationType.ORDER_REALIZED_BUYER;
                }
                case SELLER_ORDER_REJECTED_BY_BUYER: {
                    return MarketplaceSellerNotificationType.ORDER_REJECTED_BY_BUYER;
                }
                case SELLER_SALE_PROCESSED_BY_BUYER: {
                    return MarketplaceSellerNotificationType.SALE_REALIZED_BUYER;
                }
                case ACCOUNT_BOUGHT_VOUCHERS_ABOUT_TO_EXPIRE: {
                    return AccountNotificationType.VOUCHER_ABOUT_TO_EXPIRE;
                }
                case ACCOUNT_BOUGHT_VOUCHERS_EXPIRATION_DATE_CHANGED: {
                    return AccountNotificationType.VOUCHER_EXPIRATION_DATE_CHANGED;
                }
                case ACCOUNT_BOUGHT_VOUCHERS_EXPIRED: {
                    return AccountNotificationType.VOUCHER_EXPIRED;
                }
            }
        }
        return null;
    }

    public UserNotificationSettingsDTO toUserNotificationSettingsDTO(String string, NotificationSettingsEdit notificationSettingsEdit) {
        UserNotificationSettingsDTO userNotificationSettingsDTO = this.newNotificationSettingsDTO(UserNotificationSettingsDTO.class, string, notificationSettingsEdit);
        userNotificationSettingsDTO.setFwdMessageToEmail(Boolean.TRUE.equals(notificationSettingsEdit.getForwardMessages()));
        userNotificationSettingsDTO.setEmailMailings(Boolean.TRUE.equals(notificationSettingsEdit.getEmailMailings()));
        userNotificationSettingsDTO.setSmsMailings(Boolean.TRUE.equals(notificationSettingsEdit.getSmsMailings()));
        userNotificationSettingsDTO.setAccountNotificationSettings(CollectionHelper.orEmpty(notificationSettingsEdit.getUserAccounts()).entrySet().stream().map(this::toAccountNotificationSettingsDTO).collect(Collectors.toList()));
        userNotificationSettingsDTO.setAppMailings(Boolean.TRUE.equals(notificationSettingsEdit.getAppMailings()));
        return userNotificationSettingsDTO;
    }

    private List<NotificationTypeSettingsDTO> fill(AdminNotificationSettingsData adminNotificationSettingsData, NotificationSettingsView notificationSettingsView) {
        AdminNotificationSettingsDTO adminNotificationSettingsDTO = adminNotificationSettingsData.getNotificationSettings();
        CollectionHelper.orEmpty((Set)adminNotificationSettingsDTO.getAuthorizablePayments()).stream().map(this.accountsApiHelper::toTransferType).forEach(notificationSettingsView.getAuthorizablePayments()::add);
        CollectionHelper.orEmpty((Set)adminNotificationSettingsDTO.getExternalPaymentsExpired()).stream().map(this.accountsApiHelper::toTransferType).forEach(notificationSettingsView.getExternalPaymentsExpired()::add);
        CollectionHelper.orEmpty((Set)adminNotificationSettingsDTO.getExternalPaymentsFailed()).stream().map(this.accountsApiHelper::toTransferType).forEach(notificationSettingsView.getExternalPaymentsFailed()::add);
        CollectionHelper.orEmpty((Set)adminNotificationSettingsDTO.getFwdMessageCategoriesToEmail()).stream().map(this.apiHelper::toReference).forEach(notificationSettingsView.getForwardMessageCategories()::add);
        CollectionHelper.orEmpty((Set)adminNotificationSettingsDTO.getPayments()).stream().map(this.accountsApiHelper::toTransferType).forEach(notificationSettingsView.getPayments()::add);
        CollectionHelper.orEmpty((Set)adminNotificationSettingsDTO.getSystemAlerts()).stream().map(this.alertsApiHelper::toSystemAlertTypeEnum).forEach(notificationSettingsView.getSystemAlerts()::add);
        CollectionHelper.orEmpty((Set)adminNotificationSettingsDTO.getUserAlerts()).stream().map(this.alertsApiHelper::toUserAlertTypeEnum).forEach(notificationSettingsView.getUserAlerts()::add);
        CollectionHelper.orEmpty((Set)adminNotificationSettingsDTO.getUserGroups()).stream().map(this.groupsApiHelper::toGroup).forEach(notificationSettingsView.getUserGroups()::add);
        CollectionHelper.orEmpty((Set)adminNotificationSettingsDTO.getVoucherConfigurations()).stream().map(this.apiHelper::toReference).forEach(notificationSettingsView.getVoucherConfigurations()::add);
        CollectionHelper.orEmpty((Set)adminNotificationSettingsDTO.getVoucherConfigurationsBuying()).stream().map(this.apiHelper::toReference).forEach(notificationSettingsView.getVoucherConfigurationsBuying()::add);
        notificationSettingsView.setUserAccounts(null);
        return adminNotificationSettingsDTO.getNotificationTypeSettings();
    }

    private List<NotificationTypeSettingsDTO> fill(UserNotificationSettingsData userNotificationSettingsData, NotificationSettingsView notificationSettingsView) {
        UserNotificationSettingsDTO userNotificationSettingsDTO = userNotificationSettingsData.getNotificationSettings();
        notificationSettingsView.setForwardMessages(userNotificationSettingsDTO.isFwdMessageToEmail());
        notificationSettingsView.setEmailMailings(userNotificationSettingsDTO.isEmailMailings());
        notificationSettingsView.setSmsMailings(userNotificationSettingsDTO.isSmsMailings());
        notificationSettingsView.setAppMailings(userNotificationSettingsDTO.isAppMailings());
        notificationSettingsView.setAppAllowed(userNotificationSettingsData.isAppAllowed());
        CollectionHelper.orEmpty((List)userNotificationSettingsDTO.getAccountNotificationSettings()).stream().map(this::toAccountNotificationSettingsView).forEach(notificationSettingsView.getUserAccounts()::add);
        notificationSettingsView.setPayments(null);
        notificationSettingsView.setAuthorizablePayments(null);
        notificationSettingsView.setExternalPaymentsFailed(null);
        notificationSettingsView.setExternalPaymentsExpired(null);
        notificationSettingsView.setVoucherConfigurations(null);
        notificationSettingsView.setVoucherConfigurationsBuying(null);
        notificationSettingsView.setUserGroups(null);
        notificationSettingsView.setSystemAlerts(null);
        notificationSettingsView.setUserAlerts(null);
        notificationSettingsView.setForwardMessageCategories(null);
        return userNotificationSettingsDTO.getNotificationTypeSettings();
    }

    private <AS extends AccountNotificationSettings> AS newAccountNotificationSettings(Class<AS> clazz, AccountNotificationSettingsDTO accountNotificationSettingsDTO) {
        AccountNotificationSettings accountNotificationSettings = (AccountNotificationSettings)ClassHelper.instantiate(clazz);
        accountNotificationSettings.setPaymentAmount(this.apiHelper.toDecimalRange(accountNotificationSettingsDTO.getPaymentAmount()));
        return (AS)accountNotificationSettings;
    }

    private <NS extends BaseNotificationSettings> NS newBaseNotificationSettings(Class<NS> clazz, NotificationSettingsData notificationSettingsData) {
        BaseNotificationSettings baseNotificationSettings = (BaseNotificationSettings)ClassHelper.instantiate(clazz);
        baseNotificationSettings.setUser(this.usersApiHelper.toUser(notificationSettingsData.getUser()));
        baseNotificationSettings.setRole(this.authApiHelper.toRoleEnum(notificationSettingsData.getRole()));
        baseNotificationSettings.setCanEdit(notificationSettingsData.isCanManage());
        baseNotificationSettings.setEmailAllowed(notificationSettingsData.isEmailAllowed());
        baseNotificationSettings.setSmsAllowed(notificationSettingsData.isSmsAllowed());
        baseNotificationSettings.setSmsCountThisMonth(notificationSettingsData.getCurrentSmsCount());
        baseNotificationSettings.setMaxSmsPerMonth(notificationSettingsData.getMaxSmsPerMonth());
        if (notificationSettingsData instanceof UserNotificationSettingsData) {
            UserNotificationSettingsData userNotificationSettingsData = (UserNotificationSettingsData)notificationSettingsData;
            baseNotificationSettings.setForwardMessagesAllowed(userNotificationSettingsData.isForwardAllowed());
            baseNotificationSettings.setEmailMailingsAllowed(userNotificationSettingsData.isEmailMailingsAllowed());
            baseNotificationSettings.setSmsMailingsAllowed(userNotificationSettingsData.isSmsMailingsAllowed());
            baseNotificationSettings.setAppMailingsAllowed(userNotificationSettingsData.isAppMailingsAllowed());
        }
        return (NS)baseNotificationSettings;
    }

    private <DTO extends NotificationSettingsDTO> DTO newNotificationSettingsDTO(Class<DTO> clazz, String string, NotificationSettingsEdit notificationSettingsEdit) {
        NotificationSettingsDTO notificationSettingsDTO = (NotificationSettingsDTO)ClassHelper.instantiate(clazz);
        notificationSettingsDTO.setVersion(notificationSettingsEdit.getVersion());
        notificationSettingsDTO.setUser((BasicUserVO)ModelHelper.voFromString(BasicUserVO.class, (String)string));
        notificationSettingsDTO.setNotificationTypeSettings(CollectionHelper.orEmpty(notificationSettingsEdit.getNotifications()).stream().map(this::toNotificationTypeSettingsDTO).collect(Collectors.toList()));
        return (DTO)notificationSettingsDTO;
    }

    private AccountNotificationSettingsDTO toAccountNotificationSettingsDTO(Map.Entry<String, AccountNotificationSettings> entry) {
        AccountNotificationSettings accountNotificationSettings = entry.getValue();
        AccountNotificationSettingsDTO accountNotificationSettingsDTO = new AccountNotificationSettingsDTO();
        accountNotificationSettingsDTO.setAccountType((AccountTypeWithCurrencyVO)ModelHelper.voFromString(AccountTypeWithCurrencyVO.class, (String)entry.getKey()));
        if (accountNotificationSettings != null) {
            accountNotificationSettingsDTO.setPaymentAmount(this.apiHelper.toDecimalRangeDTO(accountNotificationSettings.getPaymentAmount()));
        }
        return accountNotificationSettingsDTO;
    }

    private AccountNotificationSettingsView toAccountNotificationSettingsView(AccountNotificationSettingsDTO accountNotificationSettingsDTO) {
        AccountNotificationSettingsView accountNotificationSettingsView = this.newAccountNotificationSettings(AccountNotificationSettingsView.class, accountNotificationSettingsDTO);
        accountNotificationSettingsView.setAccountType(this.accountsApiHelper.toAccountType((AccountTypeVO)accountNotificationSettingsDTO.getAccountType()));
        return accountNotificationSettingsView;
    }

    private NotificationSettingsEdit toNotificationSettingsEdit(NotificationSettingsDTO notificationSettingsDTO) {
        NotificationSettingsEdit notificationSettingsEdit = new NotificationSettingsEdit();
        notificationSettingsEdit.setVersion(notificationSettingsDTO.getVersion());
        CollectionHelper.orEmpty((List)notificationSettingsDTO.getNotificationTypeSettings()).stream().map(this::toNotificationTypeMediums).forEach(notificationSettingsEdit.getNotifications()::add);
        if (notificationSettingsDTO instanceof UserNotificationSettingsDTO) {
            UserNotificationSettingsDTO userNotificationSettingsDTO = (UserNotificationSettingsDTO)notificationSettingsDTO;
            notificationSettingsEdit.setForwardMessages(userNotificationSettingsDTO.isFwdMessageToEmail());
            notificationSettingsEdit.setEmailMailings(userNotificationSettingsDTO.isEmailMailings());
            notificationSettingsEdit.setSmsMailings(userNotificationSettingsDTO.isSmsMailings());
            notificationSettingsEdit.setAppMailings(userNotificationSettingsDTO.isAppMailings());
            CollectionHelper.orEmpty((List)userNotificationSettingsDTO.getAccountNotificationSettings()).forEach(accountNotificationSettingsDTO -> {
                String string = ModelHelper.internalNameOrId((IEntity)accountNotificationSettingsDTO.getAccountType());
                notificationSettingsEdit.getUserAccounts().put(string, this.newAccountNotificationSettings((Class)AccountNotificationSettings.class, (AccountNotificationSettingsDTO)accountNotificationSettingsDTO));
            });
        } else if (notificationSettingsDTO instanceof AdminNotificationSettingsDTO) {
            AdminNotificationSettingsDTO adminNotificationSettingsDTO = (AdminNotificationSettingsDTO)notificationSettingsDTO;
            CollectionHelper.orEmpty((Set)adminNotificationSettingsDTO.getAuthorizablePayments()).stream().map(ModelHelper::internalNameOrId).forEach(notificationSettingsEdit.getAuthorizablePayments()::add);
            CollectionHelper.orEmpty((Set)adminNotificationSettingsDTO.getExternalPaymentsExpired()).stream().map(ModelHelper::internalNameOrId).forEach(notificationSettingsEdit.getExternalPaymentsExpired()::add);
            CollectionHelper.orEmpty((Set)adminNotificationSettingsDTO.getExternalPaymentsFailed()).stream().map(ModelHelper::internalNameOrId).forEach(notificationSettingsEdit.getExternalPaymentsFailed()::add);
            CollectionHelper.orEmpty((Set)adminNotificationSettingsDTO.getFwdMessageCategoriesToEmail()).stream().map(ModelHelper::internalNameOrId).forEach(notificationSettingsEdit.getForwardMessageCategories()::add);
            CollectionHelper.orEmpty((Set)adminNotificationSettingsDTO.getPayments()).stream().map(ModelHelper::internalNameOrId).forEach(notificationSettingsEdit.getPayments()::add);
            CollectionHelper.orEmpty((Set)adminNotificationSettingsDTO.getSystemAlerts()).stream().map(this.alertsApiHelper::toSystemAlertTypeEnum).forEach(notificationSettingsEdit.getSystemAlerts()::add);
            CollectionHelper.orEmpty((Set)adminNotificationSettingsDTO.getUserAlerts()).stream().map(this.alertsApiHelper::toUserAlertTypeEnum).forEach(notificationSettingsEdit.getUserAlerts()::add);
            CollectionHelper.orEmpty((Set)adminNotificationSettingsDTO.getUserGroups()).stream().map(ModelHelper::internalNameOrId).forEach(notificationSettingsEdit.getUserGroups()::add);
            CollectionHelper.orEmpty((Set)adminNotificationSettingsDTO.getVoucherConfigurations()).stream().map(ModelHelper::internalNameOrId).forEach(notificationSettingsEdit.getVoucherConfigurations()::add);
            CollectionHelper.orEmpty((Set)adminNotificationSettingsDTO.getVoucherConfigurationsBuying()).stream().map(ModelHelper::internalNameOrId).forEach(notificationSettingsEdit.getVoucherConfigurationsBuying()::add);
        }
        return notificationSettingsEdit;
    }

    private NotificationTypeMediums toNotificationTypeMediums(NotificationTypeSettingsDTO notificationTypeSettingsDTO) {
        NotificationTypeMediums notificationTypeMediums = new NotificationTypeMediums();
        notificationTypeMediums.setKind(this.toNotificationKind(notificationTypeSettingsDTO.getType()));
        notificationTypeMediums.setType(this.notificationsApiHelper.toNotificationTypeEnum(notificationTypeSettingsDTO.getType()));
        notificationTypeMediums.setInternal(notificationTypeSettingsDTO.getNotifyByInternal());
        notificationTypeMediums.setEmail(notificationTypeSettingsDTO.getNotifyByEmail());
        notificationTypeMediums.setSms(notificationTypeSettingsDTO.getNotifyBySms());
        notificationTypeMediums.setApp(notificationTypeSettingsDTO.getNotifyByApp());
        return notificationTypeMediums;
    }

    private NotificationTypeSettingsDTO toNotificationTypeSettingsDTO(NotificationTypeMediums notificationTypeMediums) {
        NotificationTypeSettingsDTO notificationTypeSettingsDTO = new NotificationTypeSettingsDTO();
        if (notificationTypeMediums.getType() != null) {
            notificationTypeSettingsDTO.setType(this.notificationsApiHelper.toNotificationType(notificationTypeMediums.getType()));
        } else {
            notificationTypeSettingsDTO.setType(this.toNotificationType(notificationTypeMediums.getKind()));
        }
        notificationTypeSettingsDTO.setNotifyByInternal(Boolean.valueOf(Boolean.TRUE.equals(notificationTypeMediums.getInternal())));
        notificationTypeSettingsDTO.setNotifyByEmail(Boolean.valueOf(Boolean.TRUE.equals(notificationTypeMediums.getEmail())));
        notificationTypeSettingsDTO.setNotifyBySms(Boolean.valueOf(Boolean.TRUE.equals(notificationTypeMediums.getSms())));
        notificationTypeSettingsDTO.setNotifyByApp(Boolean.valueOf(Boolean.TRUE.equals(notificationTypeMediums.getApp())));
        return notificationTypeSettingsDTO;
    }
}

