/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.helpers;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.cyclos.model.EntityModel;
import org.cyclos.model.Property;
import org.cyclos.model.access.passwords.ICredentialInputDTO;
import org.cyclos.model.banking.currencies.CurrencyVO;
import org.cyclos.model.banking.transfers.TransferVO;
import org.cyclos.model.contentmanagement.contentitems.MenuItemVO;
import org.cyclos.model.marketplace.advertisements.BasicAdVO;
import org.cyclos.model.system.exportformats.ExportFormatVO;
import org.cyclos.model.system.fields.CustomFieldDetailedVO;
import org.cyclos.model.system.operationfields.CustomOperationFieldDetailedVO;
import org.cyclos.model.system.operations.CustomOperationResultPageRowAction;
import org.cyclos.model.system.operations.CustomOperationResultType;
import org.cyclos.model.system.operations.CustomOperationScope;
import org.cyclos.model.system.operations.CustomOperationShowForm;
import org.cyclos.model.system.operations.CustomOperationVO;
import org.cyclos.model.system.operations.PageResultColumn;
import org.cyclos.model.system.operations.PageResultColumnType;
import org.cyclos.model.system.operations.ReceiptItemVO;
import org.cyclos.model.system.operations.ReceiptPartAlign;
import org.cyclos.model.system.operations.ReceiptPartSize;
import org.cyclos.model.system.operations.ReceiptPartStyle;
import org.cyclos.model.system.operations.ReceiptPartVO;
import org.cyclos.model.system.operations.ReceiptVO;
import org.cyclos.model.system.operations.RunAdCustomOperationDTO;
import org.cyclos.model.system.operations.RunAdCustomOperationData;
import org.cyclos.model.system.operations.RunAdCustomOperationDataParams;
import org.cyclos.model.system.operations.RunContactCustomOperationDTO;
import org.cyclos.model.system.operations.RunContactCustomOperationData;
import org.cyclos.model.system.operations.RunContactCustomOperationDataParams;
import org.cyclos.model.system.operations.RunContactInfoCustomOperationDTO;
import org.cyclos.model.system.operations.RunContactInfoCustomOperationData;
import org.cyclos.model.system.operations.RunContactInfoCustomOperationDataParams;
import org.cyclos.model.system.operations.RunCustomOperationAction;
import org.cyclos.model.system.operations.RunCustomOperationDTO;
import org.cyclos.model.system.operations.RunCustomOperationData;
import org.cyclos.model.system.operations.RunCustomOperationDataParams;
import org.cyclos.model.system.operations.RunCustomOperationResult;
import org.cyclos.model.system.operations.RunMenuItemCustomOperationDTO;
import org.cyclos.model.system.operations.RunMenuItemCustomOperationData;
import org.cyclos.model.system.operations.RunMenuItemCustomOperationDataParams;
import org.cyclos.model.system.operations.RunRecordCustomOperationDTO;
import org.cyclos.model.system.operations.RunRecordCustomOperationData;
import org.cyclos.model.system.operations.RunRecordCustomOperationDataParams;
import org.cyclos.model.system.operations.RunTransferCustomOperationDTO;
import org.cyclos.model.system.operations.RunTransferCustomOperationData;
import org.cyclos.model.system.operations.RunTransferCustomOperationDataParams;
import org.cyclos.model.system.operations.RunUserCustomOperationDTO;
import org.cyclos.model.system.operations.RunUserCustomOperationData;
import org.cyclos.model.system.operations.RunUserCustomOperationDataParams;
import org.cyclos.model.system.operations.RunnableCustomOperationVO;
import org.cyclos.model.system.scripts.CustomScriptException;
import org.cyclos.model.users.contactinfos.ContactInfoDetailedVO;
import org.cyclos.model.users.contactinfos.ContactInfoVO;
import org.cyclos.model.users.contacts.ContactDetailedVO;
import org.cyclos.model.users.contacts.ContactVO;
import org.cyclos.model.users.records.RecordVO;
import org.cyclos.model.users.records.UserRecordVO;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.server.utils.ClassHelper;
import org.cyclos.server.utils.JsonConverter;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.StringHelper;
import org.cyclos.web.rest.helpers.AccountsApiHelper;
import org.cyclos.web.rest.helpers.ApiHelper;
import org.cyclos.web.rest.helpers.AuthApiHelper;
import org.cyclos.web.rest.helpers.ContactInfosApiHelper;
import org.cyclos.web.rest.helpers.ContactsApiHelper;
import org.cyclos.web.rest.helpers.FrontendApiHelper;
import org.cyclos.web.rest.helpers.MarketplaceApiHelper;
import org.cyclos.web.rest.helpers.RecordsApiHelper;
import org.cyclos.web.rest.helpers.TransfersApiHelper;
import org.cyclos.web.rest.helpers.UsersApiHelper;
import org.cyclos.web.rest.model.Operation;
import org.cyclos.web.rest.model.OperationCustomFieldDetailed;
import org.cyclos.web.rest.model.OperationDataForRun;
import org.cyclos.web.rest.model.OperationResultTypeEnum;
import org.cyclos.web.rest.model.OperationRowActionEnum;
import org.cyclos.web.rest.model.OperationScopeEnum;
import org.cyclos.web.rest.model.OperationShowFormEnum;
import org.cyclos.web.rest.model.Receipt;
import org.cyclos.web.rest.model.ReceiptItem;
import org.cyclos.web.rest.model.ReceiptPart;
import org.cyclos.web.rest.model.ReceiptPartAlignEnum;
import org.cyclos.web.rest.model.ReceiptPartSizeEnum;
import org.cyclos.web.rest.model.ReceiptPartStyleEnum;
import org.cyclos.web.rest.model.RunOperation;
import org.cyclos.web.rest.model.RunOperationAction;
import org.cyclos.web.rest.model.RunOperationResult;
import org.cyclos.web.rest.model.RunOperationResultColumn;
import org.cyclos.web.rest.model.RunOperationResultColumnTypeEnum;
import org.cyclos.web.utils.ServletHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

@Component
public class OperationsApiHelper {
    @Autowired
    private ApiHelper apiHelper;
    @Autowired
    private JsonConverter jsonConverter;
    @Autowired
    private AuthApiHelper authApiHelper;
    @Autowired
    private UsersApiHelper usersApiHelper;
    @Autowired
    private MarketplaceApiHelper marketplaceApiHelper;
    @Autowired
    private RecordsApiHelper recordsApiHelper;
    @Autowired
    private ContactsApiHelper contactsApiHelper;
    @Autowired
    private ContactInfosApiHelper contactInfosApiHelper;
    @Autowired
    private TransfersApiHelper transfersApiHelper;
    @Autowired
    private AccountsApiHelper accountsApiHelper;
    @Autowired
    private FrontendApiHelper frontendApiHelper;

    public Operation toOperation(CustomOperationVO customOperationVO) {
        if (customOperationVO == null) {
            return null;
        }
        Operation operation = this.newOperation(Operation.class, customOperationVO);
        operation.setMissingOptionalParameters(null);
        operation.setMissingRequiredParameters(null);
        return operation;
    }

    public Operation toOperation(RunnableCustomOperationVO runnableCustomOperationVO) {
        if (runnableCustomOperationVO == null) {
            return null;
        }
        Operation operation = this.newOperation(Operation.class, (CustomOperationVO)runnableCustomOperationVO);
        this.fill(operation, runnableCustomOperationVO);
        return operation;
    }

    public OperationDataForRun toOperationDataForRun(RunCustomOperationData runCustomOperationData) {
        if (runCustomOperationData == null) {
            return null;
        }
        OperationDataForRun operationDataForRun = this.newOperation(OperationDataForRun.class, (CustomOperationVO)runCustomOperationData);
        this.fill(operationDataForRun, runCustomOperationData);
        return operationDataForRun;
    }

    public OperationResultTypeEnum toOperationResultTypeEnum(CustomOperationResultType customOperationResultType) {
        if (customOperationResultType != null) {
            switch (customOperationResultType) {
                case PLAIN_TEXT: {
                    return OperationResultTypeEnum.PLAIN_TEXT;
                }
                case RICH_TEXT: {
                    return OperationResultTypeEnum.RICH_TEXT;
                }
                case NOTIFICATION: {
                    return OperationResultTypeEnum.NOTIFICATION;
                }
                case URL: {
                    return OperationResultTypeEnum.URL;
                }
                case FILE_DOWNLOAD: {
                    return OperationResultTypeEnum.FILE_DOWNLOAD;
                }
                case EXTERNAL_REDIRECT: {
                    return OperationResultTypeEnum.EXTERNAL_REDIRECT;
                }
                case RESULT_PAGE: {
                    return OperationResultTypeEnum.RESULT_PAGE;
                }
                case BULK_ACTION: {
                    return null;
                }
            }
        }
        return null;
    }

    public OperationRowActionEnum toOperationRowActionEnum(CustomOperationResultPageRowAction customOperationResultPageRowAction) {
        if (customOperationResultPageRowAction != null) {
            switch (customOperationResultPageRowAction) {
                case LOCATION: {
                    return OperationRowActionEnum.LOCATION;
                }
                case OPERATION: {
                    return OperationRowActionEnum.OPERATION;
                }
                case URL: {
                    return OperationRowActionEnum.URL;
                }
            }
        }
        return null;
    }

    public OperationScopeEnum toOperationScopeEnum(CustomOperationScope customOperationScope) {
        if (customOperationScope != null) {
            switch (customOperationScope) {
                case ADVERTISEMENT: {
                    return OperationScopeEnum.ADVERTISEMENT;
                }
                case CONTACT: {
                    return OperationScopeEnum.CONTACT;
                }
                case CONTACT_INFO: {
                    return OperationScopeEnum.CONTACT_INFO;
                }
                case INTERNAL: {
                    return OperationScopeEnum.INTERNAL;
                }
                case MENU: {
                    return OperationScopeEnum.MENU;
                }
                case SYSTEM: {
                    return OperationScopeEnum.SYSTEM;
                }
                case USER: {
                    return OperationScopeEnum.USER;
                }
                case RECORD: {
                    return OperationScopeEnum.RECORD;
                }
                case TRANSFER: {
                    return OperationScopeEnum.TRANSFER;
                }
                case BULK_ACTION: {
                    return OperationScopeEnum.BULK_ACTION;
                }
            }
        }
        return null;
    }

    public RunCustomOperationDataParams toRunCustomOperationDataParams(CustomOperationScope customOperationScope, String string, String string2) {
        RunCustomOperationDataParams runCustomOperationDataParams;
        if (customOperationScope == null) {
            runCustomOperationDataParams = new RunCustomOperationDataParams();
        } else {
            switch (customOperationScope) {
                case ADVERTISEMENT: {
                    runCustomOperationDataParams = new RunAdCustomOperationDataParams();
                    runCustomOperationDataParams.set((Property)RunAdCustomOperationDataParams.AD, (Object)((BasicAdVO)ModelHelper.voFromString(BasicAdVO.class, (String)string2)));
                    break;
                }
                case CONTACT: {
                    runCustomOperationDataParams = new RunContactCustomOperationDataParams();
                    runCustomOperationDataParams.set((Property)RunContactCustomOperationDataParams.CONTACT, (Object)((ContactVO)ModelHelper.voFromString(ContactVO.class, (String)string2)));
                    break;
                }
                case CONTACT_INFO: {
                    runCustomOperationDataParams = new RunContactInfoCustomOperationDataParams();
                    runCustomOperationDataParams.set((Property)RunContactInfoCustomOperationDataParams.CONTACT_INFO, (Object)((ContactInfoVO)ModelHelper.voFromString(ContactInfoVO.class, (String)string2)));
                    break;
                }
                case RECORD: {
                    runCustomOperationDataParams = new RunRecordCustomOperationDataParams();
                    runCustomOperationDataParams.set((Property)RunRecordCustomOperationDataParams.RECORD, (Object)((RecordVO)ModelHelper.voFromString(RecordVO.class, (String)string2)));
                    break;
                }
                case TRANSFER: {
                    runCustomOperationDataParams = new RunTransferCustomOperationDataParams();
                    runCustomOperationDataParams.set((Property)RunTransferCustomOperationDataParams.TRANSFER, (Object)((TransferVO)ModelHelper.voFromString(TransferVO.class, (String)string2)));
                    break;
                }
                case USER: {
                    runCustomOperationDataParams = new RunUserCustomOperationDataParams();
                    runCustomOperationDataParams.set((Property)RunUserCustomOperationDataParams.USER, (Object)((UserLocatorVO)ModelHelper.voFromString(UserLocatorVO.class, (String)string2)));
                    break;
                }
                case MENU: {
                    runCustomOperationDataParams = new RunMenuItemCustomOperationDataParams();
                    runCustomOperationDataParams.set((Property)RunMenuItemCustomOperationDataParams.MENU_ITEM, (Object)((MenuItemVO)ModelHelper.voFromString(MenuItemVO.class, (String)string2)));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unhandled scope: " + String.valueOf(customOperationScope));
                }
            }
        }
        runCustomOperationDataParams.setCustomOperation((CustomOperationVO)ModelHelper.voFromString(CustomOperationVO.class, (String)string));
        runCustomOperationDataParams.setOperationParameters(this.getRequestParameters());
        return runCustomOperationDataParams;
    }

    public RunCustomOperationDTO toRunCustomOperationDTO(OperationScopeEnum operationScopeEnum, String string, String string2, RunOperation runOperation, MultipartFile multipartFile) throws IOException {
        RunUserCustomOperationDTO runUserCustomOperationDTO;
        switch (operationScopeEnum) {
            case USER: {
                runUserCustomOperationDTO = new RunUserCustomOperationDTO();
                runUserCustomOperationDTO.setUser((UserLocatorVO)ModelHelper.voFromString(UserLocatorVO.class, (String)string2));
                break;
            }
            case CONTACT: {
                runUserCustomOperationDTO = new RunContactCustomOperationDTO();
                ((RunContactCustomOperationDTO)runUserCustomOperationDTO).setContact((ContactVO)ModelHelper.voFromString(ContactVO.class, (String)string2));
                break;
            }
            case CONTACT_INFO: {
                runUserCustomOperationDTO = new RunContactInfoCustomOperationDTO();
                ((RunContactInfoCustomOperationDTO)runUserCustomOperationDTO).setContactInfo((ContactInfoVO)ModelHelper.voFromString(ContactInfoVO.class, (String)string2));
                break;
            }
            case ADVERTISEMENT: {
                runUserCustomOperationDTO = new RunAdCustomOperationDTO();
                ((RunAdCustomOperationDTO)runUserCustomOperationDTO).setAd((BasicAdVO)ModelHelper.voFromString(BasicAdVO.class, (String)string2));
                break;
            }
            case RECORD: {
                runUserCustomOperationDTO = new RunRecordCustomOperationDTO();
                ((RunRecordCustomOperationDTO)runUserCustomOperationDTO).setRecord((RecordVO)ModelHelper.voFromString(RecordVO.class, (String)string2));
                break;
            }
            case TRANSFER: {
                runUserCustomOperationDTO = new RunTransferCustomOperationDTO();
                ((RunTransferCustomOperationDTO)runUserCustomOperationDTO).setTransfer((TransferVO)ModelHelper.voFromString(TransferVO.class, (String)string2));
                break;
            }
            case MENU: {
                runUserCustomOperationDTO = new RunMenuItemCustomOperationDTO();
                ((RunMenuItemCustomOperationDTO)runUserCustomOperationDTO).setMenuItem((MenuItemVO)ModelHelper.voFromString(MenuItemVO.class, (String)string2));
                break;
            }
            default: {
                runUserCustomOperationDTO = new RunCustomOperationDTO();
            }
        }
        runUserCustomOperationDTO.setCustomOperation((CustomOperationVO)ModelHelper.voFromString(CustomOperationVO.class, (String)string));
        if (runOperation != null) {
            runUserCustomOperationDTO.setConfirmationPassword(runOperation.getConfirmationPassword());
            runUserCustomOperationDTO.setFormParameters(this.apiHelper.toCustomFieldValuesDTO(runOperation.getFormParameters()));
            runUserCustomOperationDTO.setCurrentPage(runOperation.getPage());
            runUserCustomOperationDTO.setPageSize(runOperation.getPageSize());
            runUserCustomOperationDTO.setSkipTotalCount(Boolean.TRUE.equals(runOperation.getSkipTotalCount()));
            runUserCustomOperationDTO.setExportFormat((ExportFormatVO)ModelHelper.voFromString(ExportFormatVO.class, (String)runOperation.getExportFormat()));
            runUserCustomOperationDTO.setScannedQrCode(runOperation.getScannedQrCode());
        }
        runUserCustomOperationDTO.setFileUpload(ServletHelper.toFileInfo(multipartFile));
        return runUserCustomOperationDTO;
    }

    public RunOperationAction toRunOperationAction(RunCustomOperationAction runCustomOperationAction) {
        RunOperationAction runOperationAction = new RunOperationAction();
        runOperationAction.setAction(this.toOperation(runCustomOperationAction.getAction()));
        runOperationAction.setPrimary(runCustomOperationAction.isPrimary());
        runOperationAction.setParameters(new HashMap<String, String>(runCustomOperationAction.getParameters()));
        return runOperationAction;
    }

    public RunOperationResult toRunOperationResult(RunCustomOperationResult runCustomOperationResult) {
        if (runCustomOperationResult == null) {
            return null;
        }
        RunOperationResult runOperationResult = new RunOperationResult();
        runOperationResult.setResultType(this.toOperationResultTypeEnum(runCustomOperationResult.getResultType()));
        runOperationResult.setTitle(runCustomOperationResult.getTitle());
        runOperationResult.setContent(runCustomOperationResult.getContent());
        runOperationResult.setReceipt(this.toReceipt(runCustomOperationResult.getReceipt()));
        runOperationResult.setNotification(runCustomOperationResult.getNotification());
        runOperationResult.setNotificationLevel(this.apiHelper.toNotificationLevelEnum(runCustomOperationResult.getNotificationLevel()));
        runOperationResult.setUrl(runCustomOperationResult.getUrl());
        runOperationResult.setNewWindow(runCustomOperationResult.getNewWindow());
        if (runCustomOperationResult.getBackTo() != null) {
            runOperationResult.setBackTo(this.apiHelper.toReference((EntityModel)runCustomOperationResult.getBackTo()));
        } else if (runCustomOperationResult.isBackToRoot()) {
            runOperationResult.setBackToRoot(true);
        }
        runOperationResult.setReRun(runCustomOperationResult.isReRun());
        if (runOperationResult.getResultType() == OperationResultTypeEnum.RESULT_PAGE) {
            CollectionHelper.orEmpty((List)runCustomOperationResult.getColumns()).stream().map(this::toRunOperationResultColumn).forEach(runOperationResult.getColumns()::add);
            CollectionHelper.orEmpty((List)runCustomOperationResult.getRows()).stream().map(string -> this.toRunOperationResultRow(runOperationResult.getColumns(), (String)string)).forEach(runOperationResult.getRows()::add);
        } else {
            runOperationResult.setColumns(null);
            runOperationResult.setRows(null);
        }
        if (CollectionHelper.isEmpty((Iterable)runCustomOperationResult.getActions())) {
            runOperationResult.setActions(null);
        } else {
            runCustomOperationResult.getActions().stream().map(this::toRunOperationAction).forEach(runOperationResult.getActions()::add);
        }
        if (runCustomOperationResult.getAutoRunActionId() != null) {
            runOperationResult.setAutoRunActionId(ApiHelper.toId(runCustomOperationResult.getAutoRunActionId()));
        }
        return runOperationResult;
    }

    public RunOperationResultColumn toRunOperationResultColumn(PageResultColumn pageResultColumn) {
        if (pageResultColumn == null) {
            return null;
        }
        RunOperationResultColumn runOperationResultColumn = new RunOperationResultColumn();
        runOperationResultColumn.setHeader(pageResultColumn.getHeader());
        String string = pageResultColumn.getProperty();
        if (string == null && pageResultColumn.getIndex() != null) {
            string = pageResultColumn.getIndex().toString();
        }
        runOperationResultColumn.setProperty(string);
        runOperationResultColumn.setType(this.toRunOperationResultColumnTypeEnum(pageResultColumn.getType()));
        runOperationResultColumn.setWidth(pageResultColumn.getWidth());
        runOperationResultColumn.setAlign(pageResultColumn.getAlign());
        runOperationResultColumn.setValign(pageResultColumn.getValign());
        runOperationResultColumn.setDecimalDigits(pageResultColumn.getDecimalDigits());
        return runOperationResultColumn;
    }

    public RunOperationResultColumnTypeEnum toRunOperationResultColumnTypeEnum(PageResultColumnType pageResultColumnType) {
        if (pageResultColumnType != null) {
            switch (pageResultColumnType) {
                case BOOLEAN: {
                    return RunOperationResultColumnTypeEnum.BOOLEAN;
                }
                case CURRENCY_AMOUNT: {
                    return RunOperationResultColumnTypeEnum.CURRENCY_AMOUNT;
                }
                case DATE: {
                    return RunOperationResultColumnTypeEnum.DATE;
                }
                case NUMBER: {
                    return RunOperationResultColumnTypeEnum.NUMBER;
                }
                case STRING: {
                    return RunOperationResultColumnTypeEnum.STRING;
                }
            }
        }
        return null;
    }

    public Map<String, Object> toRunOperationResultRow(List<RunOperationResultColumn> list, String string) {
        JsonNode jsonNode;
        try {
            jsonNode = this.jsonConverter.readTree(string);
        }
        catch (JsonProcessingException jsonProcessingException) {
            throw new CustomScriptException("A row returned as a result page in custom operation was not a valid JSON: " + string);
        }
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        Object object = this.jsonConverter.nodeValue(jsonNode);
        if (object instanceof Map) {
            linkedHashMap.putAll((Map)object);
            for (RunOperationResultColumn runOperationResultColumn : list) {
                Object v;
                if (runOperationResultColumn.getType() != RunOperationResultColumnTypeEnum.CURRENCY_AMOUNT || !((v = linkedHashMap.get(runOperationResultColumn.getProperty())) instanceof Map)) continue;
                Map map = (Map)v;
                CurrencyVO currencyVO = (CurrencyVO)ClassHelper.convert(map.get("currency"), CurrencyVO.class);
                map.put("currency", this.accountsApiHelper.toCurrency(currencyVO));
                map.remove("class");
            }
        } else if (object instanceof List) {
            List list2 = (List)object;
            for (int i = 0; i < list2.size(); ++i) {
                linkedHashMap.put(String.valueOf(i), list2.get(i));
            }
        } else {
            linkedHashMap.put("0", object);
        }
        return linkedHashMap;
    }

    private void fill(Operation operation, RunnableCustomOperationVO runnableCustomOperationVO) {
        if (runnableCustomOperationVO == null) {
            return;
        }
        operation.setResultType(this.toOperationResultTypeEnum(runnableCustomOperationVO.getResultType()));
        operation.setRequireConfirmationPassword(runnableCustomOperationVO.isRequireConfirmationCredential());
        operation.setSvgIcon(runnableCustomOperationVO.getSvgIcon());
        this.apiHelper.setIconOrCustomSVG(runnableCustomOperationVO.getIcon(), operation);
        operation.setHasFileUpload(runnableCustomOperationVO.isHasFileUpload());
        operation.setSubmitWithQrCodeScan(runnableCustomOperationVO.isSubmitWithQrCodeScan());
        operation.setInformationText(runnableCustomOperationVO.getInformationText());
        operation.setConfirmationText(runnableCustomOperationVO.getConfirmationText());
        operation.setMenu(this.frontendApiHelper.toFrontendMenu(runnableCustomOperationVO.getFrontendMenu()));
        operation.setAdminMenu(this.apiHelper.toAdminMenuEnum(runnableCustomOperationVO.getAdminMenu()));
        operation.setUserMenu(this.apiHelper.toUserMenuEnum(runnableCustomOperationVO.getUserMenu()));
        operation.setUserProfileSection(this.apiHelper.toUserProfileSectionEnum(runnableCustomOperationVO.getProfileSection()));
        CollectionHelper.orEmpty((List)runnableCustomOperationVO.getMissingOptionalParameters()).stream().map(ModelHelper::unqualifyInternalName).forEach(operation.getMissingOptionalParameters()::add);
        CollectionHelper.orEmpty((List)runnableCustomOperationVO.getMissingRequiredParameters()).stream().map(ModelHelper::unqualifyInternalName).forEach(operation.getMissingRequiredParameters()::add);
        if (runnableCustomOperationVO.getResultType() != CustomOperationResultType.RESULT_PAGE) {
            operation.setShowForm(this.toOperationShowFormEnum(runnableCustomOperationVO.getShowForm()));
        }
        if (runnableCustomOperationVO.getResultType().isPage()) {
            operation.setAllowExport(runnableCustomOperationVO.isAllowExport());
        }
        if (runnableCustomOperationVO.getResultType().isContent()) {
            operation.setAllowPrint(runnableCustomOperationVO.isAllowPrint());
        }
    }

    private void fill(OperationDataForRun operationDataForRun, RunCustomOperationData runCustomOperationData) {
        if (runCustomOperationData == null) {
            return;
        }
        this.fill((Operation)operationDataForRun, (RunnableCustomOperationVO)runCustomOperationData);
        operationDataForRun.setConfirmationPasswordInput(this.authApiHelper.toPasswordInput((ICredentialInputDTO)runCustomOperationData.getConfirmationPasswordInput()));
        operationDataForRun.setCustomSubmitLabel(runCustomOperationData.getCustomSubmitLabel());
        CollectionHelper.orEmpty((List)runCustomOperationData.getFormParameters()).stream().map(this::toOperationCustomFieldDetailed).forEach(operationDataForRun.getFormParameters()::add);
        if (CollectionHelper.isEmpty((Iterable)runCustomOperationData.getActions())) {
            operationDataForRun.setActions(null);
        } else {
            runCustomOperationData.getActions().stream().map(this::toRunOperationAction).forEach(operationDataForRun.getActions()::add);
        }
        if (runCustomOperationData.getAutoRunActionId() != null) {
            operationDataForRun.setAutoRunActionId(ApiHelper.toId(runCustomOperationData.getAutoRunActionId()));
        }
        operationDataForRun.setReRun(runCustomOperationData.isReRun());
        operationDataForRun.setCloseAfterSeconds(runCustomOperationData.getCloseAfterSeconds());
        if (runCustomOperationData.getResultType() == CustomOperationResultType.RESULT_PAGE) {
            operationDataForRun.setSearchAutomatically(runCustomOperationData.isSearchAutomatically());
            operationDataForRun.setRowAction(this.toOperationRowActionEnum(runCustomOperationData.getRowAction()));
            operationDataForRun.setRowParameters(CollectionHelper.orEmpty((List)runCustomOperationData.getRowParameters()));
            operationDataForRun.setRowOperation(this.toOperation(runCustomOperationData.getRowOperation()));
            operationDataForRun.setRowLocation(runCustomOperationData.getRowLocation() == null ? null : StringHelper.camelize((String)runCustomOperationData.getRowLocation().name()));
            operationDataForRun.setRowUrl(runCustomOperationData.getRowUrl());
            operationDataForRun.setResultInformationText(runCustomOperationData.getResultInformationText());
            CollectionHelper.orEmpty((List)runCustomOperationData.getExportFormats()).stream().map(this.apiHelper::toExportFormat).forEach(operationDataForRun.getExportFormats()::add);
        } else {
            operationDataForRun.setRowParameters(null);
            operationDataForRun.setExportFormats(null);
        }
        if (runCustomOperationData instanceof RunUserCustomOperationData) {
            operationDataForRun.setUser(this.usersApiHelper.toUser((BasicUserVO)((RunUserCustomOperationData)runCustomOperationData).getUser()));
        } else if (runCustomOperationData instanceof RunAdCustomOperationData) {
            BasicAdVO basicAdVO = ((RunAdCustomOperationData)runCustomOperationData).getAd();
            if (basicAdVO != null) {
                operationDataForRun.setUser(this.usersApiHelper.toUser((BasicUserVO)basicAdVO.getOwner()));
                operationDataForRun.setAd(this.marketplaceApiHelper.toAd(basicAdVO));
            }
        } else if (runCustomOperationData instanceof RunContactCustomOperationData) {
            ContactDetailedVO contactDetailedVO = ((RunContactCustomOperationData)runCustomOperationData).getContact();
            if (contactDetailedVO != null) {
                operationDataForRun.setUser(this.usersApiHelper.toUser((BasicUserVO)contactDetailedVO.getOwner()));
                operationDataForRun.setContact(this.contactsApiHelper.toContact((ContactVO)contactDetailedVO));
            }
        } else if (runCustomOperationData instanceof RunContactInfoCustomOperationData) {
            ContactInfoDetailedVO contactInfoDetailedVO = ((RunContactInfoCustomOperationData)runCustomOperationData).getContactInfo();
            if (contactInfoDetailedVO != null) {
                operationDataForRun.setUser(this.usersApiHelper.toUser((BasicUserVO)contactInfoDetailedVO.getUser()));
                operationDataForRun.setContactInfo(this.contactInfosApiHelper.toContactInfoResult((ContactInfoVO)contactInfoDetailedVO));
            }
        } else if (runCustomOperationData instanceof RunRecordCustomOperationData) {
            RecordVO recordVO = ((RunRecordCustomOperationData)runCustomOperationData).getRecord();
            if (recordVO != null) {
                operationDataForRun.setRecord(this.recordsApiHelper.toRecord(recordVO));
                operationDataForRun.setRecordType(this.recordsApiHelper.toRecordType(recordVO.getType()));
                if (recordVO instanceof UserRecordVO) {
                    operationDataForRun.setUser(this.usersApiHelper.toUser((BasicUserVO)((UserRecordVO)recordVO).getUser()));
                }
            }
        } else if (runCustomOperationData instanceof RunTransferCustomOperationData) {
            operationDataForRun.setTransfer(this.transfersApiHelper.toTransfer(((RunTransferCustomOperationData)runCustomOperationData).getTransfer()));
        } else if (runCustomOperationData instanceof RunMenuItemCustomOperationData) {
            operationDataForRun.setMenuItem(this.apiHelper.toReference((EntityModel)((RunMenuItemCustomOperationData)runCustomOperationData).getMenuItem()));
        }
    }

    private Map<String, String> getRequestParameters() {
        HttpServletRequest httpServletRequest = ServletHelper.getRequest();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Enumeration enumeration = httpServletRequest.getParameterNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            hashMap.put(string, httpServletRequest.getParameter(string));
        }
        return hashMap;
    }

    private <Op extends Operation> Op newOperation(Class<Op> clazz, CustomOperationVO customOperationVO) {
        Operation operation = (Operation)this.apiHelper.newEntity(clazz, customOperationVO);
        operation.setScope(this.toOperationScopeEnum(customOperationVO.getScope()));
        operation.setLabel(customOperationVO.getLabel());
        operation.setSvgIcon(customOperationVO.getSvgIcon());
        return (Op)operation;
    }

    private <T extends ReceiptPart> T newPart(Class<T> clazz, ReceiptPartVO receiptPartVO) {
        ReceiptPart receiptPart = (ReceiptPart)ClassHelper.instantiate(clazz);
        receiptPart.setText(receiptPartVO.getText());
        receiptPart.setStyle(this.toReceiptPartStyleEnum(receiptPartVO.getStyle()));
        receiptPart.setAlign(this.toReceiptPartAlignEnum(receiptPartVO.getAlign()));
        receiptPart.setWidth(this.toReceiptPartSizeEnum(receiptPartVO.getWidth()));
        receiptPart.setHeight(this.toReceiptPartSizeEnum(receiptPartVO.getHeight()));
        receiptPart.setLineBefore(receiptPartVO.getLineBefore());
        receiptPart.setLineAfter(receiptPartVO.getLineAfter());
        return (T)receiptPart;
    }

    private OperationCustomFieldDetailed toOperationCustomFieldDetailed(CustomOperationFieldDetailedVO customOperationFieldDetailedVO) {
        if (customOperationFieldDetailedVO == null) {
            return null;
        }
        OperationCustomFieldDetailed operationCustomFieldDetailed = this.apiHelper.newCustomFieldDetailed(OperationCustomFieldDetailed.class, (CustomFieldDetailedVO)customOperationFieldDetailedVO);
        operationCustomFieldDetailed.setReadonly(customOperationFieldDetailedVO.isReadonlyInForm());
        return operationCustomFieldDetailed;
    }

    private OperationShowFormEnum toOperationShowFormEnum(CustomOperationShowForm customOperationShowForm) {
        if (customOperationShowForm != null) {
            switch (customOperationShowForm) {
                case ALWAYS: {
                    return OperationShowFormEnum.ALWAYS;
                }
                case MISSING_ANY: {
                    return OperationShowFormEnum.MISSING_ANY;
                }
                case MISSING_REQUIRED: {
                    return OperationShowFormEnum.MISSING_REQUIRED;
                }
            }
        }
        return null;
    }

    private Receipt toReceipt(ReceiptVO receiptVO) {
        if (receiptVO == null) {
            return null;
        }
        Receipt receipt = new Receipt();
        receipt.setTimestamp(receiptVO.getTimestamp());
        receipt.setHeader(this.toReceiptPart(receiptVO.getHeader()));
        receipt.setTitle(this.toReceiptPart(receiptVO.getTitle()));
        receiptVO.getItems().stream().map(this::toReceiptItem).forEach(receipt.getItems()::add);
        receipt.setFooter(this.toReceiptPart(receiptVO.getFooter()));
        receipt.setLabelSuffix(receiptVO.getLabelSuffix());
        receipt.setAutoPrint(receiptVO.isAutoPrint());
        return receipt;
    }

    private ReceiptItem toReceiptItem(ReceiptItemVO receiptItemVO) {
        if (receiptItemVO == null) {
            return null;
        }
        ReceiptItem receiptItem = this.newPart(ReceiptItem.class, (ReceiptPartVO)receiptItemVO);
        receiptItem.setLabel(receiptItemVO.getLabel());
        receiptItem.setLabelStyle(this.toReceiptPartStyleEnum(receiptItemVO.getLabelStyle()));
        return receiptItem;
    }

    private ReceiptPart toReceiptPart(ReceiptPartVO receiptPartVO) {
        if (receiptPartVO == null) {
            return null;
        }
        return this.newPart(ReceiptPart.class, receiptPartVO);
    }

    private ReceiptPartAlignEnum toReceiptPartAlignEnum(ReceiptPartAlign receiptPartAlign) {
        if (receiptPartAlign != null) {
            switch (receiptPartAlign) {
                case LEFT: {
                    return ReceiptPartAlignEnum.LEFT;
                }
                case CENTER: {
                    return ReceiptPartAlignEnum.CENTER;
                }
                case RIGHT: {
                    return ReceiptPartAlignEnum.RIGHT;
                }
            }
        }
        return null;
    }

    private ReceiptPartSizeEnum toReceiptPartSizeEnum(ReceiptPartSize receiptPartSize) {
        if (receiptPartSize != null) {
            switch (receiptPartSize) {
                case NORMAL: {
                    return ReceiptPartSizeEnum.NORMAL;
                }
                case DOUBLE: {
                    return ReceiptPartSizeEnum.DOUBLE;
                }
            }
        }
        return null;
    }

    private ReceiptPartStyleEnum toReceiptPartStyleEnum(ReceiptPartStyle receiptPartStyle) {
        if (receiptPartStyle != null) {
            switch (receiptPartStyle) {
                case NORMAL: {
                    return ReceiptPartStyleEnum.NORMAL;
                }
                case BOLD: {
                    return ReceiptPartStyleEnum.BOLD;
                }
                case UNDERLINE: {
                    return ReceiptPartStyleEnum.UNDERLINE;
                }
            }
        }
        return null;
    }
}

