/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.helpers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.cyclos.model.EntityModel;
import org.cyclos.model.IEntity;
import org.cyclos.model.banking.accounttypes.AccountTypeVO;
import org.cyclos.model.banking.accounttypes.AccountTypeWithCurrencyVO;
import org.cyclos.model.banking.transfertypes.TransferTypeWithCurrencyVO;
import org.cyclos.model.messaging.notificationsettings.AccountNotificationSettingsDTO;
import org.cyclos.model.system.operations.CustomOperationVO;
import org.cyclos.model.system.wizards.CustomWizardVO;
import org.cyclos.model.users.operatorgroups.OperatorGroupAccountTypeDTO;
import org.cyclos.model.users.operatorgroups.OperatorGroupDTO;
import org.cyclos.model.users.operatorgroups.OperatorGroupData;
import org.cyclos.model.users.operatorgroups.OperatorGroupListData;
import org.cyclos.model.users.operatorgroups.OperatorGroupPaymentTypeDTO;
import org.cyclos.model.users.recordtypes.RecordTypeVO;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.model.users.users.OperatorGroupAccountAccess;
import org.cyclos.model.users.users.UserVO;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.server.utils.ClassHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.web.rest.helpers.AccountsApiHelper;
import org.cyclos.web.rest.helpers.ApiHelper;
import org.cyclos.web.rest.helpers.OperationsApiHelper;
import org.cyclos.web.rest.helpers.RecordsApiHelper;
import org.cyclos.web.rest.helpers.UsersApiHelper;
import org.cyclos.web.rest.helpers.WizardsApiHelper;
import org.cyclos.web.rest.model.OperatorGroupAccount;
import org.cyclos.web.rest.model.OperatorGroupAccountAccessEnum;
import org.cyclos.web.rest.model.OperatorGroupAccountView;
import org.cyclos.web.rest.model.OperatorGroupBasicData;
import org.cyclos.web.rest.model.OperatorGroupDataForEdit;
import org.cyclos.web.rest.model.OperatorGroupDataForNew;
import org.cyclos.web.rest.model.OperatorGroupEdit;
import org.cyclos.web.rest.model.OperatorGroupManage;
import org.cyclos.web.rest.model.OperatorGroupNew;
import org.cyclos.web.rest.model.OperatorGroupPayment;
import org.cyclos.web.rest.model.OperatorGroupPaymentView;
import org.cyclos.web.rest.model.OperatorGroupView;
import org.cyclos.web.rest.model.User;
import org.cyclos.web.rest.model.UserOperatorGroupsListData;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OperatorGroupsApiHelper {
    @Autowired
    private ApiHelper apiHelper;
    @Autowired
    private UsersApiHelper usersApiHelper;
    @Autowired
    private OperationsApiHelper operationsApiHelper;
    @Autowired
    private WizardsApiHelper wizardsApiHelper;
    @Autowired
    private RecordsApiHelper recordsApiHelper;
    @Autowired
    private AccountsApiHelper accountsApiHelper;

    public OperatorGroupDataForEdit toOperatorGroupDataForEdit(OperatorGroupData operatorGroupData) {
        if (operatorGroupData == null) {
            return null;
        }
        OperatorGroupDataForEdit operatorGroupDataForEdit = this.newOperatorGroupBasicData(OperatorGroupDataForEdit.class, operatorGroupData);
        operatorGroupDataForEdit.setOperatorGroup(this.toOperatorGroupEdit((OperatorGroupDTO)operatorGroupData.getDto()));
        operatorGroupDataForEdit.setCanEdit(operatorGroupData.isEditable());
        operatorGroupDataForEdit.setCanRemove(operatorGroupData.isRemovable());
        CollectionHelper.orEmpty((Set)((OperatorGroupDTO)operatorGroupData.getDto()).getRestrictPaymentsToUsers()).stream().map(this.usersApiHelper::toUser).sorted(Comparator.comparing(User::getDisplay)).forEach(operatorGroupDataForEdit.getRestrictPaymentsToUsers()::add);
        return operatorGroupDataForEdit;
    }

    public OperatorGroupDataForNew toOperatorGroupDataForNew(OperatorGroupData operatorGroupData) {
        if (operatorGroupData == null) {
            return null;
        }
        OperatorGroupDataForNew operatorGroupDataForNew = this.newOperatorGroupBasicData(OperatorGroupDataForNew.class, operatorGroupData);
        operatorGroupDataForNew.setOperatorGroup(this.toOperatorGroupNew((OperatorGroupDTO)operatorGroupData.getDto()));
        return operatorGroupDataForNew;
    }

    public OperatorGroupDTO toOperatorGroupDTO(OperatorGroupManage operatorGroupManage) {
        if (operatorGroupManage == null) {
            return null;
        }
        OperatorGroupDTO operatorGroupDTO = new OperatorGroupDTO();
        operatorGroupDTO.setName(operatorGroupManage.getName());
        operatorGroupDTO.setDescription(operatorGroupManage.getDescription());
        operatorGroupDTO.setEditOwnProfile(Boolean.TRUE.equals(operatorGroupManage.getEditOwnProfile()));
        operatorGroupDTO.setMessages(Boolean.TRUE.equals(operatorGroupManage.getMessages()));
        operatorGroupDTO.setNotifications(Boolean.TRUE.equals(operatorGroupManage.getNotifications()));
        operatorGroupDTO.setReceivePayments(Boolean.TRUE.equals(operatorGroupManage.getReceivePayments()));
        operatorGroupDTO.setChargebackPayments(Boolean.TRUE.equals(operatorGroupManage.getChargebackPayments()));
        if (operatorGroupManage.getVoucherTransactions() != null) {
            operatorGroupDTO.setVoucherTransactions(Boolean.TRUE.equals(operatorGroupManage.getVoucherTransactions()));
        } else {
            operatorGroupDTO.setVoucherTransactions(Boolean.TRUE.equals(operatorGroupManage.getRedeemVouchers()));
        }
        operatorGroupDTO.setBrokering(Boolean.TRUE.equals(operatorGroupManage.getBrokering()));
        operatorGroupDTO.setRequestPayments(Boolean.TRUE.equals(operatorGroupManage.getRequestPayments()));
        operatorGroupDTO.setViewAdvertisements(Boolean.TRUE.equals(operatorGroupManage.getViewAdvertisements()));
        operatorGroupDTO.setManageAdvertisements(Boolean.TRUE.equals(operatorGroupManage.getManageAdvertisements()));
        operatorGroupDTO.setEnableTokenPrincipalType(Boolean.TRUE.equals(operatorGroupManage.getEnableToken()));
        operatorGroupDTO.setCancelTokenPrincipalType(Boolean.TRUE.equals(operatorGroupManage.getCancelToken()));
        operatorGroupDTO.setBlockTokenPrincipalType(Boolean.TRUE.equals(operatorGroupManage.getBlockToken()));
        operatorGroupDTO.setUnblockTokenPrincipalType(Boolean.TRUE.equals(operatorGroupManage.getUnblockToken()));
        operatorGroupDTO.setRestrictPaymentsToUsers(CollectionHelper.orEmpty(operatorGroupManage.getRestrictPaymentsToUsers()).stream().map(string -> (UserVO)ModelHelper.voFromString(UserVO.class, (String)string)).collect(Collectors.toSet()));
        operatorGroupDTO.setCustomOperations(CollectionHelper.orEmpty(operatorGroupManage.getOperations()).stream().map(string -> (CustomOperationVO)ModelHelper.voFromString(CustomOperationVO.class, (String)string)).collect(Collectors.toSet()));
        operatorGroupDTO.setCustomWizards(CollectionHelper.orEmpty(operatorGroupManage.getWizards()).stream().map(string -> (CustomWizardVO)ModelHelper.voFromString(CustomWizardVO.class, (String)string)).collect(Collectors.toSet()));
        operatorGroupDTO.setRecordTypes(CollectionHelper.orEmpty(operatorGroupManage.getRecords()).stream().map(string -> (RecordTypeVO)ModelHelper.voFromString(RecordTypeVO.class, (String)string)).collect(Collectors.toSet()));
        operatorGroupDTO.setAccountNotificationSettings(this.toAccountNotificationSettings(operatorGroupManage.getAccounts()));
        operatorGroupDTO.setAccountTypes(this.toAccountTypes(operatorGroupManage.getAccounts()));
        operatorGroupDTO.setPaymentTypes(this.toPaymentTypes(operatorGroupManage.getPayments()));
        if (operatorGroupManage instanceof OperatorGroupEdit) {
            operatorGroupDTO.setVersion(((OperatorGroupEdit)operatorGroupManage).getVersion());
        }
        return operatorGroupDTO;
    }

    public OperatorGroupView toOperatorGroupView(OperatorGroupData operatorGroupData) {
        OperatorGroupDTO operatorGroupDTO = (OperatorGroupDTO)operatorGroupData.getDto();
        OperatorGroupView operatorGroupView = this.apiHelper.newEntity(OperatorGroupView.class, operatorGroupDTO);
        operatorGroupView.setUser(this.usersApiHelper.toUser((BasicUserVO)operatorGroupDTO.getUser()));
        operatorGroupView.setCanEdit(operatorGroupData.isEditable());
        operatorGroupView.setDescription(operatorGroupDTO.getDescription());
        operatorGroupView.setEditOwnProfile(operatorGroupDTO.isEditOwnProfile());
        operatorGroupView.setMessages(operatorGroupDTO.isMessages());
        operatorGroupView.setNotifications(operatorGroupDTO.isNotifications());
        operatorGroupView.setReceivePayments(operatorGroupDTO.isReceivePayments());
        operatorGroupView.setRedeemVouchers(operatorGroupDTO.isVoucherTransactions());
        operatorGroupView.setVoucherTransactions(operatorGroupDTO.isVoucherTransactions());
        operatorGroupView.setBrokering(operatorGroupDTO.isBrokering());
        operatorGroupView.setRequestPayments(operatorGroupDTO.isRequestPayments());
        operatorGroupView.setChargebackPayments(operatorGroupDTO.isChargebackPayments());
        operatorGroupView.setViewAdvertisements(operatorGroupDTO.isViewAdvertisements());
        operatorGroupView.setManageAdvertisements(operatorGroupDTO.isManageAdvertisements());
        operatorGroupView.setEnableToken(operatorGroupDTO.isEnableTokenPrincipalType());
        operatorGroupView.setCancelToken(operatorGroupDTO.isCancelTokenPrincipalType());
        operatorGroupView.setBlockToken(operatorGroupDTO.isBlockTokenPrincipalType());
        operatorGroupView.setUnblockToken(operatorGroupDTO.isUnblockTokenPrincipalType());
        CollectionHelper.orEmpty((Set)operatorGroupDTO.getRestrictPaymentsToUsers()).stream().map(this.usersApiHelper::toUser).sorted(Comparator.comparing(User::getDisplay)).forEach(operatorGroupView.getRestrictPaymentsToUsers()::add);
        CollectionHelper.orEmpty((Set)operatorGroupDTO.getCustomOperations()).stream().map(this.operationsApiHelper::toOperation).forEach(operatorGroupView.getOperations()::add);
        CollectionHelper.orEmpty((Set)operatorGroupDTO.getCustomWizards()).stream().map(this.wizardsApiHelper::toWizard).forEach(operatorGroupView.getWizards()::add);
        CollectionHelper.orEmpty((Set)operatorGroupDTO.getRecordTypes()).stream().map(this.recordsApiHelper::toRecordType).forEach(operatorGroupView.getRecords()::add);
        operatorGroupView.setAccounts(this.toAccountsView(operatorGroupDTO));
        CollectionHelper.orEmpty((List)operatorGroupDTO.getPaymentTypes()).stream().map(this::toPaymentView).forEach(operatorGroupView.getPayments()::add);
        return operatorGroupView;
    }

    public UserOperatorGroupsListData toUserOperatorGroupsListData(OperatorGroupListData operatorGroupListData) {
        if (operatorGroupListData == null) {
            return null;
        }
        UserOperatorGroupsListData userOperatorGroupsListData = new UserOperatorGroupsListData();
        userOperatorGroupsListData.setUser(this.usersApiHelper.toUser((BasicUserVO)operatorGroupListData.getUser()));
        userOperatorGroupsListData.setCanCreate(operatorGroupListData.isCanManage());
        userOperatorGroupsListData.setCanEdit(operatorGroupListData.isCanManage());
        CollectionHelper.orEmpty((List)operatorGroupListData.getGroups()).stream().map(this.apiHelper::toReference).forEach(userOperatorGroupsListData.getOperatorGroups()::add);
        return userOperatorGroupsListData;
    }

    private <T extends OperatorGroupAccount> T newOperatorGroupAccount(Class<T> clazz, OperatorGroupAccountTypeDTO operatorGroupAccountTypeDTO, Map<AccountTypeWithCurrencyVO, AccountNotificationSettingsDTO> map) {
        OperatorGroupAccount operatorGroupAccount = (OperatorGroupAccount)ClassHelper.instantiate(clazz);
        operatorGroupAccount.setAccess(this.toOperatorGroupAccountAccessEnum(operatorGroupAccountTypeDTO.getAccess()));
        AccountNotificationSettingsDTO accountNotificationSettingsDTO = map.get(operatorGroupAccountTypeDTO.getAccountType());
        if (accountNotificationSettingsDTO != null) {
            operatorGroupAccount.setNotificationAmount(this.apiHelper.toDecimalRange(accountNotificationSettingsDTO.getPaymentAmount()));
        }
        return (T)operatorGroupAccount;
    }

    private <D extends OperatorGroupBasicData> D newOperatorGroupBasicData(Class<D> clazz, OperatorGroupData operatorGroupData) {
        OperatorGroupBasicData operatorGroupBasicData = (OperatorGroupBasicData)ClassHelper.instantiate(clazz);
        operatorGroupBasicData.setUser(this.usersApiHelper.toUser((BasicUserVO)((OperatorGroupDTO)operatorGroupData.getDto()).getUser()));
        operatorGroupBasicData.setCanChargebackPayments(operatorGroupData.isCanChargebackPayments());
        operatorGroupBasicData.setCanReceivePayments(operatorGroupData.isCanReceivePayments());
        operatorGroupBasicData.setCanRequestPayments(operatorGroupData.isCanRequestPayments());
        operatorGroupBasicData.setCanPerformVoucherTransactions(operatorGroupData.isCanPerformVoucherTransactions());
        operatorGroupBasicData.setCanRedeemVouchers(operatorGroupData.isCanPerformVoucherTransactions());
        operatorGroupBasicData.setCanViewAdvertisements(operatorGroupData.isCanViewAdvertisements());
        operatorGroupBasicData.setCanManageAdvertisements(operatorGroupData.isCanManageAdvertisements());
        operatorGroupBasicData.setCanBlockToken(operatorGroupData.isCanBlockTokenPrincipalTypes());
        operatorGroupBasicData.setCanCancelToken(operatorGroupData.isCanCancelTokenPrincipalTypes());
        operatorGroupBasicData.setCanEnableToken(operatorGroupData.isCanEnableTokenPrincipalTypes());
        operatorGroupBasicData.setCanUnblockToken(operatorGroupData.isCanUnblockTokenPrincipalTypes());
        operatorGroupBasicData.setBroker(operatorGroupData.isBroker());
        operatorGroupBasicData.setCanHaveMessages(operatorGroupData.isCanHaveMessages());
        operatorGroupBasicData.setCanHaveNotifications(operatorGroupData.isCanHaveNotifications());
        operatorGroupBasicData.setTopUpEnabled(operatorGroupData.isVoucherTopUpEnabled());
        CollectionHelper.orEmpty((List)operatorGroupData.getCustomOperations()).stream().map(this.operationsApiHelper::toOperation).forEach(operatorGroupBasicData.getOperations()::add);
        CollectionHelper.orEmpty((List)operatorGroupData.getCustomWizards()).stream().map(this.wizardsApiHelper::toWizard).forEach(operatorGroupBasicData.getWizards()::add);
        CollectionHelper.orEmpty((List)operatorGroupData.getRecordTypes()).stream().map(this.recordsApiHelper::toRecordType).forEach(operatorGroupBasicData.getRecordTypes()::add);
        CollectionHelper.orEmpty((List)((OperatorGroupDTO)operatorGroupData.getDto()).getAccountTypes()).stream().map(operatorGroupAccountTypeDTO -> this.accountsApiHelper.toAccountType((AccountTypeVO)operatorGroupAccountTypeDTO.getAccountType())).forEach(operatorGroupBasicData.getAccountTypes()::add);
        CollectionHelper.orEmpty((List)((OperatorGroupDTO)operatorGroupData.getDto()).getPaymentTypes()).stream().map(operatorGroupPaymentTypeDTO -> this.accountsApiHelper.toTransferTypeWithCurrency(operatorGroupPaymentTypeDTO.getPaymentType())).forEach(operatorGroupBasicData.getPaymentTypes()::add);
        return (D)operatorGroupBasicData;
    }

    private <T extends OperatorGroupManage> T newOperatorGroupManage(Class<T> clazz, OperatorGroupDTO operatorGroupDTO) {
        OperatorGroupManage operatorGroupManage = (OperatorGroupManage)ClassHelper.instantiate(clazz);
        operatorGroupManage.setName(operatorGroupDTO.getName());
        operatorGroupManage.setDescription(operatorGroupDTO.getDescription());
        operatorGroupManage.setEditOwnProfile(operatorGroupDTO.isEditOwnProfile());
        operatorGroupManage.setMessages(operatorGroupDTO.isMessages());
        operatorGroupManage.setNotifications(operatorGroupDTO.isNotifications());
        operatorGroupManage.setReceivePayments(operatorGroupDTO.isReceivePayments());
        operatorGroupManage.setChargebackPayments(operatorGroupDTO.isChargebackPayments());
        operatorGroupManage.setVoucherTransactions(operatorGroupDTO.isVoucherTransactions());
        operatorGroupManage.setRedeemVouchers(operatorGroupDTO.isVoucherTransactions());
        operatorGroupManage.setBrokering(operatorGroupDTO.isBrokering());
        operatorGroupManage.setRequestPayments(operatorGroupDTO.isRequestPayments());
        operatorGroupManage.setViewAdvertisements(operatorGroupDTO.isViewAdvertisements());
        operatorGroupManage.setManageAdvertisements(operatorGroupDTO.isManageAdvertisements());
        operatorGroupManage.setEnableToken(operatorGroupDTO.isEnableTokenPrincipalType());
        operatorGroupManage.setCancelToken(operatorGroupDTO.isCancelTokenPrincipalType());
        operatorGroupManage.setBlockToken(operatorGroupDTO.isBlockTokenPrincipalType());
        operatorGroupManage.setUnblockToken(operatorGroupDTO.isUnblockTokenPrincipalType());
        CollectionHelper.orEmpty((Set)operatorGroupDTO.getRestrictPaymentsToUsers()).stream().map(EntityModel::getId).map(ApiHelper::toId).forEach(operatorGroupManage.getRestrictPaymentsToUsers()::add);
        CollectionHelper.orEmpty((Set)operatorGroupDTO.getCustomOperations()).stream().map(ModelHelper::stringOrIdFromVO).forEach(operatorGroupManage.getOperations()::add);
        CollectionHelper.orEmpty((Set)operatorGroupDTO.getCustomWizards()).stream().map(ModelHelper::stringOrIdFromVO).forEach(operatorGroupManage.getWizards()::add);
        CollectionHelper.orEmpty((Set)operatorGroupDTO.getRecordTypes()).stream().map(ModelHelper::stringOrIdFromVO).forEach(operatorGroupManage.getRecords()::add);
        operatorGroupManage.setAccounts(this.toAccounts(operatorGroupDTO));
        for (OperatorGroupPaymentTypeDTO operatorGroupPaymentTypeDTO : CollectionHelper.orEmpty((List)operatorGroupDTO.getPaymentTypes())) {
            operatorGroupManage.getPayments().put(ModelHelper.internalNameOrId((IEntity)operatorGroupPaymentTypeDTO.getPaymentType()), this.toPayment(operatorGroupPaymentTypeDTO));
        }
        return (T)operatorGroupManage;
    }

    private <T extends OperatorGroupPayment> T newOperatorGroupPayment(Class<T> clazz, OperatorGroupPaymentTypeDTO operatorGroupPaymentTypeDTO) {
        OperatorGroupPayment operatorGroupPayment = (OperatorGroupPayment)ClassHelper.instantiate(clazz);
        operatorGroupPayment.setAuthorize(operatorGroupPaymentTypeDTO.isAuthorize());
        operatorGroupPayment.setPerform(operatorGroupPaymentTypeDTO.isEnabled());
        operatorGroupPayment.setRequiresAuthorization(operatorGroupPaymentTypeDTO.isRequiresAuthorization());
        operatorGroupPayment.setMaxAmountPerDay(operatorGroupPaymentTypeDTO.getMaxAmountPerDay());
        return (T)operatorGroupPayment;
    }

    private List<AccountNotificationSettingsDTO> toAccountNotificationSettings(Map<String, OperatorGroupAccount> map) {
        if (CollectionHelper.isEmpty(map)) {
            return Collections.emptyList();
        }
        ArrayList<AccountNotificationSettingsDTO> arrayList = new ArrayList<AccountNotificationSettingsDTO>(map.size());
        for (Map.Entry<String, OperatorGroupAccount> entry : map.entrySet()) {
            OperatorGroupAccount operatorGroupAccount = entry.getValue();
            if (operatorGroupAccount == null) continue;
            AccountNotificationSettingsDTO accountNotificationSettingsDTO = new AccountNotificationSettingsDTO();
            accountNotificationSettingsDTO.setAccountType((AccountTypeWithCurrencyVO)ModelHelper.voFromString(AccountTypeWithCurrencyVO.class, (String)entry.getKey()));
            accountNotificationSettingsDTO.setPaymentAmount(this.apiHelper.toDecimalRangeDTO(operatorGroupAccount.getNotificationAmount()));
            arrayList.add(accountNotificationSettingsDTO);
        }
        return arrayList;
    }

    private Map<String, OperatorGroupAccount> toAccounts(OperatorGroupDTO operatorGroupDTO) {
        List list = operatorGroupDTO.getAccountTypes();
        if (CollectionHelper.isEmpty((Iterable)list)) {
            return Collections.emptyMap();
        }
        Map<AccountTypeWithCurrencyVO, AccountNotificationSettingsDTO> map = CollectionHelper.orEmpty((List)operatorGroupDTO.getAccountNotificationSettings()).stream().collect(Collectors.toMap(AccountNotificationSettingsDTO::getAccountType, accountNotificationSettingsDTO -> accountNotificationSettingsDTO));
        HashMap<String, OperatorGroupAccount> hashMap = new HashMap<String, OperatorGroupAccount>(list.size());
        for (OperatorGroupAccountTypeDTO operatorGroupAccountTypeDTO : list) {
            OperatorGroupAccount operatorGroupAccount = this.newOperatorGroupAccount(OperatorGroupAccount.class, operatorGroupAccountTypeDTO, map);
            hashMap.put(ModelHelper.internalNameOrId((IEntity)operatorGroupAccountTypeDTO.getAccountType()), operatorGroupAccount);
        }
        return hashMap;
    }

    private List<OperatorGroupAccountView> toAccountsView(OperatorGroupDTO operatorGroupDTO) {
        List list = operatorGroupDTO.getAccountTypes();
        if (CollectionHelper.isEmpty((Iterable)list)) {
            return Collections.emptyList();
        }
        Map<AccountTypeWithCurrencyVO, AccountNotificationSettingsDTO> map = CollectionHelper.orEmpty((List)operatorGroupDTO.getAccountNotificationSettings()).stream().collect(Collectors.toMap(AccountNotificationSettingsDTO::getAccountType, accountNotificationSettingsDTO -> accountNotificationSettingsDTO));
        ArrayList<OperatorGroupAccountView> arrayList = new ArrayList<OperatorGroupAccountView>(list.size());
        for (OperatorGroupAccountTypeDTO operatorGroupAccountTypeDTO : list) {
            OperatorGroupAccountView operatorGroupAccountView = this.newOperatorGroupAccount(OperatorGroupAccountView.class, operatorGroupAccountTypeDTO, map);
            operatorGroupAccountView.setAccountType(this.accountsApiHelper.toAccountType((AccountTypeVO)operatorGroupAccountTypeDTO.getAccountType()));
            arrayList.add(operatorGroupAccountView);
        }
        return arrayList;
    }

    private List<OperatorGroupAccountTypeDTO> toAccountTypes(Map<String, OperatorGroupAccount> map) {
        if (CollectionHelper.isEmpty(map)) {
            return Collections.emptyList();
        }
        ArrayList<OperatorGroupAccountTypeDTO> arrayList = new ArrayList<OperatorGroupAccountTypeDTO>(map.size());
        for (Map.Entry<String, OperatorGroupAccount> entry : map.entrySet()) {
            OperatorGroupAccount operatorGroupAccount = entry.getValue();
            if (operatorGroupAccount == null) continue;
            OperatorGroupAccountTypeDTO operatorGroupAccountTypeDTO = new OperatorGroupAccountTypeDTO();
            operatorGroupAccountTypeDTO.setAccountType((AccountTypeWithCurrencyVO)ModelHelper.voFromString(AccountTypeWithCurrencyVO.class, (String)entry.getKey()));
            operatorGroupAccountTypeDTO.setAccess(this.toOperatorGroupAccountAccess(operatorGroupAccount.getAccess()));
            arrayList.add(operatorGroupAccountTypeDTO);
        }
        return arrayList;
    }

    private OperatorGroupAccountAccess toOperatorGroupAccountAccess(OperatorGroupAccountAccessEnum operatorGroupAccountAccessEnum) {
        if (operatorGroupAccountAccessEnum != null) {
            switch (operatorGroupAccountAccessEnum) {
                case NONE: {
                    return OperatorGroupAccountAccess.NONE;
                }
                case OWN: {
                    return OperatorGroupAccountAccess.OWN_PAYMENTS;
                }
                case INCOMING: {
                    return OperatorGroupAccountAccess.INCOMING_PAYMENTS;
                }
                case OUTGOING: {
                    return OperatorGroupAccountAccess.OUTGOING_PAYMENTS;
                }
                case FULL: {
                    return OperatorGroupAccountAccess.ALL_PAYMENTS;
                }
            }
        }
        return null;
    }

    private OperatorGroupAccountAccessEnum toOperatorGroupAccountAccessEnum(OperatorGroupAccountAccess operatorGroupAccountAccess) {
        if (operatorGroupAccountAccess != null) {
            switch (operatorGroupAccountAccess) {
                case NONE: {
                    return OperatorGroupAccountAccessEnum.NONE;
                }
                case OWN_PAYMENTS: {
                    return OperatorGroupAccountAccessEnum.OWN;
                }
                case INCOMING_PAYMENTS: {
                    return OperatorGroupAccountAccessEnum.INCOMING;
                }
                case OUTGOING_PAYMENTS: {
                    return OperatorGroupAccountAccessEnum.OUTGOING;
                }
                case ALL_PAYMENTS: {
                    return OperatorGroupAccountAccessEnum.FULL;
                }
            }
        }
        return null;
    }

    private OperatorGroupEdit toOperatorGroupEdit(OperatorGroupDTO operatorGroupDTO) {
        if (operatorGroupDTO == null) {
            return null;
        }
        OperatorGroupEdit operatorGroupEdit = this.newOperatorGroupManage(OperatorGroupEdit.class, operatorGroupDTO);
        operatorGroupEdit.setVersion(operatorGroupDTO.getVersion());
        return operatorGroupEdit;
    }

    private OperatorGroupNew toOperatorGroupNew(OperatorGroupDTO operatorGroupDTO) {
        if (operatorGroupDTO == null) {
            return null;
        }
        return this.newOperatorGroupManage(OperatorGroupNew.class, operatorGroupDTO);
    }

    private OperatorGroupPayment toPayment(OperatorGroupPaymentTypeDTO operatorGroupPaymentTypeDTO) {
        if (operatorGroupPaymentTypeDTO == null) {
            return null;
        }
        return this.newOperatorGroupPayment(OperatorGroupPayment.class, operatorGroupPaymentTypeDTO);
    }

    private List<OperatorGroupPaymentTypeDTO> toPaymentTypes(Map<String, OperatorGroupPayment> map) {
        if (CollectionHelper.isEmpty(map)) {
            return Collections.emptyList();
        }
        ArrayList<OperatorGroupPaymentTypeDTO> arrayList = new ArrayList<OperatorGroupPaymentTypeDTO>(map.size());
        for (Map.Entry<String, OperatorGroupPayment> entry : map.entrySet()) {
            OperatorGroupPayment operatorGroupPayment = entry.getValue();
            if (operatorGroupPayment == null) continue;
            OperatorGroupPaymentTypeDTO operatorGroupPaymentTypeDTO = new OperatorGroupPaymentTypeDTO();
            operatorGroupPaymentTypeDTO.setPaymentType((TransferTypeWithCurrencyVO)ModelHelper.voFromString(TransferTypeWithCurrencyVO.class, (String)entry.getKey()));
            operatorGroupPaymentTypeDTO.setAuthorize(Boolean.TRUE.equals(operatorGroupPayment.getAuthorize()));
            operatorGroupPaymentTypeDTO.setEnabled(Boolean.TRUE.equals(operatorGroupPayment.getPerform()));
            operatorGroupPaymentTypeDTO.setRequiresAuthorization(Boolean.TRUE.equals(operatorGroupPayment.getRequiresAuthorization()));
            operatorGroupPaymentTypeDTO.setMaxAmountPerDay(operatorGroupPayment.getMaxAmountPerDay());
            arrayList.add(operatorGroupPaymentTypeDTO);
        }
        return arrayList;
    }

    private OperatorGroupPaymentView toPaymentView(OperatorGroupPaymentTypeDTO operatorGroupPaymentTypeDTO) {
        if (operatorGroupPaymentTypeDTO == null) {
            return null;
        }
        OperatorGroupPaymentView operatorGroupPaymentView = this.newOperatorGroupPayment(OperatorGroupPaymentView.class, operatorGroupPaymentTypeDTO);
        operatorGroupPaymentView.setPaymentType(this.accountsApiHelper.toTransferTypeWithCurrency(operatorGroupPaymentTypeDTO.getPaymentType()));
        return operatorGroupPaymentView;
    }
}

