/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.helpers;

import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.cyclos.model.EntityModel;
import org.cyclos.model.EntityVO;
import org.cyclos.model.IEntity;
import org.cyclos.model.QueryParameters;
import org.cyclos.model.system.fields.CustomFieldDetailedVO;
import org.cyclos.model.users.groups.GroupVO;
import org.cyclos.model.users.operatorgroups.OperatorGroupVO;
import org.cyclos.model.users.operators.OperatorDTO;
import org.cyclos.model.users.operators.OperatorDataParams;
import org.cyclos.model.users.operators.OperatorQuery;
import org.cyclos.model.users.operators.OperatorRegistrationDTO;
import org.cyclos.model.users.operators.OperatorRegistrationData;
import org.cyclos.model.users.operators.OperatorWithFieldsVO;
import org.cyclos.model.users.operators.OperatorsSearchData;
import org.cyclos.model.users.users.BasicProfileField;
import org.cyclos.model.users.users.BasicUserDTO;
import org.cyclos.model.users.users.BasicUserData;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.model.users.users.DataWithBasicProfileFields;
import org.cyclos.model.users.users.IUserWithFieldsVO;
import org.cyclos.model.users.users.ProfileField;
import org.cyclos.model.users.users.SimpleBasicUserRegistrationDTO;
import org.cyclos.model.users.users.SimpleBasicUserRegistrationData;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.users.users.UserVO;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.web.rest.helpers.ApiHelper;
import org.cyclos.web.rest.helpers.GroupsApiHelper;
import org.cyclos.web.rest.helpers.UserStatusApiHelper;
import org.cyclos.web.rest.helpers.UsersApiHelper;
import org.cyclos.web.rest.model.BasicOperatorQueryFilters;
import org.cyclos.web.rest.model.GeneralOperatorsDataForSearch;
import org.cyclos.web.rest.model.GeneralOperatorsQueryFilters;
import org.cyclos.web.rest.model.OperatorDataForNew;
import org.cyclos.web.rest.model.OperatorNew;
import org.cyclos.web.rest.model.OperatorResult;
import org.cyclos.web.rest.model.UserOperatorsDataForSearch;
import org.cyclos.web.rest.model.UserOperatorsQueryFilters;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OperatorsApiHelper {
    @Autowired
    private ApiHelper apiHelper;
    @Autowired
    private UsersApiHelper usersApiHelper;
    @Autowired
    private UserStatusApiHelper userStatusApiHelper;
    @Autowired
    private GroupsApiHelper groupsApiHelper;

    public GeneralOperatorsDataForSearch toGeneralOperatorsDataForSearch(OperatorsSearchData operatorsSearchData) {
        if (operatorsSearchData == null) {
            return null;
        }
        GeneralOperatorsDataForSearch generalOperatorsDataForSearch = new GeneralOperatorsDataForSearch();
        CollectionHelper.orEmpty((List)operatorsSearchData.getUserGroups()).stream().map(this.groupsApiHelper::toGroup).forEach(generalOperatorsDataForSearch.getUserGroups()::add);
        generalOperatorsDataForSearch.setQuery(this.toGeneralOperatorsQueryFilters((OperatorQuery)operatorsSearchData.getQuery()));
        return generalOperatorsDataForSearch;
    }

    public GeneralOperatorsQueryFilters toGeneralOperatorsQueryFilters(OperatorQuery operatorQuery) {
        GeneralOperatorsQueryFilters generalOperatorsQueryFilters = this.newBasicOperatorQueryFilters(GeneralOperatorsQueryFilters.class, operatorQuery);
        generalOperatorsQueryFilters.setBroker(ModelHelper.stringOrIdFromVO((EntityVO)operatorQuery.getBroker()));
        CollectionHelper.orEmpty((Set)operatorQuery.getUserGroups()).stream().map(ModelHelper::stringOrIdFromVO).forEach(generalOperatorsQueryFilters.getUserGroups()::add);
        return generalOperatorsQueryFilters;
    }

    public OperatorDataForNew toOperatorDataForNew(OperatorRegistrationData operatorRegistrationData) {
        OperatorDataForNew operatorDataForNew = this.usersApiHelper.newBasicData(OperatorDataForNew.class, (BasicUserData<?>)operatorRegistrationData);
        this.usersApiHelper.fillBasicUserDataForNew(operatorDataForNew, (SimpleBasicUserRegistrationData)operatorRegistrationData);
        operatorDataForNew.setUser(this.usersApiHelper.toUser((BasicUserVO)((OperatorDTO)operatorRegistrationData.getDto()).getUser()));
        operatorDataForNew.setOperator(this.toOperatorNew((OperatorRegistrationDTO)operatorRegistrationData.getDto()));
        CollectionHelper.orEmpty((List)operatorRegistrationData.getGroups()).stream().map(this.apiHelper::toReference).forEach(operatorDataForNew.getGroups()::add);
        return operatorDataForNew;
    }

    public OperatorDataParams toOperatorDataParams(String string, String string2) {
        OperatorDataParams operatorDataParams = new OperatorDataParams();
        operatorDataParams.setUser((UserLocatorVO)ModelHelper.voFromString(UserLocatorVO.class, (String)string));
        operatorDataParams.setGroupId(this.apiHelper.fromId(string2));
        return operatorDataParams;
    }

    public OperatorNew toOperatorNew(OperatorRegistrationDTO operatorRegistrationDTO) {
        OperatorNew operatorNew = this.usersApiHelper.newBasicUserManage(OperatorNew.class, (BasicUserDTO)operatorRegistrationDTO);
        this.usersApiHelper.fillBasicUserNew(operatorNew, (SimpleBasicUserRegistrationDTO)operatorRegistrationDTO);
        operatorNew.setGroup(ModelHelper.internalNameOrId((IEntity)operatorRegistrationDTO.getGroup()));
        operatorNew.setCustomValues(this.apiHelper.toCustomFieldValuesMap(operatorRegistrationDTO.getCustomValues()));
        return operatorNew;
    }

    public OperatorQuery toOperatorQuery(GeneralOperatorsQueryFilters generalOperatorsQueryFilters) {
        if (generalOperatorsQueryFilters == null) {
            return null;
        }
        OperatorQuery operatorQuery = this.newOperatorQuery(generalOperatorsQueryFilters);
        operatorQuery.setIgnoreProfileFieldsInList(true);
        operatorQuery.setReturnUser(true);
        operatorQuery.setBroker((UserVO)ModelHelper.voFromString(UserVO.class, (String)generalOperatorsQueryFilters.getBroker()));
        operatorQuery.setUserGroups(CollectionHelper.orEmpty(generalOperatorsQueryFilters.getUserGroups()).stream().map(string -> (GroupVO)ModelHelper.voFromString(GroupVO.class, (String)string)).collect(Collectors.toSet()));
        return operatorQuery;
    }

    public OperatorQuery toOperatorQuery(String string, UserOperatorsQueryFilters userOperatorsQueryFilters) {
        if (userOperatorsQueryFilters == null) {
            return null;
        }
        OperatorQuery operatorQuery = this.newOperatorQuery(userOperatorsQueryFilters);
        operatorQuery.setReturnUser(false);
        operatorQuery.setUser((UserVO)ModelHelper.voFromString(UserVO.class, (String)string));
        operatorQuery.setIgnoreProfileFieldsInList(Boolean.TRUE.equals(userOperatorsQueryFilters.getIgnoreProfileFieldsInList()));
        operatorQuery.setOperatorGroups(CollectionHelper.orEmpty(userOperatorsQueryFilters.getOperatorGroups()).stream().map(this.apiHelper::fromId).map(OperatorGroupVO::new).collect(Collectors.toSet()));
        return operatorQuery;
    }

    public OperatorRegistrationDTO toOperatorRegistrationDTO(String string, OperatorNew operatorNew) {
        OperatorRegistrationDTO operatorRegistrationDTO = new OperatorRegistrationDTO();
        operatorRegistrationDTO.setUser((UserVO)ModelHelper.voFromString(UserVO.class, (String)string));
        operatorRegistrationDTO.setGroup((OperatorGroupVO)ModelHelper.voFromString(OperatorGroupVO.class, (String)operatorNew.getGroup()));
        this.usersApiHelper.fillDTO(operatorRegistrationDTO, operatorNew);
        this.usersApiHelper.fillRegistrationDTO(operatorRegistrationDTO, operatorNew);
        operatorRegistrationDTO.setCustomValues(this.apiHelper.toCustomFieldValuesDTO(operatorNew.getCustomValues()));
        return operatorRegistrationDTO;
    }

    public OperatorResult toOperatorResult(OperatorWithFieldsVO operatorWithFieldsVO) {
        OperatorResult operatorResult = this.usersApiHelper.newUserResult(OperatorResult.class, (IUserWithFieldsVO)operatorWithFieldsVO);
        operatorResult.setUser(this.usersApiHelper.toUser((BasicUserVO)operatorWithFieldsVO.getUser()));
        operatorResult.setGroup(this.apiHelper.toReference((EntityModel)operatorWithFieldsVO.getGroup()));
        return operatorResult;
    }

    public UserOperatorsDataForSearch toUserOperatorsDataForSearch(OperatorsSearchData operatorsSearchData) {
        if (operatorsSearchData == null) {
            return null;
        }
        UserOperatorsDataForSearch userOperatorsDataForSearch = new UserOperatorsDataForSearch();
        userOperatorsDataForSearch.setUser(this.usersApiHelper.toUser((BasicUserVO)operatorsSearchData.getUser()));
        userOperatorsDataForSearch.setCanCreateNew(operatorsSearchData.isCanCreateNew());
        CollectionHelper.orEmpty((List)operatorsSearchData.getOperatorGroups()).stream().map(this.apiHelper::toReference).forEach(userOperatorsDataForSearch.getGroups()::add);
        EnumSet<BasicProfileField> enumSet = EnumSet.noneOf(BasicProfileField.class);
        LinkedHashSet<CustomFieldDetailedVO> linkedHashSet = new LinkedHashSet<CustomFieldDetailedVO>();
        for (ProfileField profileField : operatorsSearchData.getProfileFieldsInList()) {
            if (profileField instanceof CustomFieldDetailedVO) {
                linkedHashSet.add((CustomFieldDetailedVO)profileField);
            } else if (profileField instanceof BasicProfileField) {
                enumSet.add((BasicProfileField)profileField);
            }
            userOperatorsDataForSearch.getFieldsInList().add(this.usersApiHelper.internalName(profileField));
        }
        linkedHashSet.stream().map(this.apiHelper::toCustomFieldDetailed).forEach(userOperatorsDataForSearch.getCustomFields()::add);
        enumSet.stream().map(basicProfileField -> this.usersApiHelper.toBasicProfileFieldInput((BasicProfileField)basicProfileField, (DataWithBasicProfileFields)operatorsSearchData)).forEach(userOperatorsDataForSearch.getBasicFields()::add);
        userOperatorsDataForSearch.setQuery(this.toUserOperatorsQueryFilters((OperatorQuery)operatorsSearchData.getQuery()));
        return userOperatorsDataForSearch;
    }

    public UserOperatorsQueryFilters toUserOperatorsQueryFilters(OperatorQuery operatorQuery) {
        UserOperatorsQueryFilters userOperatorsQueryFilters = this.newBasicOperatorQueryFilters(UserOperatorsQueryFilters.class, operatorQuery);
        if (operatorQuery.isIgnoreProfileFieldsInList()) {
            userOperatorsQueryFilters.setIgnoreProfileFieldsInList(true);
        }
        CollectionHelper.orEmpty((Set)operatorQuery.getOperatorGroups()).stream().map(ModelHelper::stringOrIdFromVO).forEach(userOperatorsQueryFilters.getOperatorGroups()::add);
        return userOperatorsQueryFilters;
    }

    private <F extends BasicOperatorQueryFilters> F newBasicOperatorQueryFilters(Class<F> clazz, OperatorQuery operatorQuery) {
        BasicOperatorQueryFilters basicOperatorQueryFilters = (BasicOperatorQueryFilters)this.apiHelper.newQueryFilters(clazz, (QueryParameters)operatorQuery);
        basicOperatorQueryFilters.setCreationPeriod(this.apiHelper.toFilter(operatorQuery.getCreated()));
        basicOperatorQueryFilters.setKeywords(operatorQuery.getKeywords());
        CollectionHelper.orEmpty((Set)operatorQuery.getUserStatus()).stream().map(this.userStatusApiHelper::toUserStatusEnum).forEach(basicOperatorQueryFilters.getStatuses()::add);
        return (F)basicOperatorQueryFilters;
    }

    private OperatorQuery newOperatorQuery(BasicOperatorQueryFilters basicOperatorQueryFilters) {
        OperatorQuery operatorQuery = this.apiHelper.newQuery(OperatorQuery.class, basicOperatorQueryFilters);
        operatorQuery.setKeywords(basicOperatorQueryFilters.getKeywords());
        operatorQuery.setCreated(this.apiHelper.toDatePeriodDTO(basicOperatorQueryFilters.getCreationPeriod()));
        operatorQuery.setUserStatus(CollectionHelper.orEmpty(basicOperatorQueryFilters.getStatuses()).stream().map(this.userStatusApiHelper::toUserStatus).collect(Collectors.toSet()));
        return operatorQuery;
    }
}

