/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.helpers;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.EntityVO;
import org.cyclos.model.QueryParameters;
import org.cyclos.model.banking.currencies.CurrencyVO;
import org.cyclos.model.banking.transfertypes.TransferTypeVO;
import org.cyclos.model.marketplace.advertisements.AdWebShopVO;
import org.cyclos.model.marketplace.webshoporders.AcceptOrderParams;
import org.cyclos.model.marketplace.webshoporders.IOrder;
import org.cyclos.model.marketplace.webshoporders.OrderActionParams;
import org.cyclos.model.marketplace.webshoporders.OrderAddressDTO;
import org.cyclos.model.marketplace.webshoporders.OrderDTO;
import org.cyclos.model.marketplace.webshoporders.OrderData;
import org.cyclos.model.marketplace.webshoporders.OrderDataParams;
import org.cyclos.model.marketplace.webshoporders.OrderLogVO;
import org.cyclos.model.marketplace.webshoporders.OrderProductDTO;
import org.cyclos.model.marketplace.webshoporders.OrderQuery;
import org.cyclos.model.marketplace.webshoporders.OrderSearchData;
import org.cyclos.model.marketplace.webshoporders.OrderStatus;
import org.cyclos.model.marketplace.webshoporders.OrderVO;
import org.cyclos.model.marketplace.webshoporders.RejectOrderParams;
import org.cyclos.model.marketplace.webshoporders.SetDeliveryMethodParams;
import org.cyclos.model.users.addresses.IAddress;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.users.users.UserVO;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.server.utils.ClassHelper;
import org.cyclos.utils.BigDecimalHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.StringHelper;
import org.cyclos.web.rest.helpers.AccountsApiHelper;
import org.cyclos.web.rest.helpers.AddressesApiHelper;
import org.cyclos.web.rest.helpers.ApiHelper;
import org.cyclos.web.rest.helpers.AuthApiHelper;
import org.cyclos.web.rest.helpers.DeliveryMethodsApiHelper;
import org.cyclos.web.rest.helpers.ImagesApiHelper;
import org.cyclos.web.rest.helpers.MarketplaceApiHelper;
import org.cyclos.web.rest.helpers.UsersApiHelper;
import org.cyclos.web.rest.model.AcceptOrderByBuyer;
import org.cyclos.web.rest.model.AcceptOrderBySeller;
import org.cyclos.web.rest.model.BaseOrderAction;
import org.cyclos.web.rest.model.BaseOrderItem;
import org.cyclos.web.rest.model.OrderBasicData;
import org.cyclos.web.rest.model.OrderDataForAcceptByBuyer;
import org.cyclos.web.rest.model.OrderDataForEdit;
import org.cyclos.web.rest.model.OrderDataForNew;
import org.cyclos.web.rest.model.OrderDataForSearch;
import org.cyclos.web.rest.model.OrderDataForSetDeliveryMethod;
import org.cyclos.web.rest.model.OrderDeliveryMethod;
import org.cyclos.web.rest.model.OrderEdit;
import org.cyclos.web.rest.model.OrderItem;
import org.cyclos.web.rest.model.OrderItemManage;
import org.cyclos.web.rest.model.OrderLog;
import org.cyclos.web.rest.model.OrderManage;
import org.cyclos.web.rest.model.OrderNew;
import org.cyclos.web.rest.model.OrderQueryFilters;
import org.cyclos.web.rest.model.OrderResult;
import org.cyclos.web.rest.model.OrderStatusEnum;
import org.cyclos.web.rest.model.OrderView;
import org.cyclos.web.rest.model.RejectOrder;
import org.cyclos.web.rest.model.SetDeliveryMethod;
import org.cyclos.web.rest.model.SimpleAddress;
import org.cyclos.web.rest.model.UserOrderResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OrdersApiHelper {
    @Autowired
    private ApiHelper apiHelper;
    @Autowired
    private MarketplaceApiHelper marketplaceApiHelper;
    @Autowired
    private DeliveryMethodsApiHelper deliveryMethodsApiHelper;
    @Autowired
    private UsersApiHelper usersApiHelper;
    @Autowired
    private AddressesApiHelper addressesApiHelper;
    @Autowired
    private AuthApiHelper authApiHelper;
    @Autowired
    private AccountsApiHelper accountsApiHelper;
    @Autowired
    private ImagesApiHelper imagesApiHelper;

    public <T extends BaseOrderItem> T newBaseOrderItem(Class<T> clazz, OrderProductDTO orderProductDTO) {
        if (orderProductDTO == null) {
            return null;
        }
        BaseOrderItem baseOrderItem = (BaseOrderItem)this.apiHelper.newEntity(clazz, orderProductDTO);
        baseOrderItem.setQuantity(orderProductDTO.getQuantity());
        baseOrderItem.setProduct(this.marketplaceApiHelper.toWebshopAd(orderProductDTO.getProduct()));
        return (T)baseOrderItem;
    }

    public AcceptOrderParams toAcceptOrderParams(String string, AcceptOrderBySeller acceptOrderBySeller) {
        AcceptOrderParams acceptOrderParams = this.newOrderActionParams(AcceptOrderParams.class, string, acceptOrderBySeller);
        return acceptOrderParams;
    }

    public AcceptOrderParams toAcceptOrderParams(String string, String string2, AcceptOrderByBuyer acceptOrderByBuyer) {
        AcceptOrderParams acceptOrderParams = this.newOrderActionParams(AcceptOrderParams.class, string, acceptOrderByBuyer);
        acceptOrderParams.setConfirmationPassword(string2);
        acceptOrderParams.setPaymentType(acceptOrderByBuyer == null ? null : (TransferTypeVO)ModelHelper.voFromString(TransferTypeVO.class, (String)acceptOrderByBuyer.getPaymentType()));
        return acceptOrderParams;
    }

    public OrderDataForAcceptByBuyer toOrderDataForAcceptByBuyer(OrderData orderData) {
        OrderDataForAcceptByBuyer orderDataForAcceptByBuyer = new OrderDataForAcceptByBuyer();
        CollectionHelper.orEmpty((List)orderData.getPaymentTypes()).stream().map(this.accountsApiHelper::toTransferType).forEach(orderDataForAcceptByBuyer.getPaymentTypes()::add);
        orderDataForAcceptByBuyer.setConfirmationPasswordInput(this.authApiHelper.toPasswordInput(orderData.getConfirmationPasswordInput()));
        return orderDataForAcceptByBuyer;
    }

    public OrderDataForEdit toOrderDataForEdit(OrderData orderData) {
        if (orderData == null) {
            return null;
        }
        OrderDataForEdit orderDataForEdit = this.newOrderData(OrderDataForEdit.class, orderData);
        orderDataForEdit.setCurrency(this.accountsApiHelper.toCurrency(((OrderDTO)orderData.getDto()).getCurrency()));
        orderDataForEdit.setCanEdit(orderData.isEditable());
        orderDataForEdit.setCanRemove(orderData.isRemovable());
        orderDataForEdit.setNumber(((OrderDTO)orderData.getDto()).getNumber());
        orderDataForEdit.setCreationDate(((OrderDTO)orderData.getDto()).getCreationDate());
        orderDataForEdit.setStatus(this.toOrderStatusEnum(((OrderDTO)orderData.getDto()).getStatus()));
        CollectionHelper.orEmpty((List)((OrderDTO)orderData.getDto()).getProducts()).stream().map(OrderProductDTO::getProduct).map(this.marketplaceApiHelper::toWebshopAd).forEach(orderDataForEdit.getItems()::add);
        orderDataForEdit.setOrder(this.toOrderEdit((OrderDTO)orderData.getDto()));
        return orderDataForEdit;
    }

    public OrderDataForNew toOrderDataForNew(OrderData orderData) {
        if (orderData == null) {
            return null;
        }
        OrderDataForNew orderDataForNew = this.newOrderData(OrderDataForNew.class, orderData);
        orderDataForNew.setSeller(this.usersApiHelper.toUser((BasicUserVO)((OrderDTO)orderData.getDto()).getSeller()));
        orderDataForNew.setBuyer(this.usersApiHelper.toUser((BasicUserVO)((OrderDTO)orderData.getDto()).getBuyer()));
        if (CollectionHelper.isEmpty((Iterable)orderData.getCurrencies())) {
            orderDataForNew.getCurrencies().add(this.accountsApiHelper.toCurrency(((OrderDTO)orderData.getDto()).getCurrency()));
        } else {
            CollectionHelper.orEmpty((List)orderData.getCurrencies()).stream().map(this.accountsApiHelper::toCurrency).forEach(orderDataForNew.getCurrencies()::add);
        }
        orderDataForNew.setOrder(this.toOrderNew((OrderDTO)orderData.getDto()));
        return orderDataForNew;
    }

    public OrderDataForSearch toOrderDataForSearch(OrderSearchData orderSearchData) {
        if (orderSearchData == null) {
            return null;
        }
        OrderDataForSearch orderDataForSearch = new OrderDataForSearch();
        orderDataForSearch.setQuery(this.toOrderQueryFilters((OrderQuery)orderSearchData.getQuery()));
        orderDataForSearch.setUser(this.usersApiHelper.toUser((BasicUserVO)orderSearchData.getUser()));
        orderDataForSearch.setCanCreateNew(orderSearchData.isCanCreateNew());
        orderDataForSearch.setNumberMask(orderSearchData.getProductNumberMask());
        CollectionHelper.orEmpty((List)orderSearchData.getCurrencies()).stream().map(this.accountsApiHelper::toCurrency).forEach(orderDataForSearch.getCurrencies()::add);
        return orderDataForSearch;
    }

    public OrderDataForSetDeliveryMethod toOrderDataForSetDeliveryMethod(OrderData orderData) {
        OrderDataForSetDeliveryMethod orderDataForSetDeliveryMethod = new OrderDataForSetDeliveryMethod();
        orderDataForSetDeliveryMethod.setCurrency(this.accountsApiHelper.toCurrency(((OrderDTO)orderData.getDto()).getCurrency()));
        CollectionHelper.orEmpty((List)orderData.getDeliveryMethods()).stream().map(this.deliveryMethodsApiHelper::toDeliveryMethod).forEach(orderDataForSetDeliveryMethod.getDeliveryMethods()::add);
        return orderDataForSetDeliveryMethod;
    }

    public OrderDataParams toOrderDataParams(String string, String string2, String string3) {
        OrderDataParams orderDataParams = new OrderDataParams();
        orderDataParams.setBuyer((UserLocatorVO)ModelHelper.voFromString(UserLocatorVO.class, (String)string2));
        orderDataParams.setSeller((UserLocatorVO)ModelHelper.voFromString(UserLocatorVO.class, (String)string));
        orderDataParams.setCurrency((CurrencyVO)ModelHelper.voFromString(CurrencyVO.class, (String)string3));
        return orderDataParams;
    }

    public OrderDTO toOrderDTO(OrderEdit orderEdit) {
        if (orderEdit == null) {
            return null;
        }
        OrderDTO orderDTO = this.toOrderDTO((OrderManage)orderEdit);
        orderDTO.setVersion(orderEdit.getVersion());
        return orderDTO;
    }

    public OrderDTO toOrderDTO(OrderNew orderNew) {
        if (orderNew == null) {
            return null;
        }
        OrderDTO orderDTO = this.toOrderDTO((OrderManage)orderNew);
        orderDTO.setSale(true);
        orderDTO.setBuyer((UserVO)ModelHelper.voFromString(UserVO.class, (String)orderNew.getBuyer()));
        orderDTO.setCurrency((CurrencyVO)ModelHelper.voFromString(CurrencyVO.class, (String)orderNew.getCurrency()));
        return orderDTO;
    }

    public OrderEdit toOrderEdit(OrderDTO orderDTO) {
        if (orderDTO == null) {
            return null;
        }
        OrderEdit orderEdit = this.newOrderManage(OrderEdit.class, orderDTO);
        orderEdit.setVersion(orderDTO.getVersion());
        return orderEdit;
    }

    public OrderLog toOrderLog(OrderLogVO orderLogVO) {
        if (orderLogVO == null) {
            return null;
        }
        OrderLog orderLog = new OrderLog();
        orderLog.setBy(this.usersApiHelper.toUser(orderLogVO.getBy()));
        orderLog.setDate(orderLogVO.getDate());
        orderLog.setRemarks(orderLogVO.getRemarks());
        orderLog.setStatus(this.toOrderStatusEnum(orderLogVO.getStatus()));
        orderLog.setPendingByAdmin(orderLogVO.isPendingByAdmin());
        return orderLog;
    }

    public OrderNew toOrderNew(OrderDTO orderDTO) {
        if (orderDTO == null) {
            return null;
        }
        OrderNew orderNew = this.newOrderManage(OrderNew.class, orderDTO);
        orderNew.setBuyer(ModelHelper.stringOrIdFromVO((EntityVO)orderDTO.getBuyer()));
        orderNew.setCurrency(ModelHelper.stringOrIdFromVO((EntityVO)orderDTO.getCurrency()));
        return orderNew;
    }

    public OrderQuery toOrderQuery(String string, OrderQueryFilters orderQueryFilters) {
        OrderQuery orderQuery = this.apiHelper.newQuery(OrderQuery.class, orderQueryFilters);
        UserVO userVO = (UserVO)ModelHelper.voFromString(UserVO.class, (String)string);
        orderQuery.setSales(Boolean.TRUE.equals(orderQueryFilters.getSales()));
        if (orderQuery.isSales()) {
            orderQuery.setSeller(userVO);
            orderQuery.setBuyer((UserVO)ModelHelper.voFromString(UserVO.class, (String)orderQueryFilters.getRelatedUser()));
        } else {
            orderQuery.setBuyer(userVO);
            orderQuery.setSeller((UserVO)ModelHelper.voFromString(UserVO.class, (String)orderQueryFilters.getRelatedUser()));
        }
        orderQuery.setPeriod(this.apiHelper.toDatePeriodDTO(orderQueryFilters.getCreationPeriod()));
        orderQuery.setStatus(this.toOrderStatus((OrderStatusEnum)CollectionHelper.first(orderQueryFilters.getStatuses())));
        orderQuery.setNumber(orderQueryFilters.getNumber());
        orderQuery.setProductNumber(orderQueryFilters.getProductNumber());
        return orderQuery;
    }

    public OrderQueryFilters toOrderQueryFilters(OrderQuery orderQuery) {
        if (orderQuery == null) {
            return null;
        }
        OrderQueryFilters orderQueryFilters = this.apiHelper.newQueryFilters(OrderQueryFilters.class, (QueryParameters)orderQuery);
        boolean bl = orderQuery.isSales();
        orderQueryFilters.setSales(bl);
        orderQueryFilters.setRelatedUser(ModelHelper.stringOrIdFromVO((EntityVO)(bl ? orderQuery.getBuyer() : orderQuery.getSeller())));
        orderQueryFilters.setCreationPeriod(this.apiHelper.toFilter(orderQuery.getPeriod()));
        orderQueryFilters.setStatuses(Arrays.asList(this.toOrderStatusEnum(orderQuery.getStatus())));
        orderQueryFilters.setNumber(orderQuery.getNumber());
        orderQueryFilters.setProductNumber(orderQuery.getProductNumber());
        return orderQueryFilters;
    }

    public OrderStatus toOrderStatus(OrderStatusEnum orderStatusEnum) {
        if (orderStatusEnum != null) {
            switch (orderStatusEnum) {
                case COMPLETED: {
                    return OrderStatus.COMPLETED;
                }
                case DISPOSED: {
                    return OrderStatus.DISPOSED;
                }
                case DRAFT: {
                    return OrderStatus.DRAFT;
                }
                case PAYMENT_CANCELED: {
                    return OrderStatus.PAYMENT_CANCELED;
                }
                case PAYMENT_DENIED: {
                    return OrderStatus.PAYMENT_DENIED;
                }
                case PAYMENT_EXPIRED: {
                    return OrderStatus.PAYMENT_EXPIRED;
                }
                case PAYMENT_PENDING: {
                    return OrderStatus.PAYMENT_PENDING;
                }
                case PENDING_BUYER: {
                    return OrderStatus.PENDING_BUYER;
                }
                case PENDING_SELLER: {
                    return OrderStatus.PENDING_SELLER;
                }
                case REJECTED_BY_BUYER: {
                    return OrderStatus.REJECTED_BY_BUYER;
                }
                case REJECTED_BY_SELLER: {
                    return OrderStatus.REJECTED_BY_SELLER;
                }
                case SHOPPING_CART: {
                    return OrderStatus.SHOPPING_CART;
                }
            }
        }
        return null;
    }

    public OrderStatusEnum toOrderStatusEnum(OrderStatus orderStatus) {
        if (orderStatus != null) {
            switch (orderStatus) {
                case COMPLETED: {
                    return OrderStatusEnum.COMPLETED;
                }
                case DISPOSED: {
                    return OrderStatusEnum.DISPOSED;
                }
                case DRAFT: {
                    return OrderStatusEnum.DRAFT;
                }
                case PAYMENT_CANCELED: {
                    return OrderStatusEnum.PAYMENT_CANCELED;
                }
                case PAYMENT_DENIED: {
                    return OrderStatusEnum.PAYMENT_DENIED;
                }
                case PAYMENT_EXPIRED: {
                    return OrderStatusEnum.PAYMENT_EXPIRED;
                }
                case PAYMENT_PENDING: {
                    return OrderStatusEnum.PAYMENT_PENDING;
                }
                case PENDING_BUYER: {
                    return OrderStatusEnum.PENDING_BUYER;
                }
                case PENDING_SELLER: {
                    return OrderStatusEnum.PENDING_SELLER;
                }
                case REJECTED_BY_BUYER: {
                    return OrderStatusEnum.REJECTED_BY_BUYER;
                }
                case REJECTED_BY_SELLER: {
                    return OrderStatusEnum.REJECTED_BY_SELLER;
                }
                case SHOPPING_CART: {
                    return OrderStatusEnum.SHOPPING_CART;
                }
            }
        }
        return null;
    }

    public OrderView toOrderView(OrderData orderData) {
        OrderDTO orderDTO = (OrderDTO)orderData.getDto();
        OrderView orderView = this.newOrderResult(OrderView.class, (IOrder)orderDTO);
        orderView.setBuyer(this.usersApiHelper.toUser((BasicUserVO)orderDTO.getBuyer()));
        orderView.setDeliveryAddress(this.addressesApiHelper.toSimpleAddress((IAddress)orderDTO.getDeliveryAddress()));
        orderView.setDeliveryMethod(this.toOrderDeliveryMethod(orderDTO));
        CollectionHelper.orEmpty((List)orderDTO.getProducts()).stream().map(this::toOrderItem).forEach(orderView.getItems()::add);
        orderView.setPaymentType(this.accountsApiHelper.toTransferType(orderDTO.getPaymentType()));
        orderView.setRemarks(orderDTO.getRemarks());
        orderView.setSale(orderDTO.isSale());
        orderView.setSeller(this.usersApiHelper.toUser((BasicUserVO)orderDTO.getSeller()));
        orderView.setPendingByAdmin(orderDTO.isPendingByAdmin());
        orderView.setCanAccept(orderData.isCanAccept());
        orderView.setCanReject(orderData.isCanReject());
        orderView.setCanSetDeliveryInformation(orderData.isCanSetDeliveryMethod() || orderData.isCanSetDeliveryPrice());
        CollectionHelper.orEmpty((List)orderData.getLogs()).stream().map(this::toOrderLog).forEach(orderView.getHistory()::add);
        CollectionHelper.orEmpty((List)orderData.getExportFormats()).stream().map(this.apiHelper::toExportFormat).forEach(orderView.getExportFormats()::add);
        return orderView;
    }

    public RejectOrderParams toRejectOrderParams(String string, RejectOrder rejectOrder) {
        RejectOrderParams rejectOrderParams = this.newOrderActionParams(RejectOrderParams.class, string, rejectOrder);
        return rejectOrderParams;
    }

    public SetDeliveryMethodParams toSetDeliveryMethodParams(String string, SetDeliveryMethod setDeliveryMethod) {
        SetDeliveryMethodParams setDeliveryMethodParams = this.newOrderActionParams(SetDeliveryMethodParams.class, string, setDeliveryMethod);
        setDeliveryMethodParams.setDeliveryMethodName(setDeliveryMethod.getName());
        setDeliveryMethodParams.setDeliveryPrice(setDeliveryMethod.getChargeAmount());
        setDeliveryMethodParams.setDeliveryType(this.deliveryMethodsApiHelper.toAdDeliveryMethodType(setDeliveryMethod.getDeliveryType()));
        setDeliveryMethodParams.setMaxDeliveryTime(this.apiHelper.toTimeIntervalDTO(setDeliveryMethod.getMaxTime()));
        setDeliveryMethodParams.setMinDeliveryTime(this.apiHelper.toTimeIntervalDTO(setDeliveryMethod.getMinTime()));
        return setDeliveryMethodParams;
    }

    public UserOrderResult toUserOrderResult(OrderVO orderVO, boolean bl) {
        UserOrderResult userOrderResult = this.newOrderResult(UserOrderResult.class, (IOrder)orderVO);
        userOrderResult.setRelatedUser(this.usersApiHelper.toUser((BasicUserVO)(bl ? orderVO.getBuyer() : orderVO.getSeller())));
        return userOrderResult;
    }

    private BigDecimal getTotalPrice(BigDecimal bigDecimal, BigDecimal bigDecimal2, CurrencyVO currencyVO) {
        int n = currencyVO.getPrecision();
        BigDecimal bigDecimal3 = bigDecimal.multiply(bigDecimal2);
        return BigDecimalHelper.round((BigDecimal)bigDecimal3, (int)n);
    }

    private <P extends OrderActionParams> P newOrderActionParams(Class<P> clazz, String string, BaseOrderAction baseOrderAction) {
        OrderActionParams orderActionParams = (OrderActionParams)ClassHelper.instantiate(clazz);
        orderActionParams.setOrder((OrderVO)ModelHelper.voFromString(OrderVO.class, (String)string));
        if (baseOrderAction != null) {
            orderActionParams.setRemarks(baseOrderAction.getRemarks());
        }
        return (P)orderActionParams;
    }

    private <D extends OrderBasicData> D newOrderData(Class<D> clazz, OrderData orderData) {
        OrderBasicData orderBasicData = (OrderBasicData)ClassHelper.instantiate(clazz);
        CollectionHelper.orEmpty((List)orderData.getDeliveryMethods()).stream().map(ModelHelper::removeId).map(this.deliveryMethodsApiHelper::toDeliveryMethod).forEach(orderBasicData.getDeliveryMethods()::add);
        orderBasicData.setBuyer(this.usersApiHelper.toUser((BasicUserVO)((OrderDTO)orderData.getDto()).getBuyer()));
        orderBasicData.setSeller(this.usersApiHelper.toUser((BasicUserVO)((OrderDTO)orderData.getDto()).getSeller()));
        orderBasicData.setAddressConfiguration(this.addressesApiHelper.toAddressConfiguration(orderData.getBuyerAddressConfiguration()));
        CollectionHelper.orEmpty((List)orderData.getBuyerAddresses()).stream().map(ModelHelper::removeId).map(this.addressesApiHelper::toAddress).forEach(orderBasicData.getAddresses()::add);
        orderBasicData.setSellerAddressConfiguration(this.addressesApiHelper.toAddressConfiguration(orderData.getSellerAddressConfiguration()));
        CollectionHelper.orEmpty((List)orderData.getSellerAddresses()).stream().map(ModelHelper::removeId).map(this.addressesApiHelper::toAddress).forEach(orderBasicData.getSellerAddresses()::add);
        return (D)orderBasicData;
    }

    private <O extends OrderManage> O newOrderManage(Class<O> clazz, OrderDTO orderDTO) {
        OrderManage orderManage = (OrderManage)ClassHelper.instantiate(clazz);
        orderManage.setDeliveryMethod(this.toOrderDeliveryMethod(orderDTO));
        orderManage.setDeliveryAddress(this.addressesApiHelper.toSimpleAddress((IAddress)orderDTO.getDeliveryAddress()));
        if (orderDTO.getStatus() == OrderStatus.DRAFT && orderDTO.isSale()) {
            orderManage.setDraft(true);
        }
        orderManage.setRemarks(orderDTO.getRemarks());
        if (orderManage.getDeliveryMethod() == null) {
            orderManage.setDeliveryMethod(new OrderDeliveryMethod());
        }
        if (orderManage.getDeliveryAddress() == null) {
            orderManage.setDeliveryAddress(new SimpleAddress());
        }
        CollectionHelper.orEmpty((List)orderDTO.getProducts()).stream().map(this::toOrderItemManage).forEach(orderManage.getItems()::add);
        return (O)orderManage;
    }

    private <T extends OrderResult> T newOrderResult(Class<T> clazz, IOrder iOrder) {
        if (iOrder == null) {
            return null;
        }
        if (iOrder.getStatus() == OrderStatus.SHOPPING_CART) {
            throw new EntityNotFoundException(IOrder.class, iOrder.getId());
        }
        OrderResult orderResult = (OrderResult)this.apiHelper.newEntity(clazz, iOrder);
        orderResult.setCreationDate(iOrder.getCreationDate());
        orderResult.setCurrency(this.accountsApiHelper.toCurrency(iOrder.getCurrency()));
        orderResult.setNumber(iOrder.getNumber());
        orderResult.setStatus(this.toOrderStatusEnum(iOrder.getStatus()));
        orderResult.setTotalPrice(iOrder.getTotal());
        orderResult.setImage(this.imagesApiHelper.toImage(iOrder.getImage()));
        orderResult.setSale(iOrder.isSale());
        return (T)orderResult;
    }

    private OrderDeliveryMethod toOrderDeliveryMethod(OrderDTO orderDTO) {
        if (StringHelper.isBlank((Object)orderDTO.getDeliveryMethodName()) && orderDTO.getMaxDeliveryTime() == null && orderDTO.getMinDeliveryTime() == null && orderDTO.getDeliveryPrice() == null) {
            return null;
        }
        OrderDeliveryMethod orderDeliveryMethod = new OrderDeliveryMethod();
        orderDeliveryMethod.setName(orderDTO.getDeliveryMethodName());
        orderDeliveryMethod.setMaxTime(this.apiHelper.toTimeInterval(orderDTO.getMaxDeliveryTime()));
        orderDeliveryMethod.setMinTime(this.apiHelper.toTimeInterval(orderDTO.getMinDeliveryTime()));
        orderDeliveryMethod.setPrice(orderDTO.getDeliveryPrice());
        orderDeliveryMethod.setDeliveryType(this.deliveryMethodsApiHelper.toDeliveryMethodTypeEnum(orderDTO.getDeliveryType()));
        return orderDeliveryMethod;
    }

    private OrderDTO toOrderDTO(OrderManage orderManage) {
        if (orderManage == null) {
            return null;
        }
        OrderDTO orderDTO = new OrderDTO();
        orderDTO.setProducts(new ArrayList());
        orderDTO.setStatus(orderManage.getDraft() == null || Boolean.TRUE.equals(orderManage.getDraft()) ? OrderStatus.DRAFT : OrderStatus.PENDING_BUYER);
        OrderDeliveryMethod orderDeliveryMethod = orderManage.getDeliveryMethod();
        if (orderDeliveryMethod != null) {
            orderDTO.setDeliveryMethodName(orderDeliveryMethod.getName());
            orderDTO.setDeliveryPrice(orderDeliveryMethod.getPrice());
            orderDTO.setMaxDeliveryTime(this.apiHelper.toTimeIntervalDTO(orderDeliveryMethod.getMaxTime()));
            orderDTO.setMinDeliveryTime(this.apiHelper.toTimeIntervalDTO(orderDeliveryMethod.getMinTime()));
            orderDTO.setDeliveryType(this.deliveryMethodsApiHelper.toAdDeliveryMethodType(orderDeliveryMethod.getDeliveryType()));
        }
        orderDTO.setDeliveryAddress(this.addressesApiHelper.toAddressDTO(OrderAddressDTO.class, orderManage.getDeliveryAddress()));
        orderDTO.setRemarks(orderManage.getRemarks());
        CollectionHelper.orEmpty(orderManage.getItems()).stream().map(this::toOrderProductDTO).forEach(orderDTO.getProducts()::add);
        return orderDTO;
    }

    private OrderItem toOrderItem(OrderProductDTO orderProductDTO) {
        if (orderProductDTO == null) {
            return null;
        }
        OrderItem orderItem = this.newBaseOrderItem(OrderItem.class, orderProductDTO);
        orderItem.setTotalPrice(this.getTotalPrice(orderProductDTO.getPrice(), orderProductDTO.getQuantity(), orderProductDTO.getOrder().getCurrency()));
        orderItem.setPrice(orderProductDTO.getPrice());
        return orderItem;
    }

    private OrderItemManage toOrderItemManage(OrderProductDTO orderProductDTO) {
        if (orderProductDTO == null) {
            return null;
        }
        OrderItemManage orderItemManage = new OrderItemManage();
        orderItemManage.setPrice(orderProductDTO.getPrice());
        orderItemManage.setProduct(ApiHelper.toId(orderProductDTO.getProduct().getId()));
        orderItemManage.setQuantity(orderProductDTO.getQuantity());
        return orderItemManage;
    }

    private OrderProductDTO toOrderProductDTO(OrderItemManage orderItemManage) {
        if (orderItemManage == null) {
            return null;
        }
        OrderProductDTO orderProductDTO = new OrderProductDTO();
        orderProductDTO.setPrice(orderItemManage.getPrice());
        orderProductDTO.setProduct((AdWebShopVO)ModelHelper.voFromString(AdWebShopVO.class, (String)orderItemManage.getProduct()));
        orderProductDTO.setQuantity(orderItemManage.getQuantity());
        return orderProductDTO;
    }
}

