/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.helpers;

import java.util.List;
import java.util.stream.Collectors;
import org.cyclos.model.access.passwords.ICredentialInputDTO;
import org.cyclos.model.banking.accounts.AccountLimitsOverviewData;
import org.cyclos.model.banking.accounts.AccountPaymentAmountLimitDTO;
import org.cyclos.model.banking.accounts.AccountPaymentAmountLimitLogVO;
import org.cyclos.model.banking.accounts.AccountPaymentAmountLimitVO;
import org.cyclos.model.banking.accounts.AccountPaymentAmountLimitsOverviewQuery;
import org.cyclos.model.banking.accounts.UserAccountPaymentAmountLimitData;
import org.cyclos.model.banking.accounttypes.AccountTypeVO;
import org.cyclos.model.banking.currencies.CurrencyVO;
import org.cyclos.model.users.groups.BasicGroupVO;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.users.users.UserVO;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.server.utils.ClassHelper;
import org.cyclos.services.users.UserService;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.web.rest.api.PaymentLimitsApi;
import org.cyclos.web.rest.helpers.AccountsApiHelper;
import org.cyclos.web.rest.helpers.ApiHelper;
import org.cyclos.web.rest.helpers.AuthApiHelper;
import org.cyclos.web.rest.helpers.GroupsApiHelper;
import org.cyclos.web.rest.helpers.UsersApiHelper;
import org.cyclos.web.rest.model.AccountPaymentLimitsData;
import org.cyclos.web.rest.model.AccountPaymentLimitsLog;
import org.cyclos.web.rest.model.AccountPaymentLimitsResult;
import org.cyclos.web.rest.model.DataForPaymentLimitsSearch;
import org.cyclos.web.rest.model.GeneralAccountPaymentLimitsResult;
import org.cyclos.web.rest.model.SetAccountPaymentLimits;
import org.cyclos.web.rest.model.UserAccountPaymentLimitsListData;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PaymentLimitsApiHelper {
    @Autowired
    private ApiHelper apiHelper;
    @Autowired
    private AccountsApiHelper accountsApiHelper;
    @Autowired
    private AuthApiHelper authApiHelper;
    @Autowired
    private UsersApiHelper usersApiHelper;
    @Autowired
    private UserService userService;
    @Autowired
    private GroupsApiHelper groupsApiHelper;

    public AccountPaymentAmountLimitDTO toAccountPaymentAmountLimitDTO(PaymentLimitsApi.SetAccountPaymentLimitsParams setAccountPaymentLimitsParams) {
        SetAccountPaymentLimits setAccountPaymentLimits = setAccountPaymentLimitsParams.setAccountPaymentLimits;
        AccountPaymentAmountLimitDTO accountPaymentAmountLimitDTO = new AccountPaymentAmountLimitDTO();
        accountPaymentAmountLimitDTO.setAccount(this.accountsApiHelper.toAccountVO(setAccountPaymentLimitsParams.user, setAccountPaymentLimitsParams.accountType));
        accountPaymentAmountLimitDTO.setConfirmationPassword(setAccountPaymentLimitsParams.confirmationPassword);
        accountPaymentAmountLimitDTO.setMaxLimit(setAccountPaymentLimits.getAmountLimit());
        accountPaymentAmountLimitDTO.setMaxLimitFromProduct(!Boolean.TRUE.equals(setAccountPaymentLimits.getCustomAmountLimit()));
        accountPaymentAmountLimitDTO.setMaxPerDayLimit(setAccountPaymentLimits.getAmountPerDayLimit());
        accountPaymentAmountLimitDTO.setMaxPerDayLimitFromProduct(!Boolean.TRUE.equals(setAccountPaymentLimits.getCustomAmountPerDayLimit()));
        accountPaymentAmountLimitDTO.setMaxPerWeekLimit(setAccountPaymentLimits.getAmountPerWeekLimit());
        accountPaymentAmountLimitDTO.setMaxPerWeekLimitFromProduct(!Boolean.TRUE.equals(setAccountPaymentLimits.getCustomAmountPerWeekLimit()));
        accountPaymentAmountLimitDTO.setMaxPerMonthLimit(setAccountPaymentLimits.getAmountPerMonthLimit());
        accountPaymentAmountLimitDTO.setMaxPerMonthLimitFromProduct(!Boolean.TRUE.equals(setAccountPaymentLimits.getCustomAmountPerMonthLimit()));
        accountPaymentAmountLimitDTO.setMaxPerYearLimit(setAccountPaymentLimits.getAmountPerYearLimit());
        accountPaymentAmountLimitDTO.setMaxPerYearLimitFromProduct(!Boolean.TRUE.equals(setAccountPaymentLimits.getCustomAmountPerYearLimit()));
        accountPaymentAmountLimitDTO.setDescription(setAccountPaymentLimits.getComment());
        return accountPaymentAmountLimitDTO;
    }

    public AccountPaymentLimitsData toAccountPaymentAmountLimitsData(UserAccountPaymentAmountLimitData userAccountPaymentAmountLimitData) {
        AccountPaymentLimitsData accountPaymentLimitsData = new AccountPaymentLimitsData();
        AccountPaymentAmountLimitDTO accountPaymentAmountLimitDTO = userAccountPaymentAmountLimitData.getDto();
        accountPaymentLimitsData.setAccount(this.accountsApiHelper.toAccountWithCurrency(accountPaymentAmountLimitDTO.getAccount(), accountPaymentAmountLimitDTO.getCurrency()));
        accountPaymentLimitsData.setUser(this.usersApiHelper.toUser((BasicUserVO)((UserVO)userAccountPaymentAmountLimitData.getDto().getAccount().getOwner())));
        accountPaymentLimitsData.setEditable(userAccountPaymentAmountLimitData.isEditable());
        accountPaymentLimitsData.setAmountLimit(accountPaymentAmountLimitDTO.getMaxLimit());
        accountPaymentLimitsData.setCustomAmountLimit(!accountPaymentAmountLimitDTO.isMaxLimitFromProduct());
        accountPaymentLimitsData.setAmountPerDayLimit(accountPaymentAmountLimitDTO.getMaxPerDayLimit());
        accountPaymentLimitsData.setCustomAmountPerDayLimit(!accountPaymentAmountLimitDTO.isMaxPerDayLimitFromProduct());
        accountPaymentLimitsData.setAmountPerWeekLimit(accountPaymentAmountLimitDTO.getMaxPerWeekLimit());
        accountPaymentLimitsData.setCustomAmountPerWeekLimit(!accountPaymentAmountLimitDTO.isMaxPerWeekLimitFromProduct());
        accountPaymentLimitsData.setAmountPerMonthLimit(accountPaymentAmountLimitDTO.getMaxPerMonthLimit());
        accountPaymentLimitsData.setCustomAmountPerMonthLimit(!accountPaymentAmountLimitDTO.isMaxPerMonthLimitFromProduct());
        accountPaymentLimitsData.setAmountPerYearLimit(accountPaymentAmountLimitDTO.getMaxPerYearLimit());
        accountPaymentLimitsData.setCustomAmountPerYearLimit(!accountPaymentAmountLimitDTO.isMaxPerYearLimitFromProduct());
        accountPaymentLimitsData.setConfirmationPasswordInput(this.authApiHelper.toPasswordInput((ICredentialInputDTO)userAccountPaymentAmountLimitData.getConfirmationPasswordInput()));
        accountPaymentLimitsData.setProductAmountLimit(userAccountPaymentAmountLimitData.getProductsMaxLimit());
        accountPaymentLimitsData.setProductAmountPerDayLimit(userAccountPaymentAmountLimitData.getProductsMaxPerDayLimit());
        accountPaymentLimitsData.setProductAmountPerWeekLimit(userAccountPaymentAmountLimitData.getProductsMaxPerWeekLimit());
        accountPaymentLimitsData.setProductAmountPerMonthLimit(userAccountPaymentAmountLimitData.getProductsMaxPerMonthLimit());
        accountPaymentLimitsData.setProductAmountPerYearLimit(userAccountPaymentAmountLimitData.getProductsMaxPerYearLimit());
        CollectionHelper.orEmpty((List)userAccountPaymentAmountLimitData.getAccountPaymentAmountLimitLogs()).stream().map(this::toAccountPaymentAmountLimitsLog).forEach(accountPaymentLimitsData.getHistory()::add);
        return accountPaymentLimitsData;
    }

    public AccountPaymentAmountLimitsOverviewQuery toAccountPaymentAmountLimitsOverviewQuery(PaymentLimitsApi.SearchAccountPaymentLimitsParams searchAccountPaymentLimitsParams) {
        AccountPaymentAmountLimitsOverviewQuery accountPaymentAmountLimitsOverviewQuery = this.apiHelper.newQuery(AccountPaymentAmountLimitsOverviewQuery.class, searchAccountPaymentLimitsParams.page, searchAccountPaymentLimitsParams.pageSize, searchAccountPaymentLimitsParams.skipTotalCount);
        accountPaymentAmountLimitsOverviewQuery.setCurrency((CurrencyVO)ModelHelper.voFromString(CurrencyVO.class, (String)searchAccountPaymentLimitsParams.currency));
        accountPaymentAmountLimitsOverviewQuery.setAccountType((AccountTypeVO)ModelHelper.voFromString(AccountTypeVO.class, (String)searchAccountPaymentLimitsParams.accountType));
        accountPaymentAmountLimitsOverviewQuery.setChangedBy((UserVO)ModelHelper.voFromString(UserVO.class, (String)searchAccountPaymentLimitsParams.by));
        accountPaymentAmountLimitsOverviewQuery.setGroups(CollectionHelper.orEmpty(searchAccountPaymentLimitsParams.groups).stream().map(string -> (BasicGroupVO)ModelHelper.voFromString(BasicGroupVO.class, (String)string)).collect(Collectors.toSet()));
        accountPaymentAmountLimitsOverviewQuery.setBrokers(CollectionHelper.orEmpty(searchAccountPaymentLimitsParams.brokers).stream().map(string -> (UserVO)ModelHelper.voFromString(UserVO.class, (String)string)).collect(Collectors.toSet()));
        accountPaymentAmountLimitsOverviewQuery.setUser((UserVO)ModelHelper.voFromString(UserVO.class, (String)searchAccountPaymentLimitsParams.user));
        accountPaymentAmountLimitsOverviewQuery.setPersonalizedMaxLimit(searchAccountPaymentLimitsParams.customAmountLimit);
        accountPaymentAmountLimitsOverviewQuery.setMaxLimitRange(this.apiHelper.toDecimalRangeDTO(searchAccountPaymentLimitsParams.customAmountLimitRange));
        accountPaymentAmountLimitsOverviewQuery.setPersonalizedMaxPerDayLimit(searchAccountPaymentLimitsParams.customAmountPerDayLimit);
        accountPaymentAmountLimitsOverviewQuery.setMaxPerDayLimitRange(this.apiHelper.toDecimalRangeDTO(searchAccountPaymentLimitsParams.customAmountPerDayLimitRange));
        accountPaymentAmountLimitsOverviewQuery.setPersonalizedMaxPerWeekLimit(searchAccountPaymentLimitsParams.customAmountPerWeekLimit);
        accountPaymentAmountLimitsOverviewQuery.setMaxPerWeekLimitRange(this.apiHelper.toDecimalRangeDTO(searchAccountPaymentLimitsParams.customAmountPerWeekLimitRange));
        accountPaymentAmountLimitsOverviewQuery.setPersonalizedMaxPerMonthLimit(searchAccountPaymentLimitsParams.customAmountPerMonthLimit);
        accountPaymentAmountLimitsOverviewQuery.setMaxPerMonthLimitRange(this.apiHelper.toDecimalRangeDTO(searchAccountPaymentLimitsParams.customAmountPerMonthLimitRange));
        accountPaymentAmountLimitsOverviewQuery.setPersonalizedMaxPerYearLimit(searchAccountPaymentLimitsParams.customAmountPerYearLimit);
        accountPaymentAmountLimitsOverviewQuery.setMaxPerYearLimitRange(this.apiHelper.toDecimalRangeDTO(searchAccountPaymentLimitsParams.customAmountPerYearLimitRange));
        return accountPaymentAmountLimitsOverviewQuery;
    }

    public DataForPaymentLimitsSearch toDataForPaymentAmountLimitsSearch(AccountLimitsOverviewData accountLimitsOverviewData) {
        DataForPaymentLimitsSearch dataForPaymentLimitsSearch = new DataForPaymentLimitsSearch();
        CollectionHelper.orEmpty((List)accountLimitsOverviewData.getManagedGroups()).stream().map(this.groupsApiHelper::toGroup).forEach(dataForPaymentLimitsSearch.getGroups()::add);
        CollectionHelper.orEmpty((List)accountLimitsOverviewData.getUserAccountTypes()).stream().map(this.accountsApiHelper::toAccountType).forEach(dataForPaymentLimitsSearch.getAccountTypes()::add);
        CollectionHelper.orEmpty((List)accountLimitsOverviewData.getExportFormats()).stream().map(this.apiHelper::toExportFormat).forEach(dataForPaymentLimitsSearch.getExportFormats()::add);
        return dataForPaymentLimitsSearch;
    }

    public GeneralAccountPaymentLimitsResult toGeneralAccountPaymentAmountLimitsResult(AccountPaymentAmountLimitVO accountPaymentAmountLimitVO) {
        GeneralAccountPaymentLimitsResult generalAccountPaymentLimitsResult = this.newResult(GeneralAccountPaymentLimitsResult.class, accountPaymentAmountLimitVO);
        generalAccountPaymentLimitsResult.setUser(this.usersApiHelper.toUser((BasicUserVO)((UserVO)accountPaymentAmountLimitVO.getAccount().getOwner())));
        return generalAccountPaymentLimitsResult;
    }

    public UserAccountPaymentLimitsListData toUserAccountPaymentAmountLimitsListData(String string, List<AccountPaymentAmountLimitVO> list) {
        UserAccountPaymentLimitsListData userAccountPaymentLimitsListData = new UserAccountPaymentLimitsListData();
        UserVO userVO = null;
        if (CollectionHelper.isEmpty(list)) {
            userVO = this.userService.locate((UserLocatorVO)ModelHelper.voFromString(UserLocatorVO.class, (String)string));
        } else {
            userVO = (UserVO)((AccountPaymentAmountLimitVO)CollectionHelper.first(list)).getAccount().getOwner();
            list.stream().map(this::toAccountPaymentLimitsResult).forEach(userAccountPaymentLimitsListData.getAccountLimits()::add);
        }
        userAccountPaymentLimitsListData.setUser(this.usersApiHelper.toUser((BasicUserVO)userVO));
        return userAccountPaymentLimitsListData;
    }

    private <R extends AccountPaymentLimitsResult> R newResult(Class<R> clazz, AccountPaymentAmountLimitVO accountPaymentAmountLimitVO) {
        AccountPaymentLimitsResult accountPaymentLimitsResult = (AccountPaymentLimitsResult)ClassHelper.instantiate(clazz);
        accountPaymentLimitsResult.setAccount(this.accountsApiHelper.toAccountWithCurrency(accountPaymentAmountLimitVO.getAccount()));
        accountPaymentLimitsResult.setAmountLimit(accountPaymentAmountLimitVO.getMaxLimit());
        accountPaymentLimitsResult.setCustomAmountLimit(!accountPaymentAmountLimitVO.isMaxLimitFromProduct());
        accountPaymentLimitsResult.setAmountPerDayLimit(accountPaymentAmountLimitVO.getMaxPerDayLimit());
        accountPaymentLimitsResult.setCustomAmountPerDayLimit(!accountPaymentAmountLimitVO.isMaxPerDayLimitFromProduct());
        accountPaymentLimitsResult.setAmountPerWeekLimit(accountPaymentAmountLimitVO.getMaxPerWeekLimit());
        accountPaymentLimitsResult.setCustomAmountPerWeekLimit(!accountPaymentAmountLimitVO.isMaxPerWeekLimitFromProduct());
        accountPaymentLimitsResult.setAmountPerMonthLimit(accountPaymentAmountLimitVO.getMaxPerMonthLimit());
        accountPaymentLimitsResult.setCustomAmountPerMonthLimit(!accountPaymentAmountLimitVO.isMaxPerMonthLimitFromProduct());
        accountPaymentLimitsResult.setAmountPerYearLimit(accountPaymentAmountLimitVO.getMaxPerYearLimit());
        accountPaymentLimitsResult.setCustomAmountPerYearLimit(!accountPaymentAmountLimitVO.isMaxPerYearLimitFromProduct());
        return (R)accountPaymentLimitsResult;
    }

    private AccountPaymentLimitsLog toAccountPaymentAmountLimitsLog(AccountPaymentAmountLimitLogVO accountPaymentAmountLimitLogVO) {
        AccountPaymentLimitsLog accountPaymentLimitsLog = new AccountPaymentLimitsLog();
        accountPaymentLimitsLog.setDate(accountPaymentAmountLimitLogVO.getModifiedAt());
        accountPaymentLimitsLog.setBy(this.usersApiHelper.toUser(accountPaymentAmountLimitLogVO.getBy()));
        accountPaymentLimitsLog.setComment(accountPaymentAmountLimitLogVO.getDescription());
        accountPaymentLimitsLog.setAmountLimit(accountPaymentAmountLimitLogVO.getMaxLimit());
        accountPaymentLimitsLog.setCustomAmountLimit(!accountPaymentAmountLimitLogVO.isMaxLimitFromProduct());
        accountPaymentLimitsLog.setAmountPerDayLimit(accountPaymentAmountLimitLogVO.getMaxPerDayLimit());
        accountPaymentLimitsLog.setCustomAmountPerDayLimit(!accountPaymentAmountLimitLogVO.isMaxPerDayLimitFromProduct());
        accountPaymentLimitsLog.setAmountPerWeekLimit(accountPaymentAmountLimitLogVO.getMaxPerWeekLimit());
        accountPaymentLimitsLog.setCustomAmountPerWeekLimit(!accountPaymentAmountLimitLogVO.isMaxPerWeekLimitFromProduct());
        accountPaymentLimitsLog.setAmountPerMonthLimit(accountPaymentAmountLimitLogVO.getMaxPerMonthLimit());
        accountPaymentLimitsLog.setCustomAmountPerMonthLimit(!accountPaymentAmountLimitLogVO.isMaxPerMonthLimitFromProduct());
        accountPaymentLimitsLog.setAmountPerYearLimit(accountPaymentAmountLimitLogVO.getMaxPerYearLimit());
        accountPaymentLimitsLog.setCustomAmountPerYearLimit(!accountPaymentAmountLimitLogVO.isMaxPerYearLimitFromProduct());
        return accountPaymentLimitsLog;
    }

    private AccountPaymentLimitsResult toAccountPaymentLimitsResult(AccountPaymentAmountLimitVO accountPaymentAmountLimitVO) {
        return this.newResult(AccountPaymentLimitsResult.class, accountPaymentAmountLimitVO);
    }
}

