/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.helpers;

import java.util.List;
import java.util.Set;
import org.cyclos.model.users.groups.BasicGroupVO;
import org.cyclos.model.users.products.ProductAssignmentAction;
import org.cyclos.model.users.products.ProductAssignmentLogVO;
import org.cyclos.model.users.products.ProductLevelData;
import org.cyclos.model.users.products.ProductNature;
import org.cyclos.model.users.products.ProductVO;
import org.cyclos.model.users.products.ProductWithUserAccountVO;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.model.users.users.UserProductsCollections;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.web.rest.helpers.AccountsApiHelper;
import org.cyclos.web.rest.helpers.ApiHelper;
import org.cyclos.web.rest.helpers.GroupsApiHelper;
import org.cyclos.web.rest.helpers.UsersApiHelper;
import org.cyclos.web.rest.model.Product;
import org.cyclos.web.rest.model.ProductAssignmentActionEnum;
import org.cyclos.web.rest.model.ProductAssignmentLog;
import org.cyclos.web.rest.model.ProductKind;
import org.cyclos.web.rest.model.ProductWithUserAccount;
import org.cyclos.web.rest.model.UserProductAssignmentData;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ProductAssignmentApiHelper {
    @Autowired
    private ApiHelper apiHelper;
    @Autowired
    private UsersApiHelper usersApiHelper;
    @Autowired
    private GroupsApiHelper groupsApiHelper;
    @Autowired
    private AccountsApiHelper accountsApiHelper;

    public ProductAssignmentActionEnum toProductAssignmentActionEnum(ProductAssignmentAction productAssignmentAction) {
        if (productAssignmentAction != null) {
            switch (productAssignmentAction) {
                case ASSIGN: {
                    return ProductAssignmentActionEnum.ASSIGN;
                }
                case UNASSIGN: {
                    return ProductAssignmentActionEnum.UNASSIGN;
                }
            }
        }
        return null;
    }

    public ProductKind toProductKind(ProductNature productNature) {
        if (productNature != null) {
            switch (productNature) {
                case ADMIN: {
                    return ProductKind.ADMINISTRATOR;
                }
                case BROKER: {
                    return ProductKind.BROKER;
                }
                case MEMBER: {
                    return ProductKind.MEMBER;
                }
            }
        }
        return null;
    }

    public UserProductAssignmentData toUserProductAssignmentData(UserProductsCollections userProductsCollections) {
        UserProductAssignmentData userProductAssignmentData = new UserProductAssignmentData();
        userProductAssignmentData.setUser(this.usersApiHelper.toUser((BasicUserVO)userProductsCollections.getUser()));
        userProductAssignmentData.setGroup(this.groupsApiHelper.toGroup((BasicGroupVO)userProductsCollections.getGroup()));
        CollectionHelper.orEmpty((List)userProductsCollections.getAvailable()).stream().map(this::toProductWithUserAccount).forEach(userProductAssignmentData.getAssignable()::add);
        CollectionHelper.orEmpty((Set)userProductsCollections.getUnassignable()).stream().map(ModelHelper::internalNameOrId).forEach(userProductAssignmentData.getUnassignable()::add);
        this.fillLevels(userProductAssignmentData, userProductsCollections.getAssigned());
        CollectionHelper.orEmpty((List)userProductsCollections.getLogs()).stream().map(this::toProductAssignmentLog).forEach(userProductAssignmentData.getHistory()::add);
        return userProductAssignmentData;
    }

    private void fillLevels(UserProductAssignmentData userProductAssignmentData, ProductLevelData productLevelData) {
        if (productLevelData == null) {
            return;
        }
        List<ProductWithUserAccount> list = null;
        switch (productLevelData.getLevel()) {
            case GROUP_SET: {
                list = userProductAssignmentData.getGroupSetProducts();
                break;
            }
            case GROUP: {
                list = userProductAssignmentData.getGroupProducts();
                break;
            }
            case INDIVIDUAL: {
                list = userProductAssignmentData.getUserProducts();
            }
        }
        if (list == null) {
            throw new IllegalStateException("Unhandled level");
        }
        CollectionHelper.orEmpty((List)productLevelData.getThisLevelsProducts()).stream().map(this::toProductWithUserAccount).forEach(list::add);
        this.fillLevels(userProductAssignmentData, productLevelData.getLevelUp());
    }

    private <P extends Product> P newProduct(Class<P> clazz, ProductVO productVO) {
        Product product = (Product)this.apiHelper.newEntity(clazz, productVO);
        product.setKind(this.toProductKind(productVO.getNature()));
        return (P)product;
    }

    private Product toProduct(ProductVO productVO) {
        if (productVO == null) {
            return null;
        }
        return this.newProduct(Product.class, productVO);
    }

    private ProductAssignmentLog toProductAssignmentLog(ProductAssignmentLogVO productAssignmentLogVO) {
        ProductAssignmentLog productAssignmentLog = new ProductAssignmentLog();
        productAssignmentLog.setDate(productAssignmentLogVO.getDate());
        productAssignmentLog.setBy(this.usersApiHelper.toUser((BasicUserVO)productAssignmentLogVO.getBy()));
        productAssignmentLog.setProduct(this.toProduct(productAssignmentLogVO.getProduct()));
        productAssignmentLog.setAction(this.toProductAssignmentActionEnum(productAssignmentLogVO.getAction()));
        return productAssignmentLog;
    }

    private ProductWithUserAccount toProductWithUserAccount(ProductWithUserAccountVO productWithUserAccountVO) {
        if (productWithUserAccountVO == null) {
            return null;
        }
        ProductWithUserAccount productWithUserAccount = this.newProduct(ProductWithUserAccount.class, (ProductVO)productWithUserAccountVO);
        productWithUserAccount.setUserAccount(this.accountsApiHelper.toAccountType(productWithUserAccountVO.getUserAccount()));
        return productWithUserAccount;
    }
}

