/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.helpers;

import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import org.cyclos.model.EntityModel;
import org.cyclos.model.EntityVO;
import org.cyclos.model.QueryParameters;
import org.cyclos.model.system.fields.CustomFieldDetailedVO;
import org.cyclos.model.system.fields.CustomFieldVO;
import org.cyclos.model.users.groups.BasicGroupVO;
import org.cyclos.model.users.records.IRecordPermissions;
import org.cyclos.model.users.records.RecordDTO;
import org.cyclos.model.users.records.RecordData;
import org.cyclos.model.users.records.RecordQuery;
import org.cyclos.model.users.records.RecordSearchData;
import org.cyclos.model.users.records.RecordVO;
import org.cyclos.model.users.records.SharedRecordFieldsSearchData;
import org.cyclos.model.users.records.SystemRecordDTO;
import org.cyclos.model.users.records.SystemRecordQuery;
import org.cyclos.model.users.records.SystemRecordVO;
import org.cyclos.model.users.records.UserRecordDTO;
import org.cyclos.model.users.records.UserRecordQuery;
import org.cyclos.model.users.records.UserRecordSearchData;
import org.cyclos.model.users.records.UserRecordVO;
import org.cyclos.model.users.recordsections.RecordSectionDetailedVO;
import org.cyclos.model.users.recordtypes.RecordCustomFieldDetailedVO;
import org.cyclos.model.users.recordtypes.RecordTypeCountVO;
import org.cyclos.model.users.recordtypes.RecordTypeDetailedVO;
import org.cyclos.model.users.recordtypes.RecordTypeResultsLayout;
import org.cyclos.model.users.recordtypes.RecordTypeVO;
import org.cyclos.model.users.recordtypes.SystemRecordTypeVO;
import org.cyclos.model.users.recordtypes.UserRecordTypeVO;
import org.cyclos.model.users.users.BasicProfileField;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.model.users.users.DataWithBasicProfileFields;
import org.cyclos.model.users.users.ProfileField;
import org.cyclos.model.users.users.UserVO;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.server.utils.ClassHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.web.rest.helpers.AddressesApiHelper;
import org.cyclos.web.rest.helpers.ApiHelper;
import org.cyclos.web.rest.helpers.AuthApiHelper;
import org.cyclos.web.rest.helpers.GroupsApiHelper;
import org.cyclos.web.rest.helpers.OperationsApiHelper;
import org.cyclos.web.rest.helpers.UserStatusApiHelper;
import org.cyclos.web.rest.helpers.UsersApiHelper;
import org.cyclos.web.rest.model.BaseRecordDataForSearch;
import org.cyclos.web.rest.model.GeneralRecordsDataForSearch;
import org.cyclos.web.rest.model.GeneralRecordsQueryFilters;
import org.cyclos.web.rest.model.OwnerRecordData;
import org.cyclos.web.rest.model.OwnerRecordPermissions;
import org.cyclos.web.rest.model.Record;
import org.cyclos.web.rest.model.RecordBasePermissions;
import org.cyclos.web.rest.model.RecordBasicData;
import org.cyclos.web.rest.model.RecordCustomField;
import org.cyclos.web.rest.model.RecordCustomFieldDetailed;
import org.cyclos.web.rest.model.RecordCustomFieldValue;
import org.cyclos.web.rest.model.RecordDataForEdit;
import org.cyclos.web.rest.model.RecordDataForNew;
import org.cyclos.web.rest.model.RecordDataForSearch;
import org.cyclos.web.rest.model.RecordEdit;
import org.cyclos.web.rest.model.RecordKind;
import org.cyclos.web.rest.model.RecordLayoutEnum;
import org.cyclos.web.rest.model.RecordManage;
import org.cyclos.web.rest.model.RecordNew;
import org.cyclos.web.rest.model.RecordQueryFilters;
import org.cyclos.web.rest.model.RecordResult;
import org.cyclos.web.rest.model.RecordSection;
import org.cyclos.web.rest.model.RecordType;
import org.cyclos.web.rest.model.RecordTypeDetailed;
import org.cyclos.web.rest.model.RecordView;
import org.cyclos.web.rest.model.RecordWithOwnerResult;
import org.cyclos.web.rest.model.SharedRecordsDataForSearch;
import org.cyclos.web.rest.model.SharedRecordsQueryFilters;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RecordsApiHelper {
    @Autowired
    private ApiHelper apiHelper;
    @Autowired
    private UsersApiHelper usersApiHelper;
    @Autowired
    private GroupsApiHelper groupsApiHelper;
    @Autowired
    private UserStatusApiHelper userStatusApiHelper;
    @Autowired
    private AddressesApiHelper addressesApiHelper;
    @Autowired
    private OperationsApiHelper operationsApiHelper;
    @Autowired
    private AuthApiHelper authApiHelper;

    public <P extends OwnerRecordPermissions> P newOwnerRecordPermissions(Class<P> clazz, RecordTypeCountVO recordTypeCountVO) {
        if (recordTypeCountVO == null) {
            return null;
        }
        OwnerRecordPermissions ownerRecordPermissions = (OwnerRecordPermissions)this.newRecordBasePermissions(clazz, (IRecordPermissions)recordTypeCountVO);
        ownerRecordPermissions.setSingleRecordId(ApiHelper.toId(recordTypeCountVO.getSingleRecordId()));
        return (P)ownerRecordPermissions;
    }

    public GeneralRecordsDataForSearch toGeneralRecordsDataForSearch(UserRecordSearchData userRecordSearchData) {
        GeneralRecordsDataForSearch generalRecordsDataForSearch = this.newRecordDataForSeach(GeneralRecordsDataForSearch.class, (RecordSearchData)userRecordSearchData);
        CollectionHelper.orEmpty((List)userRecordSearchData.getGroups()).stream().map(this.groupsApiHelper::toGroup).forEach(generalRecordsDataForSearch.getGroups()::add);
        CollectionHelper.orEmpty((List)userRecordSearchData.getUserStatuses()).stream().map(this.userStatusApiHelper::toUserStatusEnum).forEach(generalRecordsDataForSearch.getUserStatuses()::add);
        for (ProfileField profileField : CollectionHelper.orEmpty((List)userRecordSearchData.getProfileFields())) {
            if (profileField instanceof BasicProfileField) {
                generalRecordsDataForSearch.getBasicProfileFields().add(this.usersApiHelper.toBasicProfileFieldInput((BasicProfileField)profileField, (DataWithBasicProfileFields)userRecordSearchData));
                continue;
            }
            if (!(profileField instanceof CustomFieldDetailedVO)) continue;
            generalRecordsDataForSearch.getCustomProfileFields().add(this.apiHelper.toCustomFieldDetailed((CustomFieldDetailedVO)profileField));
        }
        CollectionHelper.orEmpty((List)userRecordSearchData.getAddressFields()).stream().map(this.addressesApiHelper::toAddressQueryFieldEnum).forEach(generalRecordsDataForSearch.getAddressFieldsInSearch()::add);
        generalRecordsDataForSearch.setQuery(this.toGeneralRecordsQueryFilters((UserRecordQuery)userRecordSearchData.getQuery()));
        return generalRecordsDataForSearch;
    }

    public UserRecordQuery toGeneralRecordsQuery(String string2, GeneralRecordsQueryFilters generalRecordsQueryFilters) {
        UserRecordQuery userRecordQuery = (UserRecordQuery)this.toRecordQuery(null, string2, generalRecordsQueryFilters);
        userRecordQuery.setBrokers(CollectionHelper.orEmpty(generalRecordsQueryFilters.getBrokers()).stream().map(string -> (UserVO)ModelHelper.voFromString(UserVO.class, (String)string)).collect(Collectors.toSet()));
        userRecordQuery.setGroups(CollectionHelper.orEmpty(generalRecordsQueryFilters.getGroups()).stream().map(string -> (BasicGroupVO)ModelHelper.voFromString(BasicGroupVO.class, (String)string)).collect(Collectors.toSet()));
        userRecordQuery.setUserStatuses(CollectionHelper.orEmpty(generalRecordsQueryFilters.getUserStatuses()).stream().map(this.userStatusApiHelper::toUserStatus).collect(Collectors.toSet()));
        userRecordQuery.setUser((UserVO)ModelHelper.voFromString(UserVO.class, (String)generalRecordsQueryFilters.getUser()));
        return userRecordQuery;
    }

    public GeneralRecordsQueryFilters toGeneralRecordsQueryFilters(UserRecordQuery userRecordQuery) {
        if (userRecordQuery == null) {
            return null;
        }
        return this.newGeneralRecordsQueryFilters(GeneralRecordsQueryFilters.class, userRecordQuery);
    }

    public OwnerRecordData toOwnerRecordData(RecordTypeCountVO recordTypeCountVO) {
        if (recordTypeCountVO == null) {
            return null;
        }
        OwnerRecordData ownerRecordData = this.newRecordBasePermissions(OwnerRecordData.class, (IRecordPermissions)recordTypeCountVO);
        ownerRecordData.setCount(recordTypeCountVO.getCount());
        return ownerRecordData;
    }

    public OwnerRecordPermissions toOwnerRecordPermissions(RecordTypeCountVO recordTypeCountVO) {
        if (recordTypeCountVO == null) {
            return null;
        }
        return this.newOwnerRecordPermissions(OwnerRecordPermissions.class, recordTypeCountVO);
    }

    public Record toRecord(RecordVO recordVO) {
        if (recordVO == null) {
            return null;
        }
        return this.newRecord(Record.class, recordVO);
    }

    public RecordDataForEdit toRecordDataForEdit(RecordData recordData) {
        RecordDataForEdit recordDataForEdit = this.newRecordBasicData(RecordDataForEdit.class, recordData);
        recordDataForEdit.setCanEdit(recordData.isEditable());
        recordDataForEdit.setCanRemove(recordData.isRemovable());
        recordDataForEdit.setRecord(this.toRecordEdit((RecordDTO)recordData.getDto()));
        Map<Long, String> map = CollectionHelper.orEmpty((List)recordData.getFields()).stream().collect(Collectors.toMap(EntityModel::getId, ModelHelper::unqualifyInternalName));
        CollectionHelper.orEmpty((Set)recordData.getEditableFieldIds()).stream().map(map::get).forEach(recordDataForEdit.getEditableFields()::add);
        recordDataForEdit.setBinaryValues(this.apiHelper.toCustomFieldBinaryValues(((RecordDTO)recordData.getDto()).getCustomValues()));
        return recordDataForEdit;
    }

    public RecordDataForNew toRecordDataForNew(RecordData recordData) {
        RecordDataForNew recordDataForNew = this.newRecordBasicData(RecordDataForNew.class, recordData);
        recordDataForNew.setRecord(this.toRecordNew((RecordDTO)recordData.getDto()));
        return recordDataForNew;
    }

    public RecordDataForSearch toRecordDataForSearch(RecordSearchData recordSearchData) {
        if (recordSearchData == null) {
            return null;
        }
        RecordDataForSearch recordDataForSearch = this.newRecordDataForSeach(RecordDataForSearch.class, recordSearchData);
        recordDataForSearch.setQuery(this.toRecordQueryFilters((RecordQuery)recordSearchData.getQuery()));
        recordDataForSearch.setHideKeywordsSearch(recordSearchData.isHideKeywordsSearch());
        recordDataForSearch.setUser(this.usersApiHelper.toUser((BasicUserVO)recordSearchData.getOwner()));
        return recordDataForSearch;
    }

    public RecordDTO toRecordDTO(String string, String string2, String string3, RecordManage recordManage) {
        SystemRecordDTO systemRecordDTO;
        if (recordManage == null) {
            return null;
        }
        if (this.apiHelper.isSystem(string2)) {
            systemRecordDTO = new SystemRecordDTO();
        } else {
            UserRecordDTO userRecordDTO = new UserRecordDTO();
            userRecordDTO.setUser((UserVO)ModelHelper.voFromString(UserVO.class, (String)string2));
            systemRecordDTO = userRecordDTO;
        }
        if (recordManage instanceof RecordEdit) {
            systemRecordDTO.setId(this.apiHelper.fromId(string));
            systemRecordDTO.setVersion(((RecordEdit)recordManage).getVersion());
        }
        systemRecordDTO.setType((RecordTypeDetailedVO)ModelHelper.voFromString(RecordTypeDetailedVO.class, (String)string3));
        systemRecordDTO.setCustomValues(this.apiHelper.toCustomFieldValuesDTO(recordManage.getCustomValues()));
        return systemRecordDTO;
    }

    public RecordEdit toRecordEdit(RecordDTO recordDTO) {
        if (recordDTO == null) {
            return null;
        }
        RecordEdit recordEdit = this.newRecordManage(RecordEdit.class, recordDTO);
        recordEdit.setVersion(recordDTO.getVersion());
        return recordEdit;
    }

    public RecordLayoutEnum toRecordLayoutEnum(RecordTypeResultsLayout recordTypeResultsLayout) {
        if (recordTypeResultsLayout == null) {
            return null;
        }
        switch (recordTypeResultsLayout) {
            case LIST: {
                return RecordLayoutEnum.LIST;
            }
            case SINGLE_FORM: {
                return RecordLayoutEnum.SINGLE;
            }
            case TILED: {
                return RecordLayoutEnum.TILED;
            }
        }
        throw new IllegalStateException("Unhandled layout: " + String.valueOf(recordTypeResultsLayout));
    }

    public RecordNew toRecordNew(RecordDTO recordDTO) {
        if (recordDTO == null) {
            return null;
        }
        return this.newRecordManage(RecordNew.class, recordDTO);
    }

    public RecordQuery toRecordQuery(String string, String string2, RecordQueryFilters recordQueryFilters) {
        boolean bl = this.apiHelper.isSystem(string);
        Class clazz = bl ? SystemRecordQuery.class : UserRecordQuery.class;
        RecordQuery recordQuery = (RecordQuery)this.apiHelper.newQuery(clazz, recordQueryFilters);
        if (!bl) {
            UserRecordQuery userRecordQuery = (UserRecordQuery)recordQuery;
            userRecordQuery.setUserProfileFields(this.usersApiHelper.toProfileFieldsForSearch(recordQueryFilters.getProfileFields()));
            userRecordQuery.setUser((UserVO)ModelHelper.voFromString(UserVO.class, (String)string));
        }
        recordQuery.setType((RecordTypeVO)ModelHelper.voFromString(RecordTypeVO.class, (String)string2));
        recordQuery.setKeywords(recordQueryFilters.getKeywords());
        recordQuery.setCustomValues(this.apiHelper.toCustomFieldValuesForSearch(recordQueryFilters.getCustomFields()));
        recordQuery.setDatePeriod(this.apiHelper.toDatePeriodDTO(recordQueryFilters.getCreationPeriod()));
        recordQuery.setCreatedBy((UserVO)ModelHelper.voFromString(UserVO.class, (String)recordQueryFilters.getCreatedBy()));
        return recordQuery;
    }

    public RecordQueryFilters toRecordQueryFilters(RecordQuery recordQuery) {
        return this.newRecordQueryFilters(RecordQueryFilters.class, recordQuery);
    }

    public RecordResult toRecordResult(RecordVO recordVO) {
        if (recordVO == null) {
            return null;
        }
        return this.newRecordResult(RecordResult.class, recordVO);
    }

    public RecordSection toRecordSection(RecordSectionDetailedVO recordSectionDetailedVO) {
        if (recordSectionDetailedVO == null) {
            return null;
        }
        RecordSection recordSection = this.apiHelper.newEntity(RecordSection.class, recordSectionDetailedVO);
        recordSection.setInformationText(recordSectionDetailedVO.getInformationText());
        recordSection.setFields(recordSectionDetailedVO.getFieldInternalNames());
        return recordSection;
    }

    public RecordType toRecordType(RecordTypeVO recordTypeVO) {
        if (recordTypeVO == null) {
            return null;
        }
        RecordType recordType = this.newRecordType(RecordType.class, recordTypeVO);
        if (recordTypeVO instanceof SystemRecordTypeVO) {
            SystemRecordTypeVO systemRecordTypeVO = (SystemRecordTypeVO)recordTypeVO;
            recordType.setAdminMenu(this.apiHelper.toAdminMenuEnum(systemRecordTypeVO.getAdminMenu()));
        } else if (recordTypeVO instanceof UserRecordTypeVO) {
            UserRecordTypeVO userRecordTypeVO = (UserRecordTypeVO)recordTypeVO;
            recordType.setUserMenu(this.apiHelper.toUserMenuEnum(userRecordTypeVO.getUserMenu()));
            recordType.setUserProfileSection(this.apiHelper.toUserProfileSectionEnum(userRecordTypeVO.getProfileSection()));
        }
        this.apiHelper.setIconOrCustomSVG(recordTypeVO.getIcon(), recordType);
        return recordType;
    }

    public RecordTypeDetailed toRecordTypeDetailed(RecordTypeDetailedVO recordTypeDetailedVO) {
        if (recordTypeDetailedVO == null) {
            return null;
        }
        RecordTypeDetailed recordTypeDetailed = this.newRecordType(RecordTypeDetailed.class, (RecordTypeVO)recordTypeDetailedVO);
        recordTypeDetailed.setAdminMenu(this.apiHelper.toAdminMenuEnum(recordTypeDetailedVO.getAdminMenu()));
        recordTypeDetailed.setUserMenu(this.apiHelper.toUserMenuEnum(recordTypeDetailedVO.getUserMenu()));
        recordTypeDetailed.setUserProfileSection(this.apiHelper.toUserProfileSectionEnum(recordTypeDetailedVO.getProfileSection()));
        recordTypeDetailed.setFieldColumns(recordTypeDetailedVO.getFieldColumns());
        recordTypeDetailed.setNowrapLabels(recordTypeDetailedVO.isNowrapLabels());
        recordTypeDetailed.setInformationText(recordTypeDetailedVO.getInformationText());
        CollectionHelper.orEmpty((List)recordTypeDetailedVO.getSections()).stream().map(this::toRecordSection).forEach(recordTypeDetailed.getSections()::add);
        return recordTypeDetailed;
    }

    public RecordView toRecordView(RecordData recordData) {
        Object object;
        if (recordData == null) {
            return null;
        }
        RecordDTO recordDTO = (RecordDTO)recordData.getDto();
        RecordView recordView = this.apiHelper.newEntity(RecordView.class, recordDTO);
        recordView.setDisplay(recordData.getDisplay());
        recordView.setKind(recordDTO instanceof SystemRecordDTO ? RecordKind.SYSTEM : RecordKind.USER);
        recordView.setType(this.toRecordTypeDetailed(recordDTO.getType()));
        if (recordDTO instanceof UserRecordDTO) {
            object = (UserRecordDTO)recordDTO;
            recordView.setUser(this.usersApiHelper.toUser((BasicUserVO)object.getUser()));
        }
        object = recordData.getFields();
        Map<Long, RecordCustomFieldDetailedVO> map = object.stream().collect(Collectors.toMap(EntityModel::getId, recordCustomFieldDetailedVO -> recordCustomFieldDetailedVO));
        Map<String, Integer> map2 = object.stream().collect(Collectors.toMap(recordCustomFieldDetailedVO -> ApiHelper.toId(recordCustomFieldDetailedVO.getId()), arg_0 -> RecordsApiHelper.lambda$toRecordView$4((List)object, arg_0)));
        List<RecordCustomFieldValue> list = this.apiHelper.toCustomFieldValuesList(RecordCustomFieldValue.class, recordDTO.getCustomValues(), (recordCustomFieldValue, iCustomFieldValue) -> {
            RecordCustomFieldDetailedVO recordCustomFieldDetailedVO = (RecordCustomFieldDetailedVO)map.get(iCustomFieldValue.getField().getId());
            recordCustomFieldValue.setField(this.toRecordCustomField(recordCustomFieldDetailedVO));
        });
        ToIntFunction<RecordCustomFieldValue> toIntFunction = recordCustomFieldValue -> {
            RecordCustomField recordCustomField = recordCustomFieldValue.getField();
            Integer n = recordCustomField == null ? null : (Integer)map2.get(recordCustomField.getId());
            return n == null ? -1 : n;
        };
        if (list != null) {
            list.sort(Comparator.comparingInt(toIntFunction));
        }
        recordView.setCustomValues(list);
        recordView.setCreationDate(recordDTO.getCreationDate());
        recordView.setCreatedBy(this.usersApiHelper.toUser((BasicUserVO)recordDTO.getCreatedBy()));
        recordView.setLastModificationDate(recordDTO.getLastModifiedDate());
        recordView.setLastModifiedBy(this.usersApiHelper.toUser((BasicUserVO)recordDTO.getModifiedBy()));
        recordView.setCanEdit(recordData.isEditable());
        recordView.setCanRemove(recordData.isRemovable());
        CollectionHelper.orEmpty((List)recordData.getCustomOperations()).stream().map(this.operationsApiHelper::toOperation).forEach(recordView.getOperations()::add);
        return recordView;
    }

    public RecordWithOwnerResult toRecordWithOwnerResult(RecordVO recordVO) {
        if (recordVO == null) {
            return null;
        }
        RecordWithOwnerResult recordWithOwnerResult = this.newRecordResult(RecordWithOwnerResult.class, recordVO);
        if (recordVO instanceof UserRecordVO) {
            UserRecordVO userRecordVO = (UserRecordVO)recordVO;
            recordWithOwnerResult.setUser(this.usersApiHelper.toUser((BasicUserVO)userRecordVO.getUser()));
        }
        return recordWithOwnerResult;
    }

    public UserRecordQuery toSharedRecordQuery(SharedRecordsQueryFilters sharedRecordsQueryFilters) {
        UserRecordQuery userRecordQuery = this.toGeneralRecordsQuery(null, sharedRecordsQueryFilters);
        userRecordQuery.setSharedRecordFieldSearch(true);
        userRecordQuery.setSharedRecordTypes(CollectionHelper.orEmpty(sharedRecordsQueryFilters.getTypes()).stream().map(string -> (RecordTypeVO)ModelHelper.voFromString(RecordTypeVO.class, (String)string)).collect(Collectors.toSet()));
        return userRecordQuery;
    }

    public SharedRecordsDataForSearch toSharedRecordsDataForSearch(SharedRecordFieldsSearchData sharedRecordFieldsSearchData) {
        if (sharedRecordFieldsSearchData == null) {
            return null;
        }
        SharedRecordsDataForSearch sharedRecordsDataForSearch = this.newRecordDataForSeach(SharedRecordsDataForSearch.class, (RecordSearchData)sharedRecordFieldsSearchData);
        CollectionHelper.orEmpty((List)sharedRecordFieldsSearchData.getTypes()).stream().map(this::toRecordType).forEach(sharedRecordsDataForSearch.getRecordTypes()::add);
        sharedRecordsDataForSearch.setQuery(this.toSharedRecordsQueryFilters((UserRecordQuery)sharedRecordFieldsSearchData.getQuery()));
        return sharedRecordsDataForSearch;
    }

    public SharedRecordsQueryFilters toSharedRecordsQueryFilters(UserRecordQuery userRecordQuery) {
        if (userRecordQuery == null) {
            return null;
        }
        SharedRecordsQueryFilters sharedRecordsQueryFilters = this.newGeneralRecordsQueryFilters(SharedRecordsQueryFilters.class, userRecordQuery);
        CollectionHelper.orEmpty((Set)userRecordQuery.getSharedRecordTypes()).stream().map(ModelHelper::stringOrIdFromVO).forEach(sharedRecordsQueryFilters.getTypes()::add);
        return sharedRecordsQueryFilters;
    }

    private <F extends GeneralRecordsQueryFilters> F newGeneralRecordsQueryFilters(Class<F> clazz, UserRecordQuery userRecordQuery) {
        GeneralRecordsQueryFilters generalRecordsQueryFilters = (GeneralRecordsQueryFilters)this.newRecordQueryFilters(clazz, (RecordQuery)userRecordQuery);
        CollectionHelper.orEmpty((Set)userRecordQuery.getBrokers()).stream().map(ModelHelper::stringOrIdFromVO).forEach(generalRecordsQueryFilters.getBrokers()::add);
        CollectionHelper.orEmpty((Set)userRecordQuery.getGroups()).stream().map(ModelHelper::stringOrIdFromVO).forEach(generalRecordsQueryFilters.getGroups()::add);
        generalRecordsQueryFilters.setUser(ModelHelper.stringOrIdFromVO((EntityVO)userRecordQuery.getUser()));
        CollectionHelper.orEmpty((Set)userRecordQuery.getUserStatuses()).stream().map(this.userStatusApiHelper::toUserStatusEnum).forEach(generalRecordsQueryFilters.getUserStatuses()::add);
        return (F)generalRecordsQueryFilters;
    }

    private <R extends Record> R newRecord(Class<R> clazz, RecordVO recordVO) {
        Record record = (Record)this.apiHelper.newEntity(clazz, recordVO);
        record.setDisplay(recordVO.getDisplay());
        record.setKind(recordVO instanceof SystemRecordVO ? RecordKind.SYSTEM : RecordKind.USER);
        return (R)record;
    }

    private <P extends RecordBasePermissions> P newRecordBasePermissions(Class<P> clazz, IRecordPermissions iRecordPermissions) {
        RecordBasePermissions recordBasePermissions = (RecordBasePermissions)ClassHelper.instantiate(clazz);
        recordBasePermissions.setType(this.toRecordType(iRecordPermissions.getType()));
        recordBasePermissions.setCreate(iRecordPermissions.isCanCreateNew());
        recordBasePermissions.setEdit(iRecordPermissions.isCanEdit());
        recordBasePermissions.setRemove(iRecordPermissions.isCanRemove());
        return (P)recordBasePermissions;
    }

    private <D extends RecordBasicData> D newRecordBasicData(Class<D> clazz, RecordData recordData) {
        RecordBasicData recordBasicData = (RecordBasicData)ClassHelper.instantiate(clazz);
        RecordDTO recordDTO = (RecordDTO)recordData.getDto();
        recordBasicData.setKind(recordDTO instanceof SystemRecordDTO ? RecordKind.SYSTEM : RecordKind.USER);
        if (recordDTO instanceof UserRecordDTO) {
            UserRecordDTO userRecordDTO = (UserRecordDTO)recordDTO;
            recordBasicData.setUser(this.usersApiHelper.toUser((BasicUserVO)userRecordDTO.getUser()));
        }
        recordBasicData.setType(this.toRecordTypeDetailed(recordDTO.getType()));
        recordData.getFields().stream().filter(recordCustomFieldDetailedVO -> recordDTO.isPersistent() || CollectionHelper.orEmpty((Set)recordData.getEditableFieldIds()).contains(recordCustomFieldDetailedVO.getId())).map(this::toRecordCustomFieldDetailed).forEach(recordBasicData.getFields()::add);
        recordBasicData.setConfirmationPasswordInput(this.authApiHelper.toPasswordInput(recordData.getConfirmationPasswordInput()));
        return (D)recordBasicData;
    }

    private <D extends BaseRecordDataForSearch> D newRecordDataForSeach(Class<D> clazz, RecordSearchData recordSearchData) {
        List list = CollectionHelper.orEmpty((List)recordSearchData.getFieldsForSearch());
        List list2 = CollectionHelper.orEmpty((List)recordSearchData.getFieldsForList());
        BaseRecordDataForSearch baseRecordDataForSearch = (BaseRecordDataForSearch)this.newRecordBasePermissions(clazz, (IRecordPermissions)recordSearchData);
        baseRecordDataForSearch.setHideDateOnList(recordSearchData.isHideDateOnList());
        LinkedHashSet linkedHashSet = new LinkedHashSet(list);
        linkedHashSet.addAll(list2);
        linkedHashSet.stream().map(this.apiHelper::toCustomFieldDetailed).forEach(baseRecordDataForSearch.getCustomFields()::add);
        list.stream().map(ModelHelper::unqualifiedInternalNameOrId).forEach(baseRecordDataForSearch.getFieldsInSearch()::add);
        list2.stream().map(ModelHelper::unqualifiedInternalNameOrId).forEach(baseRecordDataForSearch.getFieldsInList()::add);
        CollectionHelper.orEmpty((List)recordSearchData.getExportFormats()).stream().map(this.apiHelper::toExportFormat).forEach(baseRecordDataForSearch.getExportFormats()::add);
        return (D)baseRecordDataForSearch;
    }

    private <R extends RecordManage> R newRecordManage(Class<R> clazz, RecordDTO recordDTO) {
        RecordManage recordManage = (RecordManage)ClassHelper.instantiate(clazz);
        recordManage.setCustomValues(this.apiHelper.toCustomFieldValuesMap(recordDTO.getCustomValues()));
        return (R)recordManage;
    }

    private <F extends RecordQueryFilters> F newRecordQueryFilters(Class<F> clazz, RecordQuery recordQuery) {
        RecordQueryFilters recordQueryFilters = (RecordQueryFilters)this.apiHelper.newQueryFilters(clazz, (QueryParameters)recordQuery);
        if (recordQuery instanceof UserRecordQuery) {
            UserRecordQuery userRecordQuery = (UserRecordQuery)recordQuery;
            recordQueryFilters.setProfileFields(this.apiHelper.toFilters(userRecordQuery.getUserProfileFields()));
        }
        recordQueryFilters.setKeywords(recordQuery.getKeywords());
        recordQueryFilters.setCustomFields(this.apiHelper.toFilters(recordQuery.getCustomValues()));
        recordQueryFilters.setCreationPeriod(this.apiHelper.toFilter(recordQuery.getDatePeriod()));
        recordQueryFilters.setCreatedBy(ModelHelper.stringOrIdFromVO((EntityVO)recordQuery.getCreatedBy()));
        return (F)recordQueryFilters;
    }

    private <R extends RecordResult> R newRecordResult(Class<R> clazz, RecordVO recordVO) {
        RecordResult recordResult = (RecordResult)this.newRecord(clazz, recordVO);
        recordResult.setCreationDate(recordVO.getCreationDate());
        recordResult.setCreatedBy(this.usersApiHelper.toUser((BasicUserVO)recordVO.getCreatedBy()));
        recordResult.setLastModificationDate(recordVO.getLastModifiedDate());
        recordResult.setLastModifiedBy(this.usersApiHelper.toUser((BasicUserVO)recordVO.getModifiedBy()));
        recordResult.setCustomValues(this.apiHelper.toCustomFieldValuesMap(recordVO.getCustomValues()));
        return (R)recordResult;
    }

    private <T extends RecordType> T newRecordType(Class<T> clazz, RecordTypeVO recordTypeVO) {
        RecordType recordType = (RecordType)this.apiHelper.newEntity(clazz, recordTypeVO);
        recordType.setPluralName(recordTypeVO.getPluralName());
        recordType.setSvgIcon(recordTypeVO.getSvgIcon());
        this.apiHelper.setIconOrCustomSVG(recordTypeVO.getIcon(), recordType);
        recordType.setLayout(this.toRecordLayoutEnum(recordTypeVO.getResultsLayout()));
        recordType.setUseViewPage(recordTypeVO.isUseViewPage());
        return (T)recordType;
    }

    private RecordCustomField toRecordCustomField(RecordCustomFieldDetailedVO recordCustomFieldDetailedVO) {
        if (recordCustomFieldDetailedVO == null) {
            return null;
        }
        RecordCustomField recordCustomField = this.apiHelper.newCustomField(RecordCustomField.class, (CustomFieldVO)recordCustomFieldDetailedVO);
        recordCustomField.setSection(this.apiHelper.toReference((EntityModel)recordCustomFieldDetailedVO.getSection(), true));
        recordCustomField.setColspan(recordCustomFieldDetailedVO.getColspan());
        return recordCustomField;
    }

    private RecordCustomFieldDetailed toRecordCustomFieldDetailed(RecordCustomFieldDetailedVO recordCustomFieldDetailedVO) {
        if (recordCustomFieldDetailedVO == null) {
            return null;
        }
        RecordCustomFieldDetailed recordCustomFieldDetailed = this.apiHelper.newCustomFieldDetailed(RecordCustomFieldDetailed.class, (CustomFieldDetailedVO)recordCustomFieldDetailedVO);
        recordCustomFieldDetailed.setSection(this.apiHelper.toReference((EntityModel)recordCustomFieldDetailedVO.getSection(), true));
        recordCustomFieldDetailed.setColspan(recordCustomFieldDetailedVO.getColspan());
        return recordCustomFieldDetailed;
    }

    private static /* synthetic */ Integer lambda$toRecordView$4(List list, RecordCustomFieldDetailedVO recordCustomFieldDetailedVO) {
        return list.indexOf(recordCustomFieldDetailedVO);
    }
}

