/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.helpers;

import java.util.List;
import org.cyclos.model.access.passwords.ICredentialInputDTO;
import org.cyclos.model.banking.transactions.InstallmentStatus;
import org.cyclos.model.banking.transactions.InstallmentVO;
import org.cyclos.model.banking.transactions.PerformBasePaymentDTO;
import org.cyclos.model.banking.transactions.PerformRecurringPaymentDTO;
import org.cyclos.model.banking.transactions.RecurringPaymentActionDTO;
import org.cyclos.model.banking.transactions.RecurringPaymentDTO;
import org.cyclos.model.banking.transactions.RecurringPaymentData;
import org.cyclos.model.banking.transactions.RecurringPaymentEditData;
import org.cyclos.model.banking.transactions.RecurringPaymentPreviewVO;
import org.cyclos.model.banking.transactions.RecurringPaymentResultVO;
import org.cyclos.model.banking.transactions.RecurringPaymentStatus;
import org.cyclos.model.banking.transactions.RecurringPaymentVO;
import org.cyclos.model.banking.transactions.TransactionVO;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.model.utils.TimeField;
import org.cyclos.model.utils.TimeIntervalDTO;
import org.cyclos.server.utils.ClassHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.StringHelper;
import org.cyclos.web.rest.helpers.ApiHelper;
import org.cyclos.web.rest.helpers.AuthApiHelper;
import org.cyclos.web.rest.helpers.InstallmentsApiHelper;
import org.cyclos.web.rest.helpers.PaymentsApiHelper;
import org.cyclos.web.rest.helpers.TransactionsApiHelper;
import org.cyclos.web.rest.model.BaseTransactionResult;
import org.cyclos.web.rest.model.InstallmentView;
import org.cyclos.web.rest.model.PaymentPreview;
import org.cyclos.web.rest.model.PaymentSchedulingEnum;
import org.cyclos.web.rest.model.PerformPayment;
import org.cyclos.web.rest.model.RecurringPaymentDataForEdit;
import org.cyclos.web.rest.model.RecurringPaymentEdit;
import org.cyclos.web.rest.model.RecurringPaymentPermissions;
import org.cyclos.web.rest.model.RecurringPaymentStatusEnum;
import org.cyclos.web.rest.model.TransactionView;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class RecurringPaymentsApiHelper {
    @Autowired
    private ApiHelper apiHelper;
    @Autowired
    private AuthApiHelper authApiHelper;
    @Autowired
    @Lazy
    private PaymentsApiHelper paymentsApiHelper;
    @Autowired
    private InstallmentsApiHelper installmentsApiHelper;
    @Autowired
    private TransactionsApiHelper transactionsApiHelper;

    public void fillPerform(PerformRecurringPaymentDTO performRecurringPaymentDTO, PerformPayment performPayment) {
        if (!performRecurringPaymentDTO.isUntilCanceled()) {
            performPayment.setOccurrencesCount(performRecurringPaymentDTO.getOccurrencesCount());
        }
        if (!performRecurringPaymentDTO.isFirstOccurrenceIsNow()) {
            performPayment.setFirstOccurrenceDate(performRecurringPaymentDTO.getFirstOccurrenceDate());
        }
        performPayment.setOccurrenceInterval(this.apiHelper.toTimeInterval(performRecurringPaymentDTO.getOccurrenceInterval()));
        performPayment.setScheduling(PaymentSchedulingEnum.RECURRING);
    }

    public void fillPerformDTO(PerformRecurringPaymentDTO performRecurringPaymentDTO, PerformPayment performPayment) {
        performRecurringPaymentDTO.setOccurrencesCount(performPayment.getOccurrencesCount());
        performRecurringPaymentDTO.setUntilCanceled(performPayment.getOccurrencesCount() == null);
        performRecurringPaymentDTO.setFirstOccurrenceDate(performPayment.getFirstOccurrenceDate());
        performRecurringPaymentDTO.setFirstOccurrenceIsNow(performPayment.getFirstOccurrenceDate() == null);
        TimeIntervalDTO timeIntervalDTO = this.apiHelper.toTimeIntervalDTO(performPayment.getOccurrenceInterval());
        if (timeIntervalDTO == null) {
            timeIntervalDTO = ModelHelper.timeInterval((int)1, (TimeField)TimeField.MONTHS);
        } else if (timeIntervalDTO.getAmount() == null) {
            timeIntervalDTO.setAmount(Integer.valueOf(1));
        } else if (timeIntervalDTO.getField() == null) {
            timeIntervalDTO.setField(TimeField.MONTHS);
        }
        performRecurringPaymentDTO.setOccurrenceInterval(timeIntervalDTO);
    }

    public void fillPreview(RecurringPaymentPreviewVO recurringPaymentPreviewVO, PaymentPreview paymentPreview) {
        paymentPreview.setPayment(this.paymentsApiHelper.toPerform((PerformBasePaymentDTO)recurringPaymentPreviewVO.getRecurringPayment()));
        paymentPreview.setMainAmount(this.apiHelper.getAmount(recurringPaymentPreviewVO.getMainAmount()));
        CollectionHelper.orEmpty((List)recurringPaymentPreviewVO.getFees()).stream().map(this.paymentsApiHelper::toFeePreview).forEach(paymentPreview.getFees()::add);
        paymentPreview.setInstallments(null);
    }

    public void fillTransactionResult(RecurringPaymentResultVO recurringPaymentResultVO, BaseTransactionResult baseTransactionResult) {
        baseTransactionResult.setOccurrencesCount(recurringPaymentResultVO.getOccurrencesCount());
        baseTransactionResult.setLastOccurrenceNumber(recurringPaymentResultVO.getLastOccurrenceNumber());
        baseTransactionResult.setNextOccurrenceDate(recurringPaymentResultVO.getNextOccurrenceDate());
        baseTransactionResult.setRecurringPaymentStatus(this.toRecurringPaymentStatusEnum(recurringPaymentResultVO.getStatus()));
    }

    public void fillTransactionView(RecurringPaymentData recurringPaymentData, TransactionView transactionView) {
        RecurringPaymentPermissions recurringPaymentPermissions = this.toRecurringPaymentPermissions(recurringPaymentData);
        transactionView.setRecurringPaymentPermissions(recurringPaymentPermissions);
        CollectionHelper.orEmpty((List)recurringPaymentData.getOccurrences()).stream().map(installmentVO -> this.toInstallmentView((InstallmentVO)installmentVO, recurringPaymentData)).forEach(transactionView.getOccurrences()::add);
    }

    public void fillTransactionView(RecurringPaymentVO recurringPaymentVO, TransactionView transactionView) {
        transactionView.setRecurringPaymentStatus(this.toRecurringPaymentStatusEnum(recurringPaymentVO.getStatus()));
        transactionView.setNextOccurrenceDate(recurringPaymentVO.getNextOccurrenceDate());
        transactionView.setOccurrenceInterval(this.apiHelper.toTimeInterval(recurringPaymentVO.getOccurrenceInterval()));
        transactionView.setOccurrencesCount(recurringPaymentVO.getOccurrencesCount());
    }

    public RecurringPaymentDataForEdit toDataForEdit(RecurringPaymentEditData recurringPaymentEditData) {
        if (recurringPaymentEditData == null) {
            return null;
        }
        RecurringPaymentDataForEdit recurringPaymentDataForEdit = (RecurringPaymentDataForEdit)ClassHelper.instantiate(RecurringPaymentDataForEdit.class);
        recurringPaymentDataForEdit.setCanEdit(recurringPaymentEditData.isCanModify());
        recurringPaymentDataForEdit.setOriginalRecurringPayment(this.transactionsApiHelper.toTransaction((TransactionVO)recurringPaymentEditData.getTransaction()));
        recurringPaymentDataForEdit.setRecurringPayment(this.toRecurringPaymentEdit(recurringPaymentEditData.getDetails()));
        recurringPaymentDataForEdit.setConfirmationPasswordInput(this.authApiHelper.toPasswordInput((ICredentialInputDTO)recurringPaymentEditData.getConfirmationPasswordInput()));
        return recurringPaymentDataForEdit;
    }

    public InstallmentView toInstallmentView(InstallmentVO installmentVO, RecurringPaymentData recurringPaymentData) {
        if (installmentVO == null) {
            return null;
        }
        InstallmentView installmentView = this.installmentsApiHelper.toInstallmentView(installmentVO);
        installmentView.setCanProcess(installmentVO.getStatus() == InstallmentStatus.FAILED && recurringPaymentData.isCanProcessFailed());
        return installmentView;
    }

    public RecurringPaymentActionDTO toRecurringPaymentActionDTO(String string, String string2) {
        RecurringPaymentActionDTO recurringPaymentActionDTO = new RecurringPaymentActionDTO();
        recurringPaymentActionDTO.setRecurringPayment((RecurringPaymentVO)ModelHelper.voFromString(RecurringPaymentVO.class, (String)string));
        recurringPaymentActionDTO.setConfirmationPassword(string2);
        return recurringPaymentActionDTO;
    }

    public RecurringPaymentDTO toRecurringPaymentDTO(String string, RecurringPaymentEdit recurringPaymentEdit) {
        RecurringPaymentVO recurringPaymentVO = (RecurringPaymentVO)ModelHelper.voFromString(RecurringPaymentVO.class, (String)string);
        RecurringPaymentDTO recurringPaymentDTO = new RecurringPaymentDTO();
        if (StringHelper.isNotBlank((Object)recurringPaymentVO.getTransactionNumber())) {
            recurringPaymentDTO.setTransactionNumber(recurringPaymentVO.getTransactionNumber());
        } else {
            recurringPaymentDTO.setId(recurringPaymentVO.getId());
        }
        recurringPaymentDTO.setOccurrencesCount(recurringPaymentEdit.getOccurrencesCount());
        recurringPaymentDTO.setUntilCanceled(recurringPaymentEdit.getOccurrencesCount() == null);
        recurringPaymentDTO.setFirstOccurrenceDate(recurringPaymentEdit.getFirstOccurrenceDate());
        recurringPaymentDTO.setFirstOccurrenceIsNow(recurringPaymentEdit.getFirstOccurrenceDate() == null);
        TimeIntervalDTO timeIntervalDTO = this.apiHelper.toTimeIntervalDTO(recurringPaymentEdit.getOccurrenceInterval());
        if (timeIntervalDTO == null) {
            timeIntervalDTO = ModelHelper.timeInterval((int)1, (TimeField)TimeField.MONTHS);
        } else if (timeIntervalDTO.getAmount() == null) {
            timeIntervalDTO.setAmount(Integer.valueOf(1));
        } else if (timeIntervalDTO.getField() == null) {
            timeIntervalDTO.setField(TimeField.MONTHS);
        }
        recurringPaymentDTO.setOccurrenceInterval(timeIntervalDTO);
        recurringPaymentDTO.setVersion(recurringPaymentEdit.getVersion());
        return recurringPaymentDTO;
    }

    public RecurringPaymentEdit toRecurringPaymentEdit(RecurringPaymentDTO recurringPaymentDTO) {
        if (recurringPaymentDTO == null) {
            return null;
        }
        RecurringPaymentEdit recurringPaymentEdit = (RecurringPaymentEdit)ClassHelper.instantiate(RecurringPaymentEdit.class);
        if (!recurringPaymentDTO.isUntilCanceled()) {
            recurringPaymentEdit.setOccurrencesCount(recurringPaymentDTO.getOccurrencesCount());
        }
        if (!recurringPaymentDTO.isFirstOccurrenceIsNow()) {
            recurringPaymentEdit.setFirstOccurrenceDate(recurringPaymentDTO.getFirstOccurrenceDate());
        }
        recurringPaymentEdit.setOccurrenceInterval(this.apiHelper.toTimeInterval(recurringPaymentDTO.getOccurrenceInterval()));
        recurringPaymentEdit.setVersion(recurringPaymentDTO.getVersion());
        return recurringPaymentEdit;
    }

    public RecurringPaymentPermissions toRecurringPaymentPermissions(RecurringPaymentData recurringPaymentData) {
        RecurringPaymentPermissions recurringPaymentPermissions = new RecurringPaymentPermissions();
        recurringPaymentPermissions.setCancel(recurringPaymentData.isCanCancel());
        recurringPaymentPermissions.setBlock(recurringPaymentData.isCanBlock());
        recurringPaymentPermissions.setUnblock(recurringPaymentData.isCanUnblock());
        recurringPaymentPermissions.setEdit(recurringPaymentData.isCanModify());
        return recurringPaymentPermissions;
    }

    public RecurringPaymentStatus toRecurringPaymentStatus(RecurringPaymentStatusEnum recurringPaymentStatusEnum) {
        if (recurringPaymentStatusEnum != null) {
            switch (recurringPaymentStatusEnum) {
                case OPEN: {
                    return RecurringPaymentStatus.OPEN;
                }
                case BLOCKED: {
                    return RecurringPaymentStatus.BLOCKED;
                }
                case CLOSED: {
                    return RecurringPaymentStatus.CLOSED;
                }
                case CANCELED: {
                    return RecurringPaymentStatus.CANCELED;
                }
            }
        }
        return null;
    }

    public RecurringPaymentStatusEnum toRecurringPaymentStatusEnum(RecurringPaymentStatus recurringPaymentStatus) {
        if (recurringPaymentStatus != null) {
            switch (recurringPaymentStatus) {
                case OPEN: {
                    return RecurringPaymentStatusEnum.OPEN;
                }
                case BLOCKED: {
                    return RecurringPaymentStatusEnum.BLOCKED;
                }
                case CLOSED: {
                    return RecurringPaymentStatusEnum.CLOSED;
                }
                case CANCELED: {
                    return RecurringPaymentStatusEnum.CANCELED;
                }
            }
        }
        return null;
    }
}

