/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.helpers;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.cyclos.model.IEntity;
import org.cyclos.model.QueryParameters;
import org.cyclos.model.users.references.GeneralReferenceDTO;
import org.cyclos.model.users.references.GeneralReferenceData;
import org.cyclos.model.users.references.GeneralReferenceEntryVO;
import org.cyclos.model.users.references.GeneralReferenceQuery;
import org.cyclos.model.users.references.GeneralReferenceSearchData;
import org.cyclos.model.users.references.ReferenceLevel;
import org.cyclos.model.users.references.ReferencePeriodStatisticsVO;
import org.cyclos.model.users.references.ReferenceQuery;
import org.cyclos.model.users.references.ReferenceStatisticsParams;
import org.cyclos.model.users.references.ReferenceStatisticsVO;
import org.cyclos.model.users.references.ReferenceType;
import org.cyclos.model.users.references.ReferenceVO;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.utils.DatePeriodDTO;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.server.utils.ClassHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.DateTime;
import org.cyclos.web.rest.api.PaymentFeedbacksApi;
import org.cyclos.web.rest.api.ReferencesApi;
import org.cyclos.web.rest.helpers.ApiHelper;
import org.cyclos.web.rest.helpers.UsersApiHelper;
import org.cyclos.web.rest.model.BaseReferenceQueryFilters;
import org.cyclos.web.rest.model.Reference;
import org.cyclos.web.rest.model.ReferenceDataForSet;
import org.cyclos.web.rest.model.ReferenceDirectionEnum;
import org.cyclos.web.rest.model.ReferenceLevelEnum;
import org.cyclos.web.rest.model.ReferencePeriodStatistics;
import org.cyclos.web.rest.model.ReferenceSet;
import org.cyclos.web.rest.model.ReferenceStatistics;
import org.cyclos.web.rest.model.ReferenceView;
import org.cyclos.web.rest.model.UserReferenceDataForSearch;
import org.cyclos.web.rest.model.UserReferenceQueryFilters;
import org.cyclos.web.rest.model.UserReferenceResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ReferencesApiHelper {
    @Autowired
    private ApiHelper apiHelper;
    @Autowired
    private UsersApiHelper usersApiHelper;

    public <T extends BaseReferenceQueryFilters> T newBaseReferenceQueryFilters(Class<T> clazz, ReferenceQuery referenceQuery) {
        BaseReferenceQueryFilters baseReferenceQueryFilters = (BaseReferenceQueryFilters)this.apiHelper.newQueryFilters(clazz, (QueryParameters)referenceQuery);
        baseReferenceQueryFilters.setPeriod(this.apiHelper.toFilter(referenceQuery.getPeriod()));
        CollectionHelper.orEmpty((Set)referenceQuery.getLevels()).stream().map(this::toReferenceLevelEnum).forEach(baseReferenceQueryFilters.getLevels()::add);
        baseReferenceQueryFilters.setDirection(this.toReferenceDirectionEnum(referenceQuery.getReferenceType()));
        baseReferenceQueryFilters.setRelatedUser(ModelHelper.internalNameOrId((IEntity)referenceQuery.getUser()));
        return (T)baseReferenceQueryFilters;
    }

    public <R extends Reference> R newReference(Class<R> clazz, Long l, DateTime dateTime, ReferenceLevel referenceLevel, String string) {
        Reference reference = (Reference)ClassHelper.instantiate(clazz);
        reference.setId(ApiHelper.toId(l));
        reference.setDate(dateTime);
        reference.setLevel(this.toReferenceLevelEnum(referenceLevel));
        reference.setComments(string);
        return (R)reference;
    }

    public ReferencesStatisticParamsBuilder statisticParamsBuilder() {
        return new ReferencesStatisticParamsBuilder();
    }

    public GeneralReferenceDTO toGeneralReferenceDTO(ReferenceSet referenceSet) {
        GeneralReferenceDTO generalReferenceDTO = new GeneralReferenceDTO();
        generalReferenceDTO.setLevel(this.toReferenceLevel(referenceSet.getLevel()));
        generalReferenceDTO.setComments(referenceSet.getComments());
        generalReferenceDTO.setVersion(referenceSet.getVersion());
        return generalReferenceDTO;
    }

    public GeneralReferenceQuery toGeneralReferenceQuery(ReferencesApi.SearchUserReferencesParams searchUserReferencesParams) {
        GeneralReferenceQuery generalReferenceQuery = this.apiHelper.newQuery(GeneralReferenceQuery.class, searchUserReferencesParams.page, searchUserReferencesParams.pageSize, searchUserReferencesParams.skipTotalCount);
        generalReferenceQuery.setOwner((UserLocatorVO)ModelHelper.voFromString(UserLocatorVO.class, (String)searchUserReferencesParams.user));
        generalReferenceQuery.setUser((UserLocatorVO)ModelHelper.voFromString(UserLocatorVO.class, (String)searchUserReferencesParams.relatedUser));
        generalReferenceQuery.setLevels(CollectionHelper.orEmpty(searchUserReferencesParams.levels).stream().map(this::toReferenceLevel).collect(Collectors.toSet()));
        generalReferenceQuery.setReferenceType(this.toReferenceType(searchUserReferencesParams.direction));
        generalReferenceQuery.setPeriod(this.apiHelper.toDatePeriodDTO(searchUserReferencesParams.period));
        return generalReferenceQuery;
    }

    public Reference toReference(ReferenceVO referenceVO) {
        if (referenceVO == null) {
            return null;
        }
        return this.newReference(Reference.class, referenceVO.getId(), referenceVO.getDate(), referenceVO.getLevel(), referenceVO.getComments());
    }

    public ReferenceDataForSet toReferenceDataForSet(GeneralReferenceData generalReferenceData) {
        ReferenceDataForSet referenceDataForSet = new ReferenceDataForSet();
        GeneralReferenceDTO generalReferenceDTO = (GeneralReferenceDTO)generalReferenceData.getDto();
        referenceDataForSet.setFrom(this.usersApiHelper.toUser((BasicUserVO)generalReferenceDTO.getFrom()));
        referenceDataForSet.setTo(this.usersApiHelper.toUser((BasicUserVO)generalReferenceDTO.getTo()));
        referenceDataForSet.setReference(this.toReferenceSet(generalReferenceDTO));
        referenceDataForSet.setDate(generalReferenceDTO.getDate());
        return referenceDataForSet;
    }

    public ReferenceDirectionEnum toReferenceDirectionEnum(ReferenceType referenceType) {
        if (referenceType != null) {
            switch (referenceType) {
                case GIVEN: {
                    return ReferenceDirectionEnum.GIVEN;
                }
                case RECEIVED: {
                    return ReferenceDirectionEnum.RECEIVED;
                }
            }
        }
        return null;
    }

    public ReferenceLevel toReferenceLevel(ReferenceLevelEnum referenceLevelEnum) {
        if (referenceLevelEnum != null) {
            switch (referenceLevelEnum) {
                case VERY_BAD: {
                    return ReferenceLevel.VERY_BAD;
                }
                case BAD: {
                    return ReferenceLevel.BAD;
                }
                case NEUTRAL: {
                    return ReferenceLevel.NEUTRAL;
                }
                case GOOD: {
                    return ReferenceLevel.GOOD;
                }
                case VERY_GOOD: {
                    return ReferenceLevel.VERY_GOOD;
                }
            }
        }
        return null;
    }

    public ReferenceLevelEnum toReferenceLevelEnum(ReferenceLevel referenceLevel) {
        if (referenceLevel != null) {
            switch (referenceLevel) {
                case VERY_BAD: {
                    return ReferenceLevelEnum.VERY_BAD;
                }
                case BAD: {
                    return ReferenceLevelEnum.BAD;
                }
                case NEUTRAL: {
                    return ReferenceLevelEnum.NEUTRAL;
                }
                case GOOD: {
                    return ReferenceLevelEnum.GOOD;
                }
                case VERY_GOOD: {
                    return ReferenceLevelEnum.VERY_GOOD;
                }
                case NA: {
                    return null;
                }
            }
        }
        return null;
    }

    public ReferencePeriodStatistics toReferencePeriodStatistics(ReferencePeriodStatisticsVO referencePeriodStatisticsVO) {
        ReferencePeriodStatistics referencePeriodStatistics = new ReferencePeriodStatistics();
        referencePeriodStatistics.setPeriod(this.apiHelper.toDatePeriod(referencePeriodStatisticsVO.getPeriod()));
        referencePeriodStatistics.setScore(Float.valueOf(referencePeriodStatisticsVO.getScore()));
        referencePeriodStatistics.setTotal(referencePeriodStatisticsVO.getTotal());
        referencePeriodStatistics.setTotalPositive(referencePeriodStatisticsVO.getTotalPositive());
        referencePeriodStatistics.setTotalNegative(referencePeriodStatisticsVO.getTotalNegative());
        CollectionHelper.orEmpty((Map)referencePeriodStatisticsVO.getCounts()).entrySet().stream().forEach(entry -> {
            ReferenceLevelEnum referenceLevelEnum = this.toReferenceLevelEnum((ReferenceLevel)entry.getKey());
            int n = (Integer)entry.getValue();
            if (referenceLevelEnum != null) {
                referencePeriodStatistics.getCounts().put(referenceLevelEnum.toString(), n);
            }
        });
        return referencePeriodStatistics;
    }

    public ReferenceStatistics toReferenceStatistics(ReferenceStatisticsVO referenceStatisticsVO) {
        ReferenceStatistics referenceStatistics = new ReferenceStatistics();
        referenceStatistics.setUser(this.usersApiHelper.toUser((BasicUserVO)referenceStatisticsVO.getOwner()));
        CollectionHelper.orEmpty((List)referenceStatisticsVO.getPeriods()).stream().map(this::toReferencePeriodStatistics).forEach(referenceStatistics.getPeriods()::add);
        return referenceStatistics;
    }

    public ReferenceStatisticsParams toReferenceStatisticsParams(ReferencesApi.GetUserReferenceStatisticsParams getUserReferenceStatisticsParams) {
        return this.statisticParamsBuilder().buildFrom(getUserReferenceStatisticsParams);
    }

    public ReferenceType toReferenceType(ReferenceDirectionEnum referenceDirectionEnum) {
        if (referenceDirectionEnum != null) {
            switch (referenceDirectionEnum) {
                case GIVEN: {
                    return ReferenceType.GIVEN;
                }
                case RECEIVED: {
                    return ReferenceType.RECEIVED;
                }
            }
        }
        return null;
    }

    public ReferenceView toReferenceView(GeneralReferenceData generalReferenceData) {
        GeneralReferenceDTO generalReferenceDTO = (GeneralReferenceDTO)generalReferenceData.getDto();
        ReferenceView referenceView = this.apiHelper.newEntity(ReferenceView.class, generalReferenceDTO);
        referenceView.setDate(generalReferenceDTO.getDate());
        referenceView.setLevel(this.toReferenceLevelEnum(generalReferenceDTO.getLevel()));
        referenceView.setFrom(this.usersApiHelper.toUser((BasicUserVO)generalReferenceDTO.getFrom()));
        referenceView.setTo(this.usersApiHelper.toUser((BasicUserVO)generalReferenceDTO.getTo()));
        referenceView.setComments(generalReferenceDTO.getComments());
        referenceView.setCanEdit(generalReferenceData.isEditable());
        return referenceView;
    }

    public UserReferenceDataForSearch toUserReferenceDataForSearch(GeneralReferenceSearchData generalReferenceSearchData) {
        UserReferenceDataForSearch userReferenceDataForSearch = new UserReferenceDataForSearch();
        userReferenceDataForSearch.setUser(this.usersApiHelper.toUser((BasicUserVO)generalReferenceSearchData.getOwner()));
        userReferenceDataForSearch.setManage(generalReferenceSearchData.isEditable());
        userReferenceDataForSearch.setSet(generalReferenceSearchData.isCanSetReference());
        userReferenceDataForSearch.setCurrent(this.toReference((ReferenceVO)generalReferenceSearchData.getCurrent()));
        userReferenceDataForSearch.setQuery(this.toUserReferenceQueryFilters((GeneralReferenceQuery)generalReferenceSearchData.getQuery()));
        CollectionHelper.orEmpty((List)generalReferenceSearchData.getDirections()).stream().map(this::toReferenceDirectionEnum).forEach(userReferenceDataForSearch.getDirections()::add);
        return userReferenceDataForSearch;
    }

    public UserReferenceResult toUserReferenceResult(GeneralReferenceEntryVO generalReferenceEntryVO) {
        UserReferenceResult userReferenceResult = this.newReference(UserReferenceResult.class, generalReferenceEntryVO.getId(), generalReferenceEntryVO.getDate(), generalReferenceEntryVO.getLevel(), generalReferenceEntryVO.getComments());
        userReferenceResult.setRelatedUser(this.usersApiHelper.toUser((BasicUserVO)generalReferenceEntryVO.getRelatedUser()));
        userReferenceResult.setDirection(this.toReferenceDirectionEnum(generalReferenceEntryVO.getReferenceType()));
        return userReferenceResult;
    }

    private ReferenceSet toReferenceSet(GeneralReferenceDTO generalReferenceDTO) {
        ReferenceSet referenceSet = new ReferenceSet();
        referenceSet.setLevel(this.toReferenceLevelEnum(generalReferenceDTO.getLevel()));
        referenceSet.setComments(generalReferenceDTO.getComments());
        referenceSet.setVersion(generalReferenceDTO.getVersion());
        return referenceSet;
    }

    private UserReferenceQueryFilters toUserReferenceQueryFilters(GeneralReferenceQuery generalReferenceQuery) {
        return this.newBaseReferenceQueryFilters(UserReferenceQueryFilters.class, (ReferenceQuery)generalReferenceQuery);
    }

    public class ReferencesStatisticParamsBuilder {
        private UserLocatorVO user;
        private ReferenceType direction;
        private List<DatePeriodDTO> periods;

        public ReferenceStatisticsParams build() {
            ReferenceStatisticsParams referenceStatisticsParams = new ReferenceStatisticsParams();
            referenceStatisticsParams.setOwner(this.user);
            referenceStatisticsParams.setReferenceType(this.direction);
            referenceStatisticsParams.setPeriods(this.periods);
            return referenceStatisticsParams;
        }

        public ReferenceStatisticsParams buildFrom(PaymentFeedbacksApi.GetPaymentFeedbackStatisticsParams getPaymentFeedbackStatisticsParams) {
            this.setDirection(getPaymentFeedbackStatisticsParams.direction);
            this.setPeriods(getPaymentFeedbackStatisticsParams.periods);
            return this.setUser(getPaymentFeedbackStatisticsParams.user).build();
        }

        public ReferenceStatisticsParams buildFrom(ReferencesApi.GetUserReferenceStatisticsParams getUserReferenceStatisticsParams) {
            this.setDirection(getUserReferenceStatisticsParams.direction);
            this.setPeriods(getUserReferenceStatisticsParams.periods);
            return this.setUser(getUserReferenceStatisticsParams.user).build();
        }

        public ReferencesStatisticParamsBuilder setDirection(ReferenceDirectionEnum referenceDirectionEnum) {
            this.direction = ReferencesApiHelper.this.toReferenceType(referenceDirectionEnum);
            return this;
        }

        public ReferencesStatisticParamsBuilder setPeriods(List<String> list) {
            this.periods = CollectionHelper.orEmpty(list).stream().map(ReferencesApiHelper.this.apiHelper::toDatePeriodDTO).collect(Collectors.toList());
            return this;
        }

        public ReferencesStatisticParamsBuilder setUser(String string) {
            this.user = (UserLocatorVO)ModelHelper.voFromString(UserLocatorVO.class, (String)string);
            return this;
        }
    }
}

