/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.helpers;

import java.util.List;
import java.util.stream.Collectors;
import org.cyclos.model.banking.currencies.CurrencyVO;
import org.cyclos.model.banking.transactions.CalculateInstallmentsDTO;
import org.cyclos.model.banking.transactions.InstallmentDTO;
import org.cyclos.model.banking.transactions.PerformBasePaymentDTO;
import org.cyclos.model.banking.transactions.PerformScheduledPaymentDTO;
import org.cyclos.model.banking.transactions.ScheduledPaymentActionDTO;
import org.cyclos.model.banking.transactions.ScheduledPaymentData;
import org.cyclos.model.banking.transactions.ScheduledPaymentPreviewVO;
import org.cyclos.model.banking.transactions.ScheduledPaymentResultVO;
import org.cyclos.model.banking.transactions.ScheduledPaymentStatus;
import org.cyclos.model.banking.transactions.ScheduledPaymentVO;
import org.cyclos.model.banking.transfertypes.TransferTypeVO;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.web.rest.api.PaymentsApi;
import org.cyclos.web.rest.helpers.ApiHelper;
import org.cyclos.web.rest.helpers.InstallmentsApiHelper;
import org.cyclos.web.rest.helpers.PaymentsApiHelper;
import org.cyclos.web.rest.model.BaseTransactionResult;
import org.cyclos.web.rest.model.InstallmentView;
import org.cyclos.web.rest.model.PaymentPreview;
import org.cyclos.web.rest.model.PaymentSchedulingEnum;
import org.cyclos.web.rest.model.PerformInstallment;
import org.cyclos.web.rest.model.PerformPayment;
import org.cyclos.web.rest.model.ScheduledPaymentPermissions;
import org.cyclos.web.rest.model.ScheduledPaymentStatusEnum;
import org.cyclos.web.rest.model.TransactionView;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class ScheduledPaymentsApiHelper {
    @Autowired
    private ApiHelper apiHelper;
    @Autowired
    @Lazy
    private PaymentsApiHelper paymentsApiHelper;
    @Autowired
    @Lazy
    private InstallmentsApiHelper installmentsApiHelper;

    public void fillPerform(PerformScheduledPaymentDTO performScheduledPaymentDTO, PerformPayment performPayment) {
        if (!performScheduledPaymentDTO.isFirstInstallmentIsNow()) {
            performPayment.setFirstInstallmentDate(performScheduledPaymentDTO.getFirstInstallmentDate());
        }
        performPayment.setInstallmentsCount(performScheduledPaymentDTO.getInstallmentsCount());
        CollectionHelper.orEmpty((List)performScheduledPaymentDTO.getInstallments()).stream().map(this::toPerformInstallment).forEach(performPayment.getInstallments()::add);
        performPayment.setScheduling(PaymentSchedulingEnum.SCHEDULED);
    }

    public void fillPerformDTO(PerformScheduledPaymentDTO performScheduledPaymentDTO, PerformPayment performPayment) {
        performScheduledPaymentDTO.setInstallmentsCount(performPayment.getInstallmentsCount());
        performScheduledPaymentDTO.setFirstInstallmentDate(performPayment.getFirstInstallmentDate());
        performScheduledPaymentDTO.setFirstInstallmentIsNow(performPayment.getFirstInstallmentDate() == null);
        performScheduledPaymentDTO.setInstallments(CollectionHelper.orEmpty(performPayment.getInstallments()).stream().map(this::toInstallmentDTO).collect(Collectors.toList()));
    }

    public void fillPreview(ScheduledPaymentPreviewVO scheduledPaymentPreviewVO, PaymentPreview paymentPreview) {
        paymentPreview.setPayment(this.paymentsApiHelper.toPerform((PerformBasePaymentDTO)scheduledPaymentPreviewVO.getScheduledPayment()));
        CollectionHelper.orEmpty((List)scheduledPaymentPreviewVO.getInstallments()).stream().map(this.installmentsApiHelper::toInstallmentPreview).forEach(paymentPreview.getInstallments()::add);
        paymentPreview.setFees(null);
    }

    public void fillTransactionResult(ScheduledPaymentResultVO scheduledPaymentResultVO, BaseTransactionResult baseTransactionResult) {
        baseTransactionResult.setInstallmentCount(scheduledPaymentResultVO.getInstallmentCount());
        baseTransactionResult.setProcessedInstallments(scheduledPaymentResultVO.getProcessedInstallments());
        baseTransactionResult.setScheduledPaymentStatus(this.toScheduledPaymentStatusEnum(scheduledPaymentResultVO.getStatus()));
        baseTransactionResult.setFirstInstallment(this.installmentsApiHelper.toInstallment(scheduledPaymentResultVO.getFirstInstallment()));
        baseTransactionResult.setFirstOpenInstallment(this.installmentsApiHelper.toInstallment(scheduledPaymentResultVO.getFirstOpenInstallment()));
    }

    public void fillTransactionView(ScheduledPaymentData scheduledPaymentData, TransactionView transactionView) {
        ScheduledPaymentPermissions scheduledPaymentPermissions = new ScheduledPaymentPermissions();
        scheduledPaymentPermissions.setCancel(scheduledPaymentData.isCanCancel());
        scheduledPaymentPermissions.setBlock(scheduledPaymentData.isCanBlock());
        scheduledPaymentPermissions.setUnblock(scheduledPaymentData.isCanUnblock());
        scheduledPaymentPermissions.setSettle(scheduledPaymentData.isCanSettle());
        transactionView.setScheduledPaymentPermissions(scheduledPaymentPermissions);
        for (int i = 0; i < transactionView.getInstallmentsCount(); ++i) {
            InstallmentView installmentView = transactionView.getInstallments().get(i);
            installmentView.setCanProcess((Boolean)scheduledPaymentData.getCanProcessInstallment().get(i));
            installmentView.setCanSettle((Boolean)scheduledPaymentData.getCanSettleInstallment().get(i));
        }
    }

    public void fillTransactionView(ScheduledPaymentVO scheduledPaymentVO, TransactionView transactionView) {
        transactionView.setScheduledPaymentStatus(this.toScheduledPaymentStatusEnum(scheduledPaymentVO.getStatus()));
        transactionView.setDueAmount(this.apiHelper.getAmount(scheduledPaymentVO.getDueAmount()));
        CollectionHelper.orEmpty((List)scheduledPaymentVO.getInstallments()).stream().map(this.installmentsApiHelper::toInstallmentView).forEach(transactionView.getInstallments()::add);
        transactionView.setInstallmentsCount(transactionView.getInstallments().size());
    }

    public CalculateInstallmentsDTO toCalculateInstallments(PaymentsApi.CalculatePerformPaymentInstallmentsParams calculatePerformPaymentInstallmentsParams) {
        CalculateInstallmentsDTO calculateInstallmentsDTO = new CalculateInstallmentsDTO();
        calculateInstallmentsDTO.setOwner(ModelHelper.accountOwner((String)calculatePerformPaymentInstallmentsParams.owner));
        calculateInstallmentsDTO.setSubject(ModelHelper.accountOwner((String)calculatePerformPaymentInstallmentsParams.to));
        calculateInstallmentsDTO.setAmount(this.apiHelper.toBigDecimal(calculatePerformPaymentInstallmentsParams.amount));
        calculateInstallmentsDTO.setFirstInstallmentDate(calculatePerformPaymentInstallmentsParams.firstDate);
        calculateInstallmentsDTO.setFirstInstallmentIsNow(calculatePerformPaymentInstallmentsParams.firstDate == null);
        calculateInstallmentsDTO.setInstallmentsCount(calculatePerformPaymentInstallmentsParams.count);
        calculateInstallmentsDTO.setType((TransferTypeVO)ModelHelper.voFromString(TransferTypeVO.class, (String)calculatePerformPaymentInstallmentsParams.type));
        calculateInstallmentsDTO.setCurrency((CurrencyVO)ModelHelper.voFromString(CurrencyVO.class, (String)calculatePerformPaymentInstallmentsParams.currency));
        return calculateInstallmentsDTO;
    }

    public InstallmentDTO toInstallmentDTO(PerformInstallment performInstallment) {
        if (performInstallment == null) {
            return null;
        }
        InstallmentDTO installmentDTO = new InstallmentDTO();
        installmentDTO.setDueDate(performInstallment.getDueDate());
        installmentDTO.setAmount(performInstallment.getAmount());
        return installmentDTO;
    }

    public PerformInstallment toPerformInstallment(InstallmentDTO installmentDTO) {
        if (installmentDTO == null) {
            return null;
        }
        PerformInstallment performInstallment = new PerformInstallment();
        performInstallment.setDueDate(installmentDTO.getDueDate());
        performInstallment.setAmount(installmentDTO.getAmount());
        return performInstallment;
    }

    public ScheduledPaymentActionDTO toScheduledPaymentActionDTO(String string, String string2) {
        ScheduledPaymentActionDTO scheduledPaymentActionDTO = new ScheduledPaymentActionDTO();
        scheduledPaymentActionDTO.setScheduledPayment((ScheduledPaymentVO)ModelHelper.voFromString(ScheduledPaymentVO.class, (String)string));
        scheduledPaymentActionDTO.setConfirmationPassword(string2);
        return scheduledPaymentActionDTO;
    }

    public ScheduledPaymentStatus toScheduledPaymentStatus(ScheduledPaymentStatusEnum scheduledPaymentStatusEnum) {
        if (scheduledPaymentStatusEnum != null) {
            switch (scheduledPaymentStatusEnum) {
                case OPEN: {
                    return ScheduledPaymentStatus.OPEN;
                }
                case CLOSED: {
                    return ScheduledPaymentStatus.CLOSED;
                }
                case BLOCKED: {
                    return ScheduledPaymentStatus.BLOCKED;
                }
                case CANCELED: {
                    return ScheduledPaymentStatus.CANCELED;
                }
            }
        }
        return null;
    }

    public ScheduledPaymentStatusEnum toScheduledPaymentStatusEnum(ScheduledPaymentStatus scheduledPaymentStatus) {
        if (scheduledPaymentStatus != null) {
            switch (scheduledPaymentStatus) {
                case OPEN: {
                    return ScheduledPaymentStatusEnum.OPEN;
                }
                case CLOSED: {
                    return ScheduledPaymentStatusEnum.CLOSED;
                }
                case BLOCKED: {
                    return ScheduledPaymentStatusEnum.BLOCKED;
                }
                case CANCELED: {
                    return ScheduledPaymentStatusEnum.CANCELED;
                }
            }
        }
        return null;
    }
}

