/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.helpers;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.banking.currencies.CurrencyVO;
import org.cyclos.model.banking.transfertypes.TransferTypeVO;
import org.cyclos.model.marketplace.advertisements.AdWebShopVO;
import org.cyclos.model.marketplace.webshopdeliverymethods.AdDeliveryMethodVO;
import org.cyclos.model.marketplace.webshoporders.OrderAddressDTO;
import org.cyclos.model.marketplace.webshoporders.OrderDTO;
import org.cyclos.model.marketplace.webshoporders.OrderData;
import org.cyclos.model.marketplace.webshoporders.OrderProductDTO;
import org.cyclos.model.marketplace.webshoporders.OrderStatus;
import org.cyclos.model.marketplace.webshoporders.OrderVO;
import org.cyclos.model.marketplace.webshoporders.QuantityAdjustment;
import org.cyclos.model.marketplace.webshoporders.ShoppingCartCheckoutParams;
import org.cyclos.model.marketplace.webshoporders.ShoppingCartDTO;
import org.cyclos.model.users.addresses.AddressDTO;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.utils.BigDecimalHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.web.rest.helpers.AccountsApiHelper;
import org.cyclos.web.rest.helpers.AddressesApiHelper;
import org.cyclos.web.rest.helpers.ApiHelper;
import org.cyclos.web.rest.helpers.AuthApiHelper;
import org.cyclos.web.rest.helpers.DeliveryMethodsApiHelper;
import org.cyclos.web.rest.helpers.MarketplaceApiHelper;
import org.cyclos.web.rest.helpers.OrdersApiHelper;
import org.cyclos.web.rest.helpers.UsersApiHelper;
import org.cyclos.web.rest.model.AdStatusEnum;
import org.cyclos.web.rest.model.BaseShoppingCart;
import org.cyclos.web.rest.model.ShoppingCartCheckout;
import org.cyclos.web.rest.model.ShoppingCartDataForCheckout;
import org.cyclos.web.rest.model.ShoppingCartItem;
import org.cyclos.web.rest.model.ShoppingCartItemAvailabilityEnum;
import org.cyclos.web.rest.model.ShoppingCartItemDetailed;
import org.cyclos.web.rest.model.ShoppingCartItemQuantityAdjustmentEnum;
import org.cyclos.web.rest.model.ShoppingCartResult;
import org.cyclos.web.rest.model.ShoppingCartView;
import org.cyclos.web.rest.model.WebshopAd;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class ShoppingCartsApiHelper {
    @Autowired
    private ApiHelper apiHelper;
    @Autowired
    private UsersApiHelper usersApiHelper;
    @Autowired
    private AddressesApiHelper addressesApiHelper;
    @Autowired
    private AuthApiHelper authApiHelper;
    @Autowired
    private AccountsApiHelper accountsApiHelper;
    @Autowired
    @Lazy
    private MarketplaceApiHelper marketplaceApiHelper;
    @Autowired
    private DeliveryMethodsApiHelper deliveryMethodsApiHelper;
    @Autowired
    @Lazy
    private OrdersApiHelper ordersApiHelper;

    public ShoppingCartCheckoutParams toShoppingCartCheckoutParams(String string, String string2, ShoppingCartCheckout shoppingCartCheckout) {
        ShoppingCartCheckoutParams shoppingCartCheckoutParams = new ShoppingCartCheckoutParams();
        shoppingCartCheckoutParams.setOrder(new OrderVO(this.apiHelper.fromId(string)));
        shoppingCartCheckoutParams.setDeliveryMethod((AdDeliveryMethodVO)ModelHelper.voFromString(AdDeliveryMethodVO.class, (String)shoppingCartCheckout.getDeliveryMethod()));
        shoppingCartCheckoutParams.setDeliveryAddress((AddressDTO)this.addressesApiHelper.toAddressDTO(OrderAddressDTO.class, shoppingCartCheckout.getDeliveryAddress()));
        shoppingCartCheckoutParams.setConfirmationPassword(string2);
        shoppingCartCheckoutParams.setPaymentType((TransferTypeVO)ModelHelper.voFromString(TransferTypeVO.class, (String)shoppingCartCheckout.getPaymentType()));
        shoppingCartCheckoutParams.setRemarks(shoppingCartCheckout.getRemarks());
        return shoppingCartCheckoutParams;
    }

    public ShoppingCartDataForCheckout toShoppingCartDataForCheckout(OrderData orderData) {
        ShoppingCartDataForCheckout shoppingCartDataForCheckout = new ShoppingCartDataForCheckout();
        CollectionHelper.orEmpty((List)orderData.getPaymentTypes()).stream().map(this.accountsApiHelper::toTransferType).forEach(shoppingCartDataForCheckout.getPaymentTypes()::add);
        CollectionHelper.orEmpty((List)orderData.getDeliveryMethods()).stream().map(this.deliveryMethodsApiHelper::toDeliveryMethod).forEach(shoppingCartDataForCheckout.getDeliveryMethods()::add);
        CollectionHelper.orEmpty((List)orderData.getBuyerAddresses()).stream().map(this.addressesApiHelper::toAddress).forEach(shoppingCartDataForCheckout.getAddresses()::add);
        shoppingCartDataForCheckout.setAddressConfiguration(this.addressesApiHelper.toAddressConfiguration(orderData.getBuyerAddressConfiguration()));
        shoppingCartDataForCheckout.setConfirmationPasswordInput(this.authApiHelper.toPasswordInput(orderData.getConfirmationPasswordInput()));
        shoppingCartDataForCheckout.setCart(this.toShoppingCartView(orderData));
        return shoppingCartDataForCheckout;
    }

    public List<ShoppingCartResult> toShoppingCarts(ShoppingCartDTO shoppingCartDTO) {
        if (shoppingCartDTO == null) {
            return null;
        }
        ArrayList<ShoppingCartResult> arrayList = new ArrayList<ShoppingCartResult>();
        CollectionHelper.orEmpty((List)shoppingCartDTO.getOrders()).stream().map(orderDTO -> this.toShoppingCartResult((OrderDTO)orderDTO, shoppingCartDTO.getLowBalanceCurrencies())).forEach(arrayList::add);
        return arrayList;
    }

    public ShoppingCartView toShoppingCartView(OrderData orderData) {
        if (orderData == null) {
            return null;
        }
        OrderDTO orderDTO = (OrderDTO)orderData.getDto();
        ShoppingCartView shoppingCartView = this.newShoppingCart(ShoppingCartView.class, orderDTO, orderData.getInsufficientBalance());
        shoppingCartView.setTotalPrice(BigDecimal.ZERO);
        CollectionHelper.orEmpty((List)orderDTO.getProducts()).stream().map(this::toShoppingCartItemDetailed).forEach(shoppingCartItemDetailed -> {
            shoppingCartView.getItems().add((ShoppingCartItemDetailed)shoppingCartItemDetailed);
            shoppingCartView.setTotalPrice(shoppingCartView.getTotalPrice().add(shoppingCartItemDetailed.getTotalPrice()));
        });
        return shoppingCartView;
    }

    private BigDecimal getTotalPrice(BigDecimal bigDecimal, BigDecimal bigDecimal2, CurrencyVO currencyVO) {
        int n = currencyVO.getPrecision();
        BigDecimal bigDecimal3 = bigDecimal.multiply(bigDecimal2);
        return BigDecimalHelper.round((BigDecimal)bigDecimal3, (int)n);
    }

    private <T extends BaseShoppingCart> T newShoppingCart(Class<T> clazz, OrderDTO orderDTO, Boolean bl) {
        if (orderDTO == null) {
            return null;
        }
        if (orderDTO.getStatus() != OrderStatus.SHOPPING_CART) {
            throw new EntityNotFoundException(OrderDTO.class, orderDTO.getId());
        }
        BaseShoppingCart baseShoppingCart = (BaseShoppingCart)this.apiHelper.newEntity(clazz, orderDTO);
        baseShoppingCart.setCurrency(this.accountsApiHelper.toCurrency(orderDTO.getCurrency()));
        baseShoppingCart.setSeller(this.usersApiHelper.toUser((BasicUserVO)orderDTO.getSeller()));
        baseShoppingCart.setInsufficientBalance(bl);
        return (T)baseShoppingCart;
    }

    private <T extends ShoppingCartItem> T newShoppingCartItem(Class<T> clazz, OrderProductDTO orderProductDTO) {
        if (orderProductDTO == null) {
            return null;
        }
        ShoppingCartItem shoppingCartItem = (ShoppingCartItem)this.ordersApiHelper.newBaseOrderItem(clazz, orderProductDTO);
        shoppingCartItem.setPriceWhenAdded(orderProductDTO.getPrice());
        AdWebShopVO adWebShopVO = orderProductDTO.getProduct();
        shoppingCartItem.setPrice(this.apiHelper.getAmount(adWebShopVO.getPrice()));
        shoppingCartItem.setPromotionalPrice(adWebShopVO.isPromotionalPeriodActive() ? adWebShopVO.getPromotionalPrice() : null);
        return (T)shoppingCartItem;
    }

    private ShoppingCartItem toShoppingCartItem(OrderProductDTO orderProductDTO) {
        if (orderProductDTO == null) {
            return null;
        }
        return this.newShoppingCartItem(ShoppingCartItem.class, orderProductDTO);
    }

    private ShoppingCartItemDetailed toShoppingCartItemDetailed(OrderProductDTO orderProductDTO) {
        if (orderProductDTO == null) {
            return null;
        }
        ShoppingCartItemDetailed shoppingCartItemDetailed = this.newShoppingCartItem(ShoppingCartItemDetailed.class, orderProductDTO);
        BigDecimal bigDecimal = this.getTotalPrice(orderProductDTO.getProduct().getCurrentPrice(), orderProductDTO.getQuantity(), orderProductDTO.getOrder().getCurrency());
        shoppingCartItemDetailed.setTotalPrice(bigDecimal);
        WebshopAd webshopAd = shoppingCartItemDetailed.getProduct();
        ShoppingCartItemAvailabilityEnum shoppingCartItemAvailabilityEnum = webshopAd.getUnlimitedStock() == false && (webshopAd.getStockQuantity() == null || BigDecimalHelper.isZero((BigDecimal)webshopAd.getStockQuantity())) ? ShoppingCartItemAvailabilityEnum.OUT_OF_STOCK : (webshopAd.getStatus() != AdStatusEnum.ACTIVE ? ShoppingCartItemAvailabilityEnum.UNAVAILABLE : ShoppingCartItemAvailabilityEnum.AVAILABLE);
        shoppingCartItemDetailed.setAvailability(shoppingCartItemAvailabilityEnum);
        shoppingCartItemDetailed.setQuantityAdjustment(this.toShoppingCartItemQuantityAdjustmentEnum(orderProductDTO.getQuantityAdjustment()));
        return shoppingCartItemDetailed;
    }

    private ShoppingCartItemQuantityAdjustmentEnum toShoppingCartItemQuantityAdjustmentEnum(QuantityAdjustment quantityAdjustment) {
        if (quantityAdjustment != null) {
            switch (quantityAdjustment) {
                case MAX: {
                    return ShoppingCartItemQuantityAdjustmentEnum.MAX;
                }
                case MIN: {
                    return ShoppingCartItemQuantityAdjustmentEnum.MIN;
                }
                case STOCK: {
                    return ShoppingCartItemQuantityAdjustmentEnum.STOCK;
                }
            }
        }
        return null;
    }

    private ShoppingCartResult toShoppingCartResult(OrderDTO orderDTO, List<CurrencyVO> list) {
        if (orderDTO == null) {
            return null;
        }
        ShoppingCartResult shoppingCartResult = this.newShoppingCart(ShoppingCartResult.class, orderDTO, CollectionHelper.orEmpty(list).contains(orderDTO.getCurrency()));
        CollectionHelper.orEmpty((List)orderDTO.getProducts()).stream().map(this::toShoppingCartItem).forEach(shoppingCartResult.getItems()::add);
        return shoppingCartResult;
    }
}

