/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.helpers;

import org.cyclos.model.access.passwords.ICredentialInputDTO;
import org.cyclos.model.access.totps.RemoveTotpSecretParams;
import org.cyclos.model.access.totps.TotpSecretData;
import org.cyclos.model.access.totps.TotpSecretStatus;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.web.rest.helpers.AuthApiHelper;
import org.cyclos.web.rest.helpers.UsersApiHelper;
import org.cyclos.web.rest.model.TotpStatusEnum;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TotpApiHelper {
    @Autowired
    private UsersApiHelper usersApiHelper;
    @Autowired
    private AuthApiHelper authApiHelper;

    public RemoveTotpSecretParams toRemoveTotpSecretParams(String string, String string2) {
        RemoveTotpSecretParams removeTotpSecretParams = new RemoveTotpSecretParams();
        removeTotpSecretParams.setUser((BasicUserVO)ModelHelper.userLocator((String)string));
        removeTotpSecretParams.setConfirmationPassword(string2);
        return removeTotpSecretParams;
    }

    public org.cyclos.web.rest.model.TotpSecretData toTotpSecretData(TotpSecretData totpSecretData) {
        if (totpSecretData == null) {
            return null;
        }
        org.cyclos.web.rest.model.TotpSecretData totpSecretData2 = new org.cyclos.web.rest.model.TotpSecretData();
        totpSecretData2.setUser(this.usersApiHelper.toUser(totpSecretData.getUser()));
        totpSecretData2.setStatus(this.toTotpStatusEnum(totpSecretData.getStatus()));
        totpSecretData2.setActivationDate(totpSecretData.getActivationDate());
        totpSecretData2.setCanActivate(totpSecretData.isCanActivate());
        totpSecretData2.setCanRemove(totpSecretData.isCanRemove());
        totpSecretData2.setSecretUrl(totpSecretData.getSecretUrl());
        totpSecretData2.setSendVerificationCodeData(this.authApiHelper.toDataForSendingOtp(totpSecretData.getSendVerificationCodeData()));
        totpSecretData2.setConfirmationPasswordInput(this.authApiHelper.toPasswordInput((ICredentialInputDTO)totpSecretData.getConfirmationCredentials()));
        return totpSecretData2;
    }

    private TotpStatusEnum toTotpStatusEnum(TotpSecretStatus totpSecretStatus) {
        if (totpSecretStatus != null) {
            switch (totpSecretStatus) {
                case ACTIVE: {
                    return TotpStatusEnum.ACTIVE;
                }
                case NEVER_CREATED: {
                    return TotpStatusEnum.NEVER_CREATED;
                }
                case PENDING: {
                    return TotpStatusEnum.PENDING;
                }
            }
        }
        return null;
    }
}

