/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.helpers;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.cyclos.model.EntityModel;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.EntityVO;
import org.cyclos.model.IEntity;
import org.cyclos.model.IInternalNamedEntity;
import org.cyclos.model.QueryParameters;
import org.cyclos.model.access.agreements.AgreementVO;
import org.cyclos.model.access.passwordtypes.PasswordTypeDetailedVO;
import org.cyclos.model.access.passwordtypes.PasswordTypeVO;
import org.cyclos.model.system.fields.BaseValueForSearchDTO;
import org.cyclos.model.system.fields.CustomFieldDetailedVO;
import org.cyclos.model.system.fields.CustomFieldPossibleValueCategoryVO;
import org.cyclos.model.system.fields.CustomFieldPossibleValueVO;
import org.cyclos.model.system.fields.CustomFieldVO;
import org.cyclos.model.system.fields.CustomFieldValueDTO;
import org.cyclos.model.system.fields.CustomFieldValueForSearchDTO;
import org.cyclos.model.system.fields.ICustomFieldValue;
import org.cyclos.model.system.images.ImageVO;
import org.cyclos.model.users.addresses.AddressConfigurationData;
import org.cyclos.model.users.addresses.AddressQueryField;
import org.cyclos.model.users.addresses.GeoLocatedAddressVO;
import org.cyclos.model.users.addresses.UserAddressDTO;
import org.cyclos.model.users.addresses.UserAddressData;
import org.cyclos.model.users.addresses.UserAddressVO;
import org.cyclos.model.users.brokering.BrokeringVO;
import org.cyclos.model.users.contactinfos.ContactInfoDTO;
import org.cyclos.model.users.contactinfos.ContactInfoData;
import org.cyclos.model.users.contactinfos.ContactInfoListData;
import org.cyclos.model.users.fields.UserCustomFieldDetailedVO;
import org.cyclos.model.users.fields.UserCustomFieldVO;
import org.cyclos.model.users.fields.UserCustomFieldValueDTO;
import org.cyclos.model.users.fields.UserCustomFieldValueVO;
import org.cyclos.model.users.groups.BasicGroupVO;
import org.cyclos.model.users.groups.GroupVO;
import org.cyclos.model.users.groups.InitialGroupVO;
import org.cyclos.model.users.operators.OperatorActivitiesData;
import org.cyclos.model.users.operators.OperatorDTO;
import org.cyclos.model.users.operators.OperatorData;
import org.cyclos.model.users.operators.OperatorProfileActionsData;
import org.cyclos.model.users.operators.OperatorVO;
import org.cyclos.model.users.operators.ViewOperatorProfileData;
import org.cyclos.model.users.phones.LandLinePhoneDTO;
import org.cyclos.model.users.phones.MobilePhoneDTO;
import org.cyclos.model.users.phones.PhoneConfigurationData;
import org.cyclos.model.users.phones.PhoneDTO;
import org.cyclos.model.users.phones.PhoneListData;
import org.cyclos.model.users.products.ProductVO;
import org.cyclos.model.users.products.UserBasicFieldActions;
import org.cyclos.model.users.products.UserCustomFieldActions;
import org.cyclos.model.users.products.UserProfileFieldActions;
import org.cyclos.model.users.users.AbstractRegistrationData;
import org.cyclos.model.users.users.AbstractSimpleRegistrationData;
import org.cyclos.model.users.users.AbstractSimpleUserRegistrationDTO;
import org.cyclos.model.users.users.AbstractUserQuery;
import org.cyclos.model.users.users.AbstractUserRegistrationDTO;
import org.cyclos.model.users.users.AbstractUserSearchData;
import org.cyclos.model.users.users.AbstractViewProfileData;
import org.cyclos.model.users.users.AddressFieldValueForSearchDTO;
import org.cyclos.model.users.users.BaseUserRegistrationResult;
import org.cyclos.model.users.users.BasicProfileActionsData;
import org.cyclos.model.users.users.BasicProfileField;
import org.cyclos.model.users.users.BasicProfileFieldValueForSearchDTO;
import org.cyclos.model.users.users.BasicUserDTO;
import org.cyclos.model.users.users.BasicUserData;
import org.cyclos.model.users.users.BasicUserEditProfileData;
import org.cyclos.model.users.users.BasicUserRegistrationByManagerDTO;
import org.cyclos.model.users.users.BasicUserRegistrationDTO;
import org.cyclos.model.users.users.BasicUserRegistrationData;
import org.cyclos.model.users.users.BasicUserRegistrationDataByManager;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.model.users.users.DataWithBasicProfileFields;
import org.cyclos.model.users.users.EditProfileData;
import org.cyclos.model.users.users.IUserWithFieldsVO;
import org.cyclos.model.users.users.PasswordRegistrationDTO;
import org.cyclos.model.users.users.PasswordRegistrationData;
import org.cyclos.model.users.users.ProfileActionsData;
import org.cyclos.model.users.users.ProfileField;
import org.cyclos.model.users.users.ProfileTransactionActionsData;
import org.cyclos.model.users.users.PublicRegistrationDTO;
import org.cyclos.model.users.users.PublicRegistrationData;
import org.cyclos.model.users.users.RegistrationStatus;
import org.cyclos.model.users.users.SimpleBasicUserRegistrationDTO;
import org.cyclos.model.users.users.SimpleBasicUserRegistrationData;
import org.cyclos.model.users.users.UserAccountData;
import org.cyclos.model.users.users.UserActivitiesData;
import org.cyclos.model.users.users.UserDTO;
import org.cyclos.model.users.users.UserDataParams;
import org.cyclos.model.users.users.UserLocatorDetailedVO;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.users.users.UserMapDirectoryData;
import org.cyclos.model.users.users.UserOrderBy;
import org.cyclos.model.users.users.UserPrincipalData;
import org.cyclos.model.users.users.UserQuery;
import org.cyclos.model.users.users.UserRegistrationByMemberDTO;
import org.cyclos.model.users.users.UserRegistrationDTO;
import org.cyclos.model.users.users.UserRelationship;
import org.cyclos.model.users.users.UserSearchData;
import org.cyclos.model.users.users.UserVO;
import org.cyclos.model.users.users.UserValidationResult;
import org.cyclos.model.users.users.UserWithFieldsVO;
import org.cyclos.model.users.users.ValidateRegistrationFieldParams;
import org.cyclos.model.users.users.ViewProfileData;
import org.cyclos.model.users.usersections.UserSectionDetailedVO;
import org.cyclos.model.users.usersections.UserSectionVO;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.model.utils.RawFileVO;
import org.cyclos.server.model.users.users.SaveFullProfileData;
import org.cyclos.server.model.users.users.SaveFullProfileParams;
import org.cyclos.server.model.users.users.SaveFullProfileResult;
import org.cyclos.server.utils.ClassHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.MaskHelper;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.Pair;
import org.cyclos.utils.StringHelper;
import org.cyclos.web.rest.api.UsersApi;
import org.cyclos.web.rest.helpers.AccountsApiHelper;
import org.cyclos.web.rest.helpers.AddressesApiHelper;
import org.cyclos.web.rest.helpers.AgreementsApiHelper;
import org.cyclos.web.rest.helpers.ApiHelper;
import org.cyclos.web.rest.helpers.AuthApiHelper;
import org.cyclos.web.rest.helpers.ContactInfosApiHelper;
import org.cyclos.web.rest.helpers.ContactsApiHelper;
import org.cyclos.web.rest.helpers.GroupsApiHelper;
import org.cyclos.web.rest.helpers.IdentityProvidersApiHelper;
import org.cyclos.web.rest.helpers.ImagesApiHelper;
import org.cyclos.web.rest.helpers.ImportsApiHelper;
import org.cyclos.web.rest.helpers.NfcApiHelper;
import org.cyclos.web.rest.helpers.OperationsApiHelper;
import org.cyclos.web.rest.helpers.PasswordsApiHelper;
import org.cyclos.web.rest.helpers.PhonesApiHelper;
import org.cyclos.web.rest.helpers.RecordsApiHelper;
import org.cyclos.web.rest.helpers.TokensApiHelper;
import org.cyclos.web.rest.helpers.UserStatusApiHelper;
import org.cyclos.web.rest.helpers.WizardsApiHelper;
import org.cyclos.web.rest.model.AccountWithStatus;
import org.cyclos.web.rest.model.AddressConfigurationForUserProfile;
import org.cyclos.web.rest.model.AddressManage;
import org.cyclos.web.rest.model.AgreementsPermissions;
import org.cyclos.web.rest.model.AvailabilityEnum;
import org.cyclos.web.rest.model.BaseUserDataForSearch;
import org.cyclos.web.rest.model.BasicProfileFieldEnum;
import org.cyclos.web.rest.model.BasicProfileFieldInput;
import org.cyclos.web.rest.model.BasicUserDataForNew;
import org.cyclos.web.rest.model.BasicUserManage;
import org.cyclos.web.rest.model.BasicUserQueryFilters;
import org.cyclos.web.rest.model.BrokerView;
import org.cyclos.web.rest.model.ContactInfoConfigurationForUserProfile;
import org.cyclos.web.rest.model.ContactInfoManage;
import org.cyclos.web.rest.model.ContactsQueryFilters;
import org.cyclos.web.rest.model.DataForEditFullProfile;
import org.cyclos.web.rest.model.FieldSection;
import org.cyclos.web.rest.model.FullProfileEdit;
import org.cyclos.web.rest.model.FullProfileEditResult;
import org.cyclos.web.rest.model.GroupForRegistration;
import org.cyclos.web.rest.model.IBasicUserNew;
import org.cyclos.web.rest.model.Image;
import org.cyclos.web.rest.model.ImageConfigurationForUserProfile;
import org.cyclos.web.rest.model.PasswordRegistration;
import org.cyclos.web.rest.model.PasswordTypeRegistration;
import org.cyclos.web.rest.model.PhoneConfigurationForUserProfile;
import org.cyclos.web.rest.model.PhoneManage;
import org.cyclos.web.rest.model.ProfileFieldActions;
import org.cyclos.web.rest.model.RoleEnum;
import org.cyclos.web.rest.model.User;
import org.cyclos.web.rest.model.UserAccountVisibilitySettingsPermissions;
import org.cyclos.web.rest.model.UserAuthorizedPaymentsPermissions;
import org.cyclos.web.rest.model.UserBalanceLimitsPermissions;
import org.cyclos.web.rest.model.UserBaseAdPermissions;
import org.cyclos.web.rest.model.UserBasicData;
import org.cyclos.web.rest.model.UserBrokeringPermissions;
import org.cyclos.web.rest.model.UserContactPermissions;
import org.cyclos.web.rest.model.UserCustomField;
import org.cyclos.web.rest.model.UserCustomFieldDetailed;
import org.cyclos.web.rest.model.UserCustomFieldValue;
import org.cyclos.web.rest.model.UserDataForEdit;
import org.cyclos.web.rest.model.UserDataForMap;
import org.cyclos.web.rest.model.UserDataForNew;
import org.cyclos.web.rest.model.UserDataForSearch;
import org.cyclos.web.rest.model.UserDocuments;
import org.cyclos.web.rest.model.UserDocumentsPermissions;
import org.cyclos.web.rest.model.UserEdit;
import org.cyclos.web.rest.model.UserExternalPaymentsPermissions;
import org.cyclos.web.rest.model.UserGroupPermissions;
import org.cyclos.web.rest.model.UserIdentityProvidersPermissions;
import org.cyclos.web.rest.model.UserImportsPermissions;
import org.cyclos.web.rest.model.UserManage;
import org.cyclos.web.rest.model.UserMarketplacePermissions;
import org.cyclos.web.rest.model.UserMessagesPermissions;
import org.cyclos.web.rest.model.UserNew;
import org.cyclos.web.rest.model.UserNotificationSettingsPermissions;
import org.cyclos.web.rest.model.UserOperatorsPermissions;
import org.cyclos.web.rest.model.UserOrderByEnum;
import org.cyclos.web.rest.model.UserPasswordsPermissions;
import org.cyclos.web.rest.model.UserPaymentFeedbacksPermissions;
import org.cyclos.web.rest.model.UserPaymentLimitsPermissions;
import org.cyclos.web.rest.model.UserPaymentPermissions;
import org.cyclos.web.rest.model.UserPaymentRequestsPermissions;
import org.cyclos.web.rest.model.UserPermissions;
import org.cyclos.web.rest.model.UserPrivacySettingsPermissions;
import org.cyclos.web.rest.model.UserProductsPermissions;
import org.cyclos.web.rest.model.UserProfilePermissions;
import org.cyclos.web.rest.model.UserQueryFilters;
import org.cyclos.web.rest.model.UserQuickAccessPermissions;
import org.cyclos.web.rest.model.UserRecords;
import org.cyclos.web.rest.model.UserReferences;
import org.cyclos.web.rest.model.UserReferencesPermissions;
import org.cyclos.web.rest.model.UserRegistrationPrincipal;
import org.cyclos.web.rest.model.UserRegistrationResult;
import org.cyclos.web.rest.model.UserRegistrationStatusEnum;
import org.cyclos.web.rest.model.UserRelationshipEnum;
import org.cyclos.web.rest.model.UserResult;
import org.cyclos.web.rest.model.UserScheduledPaymentsPermissions;
import org.cyclos.web.rest.model.UserSessionPermissions;
import org.cyclos.web.rest.model.UserStatusPermissions;
import org.cyclos.web.rest.model.UserTicketsPermissions;
import org.cyclos.web.rest.model.UserTransactionPermissions;
import org.cyclos.web.rest.model.UserValidationPermissions;
import org.cyclos.web.rest.model.UserView;
import org.cyclos.web.rest.model.UserVouchersPermissions;
import org.cyclos.web.rest.model.UserWebshopPermissions;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UsersApiHelper {
    @Autowired
    private ApiHelper apiHelper;
    @Autowired
    private UserStatusApiHelper userStatusApiHelper;
    @Autowired
    private NfcApiHelper nfcApiHelper;
    @Autowired
    private ImagesApiHelper imagesApiHelper;
    @Autowired
    private GroupsApiHelper groupsApiHelper;
    @Autowired
    private AddressesApiHelper addressesApiHelper;
    @Autowired
    private ContactInfosApiHelper contactInfosApiHelper;
    @Autowired
    private PhonesApiHelper phonesApiHelper;
    @Autowired
    private AccountsApiHelper accountsApiHelper;
    @Autowired
    private RecordsApiHelper recordsApiHelper;
    @Autowired
    private OperationsApiHelper operationsApiHelper;
    @Autowired
    private WizardsApiHelper wizardsApiHelper;
    @Autowired
    private AuthApiHelper authApiHelper;
    @Autowired
    private TokensApiHelper tokensApiHelper;
    @Autowired
    private PasswordsApiHelper passwordsApiHelper;
    @Autowired
    private ContactsApiHelper contactsApiHelper;
    @Autowired
    private IdentityProvidersApiHelper identityProvidersApiHelper;
    @Autowired
    private AgreementsApiHelper agreementsApiHelper;
    @Autowired
    private ImportsApiHelper importsApiHelper;

    public <D extends BasicUserDataForNew> void fillBasicUserDataForNew(D d, SimpleBasicUserRegistrationData simpleBasicUserRegistrationData) {
        d.setGeneratedUsername(simpleBasicUserRegistrationData.isGeneratedUsername());
        d.setPhoneConfiguration(this.toPhoneConfigurationForUserProfile(simpleBasicUserRegistrationData));
        if (simpleBasicUserRegistrationData instanceof BasicUserRegistrationData) {
            BasicUserRegistrationData basicUserRegistrationData = (BasicUserRegistrationData)simpleBasicUserRegistrationData;
            boolean bl = simpleBasicUserRegistrationData instanceof PublicRegistrationData;
            CollectionHelper.orEmpty((List)basicUserRegistrationData.getPasswordsData()).stream().map(passwordRegistrationData -> this.toPasswordTypeRegistration(bl, (PasswordRegistrationData)passwordRegistrationData)).forEach(d.getPasswordTypes()::add);
            if (simpleBasicUserRegistrationData instanceof BasicUserRegistrationDataByManager) {
                BasicUserRegistrationDataByManager basicUserRegistrationDataByManager = (BasicUserRegistrationDataByManager)basicUserRegistrationData;
                d.setAllowSetSendActivationEmail(basicUserRegistrationDataByManager.isAllowSetSendActivationEmail());
            }
        }
    }

    public void fillBasicUserNew(IBasicUserNew iBasicUserNew, SimpleBasicUserRegistrationDTO simpleBasicUserRegistrationDTO) {
        CollectionHelper.orEmpty((List)simpleBasicUserRegistrationDTO.getLandLinePhones()).stream().map(this.phonesApiHelper::toPhoneNew).forEach(iBasicUserNew.getLandLinePhones()::add);
        CollectionHelper.orEmpty((List)simpleBasicUserRegistrationDTO.getMobilePhones()).stream().map(this.phonesApiHelper::toPhoneNew).forEach(iBasicUserNew.getMobilePhones()::add);
        if (simpleBasicUserRegistrationDTO instanceof BasicUserRegistrationDTO) {
            BasicUserRegistrationDTO basicUserRegistrationDTO = (BasicUserRegistrationDTO)simpleBasicUserRegistrationDTO;
            CollectionHelper.orEmpty((List)basicUserRegistrationDTO.getPasswords()).stream().map(this::toPasswordRegistration).forEach(iBasicUserNew.getPasswords()::add);
        }
    }

    public <DTO extends BasicUserDTO> void fillDTO(DTO DTO, BasicUserManage basicUserManage) {
        DTO.setName(basicUserManage.getName());
        DTO.setUsername(basicUserManage.getUsername());
        DTO.setEmail(basicUserManage.getEmail());
    }

    public <DTO extends SimpleBasicUserRegistrationDTO> void fillRegistrationDTO(DTO DTO, IBasicUserNew iBasicUserNew) {
        DTO.setMobilePhones(CollectionHelper.orEmpty(iBasicUserNew.getMobilePhones()).stream().map(this.phonesApiHelper::toMobilePhoneDTO).filter(Objects::nonNull).map(mobilePhoneDTO -> mobilePhoneDTO).collect(Collectors.toList()));
        DTO.setLandLinePhones(CollectionHelper.orEmpty(iBasicUserNew.getLandLinePhones()).stream().map(this.phonesApiHelper::toLandLinePhoneDTO).filter(Objects::nonNull).map(landLinePhoneDTO -> landLinePhoneDTO).collect(Collectors.toList()));
        if (DTO instanceof BasicUserRegistrationDTO) {
            BasicUserRegistrationDTO basicUserRegistrationDTO = (BasicUserRegistrationDTO)DTO;
            basicUserRegistrationDTO.setPasswords(CollectionHelper.orEmpty(iBasicUserNew.getPasswords()).stream().map(this::toPasswordRegistrationDTO).filter(Objects::nonNull).collect(Collectors.toList()));
            if (DTO instanceof BasicUserRegistrationByManagerDTO) {
                BasicUserRegistrationByManagerDTO basicUserRegistrationByManagerDTO = (BasicUserRegistrationByManagerDTO)basicUserRegistrationDTO;
                basicUserRegistrationByManagerDTO.setSkipActivationEmail(Boolean.TRUE.equals(iBasicUserNew.getSkipActivationEmail()));
            }
        }
    }

    public String getUserIdentification(BaseUserRegistrationResult baseUserRegistrationResult) {
        Optional<String> optional = CollectionHelper.orEmpty((List)baseUserRegistrationResult.getPrincipalsData()).stream().map(UserPrincipalData::getPrincipal).findFirst();
        if (optional.isPresent()) {
            return ModelHelper.escapeIdentifierIfNeeded((String)optional.get());
        }
        return ApiHelper.toId(baseUserRegistrationResult.getUser().getId());
    }

    public String internalName(ProfileField profileField) {
        if (profileField instanceof BasicProfileField) {
            return ((BasicProfileField)profileField).getAlias();
        }
        if (profileField instanceof IInternalNamedEntity) {
            return ((IInternalNamedEntity)profileField).getInternalName();
        }
        return null;
    }

    public <S extends BaseUserDataForSearch> S newBaseDataForSearch(Class<S> clazz, AbstractUserSearchData abstractUserSearchData) {
        BaseUserDataForSearch baseUserDataForSearch = (BaseUserDataForSearch)ClassHelper.instantiate(clazz);
        EnumSet<BasicProfileField> enumSet = EnumSet.noneOf(BasicProfileField.class);
        LinkedHashSet<CustomFieldDetailedVO> linkedHashSet = new LinkedHashSet<CustomFieldDetailedVO>();
        for (Object object : abstractUserSearchData.getSimpleProfileFields()) {
            if (object instanceof CustomFieldDetailedVO) {
                linkedHashSet.add((CustomFieldDetailedVO)object);
            } else if (object instanceof BasicProfileField) {
                enumSet.add((BasicProfileField)object);
            }
            baseUserDataForSearch.getFieldsInBasicSearch().add(this.internalName((ProfileField)object));
            baseUserDataForSearch.getFieldsInSearch().add(this.internalName((ProfileField)object));
        }
        for (Object object : abstractUserSearchData.getAdvancedProfileFields()) {
            if (object instanceof CustomFieldDetailedVO) {
                linkedHashSet.add((CustomFieldDetailedVO)object);
            } else if (object instanceof BasicProfileField) {
                enumSet.add((BasicProfileField)object);
            }
            baseUserDataForSearch.getFieldsInAdvancedSearch().add(this.internalName((ProfileField)object));
            baseUserDataForSearch.getFieldsInSearch().add(this.internalName((ProfileField)object));
        }
        if (abstractUserSearchData instanceof UserSearchData) {
            UserSearchData userSearchData = (UserSearchData)abstractUserSearchData;
            for (ProfileField profileField : userSearchData.getProfileFieldsInList()) {
                if (profileField instanceof CustomFieldDetailedVO) {
                    linkedHashSet.add((CustomFieldDetailedVO)profileField);
                    continue;
                }
                if (!(profileField instanceof BasicProfileField)) continue;
                enumSet.add((BasicProfileField)profileField);
            }
        }
        linkedHashSet.stream().map(this.apiHelper::toCustomFieldDetailed).forEach(baseUserDataForSearch.getCustomFields()::add);
        enumSet.stream().map(basicProfileField -> this.toBasicProfileFieldInput((BasicProfileField)basicProfileField, (DataWithBasicProfileFields)abstractUserSearchData)).forEach(baseUserDataForSearch.getBasicFields()::add);
        CollectionHelper.orEmpty((List)abstractUserSearchData.getGroups()).stream().map(this.groupsApiHelper::toGroup).forEach(baseUserDataForSearch.getGroups()::add);
        CollectionHelper.orEmpty((List)abstractUserSearchData.getStatuses()).stream().map(this.userStatusApiHelper::toUserStatusEnum).forEach(baseUserDataForSearch.getStatuses()::add);
        CollectionHelper.orEmpty((List)abstractUserSearchData.getProducts()).stream().map(this.apiHelper::toReference).forEach(baseUserDataForSearch.getProducts()::add);
        CollectionHelper.orEmpty((List)abstractUserSearchData.getAgreements()).stream().map(this.agreementsApiHelper::toAgreement).forEach(baseUserDataForSearch.getAgreements()::add);
        baseUserDataForSearch.setSearchByDistanceData(this.addressesApiHelper.toSearchByDistanceData(abstractUserSearchData.getSearchByDistanceData()));
        baseUserDataForSearch.setAllowKeywords(abstractUserSearchData.isAllowKeywords());
        baseUserDataForSearch.setCanViewImages(abstractUserSearchData.isCanViewImages());
        CollectionHelper.orEmpty((List)abstractUserSearchData.getExportFormats()).stream().map(this.apiHelper::toExportFormat).forEach(baseUserDataForSearch.getExportFormats()::add);
        return (S)baseUserDataForSearch;
    }

    public <D extends UserBasicData> D newBasicData(Class<D> clazz, BasicUserData<?> basicUserData) {
        UserBasicData userBasicData = (UserBasicData)ClassHelper.instantiate(clazz);
        userBasicData.setEmailRequired(basicUserData.isEmailRequired());
        this.collectProfileFieldActions(basicUserData.getProfileFieldActions(), userBasicData.getProfileFieldActions(), userBasicData.getCustomFields());
        userBasicData.setEnablePrivacy(basicUserData.isEnablePrivacy());
        List<? extends CustomFieldValueDTO> list = this.getCustomValues(basicUserData.getDto());
        userBasicData.setBinaryValues(this.apiHelper.toCustomFieldBinaryValues(list));
        return (D)userBasicData;
    }

    public <U extends BasicUserManage> U newBasicUserManage(Class<U> clazz, BasicUserDTO basicUserDTO) {
        BasicUserManage basicUserManage = (BasicUserManage)ClassHelper.instantiate(clazz);
        basicUserManage.setName(basicUserDTO.getName());
        basicUserManage.setUsername(basicUserDTO.getUsername());
        basicUserManage.setEmail(basicUserDTO.getEmail());
        basicUserManage.setCustomValues(this.apiHelper.toCustomFieldValuesMap(this.getCustomValues(basicUserDTO)));
        return (U)basicUserManage;
    }

    public <Q extends AbstractUserQuery> Q newBasicUserQuery(Class<Q> clazz, BasicUserQueryFilters basicUserQueryFilters) {
        AbstractUserQuery abstractUserQuery = (AbstractUserQuery)this.apiHelper.newQuery(clazz, basicUserQueryFilters);
        abstractUserQuery.setKeywords(basicUserQueryFilters.getKeywords());
        abstractUserQuery.setIgnoreProfileFieldsInList(Boolean.TRUE.equals(basicUserQueryFilters.getIgnoreProfileFieldsInList()));
        abstractUserQuery.setProfileFields(this.toProfileFieldsForSearch(basicUserQueryFilters.getProfileFields()));
        abstractUserQuery.setAddressResult(this.addressesApiHelper.toUserAddressResult(basicUserQueryFilters.getAddressResult()));
        abstractUserQuery.setDistance(this.addressesApiHelper.toDistanceDTO(basicUserQueryFilters.getLatitude(), basicUserQueryFilters.getLongitude(), basicUserQueryFilters.getMaxDistance()));
        abstractUserQuery.setUsersToExclude(ModelHelper.vosFromString(UserVO.class, basicUserQueryFilters.getUsersToExclude()));
        abstractUserQuery.setUsersToInclude(ModelHelper.vosFromString(UserVO.class, basicUserQueryFilters.getUsersToInclude()));
        abstractUserQuery.setCreated(this.apiHelper.toDatePeriodDTO(basicUserQueryFilters.getCreationPeriod()));
        abstractUserQuery.setActivated(this.apiHelper.toDatePeriodDTO(basicUserQueryFilters.getActivationPeriod()));
        abstractUserQuery.setLastLogin(this.apiHelper.toDatePeriodDTO(basicUserQueryFilters.getLastLoginPeriod()));
        abstractUserQuery.setGroups(CollectionHelper.orEmpty(basicUserQueryFilters.getGroups()).stream().map(string -> (BasicGroupVO)ModelHelper.voFromString(BasicGroupVO.class, (String)string)).collect(Collectors.toSet()));
        abstractUserQuery.setBrokers(CollectionHelper.orEmpty(basicUserQueryFilters.getBrokers()).stream().map(string -> (UserVO)ModelHelper.voFromString(UserVO.class, (String)string)).collect(Collectors.toSet()));
        abstractUserQuery.setOnlyBrokerIsMain(basicUserQueryFilters.getMainBrokerOnly());
        abstractUserQuery.setProducts(CollectionHelper.orEmpty(basicUserQueryFilters.getProducts()).stream().map(string -> (ProductVO)ModelHelper.voFromString(ProductVO.class, (String)string)).collect(Collectors.toSet()));
        abstractUserQuery.setProductsIndividuallyAssigned(Boolean.TRUE.equals(basicUserQueryFilters.getProductsIndividuallyAssigned()));
        abstractUserQuery.setAcceptedAgreements(CollectionHelper.orEmpty(basicUserQueryFilters.getAcceptedAgreements()).stream().map(string -> (AgreementVO)ModelHelper.voFromString(AgreementVO.class, (String)string)).collect(Collectors.toSet()));
        abstractUserQuery.setNotAcceptedAgreements(CollectionHelper.orEmpty(basicUserQueryFilters.getNotAcceptedAgreements()).stream().map(string -> (AgreementVO)ModelHelper.voFromString(AgreementVO.class, (String)string)).collect(Collectors.toSet()));
        abstractUserQuery.setIncludeGroup(Boolean.TRUE.equals(basicUserQueryFilters.getIncludeGroup()));
        abstractUserQuery.setIncludeGroupSet(Boolean.TRUE.equals(basicUserQueryFilters.getIncludeGroupSet()));
        abstractUserQuery.setUserStatus(CollectionHelper.orEmpty(basicUserQueryFilters.getStatuses()).stream().map(this.userStatusApiHelper::toUserStatus).collect(Collectors.toSet()));
        abstractUserQuery.setInvitedBy((BasicUserVO)ModelHelper.voFromString(BasicUserVO.class, (String)basicUserQueryFilters.getInvitedBy()));
        abstractUserQuery.setHasBroker(basicUserQueryFilters.getHasBroker());
        return (Q)abstractUserQuery;
    }

    public <F extends BasicUserQueryFilters> F newBasicUserQueryFilters(Class<F> clazz, AbstractUserQuery abstractUserQuery) {
        BasicUserQueryFilters basicUserQueryFilters = (BasicUserQueryFilters)this.apiHelper.newQueryFilters(clazz, (QueryParameters)abstractUserQuery);
        basicUserQueryFilters.setKeywords(abstractUserQuery.getKeywords());
        basicUserQueryFilters.setIgnoreProfileFieldsInList(abstractUserQuery.isIgnoreProfileFieldsInList());
        basicUserQueryFilters.setProfileFields(this.apiHelper.toFilters(abstractUserQuery.getProfileFields()));
        basicUserQueryFilters.setAddressResult(this.addressesApiHelper.toUserAddressResultEnum(abstractUserQuery.getAddressResult()));
        this.addressesApiHelper.fillDistance(basicUserQueryFilters, abstractUserQuery.getDistance());
        CollectionHelper.orEmpty((Set)abstractUserQuery.getUsersToExclude()).stream().map(ModelHelper::stringOrIdFromVO).forEach(basicUserQueryFilters.getUsersToExclude()::add);
        CollectionHelper.orEmpty((Set)abstractUserQuery.getUsersToInclude()).stream().map(ModelHelper::stringOrIdFromVO).forEach(basicUserQueryFilters.getUsersToInclude()::add);
        basicUserQueryFilters.setCreationPeriod(this.apiHelper.toFilter(abstractUserQuery.getCreated()));
        basicUserQueryFilters.setActivationPeriod(this.apiHelper.toFilter(abstractUserQuery.getActivated()));
        basicUserQueryFilters.setLastLoginPeriod(this.apiHelper.toFilter(abstractUserQuery.getLastLogin()));
        CollectionHelper.orEmpty((Set)abstractUserQuery.getGroups()).stream().map(ModelHelper::stringOrIdFromVO).forEach(basicUserQueryFilters.getGroups()::add);
        CollectionHelper.orEmpty((Set)abstractUserQuery.getBrokers()).stream().map(ModelHelper::stringOrIdFromVO).forEach(basicUserQueryFilters.getBrokers()::add);
        basicUserQueryFilters.setMainBrokerOnly(abstractUserQuery.getOnlyBrokerIsMain());
        basicUserQueryFilters.setHasBroker(abstractUserQuery.getHasBroker());
        if (abstractUserQuery.isIncludeGroup()) {
            basicUserQueryFilters.setIncludeGroup(true);
        }
        if (abstractUserQuery.isIncludeGroupSet()) {
            basicUserQueryFilters.setIncludeGroupSet(true);
        }
        CollectionHelper.orEmpty((Set)abstractUserQuery.getProducts()).stream().map(ModelHelper::stringOrIdFromVO).forEach(basicUserQueryFilters.getProducts()::add);
        if (CollectionHelper.isNotEmpty((Iterable)abstractUserQuery.getProducts())) {
            basicUserQueryFilters.setProductsIndividuallyAssigned(abstractUserQuery.isProductsIndividuallyAssigned());
        }
        CollectionHelper.orEmpty((Set)abstractUserQuery.getAcceptedAgreements()).stream().map(ModelHelper::stringOrIdFromVO).forEach(basicUserQueryFilters.getAcceptedAgreements()::add);
        CollectionHelper.orEmpty((Set)abstractUserQuery.getNotAcceptedAgreements()).stream().map(ModelHelper::stringOrIdFromVO).forEach(basicUserQueryFilters.getNotAcceptedAgreements()::add);
        CollectionHelper.orEmpty((Set)abstractUserQuery.getUserStatus()).stream().map(this.userStatusApiHelper::toUserStatusEnum).forEach(basicUserQueryFilters.getStatuses()::add);
        basicUserQueryFilters.setInvitedBy(ModelHelper.stringOrIdFromVO((EntityVO)abstractUserQuery.getInvitedBy()));
        return (F)basicUserQueryFilters;
    }

    public <R extends UserResult> R newUserResult(Class<R> clazz, IUserWithFieldsVO iUserWithFieldsVO) {
        UserResult userResult = (UserResult)this.apiHelper.newEntity(clazz, (BasicUserVO)iUserWithFieldsVO);
        userResult.setDisplay(iUserWithFieldsVO.getDisplay());
        userResult.setName(iUserWithFieldsVO.getName());
        userResult.setUsername(iUserWithFieldsVO.getUsername());
        userResult.setEmail(iUserWithFieldsVO.getEmail());
        userResult.setCustomValues(this.apiHelper.toCustomFieldValuesMap(iUserWithFieldsVO.getCustomValues()));
        userResult.setPhone(iUserWithFieldsVO.getPhone());
        if (iUserWithFieldsVO instanceof UserWithFieldsVO) {
            UserWithFieldsVO userWithFieldsVO = (UserWithFieldsVO)iUserWithFieldsVO;
            userResult.setAccountNumber(userWithFieldsVO.getAccountNumber());
            userResult.setImage(this.imagesApiHelper.toImage(userWithFieldsVO.getImage()));
            UserAddressVO userAddressVO = userWithFieldsVO.getAddress();
            if (userAddressVO != null) {
                userResult.setAddress(this.addressesApiHelper.toAddress((GeoLocatedAddressVO)userAddressVO));
                if (userAddressVO.getCurrentDistance() != null) {
                    userResult.setDistance((double)userAddressVO.getCurrentDistance());
                }
            }
            userResult.setGroup(this.apiHelper.toReference((EntityModel)userWithFieldsVO.getGroup()));
            userResult.setGroupSet(this.apiHelper.toReference((EntityModel)userWithFieldsVO.getGroupSet()));
        }
        return (R)userResult;
    }

    public BasicProfileFieldEnum toBasicProfileFieldEnum(BasicProfileField basicProfileField) {
        if (basicProfileField != null) {
            switch (basicProfileField) {
                case ACCOUNT_NUMBER: {
                    return BasicProfileFieldEnum.ACCOUNT_NUMBER;
                }
                case ADDRESS: {
                    return BasicProfileFieldEnum.ADDRESS;
                }
                case EMAIL: {
                    return BasicProfileFieldEnum.EMAIL;
                }
                case FULL_NAME: {
                    return BasicProfileFieldEnum.NAME;
                }
                case IMAGE: {
                    return BasicProfileFieldEnum.IMAGE;
                }
                case LOGIN_NAME: {
                    return BasicProfileFieldEnum.USERNAME;
                }
                case PHONE: {
                    return BasicProfileFieldEnum.PHONE;
                }
            }
        }
        return null;
    }

    public BasicProfileFieldInput toBasicProfileFieldInput(BasicProfileField basicProfileField, DataWithBasicProfileFields dataWithBasicProfileFields) {
        BasicProfileFieldInput basicProfileFieldInput = new BasicProfileFieldInput();
        basicProfileFieldInput.setField(this.toBasicProfileFieldEnum(basicProfileField));
        if (basicProfileField == BasicProfileField.ACCOUNT_NUMBER) {
            String string = dataWithBasicProfileFields.getAccountNumberMask();
            if (string != null) {
                basicProfileFieldInput.setMask(string);
                basicProfileFieldInput.setExample(MaskHelper.getExample((String)string));
            }
        } else if (basicProfileField == BasicProfileField.PHONE) {
            basicProfileFieldInput.setExample(dataWithBasicProfileFields.getMobilePhoneExample());
        }
        return basicProfileFieldInput;
    }

    public UserQuery toContactsQuery(String string, ContactsQueryFilters contactsQueryFilters) {
        if (contactsQueryFilters == null) {
            return null;
        }
        UserQuery userQuery = this.apiHelper.newQuery(UserQuery.class, contactsQueryFilters);
        userQuery.setOnlyContacts(true);
        userQuery.setKeywords(contactsQueryFilters.getKeywords());
        userQuery.setContactsOwner((UserLocatorVO)ModelHelper.voFromString(UserLocatorVO.class, (String)string));
        userQuery.setIgnoreProfileFieldsInList(Boolean.TRUE.equals(contactsQueryFilters.getIgnoreProfileFieldsInList()));
        userQuery.setIncludeGroup(Boolean.TRUE.equals(contactsQueryFilters.getIncludeGroup()));
        userQuery.setIncludeGroupSet(Boolean.TRUE.equals(contactsQueryFilters.getIncludeGroupSet()));
        return userQuery;
    }

    public UserDataForEdit toDataForEdit(BasicUserEditProfileData<?> basicUserEditProfileData) {
        UserDataForEdit userDataForEdit = this.newBasicData((Class)UserDataForEdit.class, (BasicUserData<?>)basicUserEditProfileData);
        userDataForEdit.setEmailPendingValidation(basicUserEditProfileData.getEmailPendingValidation());
        userDataForEdit.setConfirmationPasswordInput(this.authApiHelper.toPasswordInput(basicUserEditProfileData.getConfirmationPasswordInput()));
        BasicUserDTO basicUserDTO = basicUserEditProfileData.getDto();
        RoleEnum roleEnum = basicUserDTO instanceof OperatorDTO ? RoleEnum.OPERATOR : RoleEnum.MEMBER;
        userDataForEdit.setRole(roleEnum);
        User user = this.apiHelper.newEntity(User.class, basicUserDTO);
        user.setDisplay(basicUserEditProfileData.getDisplay());
        userDataForEdit.setDetails(user);
        if (basicUserEditProfileData instanceof EditProfileData) {
            EditProfileData editProfileData = (EditProfileData)basicUserEditProfileData;
            userDataForEdit.setNameLabel(editProfileData.getNameLabel());
            user.setImage(this.imagesApiHelper.toImage((ImageVO)CollectionHelper.first((Iterable)editProfileData.getImages())));
        } else if (basicUserEditProfileData instanceof OperatorData) {
            OperatorData operatorData = (OperatorData)basicUserEditProfileData;
            user.setUser(this.toUser((BasicUserVO)((OperatorDTO)operatorData.getDto()).getUser()));
        }
        userDataForEdit.setUser(this.toUserEdit(basicUserDTO));
        return userDataForEdit;
    }

    public DataForEditFullProfile toDataForEditFullProfile(SaveFullProfileData saveFullProfileData) {
        DataForEditFullProfile dataForEditFullProfile = (DataForEditFullProfile)ClassHelper.instantiate(DataForEditFullProfile.class);
        BasicUserEditProfileData basicUserEditProfileData = saveFullProfileData.getUser();
        UserDataForEdit userDataForEdit = this.toDataForEdit(basicUserEditProfileData);
        dataForEditFullProfile.setUserConfiguration(userDataForEdit);
        dataForEditFullProfile.setUser(userDataForEdit.getUser());
        userDataForEdit.setUser(null);
        dataForEditFullProfile.setConfirmationPasswordInput(this.authApiHelper.toPasswordInput(basicUserEditProfileData.getConfirmationPasswordInput()));
        dataForEditFullProfile.setPhoneConfiguration(this.phonesApiHelper.toPhoneConfigurationForUserProfile(saveFullProfileData.getPhoneConfiguration()));
        CollectionHelper.orEmpty((List)saveFullProfileData.getLandLinePhones()).stream().map(this.phonesApiHelper::toPhoneEditWithId).forEach(dataForEditFullProfile.getLandLinePhones()::add);
        CollectionHelper.orEmpty((List)saveFullProfileData.getMobilePhones()).stream().map(this.phonesApiHelper::toPhoneEditWithId).forEach(dataForEditFullProfile.getMobilePhones()::add);
        if (userDataForEdit.getRole() == RoleEnum.MEMBER) {
            dataForEditFullProfile.setAddressConfiguration(this.addressesApiHelper.toAddressConfigurationForUserProfile(saveFullProfileData.getAddressConfiguration()));
            CollectionHelper.orEmpty((List)saveFullProfileData.getAddresses()).stream().map(this.addressesApiHelper::toAddressEditWithId).forEach(dataForEditFullProfile.getAddresses()::add);
            dataForEditFullProfile.setAddressBinaryValues(this.addressesApiHelper.toAddressBinaryValuesForUserProfile(saveFullProfileData.getAddresses()));
            dataForEditFullProfile.setContactInfoConfiguration(this.contactInfosApiHelper.toContactInfoConfigurationForUserProfile(saveFullProfileData.getContactInfoConfiguration()));
            CollectionHelper.orEmpty((List)saveFullProfileData.getContactInfos()).stream().map(this.contactInfosApiHelper::toContactInfoEditWithId).forEach(dataForEditFullProfile.getContactInfos()::add);
            dataForEditFullProfile.setContactInfoBinaryValues(this.contactInfosApiHelper.toContactInfoBinaryValuesForUserProfile(saveFullProfileData.getContactInfos()));
            dataForEditFullProfile.setImageConfiguration(this.imagesApiHelper.toImageConfigurationForUserProfile(saveFullProfileData.getImageConfiguration()));
            CollectionHelper.orEmpty((List)saveFullProfileData.getImages()).stream().map(this.imagesApiHelper::toImage).forEach(dataForEditFullProfile.getImages()::add);
        }
        return dataForEditFullProfile;
    }

    public UserDataForMap toDataForMap(UserMapDirectoryData userMapDirectoryData) {
        UserDataForMap userDataForMap = this.newDataForSearch(UserDataForMap.class, (UserSearchData)userMapDirectoryData);
        userDataForMap.setMapDirectoryField(ModelHelper.unqualifiedInternalNameOrId((IEntity)userMapDirectoryData.getMapDirectoryField()));
        userDataForMap.setDefaultMapLocation(this.addressesApiHelper.toGeographicalCoordinate(userMapDirectoryData.getDefaultMapLocation()));
        userDataForMap.setDefaultMapZoomMobile(userMapDirectoryData.getDefaultMapZoomMobile());
        userDataForMap.setDefaultMapZoomWeb(userMapDirectoryData.getDefaultMapZoomWeb());
        return userDataForMap;
    }

    public UserDataForNew toDataForNew(AbstractSimpleRegistrationData abstractSimpleRegistrationData) {
        UserRegistrationDTO userRegistrationDTO;
        AbstractUserRegistrationDTO abstractUserRegistrationDTO;
        if (abstractSimpleRegistrationData == null) {
            return null;
        }
        AbstractSimpleUserRegistrationDTO abstractSimpleUserRegistrationDTO = (AbstractSimpleUserRegistrationDTO)abstractSimpleRegistrationData.getDto();
        UserDataForNew userDataForNew = this.newBasicData((Class)UserDataForNew.class, (BasicUserData<?>)abstractSimpleRegistrationData);
        this.fillBasicUserDataForNew(userDataForNew, (SimpleBasicUserRegistrationData)abstractSimpleRegistrationData);
        userDataForNew.setGroup(this.toGroupForRegistration(abstractSimpleRegistrationData.getGroup()));
        if (abstractSimpleUserRegistrationDTO instanceof AbstractUserRegistrationDTO) {
            abstractUserRegistrationDTO = (AbstractUserRegistrationDTO)abstractSimpleUserRegistrationDTO;
            CollectionHelper.orEmpty((List)abstractUserRegistrationDTO.getUploadedImages()).stream().map(this.imagesApiHelper::toImage).forEach(userDataForNew.getImages()::add);
            if (abstractUserRegistrationDTO instanceof UserRegistrationDTO) {
                userRegistrationDTO = (UserRegistrationDTO)abstractUserRegistrationDTO;
                userDataForNew.setBroker(this.toUser((BasicUserVO)userRegistrationDTO.getBroker()));
            }
        }
        userDataForNew.setNameLabel(abstractSimpleRegistrationData.getNameLabel());
        userDataForNew.setUser(this.toUserNew(abstractSimpleUserRegistrationDTO));
        userDataForNew.setAddressConfiguration(this.toAddressConfigurationForUserProfile(abstractSimpleRegistrationData));
        userDataForNew.setImageConfiguration(this.toImageConfigurationForUserProfile(abstractSimpleRegistrationData));
        if (abstractSimpleRegistrationData instanceof AbstractRegistrationData) {
            abstractUserRegistrationDTO = (AbstractRegistrationData)abstractSimpleRegistrationData;
            userRegistrationDTO = (AbstractUserRegistrationDTO)abstractUserRegistrationDTO.getDto();
            userDataForNew.setContactInfoConfiguration(this.toContactInfoConfigurationForUserProfile((AbstractRegistrationData)abstractUserRegistrationDTO));
            ContactInfoDTO contactInfoDTO = (ContactInfoDTO)CollectionHelper.first((Iterable)userRegistrationDTO.getContactInfos());
            if (contactInfoDTO != null) {
                userDataForNew.setContactInfoBinaryValues(this.apiHelper.toCustomFieldBinaryValues(contactInfoDTO.getCustomValues()));
                userDataForNew.setContactInfoImage(this.imagesApiHelper.toImage(contactInfoDTO.getImage()));
            }
            if (CollectionHelper.isEmpty((Iterable)abstractUserRegistrationDTO.getSecurityQuestions())) {
                userDataForNew.setSecurityQuestions(null);
                userDataForNew.setRequireSecurityQuestion(null);
            } else {
                abstractUserRegistrationDTO.getSecurityQuestions().stream().map(this.passwordsApiHelper::toEntityReference).forEach(userDataForNew.getSecurityQuestions()::add);
                userDataForNew.setRequireSecurityQuestion(abstractUserRegistrationDTO.isRequireSecurityQuestion());
            }
        }
        if (abstractSimpleRegistrationData instanceof PublicRegistrationData) {
            abstractUserRegistrationDTO = (PublicRegistrationData)abstractSimpleRegistrationData;
            CollectionHelper.orEmpty((List)abstractUserRegistrationDTO.getIdentityProviders()).stream().map(this.identityProvidersApiHelper::toIdentityProvider).forEach(userDataForNew.getIdentityProviders()::add);
            CollectionHelper.orEmpty((List)abstractUserRegistrationDTO.getAgreements()).stream().map(this.agreementsApiHelper::toAgreement).forEach(userDataForNew.getAgreements()::add);
            userDataForNew.setCaptchaInput(this.authApiHelper.toCaptchaInput(abstractUserRegistrationDTO.getCaptchaInput()));
            if (userDataForNew.getCaptchaInput() != null) {
                userDataForNew.setCaptchaType(userDataForNew.getCaptchaInput().getProvider());
            }
            userDataForNew.setBroker(this.toUser((BasicUserVO)abstractUserRegistrationDTO.getBroker()));
        } else {
            userDataForNew.setAgreements(null);
        }
        CollectionHelper.orEmpty((List)abstractSimpleRegistrationData.getNfcTokenTypes()).stream().map(this.apiHelper::toReference).forEach(userDataForNew.getNfcTokenTypes()::add);
        return userDataForNew;
    }

    public UserDataForSearch toDataForSearch(UserSearchData userSearchData) {
        UserDataForSearch userDataForSearch = this.newDataForSearch(UserDataForSearch.class, userSearchData);
        userDataForSearch.setBroker(this.toUser((BasicUserVO)userSearchData.getBroker()));
        return userDataForSearch;
    }

    public FullProfileEditResult toFullProfileEditResult(SaveFullProfileResult saveFullProfileResult) {
        if (saveFullProfileResult == null) {
            return null;
        }
        FullProfileEditResult fullProfileEditResult = (FullProfileEditResult)ClassHelper.instantiate(FullProfileEditResult.class);
        fullProfileEditResult.setCreatedLandLinePhones(CollectionHelper.map((Collection)saveFullProfileResult.getCreatedLandLinePhones(), ApiHelper::toId));
        fullProfileEditResult.setCreatedMobilePhones(CollectionHelper.map((Collection)saveFullProfileResult.getCreatedMobilePhones(), ApiHelper::toId));
        fullProfileEditResult.setCreatedAddresses(CollectionHelper.map((Collection)saveFullProfileResult.getCreatedAddresses(), ApiHelper::toId));
        fullProfileEditResult.setCreatedContactInfos(CollectionHelper.map((Collection)saveFullProfileResult.getCreatedContactInfos(), ApiHelper::toId));
        fullProfileEditResult.setCreatedImages(CollectionHelper.map((Collection)saveFullProfileResult.getCreatedImages(), ModelHelper::stringOrIdFromVO));
        return fullProfileEditResult;
    }

    public GroupForRegistration toGroupForRegistration(InitialGroupVO initialGroupVO) {
        GroupForRegistration groupForRegistration = this.apiHelper.newEntity(GroupForRegistration.class, initialGroupVO);
        groupForRegistration.setDescription(initialGroupVO.getDescription());
        return groupForRegistration;
    }

    public PasswordRegistration toPasswordRegistration(PasswordRegistrationDTO passwordRegistrationDTO) {
        if (passwordRegistrationDTO == null) {
            return null;
        }
        PasswordRegistration passwordRegistration = new PasswordRegistration();
        passwordRegistration.setType(ModelHelper.internalNameOrId((IEntity)passwordRegistrationDTO.getType()));
        passwordRegistration.setForceChange(false);
        return passwordRegistration;
    }

    public PasswordRegistrationDTO toPasswordRegistrationDTO(PasswordRegistration passwordRegistration) {
        if (passwordRegistration == null) {
            return null;
        }
        PasswordRegistrationDTO passwordRegistrationDTO = new PasswordRegistrationDTO();
        passwordRegistrationDTO.setType((PasswordTypeVO)ModelHelper.voFromString(PasswordTypeVO.class, (String)passwordRegistration.getType()));
        passwordRegistrationDTO.setAssign(StringHelper.isNotBlank((Object)passwordRegistration.getValue()));
        passwordRegistrationDTO.setValue(passwordRegistration.getValue());
        if (Boolean.TRUE.equals(passwordRegistration.getCheckConfirmation())) {
            passwordRegistrationDTO.setConfirmationValue(passwordRegistration.getConfirmationValue());
        } else {
            passwordRegistrationDTO.setConfirmationValue(passwordRegistration.getValue());
        }
        passwordRegistrationDTO.setForceChange(Boolean.TRUE.equals(passwordRegistration.getForceChange()));
        return passwordRegistrationDTO;
    }

    public Set<BaseValueForSearchDTO> toProfileFieldsForSearch(Collection<String> collection) {
        if (CollectionHelper.isEmpty(collection)) {
            return null;
        }
        return collection.stream().map(this::toProfileFieldForSearch).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public SaveFullProfileParams toSaveFullProfileParams(String string2, FullProfileEdit fullProfileEdit, String string3) {
        SaveFullProfileParams saveFullProfileParams = new SaveFullProfileParams();
        saveFullProfileParams.setLocator((UserLocatorVO)ModelHelper.voFromString(UserLocatorVO.class, (String)string2));
        saveFullProfileParams.setConfirmationPassword(string3);
        saveFullProfileParams.setUser((BasicUserDTO)this.toUserDTO(fullProfileEdit.getUser()));
        BeanWrapperImpl beanWrapperImpl = new BeanWrapperImpl((Object)fullProfileEdit);
        BeanWrapperImpl beanWrapperImpl2 = new BeanWrapperImpl((Object)saveFullProfileParams);
        Function<PhoneManage, LandLinePhoneDTO> function = this.phonesApiHelper::toLandLinePhoneDTO;
        this.processEach((BeanWrapper)beanWrapperImpl, (BeanWrapper)beanWrapperImpl2, "createLandLinePhones", function);
        this.processEach((BeanWrapper)beanWrapperImpl, (BeanWrapper)beanWrapperImpl2, "modifyLandLinePhones", function);
        Function<PhoneManage, MobilePhoneDTO> function2 = this.phonesApiHelper::toMobilePhoneDTO;
        this.processEach((BeanWrapper)beanWrapperImpl, (BeanWrapper)beanWrapperImpl2, "createMobilePhones", function2);
        this.processEach((BeanWrapper)beanWrapperImpl, (BeanWrapper)beanWrapperImpl2, "modifyMobilePhones", function2);
        this.processEach((BeanWrapper)beanWrapperImpl, (BeanWrapper)beanWrapperImpl2, "removePhones", this.apiHelper::fromId);
        Function<AddressManage, UserAddressDTO> function3 = this.addressesApiHelper::toAddressDTO;
        this.processEach((BeanWrapper)beanWrapperImpl, (BeanWrapper)beanWrapperImpl2, "createAddresses", function3);
        this.processEach((BeanWrapper)beanWrapperImpl, (BeanWrapper)beanWrapperImpl2, "modifyAddresses", function3);
        this.processEach((BeanWrapper)beanWrapperImpl, (BeanWrapper)beanWrapperImpl2, "removeAddresses", this.apiHelper::fromId);
        Function<ContactInfoManage, ContactInfoDTO> function4 = this.contactInfosApiHelper::toContactInfoDTO;
        this.processEach((BeanWrapper)beanWrapperImpl, (BeanWrapper)beanWrapperImpl2, "createContactInfos", function4);
        this.processEach((BeanWrapper)beanWrapperImpl, (BeanWrapper)beanWrapperImpl2, "modifyContactInfos", function4);
        this.processEach((BeanWrapper)beanWrapperImpl, (BeanWrapper)beanWrapperImpl2, "removeContactInfos", this.apiHelper::fromId);
        Function<String, ImageVO> function5 = string -> (ImageVO)ModelHelper.voFromString(ImageVO.class, (String)string);
        this.processEach((BeanWrapper)beanWrapperImpl, (BeanWrapper)beanWrapperImpl2, "addImages", function5);
        this.processEach((BeanWrapper)beanWrapperImpl, (BeanWrapper)beanWrapperImpl2, "removeImages", function5);
        this.processEach((BeanWrapper)beanWrapperImpl, (BeanWrapper)beanWrapperImpl2, "reorderImages", function5);
        return saveFullProfileParams;
    }

    public User toUser(BasicUserVO basicUserVO) {
        if (basicUserVO == null) {
            return null;
        }
        return this.newUser(User.class, basicUserVO);
    }

    public UserCustomFieldValue toUserCustomFieldValue(UserCustomFieldValueVO userCustomFieldValueVO) {
        if (userCustomFieldValueVO == null) {
            return null;
        }
        UserCustomFieldValue userCustomFieldValue = this.apiHelper.newBaseFieldValue(UserCustomFieldValue.class, (ICustomFieldValue<CustomFieldPossibleValueVO, CustomFieldPossibleValueCategoryVO, RawFileVO, ImageVO>)userCustomFieldValueVO);
        userCustomFieldValue.setField(this.toUserCustomField(userCustomFieldValueVO.getField()));
        userCustomFieldValue.setHidden(userCustomFieldValueVO.isHidden());
        return userCustomFieldValue;
    }

    public List<UserCustomFieldValueDTO> toUserCustomValuesDTO(Map<String, String> map, List<String> list) {
        ArrayList<UserCustomFieldValueDTO> arrayList = new ArrayList<UserCustomFieldValueDTO>(map.size());
        map.forEach((string, string2) -> {
            UserCustomFieldValueDTO userCustomFieldValueDTO = new UserCustomFieldValueDTO();
            userCustomFieldValueDTO.setField((CustomFieldVO)ModelHelper.voFromString(CustomFieldVO.class, (String)string));
            userCustomFieldValueDTO.setReferenceValue(string2);
            userCustomFieldValueDTO.setHidden(list.contains(string));
            arrayList.add(userCustomFieldValueDTO);
        });
        return arrayList;
    }

    public UserDataParams toUserDataParams(UsersApi.GetUserDataForNewParams getUserDataForNewParams) {
        UserDataParams userDataParams = new UserDataParams();
        userDataParams.setGroup((GroupVO)ModelHelper.voFromString(GroupVO.class, (String)getUserDataForNewParams.group));
        userDataParams.setBroker((UserLocatorVO)ModelHelper.voFromString(UserLocatorVO.class, (String)getUserDataForNewParams.broker));
        userDataParams.setAsMember(Boolean.TRUE.equals(getUserDataForNewParams.asMember));
        return userDataParams;
    }

    public UserDTO toUserDTO(UserEdit userEdit) {
        if (userEdit == null) {
            return null;
        }
        UserDTO userDTO = new UserDTO();
        userDTO.setVersion(userEdit.getVersion());
        this.fillDTO(userDTO, userEdit);
        return userDTO;
    }

    public UserEdit toUserEdit(BasicUserDTO basicUserDTO) {
        if (basicUserDTO == null) {
            return null;
        }
        UserEdit userEdit = this.newUserManage(UserEdit.class, basicUserDTO);
        userEdit.setVersion(basicUserDTO.getVersion());
        return userEdit;
    }

    public UserNew toUserNew(AbstractSimpleUserRegistrationDTO abstractSimpleUserRegistrationDTO) {
        if (abstractSimpleUserRegistrationDTO == null) {
            return null;
        }
        UserNew userNew = this.newUserManage(UserNew.class, (BasicUserDTO)abstractSimpleUserRegistrationDTO);
        userNew.setGroup(ModelHelper.unqualifiedInternalNameOrId((IEntity)abstractSimpleUserRegistrationDTO.getGroup()));
        userNew.setAsMember(abstractSimpleUserRegistrationDTO instanceof UserRegistrationByMemberDTO);
        this.fillBasicUserNew(userNew, (SimpleBasicUserRegistrationDTO)abstractSimpleUserRegistrationDTO);
        if (abstractSimpleUserRegistrationDTO instanceof AbstractUserRegistrationDTO) {
            PublicRegistrationDTO publicRegistrationDTO;
            AbstractUserRegistrationDTO abstractUserRegistrationDTO = (AbstractUserRegistrationDTO)abstractSimpleUserRegistrationDTO;
            CollectionHelper.orEmpty((List)abstractUserRegistrationDTO.getUploadedImages()).stream().map(ModelHelper::stringOrIdFromVO).forEach(userNew.getImages()::add);
            CollectionHelper.orEmpty((List)abstractUserRegistrationDTO.getAddresses()).stream().map(this.addressesApiHelper::toAddressNew).forEach(userNew.getAddresses()::add);
            CollectionHelper.orEmpty((List)abstractUserRegistrationDTO.getContactInfos()).stream().map(this.contactInfosApiHelper::toContactInfoNew).forEach(userNew.getContactInfos()::add);
            if (abstractSimpleUserRegistrationDTO instanceof PublicRegistrationDTO) {
                publicRegistrationDTO = (PublicRegistrationDTO)abstractSimpleUserRegistrationDTO;
                userNew.setAcceptAgreement(publicRegistrationDTO.isAgreement());
                CollectionHelper.orEmpty((Set)publicRegistrationDTO.getAgreements()).stream().map(ModelHelper::stringOrIdFromVO).forEach(userNew.getAcceptAgreements()::add);
                if (publicRegistrationDTO.getSecurityQuestion() != null) {
                    userNew.setSecurityQuestion(publicRegistrationDTO.getSecurityQuestion().name());
                }
                userNew.setSecurityAnswer(publicRegistrationDTO.getSecurityAnswer());
                userNew.setIdentityProviderRequestId(publicRegistrationDTO.getIdentityProviderRequestId());
                userNew.setInviteToken(publicRegistrationDTO.getInviteToken());
            }
            if (abstractSimpleUserRegistrationDTO instanceof UserRegistrationDTO) {
                publicRegistrationDTO = (UserRegistrationDTO)abstractUserRegistrationDTO;
                userNew.setBroker(ModelHelper.stringOrIdFromVO((EntityVO)publicRegistrationDTO.getBroker()));
            }
        }
        return userNew;
    }

    public UserOrderBy toUserOrderBy(UserOrderByEnum userOrderByEnum) {
        if (userOrderByEnum != null) {
            switch (userOrderByEnum) {
                case ALPHABETICALLY_ASC: {
                    return UserOrderBy.ALPHABETICALLY_ASC;
                }
                case ALPHABETICALLY_DESC: {
                    return UserOrderBy.ALPHABETICALLY_DESC;
                }
                case CREATION_DATE: {
                    return UserOrderBy.CREATION_DATE;
                }
                case DISTANCE: {
                    return UserOrderBy.DISTANCE;
                }
                case RELEVANCE: {
                    return UserOrderBy.RELEVANCE;
                }
                case RANDOM: {
                    return UserOrderBy.RANDOM;
                }
            }
        }
        return null;
    }

    public UserOrderByEnum toUserOrderByEnum(UserOrderBy userOrderBy) {
        if (userOrderBy != null) {
            switch (userOrderBy) {
                case ALPHABETICALLY_ASC: {
                    return UserOrderByEnum.ALPHABETICALLY_ASC;
                }
                case ALPHABETICALLY_DESC: {
                    return UserOrderByEnum.ALPHABETICALLY_DESC;
                }
                case CREATION_DATE: {
                    return UserOrderByEnum.CREATION_DATE;
                }
                case DISTANCE: {
                    return UserOrderByEnum.DISTANCE;
                }
                case RELEVANCE: {
                    return UserOrderByEnum.RELEVANCE;
                }
                case RANDOM: {
                    return UserOrderByEnum.RANDOM;
                }
            }
        }
        return null;
    }

    public UserQuery toUserQuery(UserQueryFilters userQueryFilters) {
        if (userQueryFilters == null) {
            return null;
        }
        UserQuery userQuery = this.newBasicUserQuery(UserQuery.class, userQueryFilters);
        userQuery.setContactsOwner((UserLocatorVO)ModelHelper.voFromString(UserLocatorVO.class, (String)userQueryFilters.getContactsOwner()));
        userQuery.setExcludeContacts(Boolean.TRUE.equals(userQueryFilters.getExcludeContacts()));
        userQuery.setRoles(CollectionHelper.orEmpty(userQueryFilters.getRoles()).stream().map(this.authApiHelper::toRole).collect(Collectors.toSet()));
        userQuery.setOrderBy(this.toUserOrderBy(userQueryFilters.getOrderBy()));
        userQuery.setFromMenu(Boolean.TRUE.equals(userQueryFilters.getFromMenu()));
        userQuery.setIncludeGlobal(Boolean.TRUE.equals(userQueryFilters.getIncludeGlobal()));
        return userQuery;
    }

    public UserQueryFilters toUserQueryFilters(UserQuery userQuery) {
        if (userQuery == null) {
            return null;
        }
        return this.newUserQueryFilters(UserQueryFilters.class, userQuery);
    }

    public AbstractSimpleUserRegistrationDTO toUserRegistrationDTO(UserNew userNew) {
        Object object;
        PublicRegistrationDTO publicRegistrationDTO;
        if (userNew == null) {
            return null;
        }
        if (this.apiHelper.isGuest()) {
            publicRegistrationDTO = new PublicRegistrationDTO();
            publicRegistrationDTO.setCaptchaResponse(this.authApiHelper.toCaptchaResponseDTO(userNew.getCaptcha()));
            publicRegistrationDTO.setIdentityProviderRequestId(userNew.getIdentityProviderRequestId());
            publicRegistrationDTO.setAgreement(Boolean.TRUE.equals(userNew.getAcceptAgreement()));
            publicRegistrationDTO.setAgreements(CollectionHelper.orEmpty(userNew.getAcceptAgreements()).stream().map(string -> (AgreementVO)ModelHelper.voFromString(AgreementVO.class, (String)string)).collect(Collectors.toSet()));
            publicRegistrationDTO.setInviteToken(userNew.getInviteToken());
            publicRegistrationDTO.setExternalPaymentToken(userNew.getExternalPaymentToken());
            publicRegistrationDTO.setUserAgentId(userNew.getUserAgentId());
            object = publicRegistrationDTO;
        } else {
            object = Boolean.TRUE.equals(userNew.getAsMember()) ? new UserRegistrationByMemberDTO() : new UserRegistrationDTO();
        }
        this.fillDTO(object, userNew);
        this.fillRegistrationDTO(object, userNew);
        object.setGroup((GroupVO)ModelHelper.voFromString(GroupVO.class, (String)userNew.getGroup()));
        if (object instanceof UserRegistrationDTO) {
            ((UserRegistrationDTO)object).setBroker((UserVO)ModelHelper.voFromString(UserVO.class, (String)userNew.getBroker()));
        }
        object.setAddresses(userNew.getAddresses().stream().map(this.addressesApiHelper::toAddressDTO).filter(Objects::nonNull).collect(Collectors.toList()));
        if (object instanceof AbstractUserRegistrationDTO) {
            publicRegistrationDTO = (AbstractUserRegistrationDTO)object;
            publicRegistrationDTO.setSecurityQuestion(this.passwordsApiHelper.toSecurityQuestion(userNew.getSecurityQuestion()));
            publicRegistrationDTO.setSecurityAnswer(userNew.getSecurityAnswer());
            publicRegistrationDTO.setContactInfos(userNew.getContactInfos().stream().map(this.contactInfosApiHelper::toContactInfoDTO).filter(Objects::nonNull).collect(Collectors.toList()));
        }
        object.setUploadedImages(CollectionHelper.map(userNew.getImages(), string -> (ImageVO)ModelHelper.voFromString(ImageVO.class, (String)string)));
        object.setNfcToken(this.nfcApiHelper.toNFCTagWithChallengeDTO(userNew.getNfcToken()));
        return object;
    }

    public UserRegistrationPrincipal toUserRegistrationPrincipal(UserPrincipalData userPrincipalData) {
        if (userPrincipalData == null) {
            return null;
        }
        UserRegistrationPrincipal userRegistrationPrincipal = new UserRegistrationPrincipal();
        userRegistrationPrincipal.setType(this.authApiHelper.toPrincipalType(userPrincipalData.getPrincipalType()));
        userRegistrationPrincipal.setValue(userPrincipalData.getPrincipal());
        CollectionHelper.orEmpty((List)userPrincipalData.getChannels()).stream().map(this.apiHelper::toReference).forEach(userRegistrationPrincipal.getChannels()::add);
        return userRegistrationPrincipal;
    }

    public UserRegistrationResult toUserRegistrationResult(org.cyclos.model.users.users.UserRegistrationResult userRegistrationResult) {
        if (userRegistrationResult == null) {
            return null;
        }
        UserRegistrationResult userRegistrationResult2 = this.newUserRegistrationResult(userRegistrationResult);
        userRegistrationResult2.setStatus(this.toUserRegistrationStatusEnum(userRegistrationResult.getStatus()));
        return userRegistrationResult2;
    }

    public UserRegistrationResult toUserRegistrationResult(UserValidationResult userValidationResult) {
        if (userValidationResult == null) {
            return null;
        }
        UserRegistrationResult userRegistrationResult = this.newUserRegistrationResult(userValidationResult);
        userRegistrationResult.setStatus(userValidationResult.isActive() ? UserRegistrationStatusEnum.ACTIVE : UserRegistrationStatusEnum.INACTIVE);
        return userRegistrationResult;
    }

    public UserRelationshipEnum toUserRelationshipEnum(UserRelationship userRelationship) {
        if (userRelationship != null) {
            switch (userRelationship) {
                case ADMINISTRATOR: {
                    return UserRelationshipEnum.ADMINISTRATOR;
                }
                case BROKER: {
                    return UserRelationshipEnum.BROKER;
                }
                case BROKERED: {
                    return UserRelationshipEnum.BROKERED;
                }
                case NONE: {
                    return UserRelationshipEnum.NONE;
                }
                case OWNER: {
                    return UserRelationshipEnum.OWNER;
                }
                case SAME_OWNER: {
                    return UserRelationshipEnum.SAME_OWNER;
                }
                case SELF: {
                    return UserRelationshipEnum.SELF;
                }
            }
        }
        return null;
    }

    public UserResult toUserResult(IUserWithFieldsVO iUserWithFieldsVO) {
        if (iUserWithFieldsVO == null) {
            return null;
        }
        return this.newUserResult(UserResult.class, iUserWithFieldsVO);
    }

    public UserView toUserView(AbstractViewProfileData abstractViewProfileData) {
        Object object;
        Object object2;
        ProfileActionsData profileActionsData;
        OperatorActivitiesData operatorActivitiesData;
        Object object3;
        OperatorProfileActionsData operatorProfileActionsData;
        if (abstractViewProfileData == null) {
            return null;
        }
        UserView userView = new UserView();
        userView.setId(ApiHelper.toId(abstractViewProfileData.getId()));
        userView.setDisplay(abstractViewProfileData.getDisplay());
        userView.setName(abstractViewProfileData.getName());
        userView.setUsername(abstractViewProfileData.getUsername());
        userView.setEmail(abstractViewProfileData.getEmail());
        userView.setEmailPendingValidation(abstractViewProfileData.getEmailPendingValidation());
        List list = abstractViewProfileData.getFields();
        if (list != null) {
            operatorProfileActionsData = list.stream().collect(Collectors.toMap(EntityModel::getId, userCustomFieldDetailedVO -> userCustomFieldDetailedVO));
            userView.setCustomValues(this.apiHelper.toCustomFieldValuesList(UserCustomFieldValue.class, abstractViewProfileData.getCustomValues(), (userCustomFieldValue, iCustomFieldValue) -> {
                userCustomFieldValue.setHidden(this.isHidden((ICustomFieldValue<?, ?, ?, ?>)iCustomFieldValue));
                userCustomFieldValue.setField(this.toUserCustomField((UserCustomFieldDetailedVO)operatorProfileActionsData.get(iCustomFieldValue.getField().getId())));
            }));
        }
        userView.setRelationship(this.toUserRelationshipEnum(abstractViewProfileData.getRelationship()));
        CollectionHelper.orEmpty((List)abstractViewProfileData.getEnabledProfileFields()).stream().map(this::internalName).forEach(userView.getEnabledProfileFields()::add);
        userView.setStatus(this.userStatusApiHelper.toUserStatusEnum(abstractViewProfileData.getStatus()));
        if (abstractViewProfileData instanceof ViewOperatorProfileData) {
            object3 = (ViewOperatorProfileData)abstractViewProfileData;
            operatorActivitiesData = object3.getActivities();
            userView.setRole(RoleEnum.OPERATOR);
            operatorProfileActionsData = object3.getActions();
            userView.setAddresses(null);
            userView.setAdditionalImages(null);
            userView.setContactInfos(null);
            userView.setGroup(this.apiHelper.toReference((EntityModel)object3.getGroup()));
            userView.setUser(this.toUser((BasicUserVO)object3.getUser()));
            userView.setBrokers(null);
        } else {
            object3 = (ViewProfileData)abstractViewProfileData;
            userView.setNameLabel(object3.getNameLabel());
            userView.setContact(this.contactsApiHelper.toContactView(object3.getContactData()));
            userView.setInvitedBy(this.toUser(object3.getInvitedBy()));
            operatorActivitiesData = object3.getActivities();
            profileActionsData = object3.getActions();
            operatorProfileActionsData = profileActionsData;
            if (profileActionsData != null) {
                CollectionHelper.orEmpty((List)profileActionsData.getViewRecordTypes()).forEach(recordTypeCountVO -> {
                    UserRecords userRecords = new UserRecords();
                    userRecords.setCount(recordTypeCountVO.getCount());
                    userView.getRecords().put(ModelHelper.internalNameOrId((IEntity)recordTypeCountVO.getType()), userRecords);
                });
                if (profileActionsData.isViewDocuments()) {
                    object2 = new UserDocuments();
                    ((UserDocuments)object2).setCount(profileActionsData.getDocumentCount());
                    userView.setDocuments((UserDocuments)object2);
                }
            }
            if ((object2 = object3.getGroup()) != null) {
                userView.setRole(this.authApiHelper.toRoleEnum(object2.getNature()));
            }
            userView.setGroup(this.apiHelper.toReference((EntityModel)object2));
            userView.setGroupSet(this.apiHelper.toReference((EntityModel)object3.getGroupSet()));
            userView.setContact(this.contactsApiHelper.toContactView(object3.getContactData()));
            if (object3.getAddressListData() != null) {
                CollectionHelper.orEmpty((List)object3.getAddressListData().getAddresses()).stream().map(geoLocatedAddressVO -> (UserAddressVO)geoLocatedAddressVO).map(this.addressesApiHelper::toAddressView).forEach(userView.getAddresses()::add);
            }
            if (object3.getContactInfoListData() != null) {
                CollectionHelper.orEmpty((List)object3.getContactInfoListData().getContactInfos()).stream().map(this.contactInfosApiHelper::toContactInfoDetailed).forEach(userView.getContactInfos()::add);
            }
            for (int i = 0; i < CollectionHelper.orEmpty((List)object3.getImages()).size(); ++i) {
                ImageVO imageVO = (ImageVO)object3.getImages().get(i);
                Image image = this.imagesApiHelper.toImage(imageVO);
                if (i == 0) {
                    userView.setImage(image);
                    continue;
                }
                userView.getAdditionalImages().add(image);
            }
            object = new ArrayList();
            if (object3.getMainBroker() != null) {
                object.add(this.toBrokerView(object3.getMainBroker()));
            }
            if (object3.getOtherBrokers() != null) {
                object3.getOtherBrokers().stream().map(this::toBrokerView).forEach(((List)object)::add);
            }
            userView.setBrokers((List<BrokerView>)(object3.getOtherBrokers() == null && object3.getMainBroker() == null ? null : object));
            CollectionHelper.orEmpty((List)object3.getAccountsData()).stream().map(this::toAccountWithStatus).forEach(userView.getAccounts()::add);
        }
        if (abstractViewProfileData.getPhoneListData() != null) {
            CollectionHelper.orEmpty((List)abstractViewProfileData.getPhoneListData().getPhones()).stream().map(this.phonesApiHelper::toPhoneView).forEach(userView.getPhones()::add);
        }
        userView.setRegistrationDate(abstractViewProfileData.getUserCreationDate());
        if (operatorActivitiesData != null) {
            userView.setActivationDate(operatorActivitiesData.getUserActivationDate());
            if (operatorActivitiesData.isLastLoginVisible()) {
                userView.setOnline(operatorActivitiesData.isOnline());
                userView.setLastLogin(operatorActivitiesData.getLastLogin());
                userView.setFirstLogin(operatorActivitiesData.getFirstLogin());
            }
            if (operatorActivitiesData instanceof UserActivitiesData) {
                object3 = (UserActivitiesData)operatorActivitiesData;
                profileActionsData = object3.getReferenceStatistics();
                if (profileActionsData != null) {
                    object2 = new UserReferences();
                    ((UserReferences)object2).setCount(profileActionsData.getTotal());
                    ((UserReferences)object2).setScore(Float.isNaN(profileActionsData.getScore()) ? null : new BigDecimal(profileActionsData.getScore()));
                    userView.setReferences((UserReferences)object2);
                }
                if ((object2 = object3.getFeedbackStatistics()) != null) {
                    object = new UserReferences();
                    ((UserReferences)object).setCount(object2.getTotal());
                    ((UserReferences)object).setScore(Float.isNaN(object2.getScore()) ? null : new BigDecimal(object2.getScore()));
                    userView.setPaymentFeedbacks((UserReferences)object);
                }
            }
        }
        object3 = this.toUserPermissions(abstractViewProfileData, (BasicProfileActionsData)operatorProfileActionsData);
        userView.setPermissions((UserPermissions)object3);
        return userView;
    }

    public ValidateRegistrationFieldParams toValidateRegistrationFieldParams(UsersApi.ValidateUserRegistrationFieldParams validateUserRegistrationFieldParams) {
        ValidateRegistrationFieldParams validateRegistrationFieldParams = new ValidateRegistrationFieldParams();
        validateRegistrationFieldParams.setGroup((GroupVO)ModelHelper.voFromString(GroupVO.class, (String)validateUserRegistrationFieldParams.group));
        validateRegistrationFieldParams.setField(validateUserRegistrationFieldParams.field);
        validateRegistrationFieldParams.setValue(validateUserRegistrationFieldParams.value);
        validateRegistrationFieldParams.setAsMember(Boolean.TRUE.equals(validateUserRegistrationFieldParams.asMember));
        return validateRegistrationFieldParams;
    }

    protected UserTransactionPermissions toUserTransactionPermissions(ProfileTransactionActionsData profileTransactionActionsData) {
        if (profileTransactionActionsData == null) {
            return null;
        }
        return this.newUserTransactionPermissions(UserTransactionPermissions.class, profileTransactionActionsData);
    }

    private UserBasicFieldActions basicActions(List<UserProfileFieldActions> list, BasicProfileField basicProfileField) {
        return list.stream().filter(userProfileFieldActions -> {
            if (userProfileFieldActions instanceof UserBasicFieldActions) {
                return ((UserBasicFieldActions)userProfileFieldActions).getBasicField() == basicProfileField;
            }
            return false;
        }).findFirst().orElse(null);
    }

    private void collectProfileFieldActions(List<UserProfileFieldActions> list, Map<String, ProfileFieldActions> map, List<UserCustomFieldDetailed> list2) {
        list.forEach(userProfileFieldActions -> {
            if (userProfileFieldActions.isView()) {
                String string;
                ProfileFieldActions profileFieldActions = new ProfileFieldActions();
                profileFieldActions.setEdit(userProfileFieldActions.isEdit());
                profileFieldActions.setManagePrivacy(userProfileFieldActions.isManagePrivacy());
                if (userProfileFieldActions instanceof UserBasicFieldActions) {
                    BasicProfileField basicProfileField = ((UserBasicFieldActions)userProfileFieldActions).getBasicField();
                    string = basicProfileField.getAlias();
                } else {
                    UserCustomFieldDetailedVO userCustomFieldDetailedVO = ((UserCustomFieldActions)userProfileFieldActions).getCustomField();
                    list2.add(this.toUserCustomFieldDetailed(userCustomFieldDetailedVO));
                    string = ModelHelper.internalNameOrId((IEntity)userCustomFieldDetailedVO);
                }
                map.put(string, profileFieldActions);
            }
        });
    }

    private <DTO extends UserDTO> void fillDTO(DTO DTO, UserManage userManage) {
        this.fillDTO(DTO, (BasicUserManage)userManage);
        List list = CollectionHelper.orEmpty(userManage.getHiddenFields());
        DTO.setHideEmail(CollectionHelper.containsAny((Collection)list, (Collection)BasicProfileField.EMAIL.getAliases()));
        DTO.setCustomValues(this.toUserCustomValuesDTO(userManage.getCustomValues(), list));
    }

    private List<? extends CustomFieldValueDTO> getCustomValues(BasicUserDTO basicUserDTO) {
        if (basicUserDTO instanceof UserDTO) {
            return ((UserDTO)basicUserDTO).getCustomValues();
        }
        if (basicUserDTO instanceof OperatorDTO) {
            return ((OperatorDTO)basicUserDTO).getCustomValues();
        }
        return null;
    }

    private List<String> getHiddenFields(BasicUserDTO basicUserDTO) {
        if (basicUserDTO instanceof UserDTO) {
            UserDTO userDTO = (UserDTO)basicUserDTO;
            ArrayList<String> arrayList = new ArrayList<String>();
            if (userDTO.isHideEmail()) {
                arrayList.add(BasicProfileField.EMAIL.getAlias());
            }
            CollectionHelper.orEmpty((List)userDTO.getCustomValues()).stream().map(userCustomFieldValueDTO -> userCustomFieldValueDTO.isHidden() ? ModelHelper.internalNameOrId((IEntity)userCustomFieldValueDTO.getField()) : null).filter(Objects::nonNull).forEach(arrayList::add);
            return arrayList;
        }
        return Collections.emptyList();
    }

    private boolean isHidden(ICustomFieldValue<?, ?, ?, ?> iCustomFieldValue) {
        if (iCustomFieldValue instanceof UserCustomFieldValueVO) {
            return ((UserCustomFieldValueVO)iCustomFieldValue).isHidden();
        }
        if (iCustomFieldValue instanceof UserCustomFieldValueDTO) {
            return ((UserCustomFieldValueDTO)iCustomFieldValue).isHidden();
        }
        return false;
    }

    private <S extends UserDataForSearch> S newDataForSearch(Class<S> clazz, UserSearchData userSearchData) {
        UserDataForSearch userDataForSearch = (UserDataForSearch)this.newBaseDataForSearch(clazz, (AbstractUserSearchData)userSearchData);
        for (ProfileField profileField : userSearchData.getProfileFieldsInList()) {
            userDataForSearch.getFieldsInList().add(this.internalName(profileField));
        }
        userDataForSearch.setResultType(this.apiHelper.toResultTypeEnum(userSearchData.getResultType()));
        CollectionHelper.orEmpty((List)userSearchData.getAddressFields()).stream().map(this.addressesApiHelper::toAddressQueryFieldEnum).forEach(userDataForSearch.getAddressFieldsInSearch()::add);
        if (CollectionHelper.isNotEmpty((Iterable)userSearchData.getInitialGroups())) {
            userSearchData.getInitialGroups().stream().map(this.groupsApiHelper::toGroup).forEach(userDataForSearch.getGroupsForRegistration()::add);
        }
        UserQuery userQuery = (UserQuery)userSearchData.getQuery();
        userDataForSearch.setQuery(this.toUserQueryFilters(userQuery));
        return (S)userDataForSearch;
    }

    private <U extends User> U newUser(Class<U> clazz, BasicUserVO basicUserVO) {
        UserVO userVO;
        User user = (User)this.apiHelper.newEntity(clazz, basicUserVO);
        user.setDisplay(basicUserVO.getDisplay());
        if (basicUserVO instanceof UserVO) {
            userVO = (UserVO)basicUserVO;
            user.setImage(this.imagesApiHelper.toImage(userVO.getImage()));
        }
        if (basicUserVO instanceof OperatorVO) {
            userVO = (OperatorVO)basicUserVO;
            user.setUser(this.toUser((BasicUserVO)userVO.getUser()));
        }
        if ((userVO = basicUserVO.getLocator()) != null) {
            String string = userVO.getPrincipalType();
            Object object = userVO.getPrincipal();
            if (StringHelper.isNotBlank((Object)object) && StringHelper.isNotBlank((Object)string)) {
                object = string + ":" + (String)object;
            }
            user.setLocator((String)object);
            if (userVO instanceof UserLocatorDetailedVO) {
                user.setLocatorPrincipal(this.authApiHelper.toPrincipal(((UserLocatorDetailedVO)userVO).getUserPrincipal()));
            }
        }
        return (U)user;
    }

    private <U extends UserManage> U newUserManage(Class<U> clazz, BasicUserDTO basicUserDTO) {
        UserManage userManage = (UserManage)this.newBasicUserManage(clazz, basicUserDTO);
        userManage.setHiddenFields(this.getHiddenFields(basicUserDTO));
        return (U)userManage;
    }

    private <F extends UserQueryFilters> F newUserQueryFilters(Class<F> clazz, UserQuery userQuery) {
        UserQueryFilters userQueryFilters = (UserQueryFilters)this.newBasicUserQueryFilters(clazz, (AbstractUserQuery)userQuery);
        if (userQuery.isIgnoreProfileFieldsInList()) {
            userQueryFilters.setIgnoreProfileFieldsInList(true);
        }
        userQueryFilters.setContactsOwner(ModelHelper.stringOrIdFromVO((EntityVO)userQuery.getContactsOwner()));
        userQueryFilters.setExcludeContacts(userQuery.isExcludeContacts());
        CollectionHelper.orEmpty((Set)userQuery.getRoles()).stream().map(this.authApiHelper::toRoleEnum).distinct().forEach(userQueryFilters.getRoles()::add);
        userQueryFilters.setOrderBy(this.toUserOrderByEnum(userQuery.getOrderBy()));
        userQueryFilters.setFromMenu(userQuery.isFromMenu());
        userQueryFilters.setIncludeGlobal(userQuery.isIncludeGlobal());
        return (F)userQueryFilters;
    }

    private <T extends BaseUserRegistrationResult> UserRegistrationResult newUserRegistrationResult(T t) {
        if (t == null) {
            return null;
        }
        UserRegistrationResult userRegistrationResult = new UserRegistrationResult();
        userRegistrationResult.setUser(this.toUser(t.getUser()));
        userRegistrationResult.setRootUrl(t.getRootUrl());
        CollectionHelper.orEmpty((List)t.getGeneratedPasswords()).stream().map(this.apiHelper::toReference).forEach(userRegistrationResult.getGeneratedPasswords()::add);
        CollectionHelper.orEmpty((List)t.getPrincipalsData()).stream().map(this::toUserRegistrationPrincipal).forEach(userRegistrationResult.getPrincipals()::add);
        return userRegistrationResult;
    }

    private <P extends UserTransactionPermissions> P newUserTransactionPermissions(Class<P> clazz, ProfileTransactionActionsData profileTransactionActionsData) {
        UserTransactionPermissions userTransactionPermissions = (UserTransactionPermissions)ClassHelper.instantiate(clazz);
        if (profileTransactionActionsData == null) {
            profileTransactionActionsData = new ProfileTransactionActionsData();
        }
        UserPaymentPermissions userPaymentPermissions = new UserPaymentPermissions();
        userPaymentPermissions.setSelfToUser(profileTransactionActionsData.isPaymentSelfToUser());
        userPaymentPermissions.setSelfToSystem(profileTransactionActionsData.isPaymentSelfToSystem());
        userPaymentPermissions.setSelfToSelf(profileTransactionActionsData.isPaymentSelfToSelf());
        userPaymentPermissions.setSystemToUser(profileTransactionActionsData.isPaymentSystemToUser());
        userPaymentPermissions.setUserToUser(profileTransactionActionsData.isPaymentUserToUser());
        userPaymentPermissions.setAsUserToSystem(profileTransactionActionsData.isPaymentAsUserToSystem());
        userPaymentPermissions.setAsUserToUser(profileTransactionActionsData.isPaymentAsUserToUser());
        userPaymentPermissions.setAsUserToSelf(profileTransactionActionsData.isPaymentAsUserToSelf());
        userTransactionPermissions.setPayment(userPaymentPermissions);
        UserScheduledPaymentsPermissions userScheduledPaymentsPermissions = new UserScheduledPaymentsPermissions();
        userScheduledPaymentsPermissions.setView(profileTransactionActionsData.isViewScheduledPayments());
        userTransactionPermissions.setScheduledPayments(userScheduledPaymentsPermissions);
        UserPaymentRequestsPermissions userPaymentRequestsPermissions = new UserPaymentRequestsPermissions();
        userPaymentRequestsPermissions.setView(profileTransactionActionsData.isViewPaymentRequests());
        userPaymentRequestsPermissions.setSendSelfToUser(profileTransactionActionsData.isRequestPaymentSelfToUser());
        userPaymentRequestsPermissions.setSendSelfToSystem(profileTransactionActionsData.isRequestPaymentSelfToSystem());
        userPaymentRequestsPermissions.setSendFromSystem(profileTransactionActionsData.isRequestPaymentSystemToUser());
        userPaymentRequestsPermissions.setSendFromUser(profileTransactionActionsData.isRequestPaymentUserToUser());
        userPaymentRequestsPermissions.setSendAsUserToSystem(profileTransactionActionsData.isRequestPaymentAsUserToSystem());
        userPaymentRequestsPermissions.setSendAsUserToUser(profileTransactionActionsData.isRequestPaymentAsUserToUser());
        userTransactionPermissions.setPaymentRequests(userPaymentRequestsPermissions);
        UserAuthorizedPaymentsPermissions userAuthorizedPaymentsPermissions = new UserAuthorizedPaymentsPermissions();
        userAuthorizedPaymentsPermissions.setView(profileTransactionActionsData.isViewPendingTransactions());
        userTransactionPermissions.setAuthorizedPayments(userAuthorizedPaymentsPermissions);
        UserTicketsPermissions userTicketsPermissions = new UserTicketsPermissions();
        userTicketsPermissions.setView(profileTransactionActionsData.isViewTickets());
        userTransactionPermissions.setTickets(userTicketsPermissions);
        UserExternalPaymentsPermissions userExternalPaymentsPermissions = new UserExternalPaymentsPermissions();
        userExternalPaymentsPermissions.setPerformAsSelf(profileTransactionActionsData.isExternalPaymentAsSelf());
        userExternalPaymentsPermissions.setPerformAsUser(profileTransactionActionsData.isExternalPaymentAsUser());
        userExternalPaymentsPermissions.setView(profileTransactionActionsData.isViewExternalPayments());
        userTransactionPermissions.setExternalPayments(userExternalPaymentsPermissions);
        return (P)userTransactionPermissions;
    }

    private <In, Out> void processEach(BeanWrapper beanWrapper, BeanWrapper beanWrapper2, String string, Function<In, Out> function) {
        Collection collection = (Collection)beanWrapper.getPropertyValue(string);
        if (CollectionHelper.isNotEmpty((Iterable)collection)) {
            List list = collection.stream().map(function).collect(Collectors.toList());
            beanWrapper2.setPropertyValue(string, list);
        }
    }

    private AccountWithStatus toAccountWithStatus(UserAccountData userAccountData) {
        return this.accountsApiHelper.toAccountWithStatus(userAccountData);
    }

    private AddressConfigurationForUserProfile toAddressConfigurationForUserProfile(AbstractSimpleRegistrationData abstractSimpleRegistrationData) {
        UserBasicFieldActions userBasicFieldActions;
        AddressConfigurationData addressConfigurationData = abstractSimpleRegistrationData.getAddressConfiguration();
        if (addressConfigurationData == null) {
            AddressConfigurationForUserProfile addressConfigurationForUserProfile = new AddressConfigurationForUserProfile();
            addressConfigurationForUserProfile.setAvailability(AvailabilityEnum.DISABLED);
            addressConfigurationForUserProfile.setMaxAddresses(0);
            return addressConfigurationForUserProfile;
        }
        AddressConfigurationForUserProfile addressConfigurationForUserProfile = this.addressesApiHelper.newAddressConfiguration(AddressConfigurationForUserProfile.class, addressConfigurationData);
        UserAddressData userAddressData = abstractSimpleRegistrationData.getAddressData();
        addressConfigurationForUserProfile.setAvailability(this.apiHelper.toAvailability(abstractSimpleRegistrationData.isCanCreateAddress(), addressConfigurationData.isRequiredAddress()));
        if (userAddressData != null && addressConfigurationForUserProfile.getAvailability() != AvailabilityEnum.DISABLED) {
            userBasicFieldActions = (UserAddressDTO)userAddressData.getDto();
            addressConfigurationForUserProfile.setAddress(this.addressesApiHelper.toAddressNew((UserAddressDTO)userBasicFieldActions));
            addressConfigurationForUserProfile.setContactInfoEnabled(userAddressData.isContactInfoEnabled());
            CollectionHelper.orEmpty((List)userAddressData.getContactInfoFields()).stream().map(this.apiHelper::toCustomFieldDetailed).forEach(addressConfigurationForUserProfile.getContactInfoFields()::add);
            addressConfigurationForUserProfile.setPhoneConfiguration(this.phonesApiHelper.toPhoneConfiguration(userAddressData.getPhoneConfiguration()));
        }
        addressConfigurationForUserProfile.setEdit((userBasicFieldActions = this.basicActions(abstractSimpleRegistrationData.getProfileFieldActions(), BasicProfileField.ADDRESS)) != null && userBasicFieldActions.isEdit());
        addressConfigurationForUserProfile.setManagePrivacy(userBasicFieldActions != null && userBasicFieldActions.isManagePrivacy());
        addressConfigurationForUserProfile.setMaxAddresses(abstractSimpleRegistrationData.getMaxAddresses());
        return addressConfigurationForUserProfile;
    }

    private BrokerView toBrokerView(BrokeringVO brokeringVO) {
        if (brokeringVO == null) {
            return null;
        }
        BrokerView brokerView = new BrokerView();
        brokerView.setBroker(this.toUser((BasicUserVO)brokeringVO.getBroker()));
        brokerView.setMainBroker(brokeringVO.isMain());
        brokerView.setSince(brokeringVO.getBeginDate());
        return brokerView;
    }

    private ContactInfoConfigurationForUserProfile toContactInfoConfigurationForUserProfile(AbstractRegistrationData abstractRegistrationData) {
        ContactInfoData contactInfoData = abstractRegistrationData.getContactInfoData();
        if (contactInfoData == null) {
            ContactInfoConfigurationForUserProfile contactInfoConfigurationForUserProfile = new ContactInfoConfigurationForUserProfile();
            contactInfoConfigurationForUserProfile.setAvailability(AvailabilityEnum.DISABLED);
            contactInfoConfigurationForUserProfile.setMaxContactInfos(0);
            return contactInfoConfigurationForUserProfile;
        }
        ContactInfoConfigurationForUserProfile contactInfoConfigurationForUserProfile = new ContactInfoConfigurationForUserProfile();
        contactInfoConfigurationForUserProfile.setContactInfo(this.contactInfosApiHelper.toContactInfoNew((ContactInfoDTO)contactInfoData.getDto()));
        contactInfoData.getCustomFields().stream().map(this.apiHelper::toCustomFieldDetailed).forEach(contactInfoConfigurationForUserProfile.getCustomFields()::add);
        contactInfoConfigurationForUserProfile.setAvailability(this.apiHelper.toAvailability(abstractRegistrationData.isCanCreateContactInfos(), false));
        contactInfoConfigurationForUserProfile.setEdit(contactInfoData.isEditable());
        contactInfoConfigurationForUserProfile.setManagePrivacy(contactInfoData.isEditable());
        contactInfoConfigurationForUserProfile.setMaxContactInfos(abstractRegistrationData.getMaxContactInfos());
        return contactInfoConfigurationForUserProfile;
    }

    private FieldSection toFieldSection(UserSectionVO userSectionVO) {
        if (userSectionVO == null) {
            return null;
        }
        FieldSection fieldSection = this.apiHelper.newEntity(FieldSection.class, userSectionVO);
        if (userSectionVO instanceof UserSectionDetailedVO) {
            UserSectionDetailedVO userSectionDetailedVO = (UserSectionDetailedVO)userSectionVO;
            fieldSection.setInformationText(userSectionDetailedVO.getInformationText());
        }
        return fieldSection;
    }

    private ImageConfigurationForUserProfile toImageConfigurationForUserProfile(AbstractSimpleRegistrationData abstractSimpleRegistrationData) {
        UserProfileFieldActions userProfileFieldActions2 = abstractSimpleRegistrationData.getProfileFieldActions().stream().filter(userProfileFieldActions -> {
            if (userProfileFieldActions instanceof UserBasicFieldActions) {
                return ((UserBasicFieldActions)userProfileFieldActions).getBasicField() == BasicProfileField.IMAGE;
            }
            return false;
        }).findFirst().orElse(null);
        if (userProfileFieldActions2 == null || !userProfileFieldActions2.isEdit()) {
            ImageConfigurationForUserProfile imageConfigurationForUserProfile = new ImageConfigurationForUserProfile();
            imageConfigurationForUserProfile.setAvailability(AvailabilityEnum.DISABLED);
            imageConfigurationForUserProfile.setMaxImages(0);
            return imageConfigurationForUserProfile;
        }
        ImageConfigurationForUserProfile imageConfigurationForUserProfile = new ImageConfigurationForUserProfile();
        imageConfigurationForUserProfile.setAvailability(this.apiHelper.toAvailability(true, abstractSimpleRegistrationData.isImageRequired()));
        imageConfigurationForUserProfile.setManage(true);
        imageConfigurationForUserProfile.setMaxImages(abstractSimpleRegistrationData.getMaxImages());
        return imageConfigurationForUserProfile;
    }

    private PasswordTypeRegistration toPasswordTypeRegistration(boolean bl, PasswordRegistrationData passwordRegistrationData) {
        PasswordTypeDetailedVO passwordTypeDetailedVO = passwordRegistrationData.getType();
        PasswordTypeRegistration passwordTypeRegistration = this.passwordsApiHelper.newPasswordTypeDetailed(PasswordTypeRegistration.class, passwordTypeDetailedVO);
        passwordTypeRegistration.setCanForceChange(bl ? false : passwordRegistrationData.isUserCanChangePassword());
        return passwordTypeRegistration;
    }

    private PhoneConfigurationForUserProfile toPhoneConfigurationForUserProfile(SimpleBasicUserRegistrationData simpleBasicUserRegistrationData) {
        PhoneConfigurationData phoneConfigurationData = simpleBasicUserRegistrationData.getPhoneConfiguration();
        if (phoneConfigurationData == null) {
            PhoneConfigurationForUserProfile phoneConfigurationForUserProfile = new PhoneConfigurationForUserProfile();
            phoneConfigurationForUserProfile.setEdit(false);
            phoneConfigurationForUserProfile.setManagePrivacy(false);
            phoneConfigurationForUserProfile.setMobileAvailability(AvailabilityEnum.DISABLED);
            phoneConfigurationForUserProfile.setMaxMobiles(0);
            phoneConfigurationForUserProfile.setLandLineAvailability(AvailabilityEnum.DISABLED);
            phoneConfigurationForUserProfile.setMaxLandLines(0);
            return phoneConfigurationForUserProfile;
        }
        PhoneConfigurationForUserProfile phoneConfigurationForUserProfile = this.phonesApiHelper.newPhoneConfiguration(PhoneConfigurationForUserProfile.class, phoneConfigurationData);
        phoneConfigurationForUserProfile.setMobileAvailability(this.apiHelper.toAvailability(simpleBasicUserRegistrationData.isCanCreateMobilePhone(), simpleBasicUserRegistrationData.isMobileRequired()));
        phoneConfigurationForUserProfile.setLandLineAvailability(this.apiHelper.toAvailability(simpleBasicUserRegistrationData.isCanCreateLandlinePhone(), simpleBasicUserRegistrationData.isLandLineRequired()));
        UserBasicFieldActions userBasicFieldActions = this.basicActions(simpleBasicUserRegistrationData.getProfileFieldActions(), BasicProfileField.PHONE);
        phoneConfigurationForUserProfile.setEdit(userBasicFieldActions != null && userBasicFieldActions.isEdit());
        phoneConfigurationForUserProfile.setManagePrivacy(userBasicFieldActions != null && userBasicFieldActions.isManagePrivacy());
        phoneConfigurationForUserProfile.setMaxLandLines(simpleBasicUserRegistrationData.getMaxLandLinePhones());
        phoneConfigurationForUserProfile.setMaxMobiles(simpleBasicUserRegistrationData.getMaxMobilePhones());
        if (phoneConfigurationForUserProfile.getMobileAvailability() != AvailabilityEnum.DISABLED && simpleBasicUserRegistrationData.getMobilePhoneData() != null) {
            phoneConfigurationForUserProfile.setMobilePhone(this.phonesApiHelper.toPhoneNew((PhoneDTO)simpleBasicUserRegistrationData.getMobilePhoneData().getDto()));
        }
        if (phoneConfigurationForUserProfile.getLandLineAvailability() != AvailabilityEnum.DISABLED && simpleBasicUserRegistrationData.getLandLinePhoneData() != null) {
            phoneConfigurationForUserProfile.setLandLinePhone(this.phonesApiHelper.toPhoneNew((PhoneDTO)simpleBasicUserRegistrationData.getLandLinePhoneData().getDto()));
        }
        return phoneConfigurationForUserProfile;
    }

    private BaseValueForSearchDTO toProfileFieldForSearch(String string) {
        AddressFieldValueForSearchDTO addressFieldValueForSearchDTO;
        AddressQueryField addressQueryField;
        Pair<String, String> pair = this.apiHelper.splitFieldParts(string);
        if (pair == null) {
            return null;
        }
        String string2 = StringUtils.substringBefore((String)((String)pair.getFirst()), (String)".");
        String string3 = StringUtils.substringAfterLast((String)((String)pair.getFirst()), (String)".");
        BasicProfileField basicProfileField = BasicProfileField.getByAlias((String)string2);
        AddressQueryField addressQueryField2 = addressQueryField = basicProfileField == BasicProfileField.ADDRESS ? AddressQueryField.getByInternalName((String)string3) : null;
        if (addressQueryField != null) {
            AddressFieldValueForSearchDTO addressFieldValueForSearchDTO2 = new AddressFieldValueForSearchDTO();
            addressFieldValueForSearchDTO2.setAddressField(addressQueryField);
            addressFieldValueForSearchDTO = addressFieldValueForSearchDTO2;
        } else if (basicProfileField == null) {
            CustomFieldValueForSearchDTO customFieldValueForSearchDTO = new CustomFieldValueForSearchDTO();
            customFieldValueForSearchDTO.setField((CustomFieldVO)ModelHelper.voFromString(CustomFieldVO.class, (String)string2));
            addressFieldValueForSearchDTO = customFieldValueForSearchDTO;
        } else {
            if (basicProfileField == BasicProfileField.ADDRESS && (StringUtils.isNotEmpty((CharSequence)string3) || StringUtils.contains((CharSequence)((CharSequence)pair.getFirst()), (CharSequence)"."))) {
                throw new EntityNotFoundException(ProfileField.class, (String)pair.getFirst());
            }
            BasicProfileFieldValueForSearchDTO basicProfileFieldValueForSearchDTO = new BasicProfileFieldValueForSearchDTO();
            basicProfileFieldValueForSearchDTO.setField(basicProfileField);
            addressFieldValueForSearchDTO = basicProfileFieldValueForSearchDTO;
        }
        addressFieldValueForSearchDTO.setStringValue((String)pair.getSecond());
        return addressFieldValueForSearchDTO;
    }

    private UserCustomField toUserCustomField(UserCustomFieldDetailedVO userCustomFieldDetailedVO) {
        if (userCustomFieldDetailedVO == null) {
            return null;
        }
        UserCustomField userCustomField = this.apiHelper.newCustomField(UserCustomField.class, (CustomFieldVO)userCustomFieldDetailedVO);
        userCustomField.setSection(this.toFieldSection((UserSectionVO)userCustomFieldDetailedVO.getSection()));
        return userCustomField;
    }

    private UserCustomField toUserCustomField(UserCustomFieldVO userCustomFieldVO) {
        if (userCustomFieldVO == null) {
            return null;
        }
        UserCustomField userCustomField = this.apiHelper.newCustomField(UserCustomField.class, (CustomFieldVO)userCustomFieldVO);
        userCustomField.setSection(this.toFieldSection(userCustomFieldVO.getSection()));
        return userCustomField;
    }

    private UserCustomFieldDetailed toUserCustomFieldDetailed(UserCustomFieldDetailedVO userCustomFieldDetailedVO) {
        if (userCustomFieldDetailedVO == null) {
            return null;
        }
        UserCustomFieldDetailed userCustomFieldDetailed = this.apiHelper.newCustomFieldDetailed(UserCustomFieldDetailed.class, (CustomFieldDetailedVO)userCustomFieldDetailedVO);
        userCustomFieldDetailed.setHiddenByDefault(userCustomFieldDetailedVO.isHiddenByDefault());
        userCustomFieldDetailed.setSection(this.toFieldSection((UserSectionVO)userCustomFieldDetailedVO.getSection()));
        return userCustomFieldDetailed;
    }

    private UserPermissions toUserPermissions(AbstractViewProfileData abstractViewProfileData, BasicProfileActionsData basicProfileActionsData) {
        UserGroupPermissions userGroupPermissions;
        UserValidationPermissions userValidationPermissions;
        if (basicProfileActionsData == null) {
            return null;
        }
        ProfileActionsData profileActionsData = (ProfileActionsData)ObjectHelper.ifType((Object)basicProfileActionsData, ProfileActionsData.class);
        UserPermissions userPermissions = profileActionsData == null ? new UserPermissions() : this.newUserTransactionPermissions(UserPermissions.class, profileActionsData.getTransactions());
        CollectionHelper.orEmpty((List)basicProfileActionsData.getTokens()).stream().map(this.tokensApiHelper::toTokenPermissions).forEach(userPermissions.getTokens()::add);
        userPermissions.setProfile(this.toUserProfilePermissions(abstractViewProfileData));
        UserPasswordsPermissions userPasswordsPermissions = new UserPasswordsPermissions();
        userPasswordsPermissions.setManage(basicProfileActionsData.isManagePasswords());
        userPasswordsPermissions.setResetSecurityQuestion(basicProfileActionsData.isResetSecurityQuestion());
        userPasswordsPermissions.setViewTotpSecret(basicProfileActionsData.isViewTotpSecret());
        userPermissions.setPasswords(userPasswordsPermissions);
        ViewProfileData viewProfileData = (ViewProfileData)ObjectHelper.ifType((Object)abstractViewProfileData, ViewProfileData.class);
        UserProductsPermissions userProductsPermissions = new UserProductsPermissions();
        userProductsPermissions.setView(profileActionsData != null && profileActionsData.isViewProducts());
        if (viewProfileData != null && viewProfileData.getProducts() != null) {
            CollectionHelper.orEmpty((List)viewProfileData.getProducts().getThisLevelsProducts()).stream().map(this.apiHelper::toReference).forEach(userProductsPermissions.getIndividual()::add);
            userValidationPermissions = viewProfileData.getProducts().getLevelUp();
            CollectionHelper.orEmpty((List)userValidationPermissions.getThisLevelsProducts()).stream().map(this.apiHelper::toReference).forEach(userProductsPermissions.getGroup()::add);
            userGroupPermissions = userValidationPermissions.getLevelUp();
            if (userGroupPermissions != null) {
                CollectionHelper.orEmpty((List)userGroupPermissions.getThisLevelsProducts()).stream().map(this.apiHelper::toReference).forEach(userProductsPermissions.getGroupSet()::add);
            }
        }
        userPermissions.setProducts(userProductsPermissions);
        userValidationPermissions = new UserValidationPermissions();
        userValidationPermissions.setValidateRegistration(basicProfileActionsData.isManuallyValidateRegistration());
        userValidationPermissions.setResendRegistrationValidation(basicProfileActionsData.isResendRegistrationValidationEmail());
        userValidationPermissions.setValidateEmailChange(basicProfileActionsData.isManuallyValidateEmail());
        userValidationPermissions.setResendEmailChange(basicProfileActionsData.isResendEmailChangeEmail());
        userPermissions.setValidation(userValidationPermissions);
        userGroupPermissions = new UserGroupPermissions();
        userGroupPermissions.setView(basicProfileActionsData.isViewGroupHistory());
        userPermissions.setGroup(userGroupPermissions);
        UserStatusPermissions userStatusPermissions = new UserStatusPermissions();
        userStatusPermissions.setView(basicProfileActionsData.isViewStatusHistory());
        userPermissions.setStatus(userStatusPermissions);
        UserSessionPermissions userSessionPermissions = new UserSessionPermissions();
        userSessionPermissions.setDisconnect(basicProfileActionsData.isDisconnect());
        userPermissions.setSession(userSessionPermissions);
        UserNotificationSettingsPermissions userNotificationSettingsPermissions = new UserNotificationSettingsPermissions();
        userNotificationSettingsPermissions.setView(basicProfileActionsData.isViewNotificationSettings());
        userPermissions.setNotificationSettings(userNotificationSettingsPermissions);
        UserQuickAccessPermissions userQuickAccessPermissions = new UserQuickAccessPermissions();
        userQuickAccessPermissions.setView(basicProfileActionsData.isViewQuickAccess());
        userPermissions.setQuickAccess(userQuickAccessPermissions);
        if (profileActionsData == null) {
            userPermissions.setAccounts(null);
            userPermissions.setRecords(null);
            userPermissions.setOperations(null);
        } else {
            UserContactPermissions userContactPermissions = new UserContactPermissions();
            userContactPermissions.setAdd(profileActionsData.isAddToContactList());
            userContactPermissions.setRemove(profileActionsData.isRemoveFromContactList());
            userPermissions.setContact(userContactPermissions);
            UserBrokeringPermissions userBrokeringPermissions = new UserBrokeringPermissions();
            userBrokeringPermissions.setViewBrokers(profileActionsData.isViewBrokers());
            userBrokeringPermissions.setViewMembers(profileActionsData.isViewBrokeredUsers());
            userPermissions.setBrokering(userBrokeringPermissions);
            UserOperatorsPermissions userOperatorsPermissions = new UserOperatorsPermissions();
            userOperatorsPermissions.setViewOperators(profileActionsData.isViewOperators());
            userOperatorsPermissions.setViewGroups(userOperatorsPermissions.getViewOperators());
            userPermissions.setOperators(userOperatorsPermissions);
            UserMarketplacePermissions userMarketplacePermissions = new UserMarketplacePermissions();
            UserBaseAdPermissions userBaseAdPermissions = new UserBaseAdPermissions();
            UserWebshopPermissions userWebshopPermissions = new UserWebshopPermissions();
            userMarketplacePermissions.setSimple(userBaseAdPermissions);
            userMarketplacePermissions.setWebshop(userWebshopPermissions);
            userMarketplacePermissions.setViewInterests(profileActionsData.isViewAdInterests());
            userMarketplacePermissions.setManageInterests(profileActionsData.isManageAdInterests());
            userMarketplacePermissions.setViewFavorites(profileActionsData.isViewFavoriteAds());
            userBaseAdPermissions.setManage(profileActionsData.isManageAds());
            userBaseAdPermissions.setView(profileActionsData.isViewAds());
            userBaseAdPermissions.setManagePending(profileActionsData.isManagePendingAds());
            userBaseAdPermissions.setViewPending(profileActionsData.isViewPendingAds());
            userWebshopPermissions.setManage(profileActionsData.isManageWebShop());
            userWebshopPermissions.setView(profileActionsData.isViewWebShop());
            userWebshopPermissions.setManagePending(profileActionsData.isManagePendingWebShop());
            userWebshopPermissions.setViewPending(profileActionsData.isViewPendingWebShop());
            userWebshopPermissions.setViewSales(profileActionsData.isViewSales());
            userWebshopPermissions.setPurchase(profileActionsData.isPurchase());
            userWebshopPermissions.setViewPurchases(profileActionsData.isViewPurchases());
            userWebshopPermissions.setViewSettings(profileActionsData.isViewWebShopSettings());
            userWebshopPermissions.setManageSettings(profileActionsData.isManageWebShopSettings());
            userPermissions.setMarketplace(userMarketplacePermissions);
            CollectionHelper.orEmpty((List)profileActionsData.getAccounts()).stream().map(this.accountsApiHelper::toAccountWithCurrency).forEach(userPermissions.getAccounts()::add);
            UserAccountVisibilitySettingsPermissions userAccountVisibilitySettingsPermissions = new UserAccountVisibilitySettingsPermissions();
            userAccountVisibilitySettingsPermissions.setView(profileActionsData.isViewAccountsVisibilitySettings());
            userPermissions.setAccountVisibilitySettings(userAccountVisibilitySettingsPermissions);
            UserBalanceLimitsPermissions userBalanceLimitsPermissions = new UserBalanceLimitsPermissions();
            userBalanceLimitsPermissions.setView(profileActionsData.isViewCreditLimit());
            userPermissions.setBalanceLimits(userBalanceLimitsPermissions);
            UserPaymentLimitsPermissions userPaymentLimitsPermissions = new UserPaymentLimitsPermissions();
            userPaymentLimitsPermissions.setView(profileActionsData.isViewPaymentLimits());
            userPermissions.setPaymentLimits(userPaymentLimitsPermissions);
            UserDocumentsPermissions userDocumentsPermissions = new UserDocumentsPermissions();
            userDocumentsPermissions.setView(profileActionsData.isViewDocuments());
            userPermissions.setDocuments(userDocumentsPermissions);
            UserReferencesPermissions userReferencesPermissions = new UserReferencesPermissions();
            userReferencesPermissions.setView(profileActionsData.isViewReferences());
            userPermissions.setReferences(userReferencesPermissions);
            UserPaymentFeedbacksPermissions userPaymentFeedbacksPermissions = new UserPaymentFeedbacksPermissions();
            userPaymentFeedbacksPermissions.setView(profileActionsData.isViewTransactionFeedbacks());
            userPermissions.setPaymentFeedbacks(userPaymentFeedbacksPermissions);
            CollectionHelper.orEmpty((List)profileActionsData.getViewRecordTypes()).stream().map(this.recordsApiHelper::toOwnerRecordPermissions).forEach(userPermissions.getRecords()::add);
            CollectionHelper.orEmpty((List)profileActionsData.getCustomOperations()).stream().map(this.operationsApiHelper::toOperation).forEach(userPermissions.getOperations()::add);
            CollectionHelper.orEmpty((List)profileActionsData.getWizards()).stream().map(this.wizardsApiHelper::toWizard).forEach(userPermissions.getWizards()::add);
            UserVouchersPermissions userVouchersPermissions = new UserVouchersPermissions();
            userVouchersPermissions.setView(profileActionsData.isViewVouchers());
            userVouchersPermissions.setBuy(profileActionsData.isBuyVouchers());
            userVouchersPermissions.setSend(profileActionsData.isSendVoucher());
            userVouchersPermissions.setViewTransactions(profileActionsData.isViewVoucherTransactions());
            userVouchersPermissions.setRedeem(profileActionsData.isRedeemVoucher());
            userVouchersPermissions.setTopUp(profileActionsData.isTopUpVoucher());
            userVouchersPermissions.setTopUpEnabled(profileActionsData.isVoucherTopUpEnabled());
            userVouchersPermissions.setViewRedeemed(userVouchersPermissions.getView());
            userVouchersPermissions.setViewBought(userVouchersPermissions.getViewTransactions());
            userPermissions.setVouchers(userVouchersPermissions);
            UserIdentityProvidersPermissions userIdentityProvidersPermissions = new UserIdentityProvidersPermissions();
            userIdentityProvidersPermissions.setView(profileActionsData.isViewIdentityProviders());
            userPermissions.setIdentityProviders(userIdentityProvidersPermissions);
            UserPrivacySettingsPermissions userPrivacySettingsPermissions = new UserPrivacySettingsPermissions();
            userPrivacySettingsPermissions.setView(profileActionsData.isViewPrivacySettings());
            userPermissions.setPrivacySettings(userPrivacySettingsPermissions);
            AgreementsPermissions agreementsPermissions = new AgreementsPermissions();
            agreementsPermissions.setView(profileActionsData.isViewAgreementLog());
            userPermissions.setAgreements(agreementsPermissions);
            UserMessagesPermissions userMessagesPermissions = new UserMessagesPermissions();
            userMessagesPermissions.setSend(profileActionsData.isSendMessage());
            userPermissions.setMessages(userMessagesPermissions);
            if (CollectionHelper.isNotEmpty((Iterable)profileActionsData.getImportTypes())) {
                UserImportsPermissions userImportsPermissions = new UserImportsPermissions();
                profileActionsData.getImportTypes().stream().map(this.importsApiHelper::toUserImportedFileKind).forEach(userImportsPermissions.getKinds()::add);
                userPermissions.setImports(userImportsPermissions);
            }
        }
        return userPermissions;
    }

    private UserProfilePermissions toUserProfilePermissions(AbstractViewProfileData abstractViewProfileData) {
        Object object;
        ViewProfileData viewProfileData = (ViewProfileData)ObjectHelper.ifType((Object)abstractViewProfileData, ViewProfileData.class);
        boolean bl = viewProfileData != null;
        PhoneListData phoneListData = abstractViewProfileData.getPhoneListData();
        if (bl && viewProfileData.getActions() == null) {
            return null;
        }
        UserProfilePermissions userProfilePermissions = new UserProfilePermissions();
        userProfilePermissions.setEditProfile(abstractViewProfileData.isCanEditProfile());
        userProfilePermissions.setManagePhones(phoneListData != null && phoneListData.isManagesPhones());
        userProfilePermissions.setManagePhonesPrivacy(phoneListData != null && phoneListData.isCanManagePrivacy());
        userProfilePermissions.setPhysicallyRemove(abstractViewProfileData.isCanPhysicallyRemove());
        if (bl) {
            object = viewProfileData.getAddressListData();
            userProfilePermissions.setManageAddresses(object != null && object.isManagesAddresses());
            userProfilePermissions.setManageAddressesPrivacy(object != null && object.isCanManagePrivacy());
            userProfilePermissions.setManageImages(viewProfileData.isManageUserImages());
            ContactInfoListData contactInfoListData = viewProfileData.getContactInfoListData();
            userProfilePermissions.setManageContactInfos(contactInfoListData != null && contactInfoListData.isCanManage());
        } else {
            userProfilePermissions.setManageAddresses(false);
            userProfilePermissions.setManageAddressesPrivacy(false);
            userProfilePermissions.setManageImages(false);
            userProfilePermissions.setManageContactInfos(false);
        }
        if (Boolean.TRUE.equals(userProfilePermissions.getManageAddresses())) {
            object = viewProfileData.getAddressListData().getMaxAddresses();
            boolean bl2 = viewProfileData.getAddressConfiguration().isRequiredAddress();
            userProfilePermissions.setCanCreateAddress(viewProfileData.getAddressListData().isCanCreateAddress());
            userProfilePermissions.setMaxAddresses((Integer)object);
            userProfilePermissions.setAddressAvailability(this.apiHelper.toAvailability((Integer)object > 0, bl2));
        }
        if (Boolean.TRUE.equals(userProfilePermissions.getManagePhones())) {
            boolean bl3 = abstractViewProfileData.getPhoneConfiguration().isLandLineRequired();
            boolean bl4 = abstractViewProfileData.getPhoneConfiguration().isMobileRequired();
            Integer n = phoneListData.getMaxLandLinePhones();
            Integer n2 = phoneListData.getMaxMobilePhones();
            userProfilePermissions.setCanCreateLandLine(phoneListData.isCanCreateLandlinePhone());
            userProfilePermissions.setMaxLandLines(n);
            userProfilePermissions.setLandLineAvailability(this.apiHelper.toAvailability(n > 0, bl3));
            userProfilePermissions.setCanCreateMobile(phoneListData.isCanCreateMobilePhone());
            userProfilePermissions.setMaxMobiles(n2);
            userProfilePermissions.setMobileAvailability(this.apiHelper.toAvailability(n2 > 0, bl4));
        }
        if (Boolean.TRUE.equals(userProfilePermissions.getManageImages())) {
            Integer n = viewProfileData.getMaxUserImages();
            userProfilePermissions.setCanCreateImage(n > CollectionHelper.size((Collection)viewProfileData.getImages()));
            userProfilePermissions.setMaxImages(n);
            userProfilePermissions.setProfileImageAvailability(this.apiHelper.toAvailability(n > 0, viewProfileData.isProfileImageRequired()));
        }
        if (Boolean.TRUE.equals(userProfilePermissions.getManageContactInfos())) {
            Integer n = viewProfileData.getContactInfoListData().getMaxContactInfo();
            userProfilePermissions.setCanCreateContactInfo(viewProfileData.getContactInfoListData().isCanCreate());
            userProfilePermissions.setMaxContactInfos(n);
            userProfilePermissions.setContactInfoAvailability(this.apiHelper.toAvailability(n > 0, false));
        }
        return userProfilePermissions;
    }

    private UserRegistrationStatusEnum toUserRegistrationStatusEnum(RegistrationStatus registrationStatus) {
        if (registrationStatus != null) {
            switch (registrationStatus) {
                case ACTIVE: {
                    return UserRegistrationStatusEnum.ACTIVE;
                }
                case EMAIL_VALIDATION: {
                    return UserRegistrationStatusEnum.EMAIL_VALIDATION;
                }
                case INACTIVE: {
                    return UserRegistrationStatusEnum.INACTIVE;
                }
            }
        }
        return null;
    }
}

