/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.helpers;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.cyclos.model.ConfigurationEntityVO;
import org.cyclos.model.EntityVO;
import org.cyclos.model.QueryParameters;
import org.cyclos.model.access.passwords.ICredentialInputDTO;
import org.cyclos.model.banking.accounts.AccountVO;
import org.cyclos.model.banking.transactions.BaseInternalPaymentPreviewVO;
import org.cyclos.model.banking.transactions.TransactionVO;
import org.cyclos.model.banking.vouchercategories.VoucherCategoryVO;
import org.cyclos.model.banking.voucherconfigurations.VoucherConfigurationVO;
import org.cyclos.model.banking.voucherconfigurations.VoucherGenerationAmount;
import org.cyclos.model.banking.voucherconfigurations.VoucherGenerationStatus;
import org.cyclos.model.banking.voucherconfigurations.VoucherPinOnActivation;
import org.cyclos.model.banking.vouchers.AssignVoucherDTO;
import org.cyclos.model.banking.vouchers.BasicCreateVoucherData;
import org.cyclos.model.banking.vouchers.BasicVoucherData;
import org.cyclos.model.banking.vouchers.BasicVoucherQuery;
import org.cyclos.model.banking.vouchers.BuyVoucherData;
import org.cyclos.model.banking.vouchers.BuyVoucherPreviewVO;
import org.cyclos.model.banking.vouchers.BuyVouchersDTO;
import org.cyclos.model.banking.vouchers.CancelVoucherDTO;
import org.cyclos.model.banking.vouchers.ChangeVoucherExpirationDateDTO;
import org.cyclos.model.banking.vouchers.ChangeVoucherNotificationSettingsDTO;
import org.cyclos.model.banking.vouchers.ChangeVoucherPinDTO;
import org.cyclos.model.banking.vouchers.CreateVoucherDataParams;
import org.cyclos.model.banking.vouchers.GeneralVoucherQuery;
import org.cyclos.model.banking.vouchers.GeneralVouchersSearchData;
import org.cyclos.model.banking.vouchers.GenerateVouchersDTO;
import org.cyclos.model.banking.vouchers.GenerateVouchersData;
import org.cyclos.model.banking.vouchers.InitialVoucherUserData;
import org.cyclos.model.banking.vouchers.PerformVoucherTransactionDTO;
import org.cyclos.model.banking.vouchers.PerformVoucherTransactionData;
import org.cyclos.model.banking.vouchers.RedeemVoucherDTO;
import org.cyclos.model.banking.vouchers.RedeemVoucherData;
import org.cyclos.model.banking.vouchers.RedeemVoucherPreviewVO;
import org.cyclos.model.banking.vouchers.SendVoucherDTO;
import org.cyclos.model.banking.vouchers.SimpleChangeVoucherPinDTO;
import org.cyclos.model.banking.vouchers.TopUpVoucherDTO;
import org.cyclos.model.banking.vouchers.TopUpVoucherData;
import org.cyclos.model.banking.vouchers.TopUpVoucherPreviewVO;
import org.cyclos.model.banking.vouchers.UserVoucherQuery;
import org.cyclos.model.banking.vouchers.UserVouchersSearchData;
import org.cyclos.model.banking.vouchers.VoucherBarcodeParams;
import org.cyclos.model.banking.vouchers.VoucherCancelAction;
import org.cyclos.model.banking.vouchers.VoucherCreationType;
import org.cyclos.model.banking.vouchers.VoucherData;
import org.cyclos.model.banking.vouchers.VoucherOrderBy;
import org.cyclos.model.banking.vouchers.VoucherPackVO;
import org.cyclos.model.banking.vouchers.VoucherPackWithIdsVO;
import org.cyclos.model.banking.vouchers.VoucherPinStatusForRedeem;
import org.cyclos.model.banking.vouchers.VoucherStatus;
import org.cyclos.model.banking.vouchers.VoucherTransactionData;
import org.cyclos.model.banking.vouchers.VoucherTransactionDataParams;
import org.cyclos.model.banking.vouchers.VoucherTransactionNature;
import org.cyclos.model.banking.vouchers.VoucherTransactionPreviewVO;
import org.cyclos.model.banking.vouchers.VoucherTransactionResultVO;
import org.cyclos.model.banking.vouchers.VoucherTransactionVO;
import org.cyclos.model.banking.vouchers.VoucherTransactionsQuery;
import org.cyclos.model.banking.vouchers.VoucherTransactionsSearchData;
import org.cyclos.model.banking.vouchers.VoucherVO;
import org.cyclos.model.banking.vouchertypes.VoucherGiftOption;
import org.cyclos.model.banking.vouchertypes.VoucherTypeDetailedVO;
import org.cyclos.model.banking.vouchertypes.VoucherTypeVO;
import org.cyclos.model.system.fields.CustomFieldDetailedVO;
import org.cyclos.model.users.groups.BasicGroupVO;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.users.users.UserVO;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.server.utils.ClassHelper;
import org.cyclos.services.banking.VoucherService;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.DateTime;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.StringHelper;
import org.cyclos.web.rest.helpers.AccountsApiHelper;
import org.cyclos.web.rest.helpers.ApiHelper;
import org.cyclos.web.rest.helpers.AuthApiHelper;
import org.cyclos.web.rest.helpers.GroupsApiHelper;
import org.cyclos.web.rest.helpers.ImagesApiHelper;
import org.cyclos.web.rest.helpers.PaymentsApiHelper;
import org.cyclos.web.rest.helpers.PhonesApiHelper;
import org.cyclos.web.rest.helpers.TransactionsApiHelper;
import org.cyclos.web.rest.helpers.UsersApiHelper;
import org.cyclos.web.rest.model.AssignVoucher;
import org.cyclos.web.rest.model.BaseVoucherBuyingPreview;
import org.cyclos.web.rest.model.BaseVouchersQueryFilters;
import org.cyclos.web.rest.model.BuyVoucher;
import org.cyclos.web.rest.model.ChangeVoucherExpirationDate;
import org.cyclos.web.rest.model.ChangeVoucherNotificationSettings;
import org.cyclos.web.rest.model.ChangeVoucherPin;
import org.cyclos.web.rest.model.GeneralVouchersDataForSearch;
import org.cyclos.web.rest.model.GenerateVoucher;
import org.cyclos.web.rest.model.ImageSizeEnum;
import org.cyclos.web.rest.model.PerformVoucherTransaction;
import org.cyclos.web.rest.model.RedeemVoucher;
import org.cyclos.web.rest.model.SendVoucher;
import org.cyclos.web.rest.model.SimpleChangeVoucherPin;
import org.cyclos.web.rest.model.TopUpVoucher;
import org.cyclos.web.rest.model.UserVoucherTransactionsDataForSearch;
import org.cyclos.web.rest.model.UserVoucherTransactionsQueryFilters;
import org.cyclos.web.rest.model.UserVouchersDataForSearch;
import org.cyclos.web.rest.model.UserVouchersQueryFilters;
import org.cyclos.web.rest.model.Voucher;
import org.cyclos.web.rest.model.VoucherBasicData;
import org.cyclos.web.rest.model.VoucherBasicDataForTransaction;
import org.cyclos.web.rest.model.VoucherBoughtResult;
import org.cyclos.web.rest.model.VoucherBuyingPreview;
import org.cyclos.web.rest.model.VoucherCancelActionEnum;
import org.cyclos.web.rest.model.VoucherCategory;
import org.cyclos.web.rest.model.VoucherConfiguration;
import org.cyclos.web.rest.model.VoucherCreateData;
import org.cyclos.web.rest.model.VoucherCreationTypeEnum;
import org.cyclos.web.rest.model.VoucherDataForBuy;
import org.cyclos.web.rest.model.VoucherDataForGenerate;
import org.cyclos.web.rest.model.VoucherDataForRedeem;
import org.cyclos.web.rest.model.VoucherDataForTopUp;
import org.cyclos.web.rest.model.VoucherGenerationAmountEnum;
import org.cyclos.web.rest.model.VoucherGenerationStatusEnum;
import org.cyclos.web.rest.model.VoucherGiftEnum;
import org.cyclos.web.rest.model.VoucherInitialDataForTransaction;
import org.cyclos.web.rest.model.VoucherOrderByEnum;
import org.cyclos.web.rest.model.VoucherPinOnActivationEnum;
import org.cyclos.web.rest.model.VoucherPinStatusForRedeemEnum;
import org.cyclos.web.rest.model.VoucherRedeemPreview;
import org.cyclos.web.rest.model.VoucherRedeemResult;
import org.cyclos.web.rest.model.VoucherRelationEnum;
import org.cyclos.web.rest.model.VoucherResult;
import org.cyclos.web.rest.model.VoucherSendingPreview;
import org.cyclos.web.rest.model.VoucherStatusEnum;
import org.cyclos.web.rest.model.VoucherTopUpPreview;
import org.cyclos.web.rest.model.VoucherTransaction;
import org.cyclos.web.rest.model.VoucherTransactionKind;
import org.cyclos.web.rest.model.VoucherTransactionPreview;
import org.cyclos.web.rest.model.VoucherTransactionResult;
import org.cyclos.web.rest.model.VoucherTransactionView;
import org.cyclos.web.rest.model.VoucherType;
import org.cyclos.web.rest.model.VoucherTypeDetailed;
import org.cyclos.web.rest.model.VoucherView;
import org.cyclos.web.rest.model.VouchersQueryFilters;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class VouchersApiHelper {
    @Autowired
    private ApiHelper apiHelper;
    @Autowired
    private UsersApiHelper usersApiHelper;
    @Autowired
    private VoucherService voucherService;
    @Autowired
    private TransactionsApiHelper transactionsApiHelper;
    @Autowired
    private AccountsApiHelper accountsApiHelper;
    @Autowired
    private AuthApiHelper authApiHelper;
    @Autowired
    private ImagesApiHelper imagesApiHelper;
    @Autowired
    private GroupsApiHelper groupsApiHelper;
    @Autowired
    private PhonesApiHelper phonesApiHelper;
    @Autowired
    private PaymentsApiHelper paymentsApiHelper;

    public Long ensureId(String string) {
        if (string == null) {
            return null;
        }
        Long l = this.apiHelper.fromId(string);
        if (l == null) {
            VoucherVO voucherVO = this.voucherService.loadByToken(ModelHelper.locatorText((String)string));
            l = voucherVO.getId();
        }
        return l;
    }

    public <DTO extends SimpleChangeVoucherPinDTO> DTO newSimpleChangeVoucherPinDTO(Class<DTO> clazz, SimpleChangeVoucherPin simpleChangeVoucherPin) {
        SimpleChangeVoucherPinDTO simpleChangeVoucherPinDTO = (SimpleChangeVoucherPinDTO)ClassHelper.instantiate(clazz);
        simpleChangeVoucherPinDTO.setNewPin(simpleChangeVoucherPin.getNewPin());
        simpleChangeVoucherPinDTO.setConfirmNewPin(Boolean.TRUE.equals(simpleChangeVoucherPin.getCheckPinConfirmation()) ? simpleChangeVoucherPin.getNewPinConfirmation() : simpleChangeVoucherPin.getNewPin());
        return (DTO)simpleChangeVoucherPinDTO;
    }

    public AssignVoucherDTO toAssignVoucherDTO(String string, AssignVoucher assignVoucher) {
        AssignVoucherDTO assignVoucherDTO = new AssignVoucherDTO();
        assignVoucherDTO.setVoucher((VoucherVO)ModelHelper.voFromString(VoucherVO.class, (String)string));
        assignVoucherDTO.setUser((UserLocatorVO)ModelHelper.voFromString(UserLocatorVO.class, (String)assignVoucher.getUser()));
        return assignVoucherDTO;
    }

    public BuyVouchersDTO toBuyVouchersDTO(String string, BuyVoucher buyVoucher, String string2) {
        BuyVouchersDTO buyVouchersDTO = new BuyVouchersDTO();
        buyVouchersDTO.setUser((UserLocatorVO)ModelHelper.voFromString(UserLocatorVO.class, (String)string));
        buyVouchersDTO.setType((VoucherTypeVO)ModelHelper.voFromString(VoucherTypeVO.class, (String)buyVoucher.getType()));
        buyVouchersDTO.setGift(Boolean.TRUE.equals(buyVoucher.getGift()));
        buyVouchersDTO.setCount((Integer)ObjectHelper.defaultValue((Object)buyVoucher.getCount(), (Object)1));
        buyVouchersDTO.setAmount(buyVoucher.getAmount());
        if (CollectionHelper.isNotEmpty(buyVoucher.getPaymentCustomValues())) {
            buyVouchersDTO.setPaymentCustomValues(this.apiHelper.toCustomFieldValuesDTO(buyVoucher.getPaymentCustomValues()));
        } else {
            buyVouchersDTO.setPaymentCustomValues(this.apiHelper.toCustomFieldValuesDTO(buyVoucher.getCustomValues()));
        }
        buyVouchersDTO.setConfirmationPassword(string2);
        buyVouchersDTO.setCustomValues(this.apiHelper.toCustomFieldValuesDTO(buyVoucher.getVoucherCustomValues()));
        return buyVouchersDTO;
    }

    public CancelVoucherDTO toCancelVoucherDTO(Long l, String string) {
        CancelVoucherDTO cancelVoucherDTO = new CancelVoucherDTO();
        cancelVoucherDTO.setVoucher(new VoucherVO(l));
        cancelVoucherDTO.setConfirmationPassword(string);
        return cancelVoucherDTO;
    }

    public ChangeVoucherExpirationDateDTO toChangeVoucherExpirationDateDTO(Long l, ChangeVoucherExpirationDate changeVoucherExpirationDate, String string) {
        ChangeVoucherExpirationDateDTO changeVoucherExpirationDateDTO = new ChangeVoucherExpirationDateDTO();
        changeVoucherExpirationDateDTO.setVoucher(new VoucherVO(l));
        changeVoucherExpirationDateDTO.setConfirmationPassword(string);
        changeVoucherExpirationDateDTO.setExpirationDateComments(changeVoucherExpirationDate.getComments());
        changeVoucherExpirationDateDTO.setNewExpirationDate(changeVoucherExpirationDate.getNewExpirationDate());
        return changeVoucherExpirationDateDTO;
    }

    public ChangeVoucherNotificationSettingsDTO toChangeVoucherNotificationSettingsDTO(String string, ChangeVoucherNotificationSettings changeVoucherNotificationSettings, String string2) {
        ChangeVoucherNotificationSettingsDTO changeVoucherNotificationSettingsDTO = new ChangeVoucherNotificationSettingsDTO();
        changeVoucherNotificationSettingsDTO.setVoucher((VoucherVO)ModelHelper.voFromString(VoucherVO.class, (String)string));
        changeVoucherNotificationSettingsDTO.setEmail(changeVoucherNotificationSettings.getEmail());
        changeVoucherNotificationSettingsDTO.setMobilePhone(changeVoucherNotificationSettings.getMobilePhone());
        changeVoucherNotificationSettingsDTO.setEnableNotifications(Boolean.TRUE.equals(changeVoucherNotificationSettings.getEnableNotifications()));
        changeVoucherNotificationSettingsDTO.setConfirmationPassword(string2);
        return changeVoucherNotificationSettingsDTO;
    }

    public ChangeVoucherPinDTO toChangeVoucherPinDTO(String string, ChangeVoucherPin changeVoucherPin, String string2) {
        ChangeVoucherPinDTO changeVoucherPinDTO = this.newSimpleChangeVoucherPinDTO(ChangeVoucherPinDTO.class, changeVoucherPin);
        changeVoucherPinDTO.setVoucher((VoucherVO)ModelHelper.voFromString(VoucherVO.class, (String)string));
        changeVoucherPinDTO.setOldPin(changeVoucherPin.getOldPin());
        changeVoucherPinDTO.setConfirmationPassword(string2);
        return changeVoucherPinDTO;
    }

    public CreateVoucherDataParams toCreateVoucherDataParams(String string, String string2) {
        CreateVoucherDataParams createVoucherDataParams = new CreateVoucherDataParams();
        createVoucherDataParams.setUser((UserLocatorVO)ModelHelper.voFromString(UserLocatorVO.class, (String)string));
        createVoucherDataParams.setType((VoucherTypeVO)ModelHelper.voFromString(VoucherTypeVO.class, (String)string2));
        return createVoucherDataParams;
    }

    public GeneralVouchersDataForSearch toGeneralVouchersDataForSearch(GeneralVouchersSearchData generalVouchersSearchData) {
        GeneralVouchersDataForSearch generalVouchersDataForSearch = new GeneralVouchersDataForSearch();
        generalVouchersDataForSearch.setTopUpEnabled(generalVouchersSearchData.isVoucherTopUpEnabled());
        generalVouchersDataForSearch.setCanGenerate(generalVouchersSearchData.isCanGenerate());
        generalVouchersDataForSearch.setMask(generalVouchersSearchData.getMask());
        CollectionHelper.orEmpty((List)generalVouchersSearchData.getTypes()).stream().map(this::toVoucherType).forEach(generalVouchersDataForSearch.getTypes()::add);
        CollectionHelper.orEmpty((List)generalVouchersSearchData.getUserGroups()).stream().map(this.groupsApiHelper::toGroup).forEach(generalVouchersDataForSearch.getUserGroups()::add);
        CollectionHelper.orEmpty((List)generalVouchersSearchData.getExportFormats()).stream().map(this.apiHelper::toExportFormat).forEach(generalVouchersDataForSearch.getExportFormats()::add);
        generalVouchersSearchData.getFieldsForSearch().stream().map(ConfigurationEntityVO::getInternalName).forEach(generalVouchersDataForSearch.getFieldsInBasicSearch()::add);
        generalVouchersSearchData.getFieldsForSearch().stream().map(this.apiHelper::toCustomFieldDetailed).forEach(generalVouchersDataForSearch.getCustomFields()::add);
        generalVouchersDataForSearch.setQuery(this.toVoucherQueryFilters((GeneralVoucherQuery)generalVouchersSearchData.getQuery()));
        return generalVouchersDataForSearch;
    }

    public GenerateVoucher toGenerateVoucher(GenerateVouchersDTO generateVouchersDTO) {
        GenerateVoucher generateVoucher = new GenerateVoucher();
        generateVoucher.setUser(ModelHelper.stringOrIdFromVO((EntityVO)generateVouchersDTO.getOwner()));
        generateVoucher.setType(ModelHelper.stringOrIdFromVO((EntityVO)generateVouchersDTO.getType()));
        generateVoucher.setCount((Integer)ObjectHelper.defaultValue((Object)generateVouchersDTO.getCount(), (Object)1));
        generateVoucher.setAmount(generateVouchersDTO.getAmount());
        return generateVoucher;
    }

    public GenerateVouchersDTO toGenerateVouchersDTO(GenerateVoucher generateVoucher, String string) {
        GenerateVouchersDTO generateVouchersDTO = new GenerateVouchersDTO();
        generateVouchersDTO.setOwner((UserVO)ModelHelper.voFromString(UserLocatorVO.class, (String)generateVoucher.getUser()));
        generateVouchersDTO.setType((VoucherTypeVO)ModelHelper.voFromString(VoucherTypeVO.class, (String)generateVoucher.getType()));
        generateVouchersDTO.setCount((Integer)ObjectHelper.defaultValue((Object)generateVoucher.getCount(), (Object)1));
        generateVouchersDTO.setAmount(generateVoucher.getAmount());
        generateVouchersDTO.setConfirmationPassword(string);
        generateVouchersDTO.setCustomValues(this.apiHelper.toCustomFieldValuesDTO(generateVoucher.getVoucherCustomValues()));
        return generateVouchersDTO;
    }

    public RedeemVoucherDTO toRedeemVoucherDTO(String string, String string2, RedeemVoucher redeemVoucher) {
        RedeemVoucherDTO redeemVoucherDTO = new RedeemVoucherDTO();
        redeemVoucherDTO.setUser((UserLocatorVO)ModelHelper.voFromString(UserLocatorVO.class, (String)string));
        redeemVoucherDTO.setToken(string2);
        if (redeemVoucher != null) {
            redeemVoucherDTO.setAmount(redeemVoucher.getAmount());
            redeemVoucherDTO.setPin(redeemVoucher.getPin());
            redeemVoucherDTO.setPaymentCustomValues(this.apiHelper.toCustomFieldValuesDTO(redeemVoucher.getPaymentCustomValues()));
        }
        return redeemVoucherDTO;
    }

    public SendVoucherDTO toSendVoucherDTO(String string, SendVoucher sendVoucher, String string2) {
        SendVoucherDTO sendVoucherDTO = new SendVoucherDTO();
        sendVoucherDTO.setEmail(sendVoucher.getEmail());
        sendVoucherDTO.setMessage(sendVoucher.getMessage());
        sendVoucherDTO.setAmount(sendVoucher.getAmount());
        sendVoucherDTO.setCount(Integer.valueOf(1));
        sendVoucherDTO.setType((VoucherTypeVO)ModelHelper.voFromString(VoucherTypeVO.class, (String)sendVoucher.getType()));
        sendVoucherDTO.setUser((UserLocatorVO)ModelHelper.voFromString(UserLocatorVO.class, (String)string));
        sendVoucherDTO.setConfirmationPassword(string2);
        if (CollectionHelper.isNotEmpty(sendVoucher.getPaymentCustomValues())) {
            sendVoucherDTO.setPaymentCustomValues(this.apiHelper.toCustomFieldValuesDTO(sendVoucher.getPaymentCustomValues()));
        }
        sendVoucherDTO.setCustomValues(this.apiHelper.toCustomFieldValuesDTO(sendVoucher.getVoucherCustomValues()));
        return sendVoucherDTO;
    }

    public TopUpVoucherDTO toTopUpVoucherDTO(String string, String string2, String string3, TopUpVoucher topUpVoucher) {
        TopUpVoucherDTO topUpVoucherDTO = new TopUpVoucherDTO();
        topUpVoucherDTO.setUser((UserLocatorVO)ModelHelper.voFromString(UserLocatorVO.class, (String)string));
        topUpVoucherDTO.setToken(string2);
        topUpVoucherDTO.setConfirmationPassword(string3);
        if (topUpVoucher != null) {
            topUpVoucherDTO.setAmount(topUpVoucher.getAmount());
            topUpVoucherDTO.setEmail(topUpVoucher.getEmail());
            topUpVoucherDTO.setMobilePhone(topUpVoucher.getMobilePhone());
            topUpVoucherDTO.setPin(topUpVoucher.getPin());
            if (Boolean.TRUE.equals(topUpVoucher.getCheckPinConfirmation())) {
                topUpVoucherDTO.setPinConfirmation(topUpVoucher.getPinConfirmation());
            } else {
                topUpVoucherDTO.setPinConfirmation(topUpVoucher.getPin());
            }
            topUpVoucherDTO.setPaymentCustomValues(this.apiHelper.toCustomFieldValuesDTO(topUpVoucher.getPaymentCustomValues()));
        }
        topUpVoucherDTO.setCustomValues(this.apiHelper.toCustomFieldValuesDTO(topUpVoucher.getVoucherCustomValues()));
        return topUpVoucherDTO;
    }

    public UserVoucherQuery toUserVoucherQuery(String string, UserVouchersQueryFilters userVouchersQueryFilters) {
        UserVoucherQuery userVoucherQuery = this.newBasicVoucherQuery(UserVoucherQuery.class, userVouchersQueryFilters);
        userVoucherQuery.setUser((UserLocatorVO)ModelHelper.voFromString(UserLocatorVO.class, (String)string));
        return userVoucherQuery;
    }

    public UserVouchersQueryFilters toUserVoucherQueryFilters(VoucherRelationEnum voucherRelationEnum, GeneralVoucherQuery generalVoucherQuery) {
        UserVouchersQueryFilters userVouchersQueryFilters = this.newBaseVouchersQueryFilters(UserVouchersQueryFilters.class, (BasicVoucherQuery)generalVoucherQuery);
        userVouchersQueryFilters.setRelation(voucherRelationEnum);
        userVouchersQueryFilters.setRedeemBy(ModelHelper.stringOrIdFromVO((EntityVO)generalVoucherQuery.getTransactionBy()));
        userVouchersQueryFilters.setRedeemPeriod(this.apiHelper.toFilter(generalVoucherQuery.getTransactionPeriod()));
        return userVouchersQueryFilters;
    }

    public UserVouchersDataForSearch toUserVouchersDataForSearch(UserVouchersSearchData userVouchersSearchData) {
        UserVouchersDataForSearch userVouchersDataForSearch = new UserVouchersDataForSearch();
        userVouchersDataForSearch.setUser(this.usersApiHelper.toUser((BasicUserVO)userVouchersSearchData.getUser()));
        userVouchersDataForSearch.setCanBuy(userVouchersSearchData.isCanBuy());
        userVouchersDataForSearch.setCanSend(userVouchersSearchData.isCanSend());
        userVouchersDataForSearch.setCanSendImport(userVouchersSearchData.isCanSendImport());
        userVouchersDataForSearch.setMask(userVouchersSearchData.getMask());
        CollectionHelper.orEmpty((List)userVouchersSearchData.getTypes()).stream().map(this::toVoucherType).forEach(userVouchersDataForSearch.getTypes()::add);
        userVouchersDataForSearch.setOperators(null);
        userVouchersDataForSearch.setQuery(this.toUserVoucherQueryFilters((UserVoucherQuery)userVouchersSearchData.getQuery()));
        CollectionHelper.orEmpty((List)userVouchersSearchData.getExportFormats()).stream().map(this.apiHelper::toExportFormat).forEach(userVouchersDataForSearch.getExportFormats()::add);
        return userVouchersDataForSearch;
    }

    public UserVouchersDataForSearch toUserVouchersDataForSearch(VoucherTransactionsSearchData voucherTransactionsSearchData) {
        UserVouchersDataForSearch userVouchersDataForSearch = new UserVouchersDataForSearch();
        userVouchersDataForSearch.setUser(this.usersApiHelper.toUser((BasicUserVO)voucherTransactionsSearchData.getUser()));
        userVouchersDataForSearch.setCanRedeem(voucherTransactionsSearchData.isCanRedeem());
        CollectionHelper.orEmpty((List)voucherTransactionsSearchData.getTypes()).stream().map(this::toVoucherType).forEach(userVouchersDataForSearch.getTypes()::add);
        CollectionHelper.orEmpty((List)voucherTransactionsSearchData.getOperators()).stream().map(this.usersApiHelper::toUser).forEach(userVouchersDataForSearch.getOperators()::add);
        userVouchersDataForSearch.setQuery(this.toUserVoucherQueryFilters((VoucherTransactionsQuery)voucherTransactionsSearchData.getQuery()));
        return userVouchersDataForSearch;
    }

    public UserVoucherTransactionsDataForSearch toUserVoucherTransactionsDataForSearch(VoucherTransactionsSearchData voucherTransactionsSearchData) {
        UserVoucherTransactionsDataForSearch userVoucherTransactionsDataForSearch = new UserVoucherTransactionsDataForSearch();
        userVoucherTransactionsDataForSearch.setUser(this.usersApiHelper.toUser((BasicUserVO)voucherTransactionsSearchData.getUser()));
        userVoucherTransactionsDataForSearch.setCanRedeem(voucherTransactionsSearchData.isCanRedeem());
        userVoucherTransactionsDataForSearch.setCanTopUp(voucherTransactionsSearchData.isCanTopUp());
        CollectionHelper.orEmpty((List)voucherTransactionsSearchData.getTypes()).stream().map(this::toVoucherType).forEach(userVoucherTransactionsDataForSearch.getTypes()::add);
        CollectionHelper.orEmpty((List)voucherTransactionsSearchData.getOperators()).stream().map(this.usersApiHelper::toUser).forEach(userVoucherTransactionsDataForSearch.getOperators()::add);
        userVoucherTransactionsDataForSearch.setQuery(this.toUserVoucherTransactionsQueryFilters((VoucherTransactionsQuery)voucherTransactionsSearchData.getQuery()));
        userVoucherTransactionsDataForSearch.setTopUpEnabled(voucherTransactionsSearchData.isVoucherTopUpEnabled());
        return userVoucherTransactionsDataForSearch;
    }

    public Voucher toVoucher(VoucherVO voucherVO) {
        if (voucherVO == null) {
            return null;
        }
        return this.newVoucher(Voucher.class, voucherVO);
    }

    public VoucherBarcodeParams toVoucherBarcodeParams(String string, ImageSizeEnum imageSizeEnum) {
        VoucherBarcodeParams voucherBarcodeParams = new VoucherBarcodeParams();
        voucherBarcodeParams.setVoucher((VoucherVO)ModelHelper.voFromString(VoucherVO.class, (String)string));
        voucherBarcodeParams.setSize(this.apiHelper.toImageSize(imageSizeEnum));
        return voucherBarcodeParams;
    }

    public VoucherBoughtResult toVoucherBoughtResult(VoucherPackWithIdsVO voucherPackWithIdsVO) {
        if (voucherPackWithIdsVO == null) {
            return null;
        }
        VoucherBoughtResult voucherBoughtResult = new VoucherBoughtResult();
        voucherBoughtResult.setVouchers(CollectionHelper.orEmpty((Set)voucherPackWithIdsVO.getVoucherIds()).stream().map(ApiHelper::toId).collect(Collectors.toList()));
        voucherBoughtResult.setVoucherStatus(this.toVoucherStatusEnum(voucherPackWithIdsVO.getVoucherStatus()));
        return voucherBoughtResult;
    }

    public VoucherBuyingPreview toVoucherBuyingPreview(BuyVoucherPreviewVO buyVoucherPreviewVO) {
        VoucherBuyingPreview voucherBuyingPreview = this.newBaseVoucherBuyingPreview(VoucherBuyingPreview.class, buyVoucherPreviewVO);
        voucherBuyingPreview.setTotalAmount(buyVoucherPreviewVO.getTotalAmount());
        voucherBuyingPreview.setBuyVoucher(this.toBuyVoucher((BuyVouchersDTO)buyVoucherPreviewVO.getParams()));
        return voucherBuyingPreview;
    }

    public VoucherCancelActionEnum toVoucherCancelActionEnum(VoucherCancelAction voucherCancelAction) {
        if (voucherCancelAction != null) {
            switch (voucherCancelAction) {
                case CANCEL_AND_REFUND: {
                    return VoucherCancelActionEnum.CANCEL_AND_REFUND;
                }
                case CANCEL_GENERATED: {
                    return VoucherCancelActionEnum.CANCEL_GENERATED;
                }
                case CANCEL_PENDING_PACK: {
                    return VoucherCancelActionEnum.CANCEL_PENDING_PACK;
                }
                case CANCEL_PENDING_SINGLE: {
                    return VoucherCancelActionEnum.CANCEL_PENDING_SINGLE;
                }
                case CANCEL_AND_CHARGEBACK: {
                    return VoucherCancelActionEnum.CANCEL_AND_CHARGEBACK;
                }
            }
        }
        return null;
    }

    public VoucherCategory toVoucherCategory(VoucherCategoryVO voucherCategoryVO) {
        if (voucherCategoryVO == null) {
            return null;
        }
        VoucherCategory voucherCategory = this.apiHelper.newEntity(VoucherCategory.class, voucherCategoryVO);
        voucherCategory.setImage(this.imagesApiHelper.toImage(voucherCategoryVO.getImage()));
        return voucherCategory;
    }

    public VoucherConfiguration toVoucherConfiguration(VoucherConfigurationVO voucherConfigurationVO) {
        if (voucherConfigurationVO == null) {
            return null;
        }
        VoucherConfiguration voucherConfiguration = this.apiHelper.newEntity(VoucherConfiguration.class, voucherConfigurationVO);
        voucherConfiguration.setCurrency(this.accountsApiHelper.toCurrency(voucherConfigurationVO.getCurrency()));
        return voucherConfiguration;
    }

    public VoucherCreationType toVoucherCreationType(VoucherCreationTypeEnum voucherCreationTypeEnum) {
        if (voucherCreationTypeEnum != null) {
            switch (voucherCreationTypeEnum) {
                case GENERATED: {
                    return VoucherCreationType.GENERATED;
                }
                case BOUGHT: {
                    return VoucherCreationType.BOUGHT;
                }
                case SENT: {
                    return VoucherCreationType.SENT;
                }
            }
        }
        return null;
    }

    public VoucherCreationTypeEnum toVoucherCreationTypeEnum(VoucherCreationType voucherCreationType) {
        if (voucherCreationType != null) {
            switch (voucherCreationType) {
                case GENERATED: {
                    return VoucherCreationTypeEnum.GENERATED;
                }
                case BOUGHT: {
                    return VoucherCreationTypeEnum.BOUGHT;
                }
                case SENT: {
                    return VoucherCreationTypeEnum.SENT;
                }
            }
        }
        return null;
    }

    public VoucherDataForBuy toVoucherDataForBuy(BuyVoucherData buyVoucherData) {
        VoucherDataForBuy voucherDataForBuy;
        if (buyVoucherData.getType() != null) {
            voucherDataForBuy = this.newVoucherCreateData(VoucherDataForBuy.class, (BasicCreateVoucherData)buyVoucherData, buyVoucherData.getPaymentCustomFields());
            voucherDataForBuy.setAccount(this.accountsApiHelper.toAccountWithStatus((AccountVO)buyVoucherData.getAccount()));
            voucherDataForBuy.setFixedAmount(buyVoucherData.getFixedAmount());
            voucherDataForBuy.setAmountRange(this.apiHelper.toDecimalRange(buyVoucherData.getAmountRange()));
            voucherDataForBuy.setMinimumTimeToRedeem(this.apiHelper.toTimeInterval(buyVoucherData.getMinimumTimeToRedeem()));
            voucherDataForBuy.setCanBuyMultiple(buyVoucherData.isCanBuyMultiple());
            voucherDataForBuy.setTypes(null);
            CollectionHelper.orEmpty((List)buyVoucherData.getCustomFields()).stream().map(this.apiHelper::toCustomFieldDetailed).forEach(voucherDataForBuy.getVoucherCustomFields()::add);
            voucherDataForBuy.setConfirmationPasswordInput(this.authApiHelper.toPasswordInput((ICredentialInputDTO)buyVoucherData.getConfirmationPasswordInput()));
        } else {
            voucherDataForBuy = new VoucherDataForBuy();
            CollectionHelper.orEmpty((List)buyVoucherData.getCategories()).stream().map(this::toVoucherCategory).forEach(voucherDataForBuy.getCategories()::add);
            CollectionHelper.orEmpty((List)buyVoucherData.getTypes()).stream().map(this::toVoucherTypeDetailed).forEach(voucherDataForBuy.getTypes()::add);
        }
        voucherDataForBuy.setUser(this.usersApiHelper.toUser((BasicUserVO)buyVoucherData.getUser()));
        return voucherDataForBuy;
    }

    public VoucherDataForGenerate toVoucherDataForGenerate(GenerateVouchersData generateVouchersData) {
        VoucherDataForGenerate voucherDataForGenerate;
        if (generateVouchersData.getType() != null) {
            voucherDataForGenerate = this.newVoucherCreateData(VoucherDataForGenerate.class, (BasicCreateVoucherData)generateVouchersData, null);
            voucherDataForGenerate.setConfirmationPasswordInput(this.authApiHelper.toPasswordInput((ICredentialInputDTO)generateVouchersData.getConfirmationPasswordInput()));
            voucherDataForGenerate.setGenerateVoucher(this.toGenerateVoucher(generateVouchersData.getDto()));
            voucherDataForGenerate.setGenerationAmount(this.toVoucherGenerationAmountEnum(generateVouchersData.getGenerationAmount()));
            voucherDataForGenerate.setGenerationStatus(this.toVoucherGenerationStatusEnum(generateVouchersData.getGenerationStatus()));
            voucherDataForGenerate.setTypes(null);
            CollectionHelper.orEmpty((List)generateVouchersData.getCustomFields()).stream().map(this.apiHelper::toCustomFieldDetailed).forEach(voucherDataForGenerate.getVoucherCustomFields()::add);
        } else {
            voucherDataForGenerate = new VoucherDataForGenerate();
            CollectionHelper.orEmpty((List)generateVouchersData.getCategories()).stream().map(this::toVoucherCategory).forEach(voucherDataForGenerate.getCategories()::add);
            CollectionHelper.orEmpty((List)generateVouchersData.getTypes()).stream().map(this::toVoucherTypeDetailed).forEach(voucherDataForGenerate.getTypes()::add);
        }
        voucherDataForGenerate.setUser(this.usersApiHelper.toUser((BasicUserVO)generateVouchersData.getUser()));
        return voucherDataForGenerate;
    }

    public VoucherDataForRedeem toVoucherDataForRedeem(RedeemVoucherData redeemVoucherData) {
        VoucherDataForRedeem voucherDataForRedeem = this.newVoucherDataForTransaction(VoucherDataForRedeem.class, (PerformVoucherTransactionData)redeemVoucherData);
        voucherDataForRedeem.setKind(VoucherTransactionKind.REDEEM);
        voucherDataForRedeem.setBalance(redeemVoucherData.getBalance());
        voucherDataForRedeem.setPinInput(this.authApiHelper.toPasswordInput((ICredentialInputDTO)redeemVoucherData.getPinInput()));
        voucherDataForRedeem.setBuyer(this.usersApiHelper.toUser((BasicUserVO)redeemVoucherData.getBuyer()));
        voucherDataForRedeem.setCanSendPin(redeemVoucherData.isCanSendPin());
        return voucherDataForRedeem;
    }

    public VoucherDataForTopUp toVoucherDataForTopUp(TopUpVoucherData topUpVoucherData) {
        VoucherDataForTopUp voucherDataForTopUp = this.newVoucherDataForTransaction(VoucherDataForTopUp.class, (PerformVoucherTransactionData)topUpVoucherData);
        voucherDataForTopUp.setKind(VoucherTransactionKind.TOP_UP);
        voucherDataForTopUp.setConfirmationPasswordInput(this.authApiHelper.toPasswordInput((ICredentialInputDTO)topUpVoucherData.getConfirmationPasswordInput()));
        voucherDataForTopUp.setIsActivation(topUpVoucherData.isIsActivation());
        voucherDataForTopUp.setGenerationAmount(this.toVoucherGenerationAmountEnum(topUpVoucherData.getGenerationAmount()));
        voucherDataForTopUp.setPinOnActivation(this.toVoucherPinOnActivationEnum(topUpVoucherData.getPinOnActivation()));
        voucherDataForTopUp.setPhoneConfiguration(this.phonesApiHelper.toPhoneConfiguration(topUpVoucherData.getPhoneConfiguration()));
        voucherDataForTopUp.setPinInput(this.authApiHelper.toPasswordInput((ICredentialInputDTO)topUpVoucherData.getPinInput()));
        voucherDataForTopUp.setEmailInput(this.apiHelper.toAvailabilityEnum(topUpVoucherData.getEmailInput()));
        CollectionHelper.orEmpty((List)topUpVoucherData.getVoucherCustomFields()).stream().map(this.apiHelper::toCustomFieldDetailed).forEach(voucherDataForTopUp.getVoucherCustomFields()::add);
        return voucherDataForTopUp;
    }

    public VoucherInitialDataForTransaction toVoucherInitialDataForTransaction(InitialVoucherUserData initialVoucherUserData) {
        if (initialVoucherUserData == null) {
            return null;
        }
        VoucherInitialDataForTransaction voucherInitialDataForTransaction = new VoucherInitialDataForTransaction();
        voucherInitialDataForTransaction.setUser(this.usersApiHelper.toUser((BasicUserVO)initialVoucherUserData.getUser()));
        voucherInitialDataForTransaction.setMask(initialVoucherUserData.getMask());
        return voucherInitialDataForTransaction;
    }

    public VoucherOrderBy toVoucherOrderBy(VoucherOrderByEnum voucherOrderByEnum) {
        if (voucherOrderByEnum != null) {
            switch (voucherOrderByEnum) {
                case CREATION_DATE_ASC: {
                    return VoucherOrderBy.CREATION_DATE_ASC;
                }
                case CREATION_DATE_DESC: {
                    return VoucherOrderBy.CREATION_DATE_DESC;
                }
                case EXPIRATION_DATE_ASC: {
                    return VoucherOrderBy.EXPIRATION_DATE_ASC;
                }
                case EXPIRATION_DATE_DESC: {
                    return VoucherOrderBy.EXPIRATION_DATE_DESC;
                }
                case REDEEM_DATE_ASC: {
                    return VoucherOrderBy.CREATION_DATE_ASC;
                }
                case REDEEM_DATE_DESC: {
                    return VoucherOrderBy.CREATION_DATE_ASC;
                }
            }
        }
        return null;
    }

    public VoucherOrderByEnum toVoucherOrderByEnum(VoucherOrderBy voucherOrderBy) {
        if (voucherOrderBy != null) {
            switch (voucherOrderBy) {
                case CREATION_DATE_ASC: {
                    return VoucherOrderByEnum.CREATION_DATE_ASC;
                }
                case CREATION_DATE_DESC: {
                    return VoucherOrderByEnum.CREATION_DATE_DESC;
                }
                case EXPIRATION_DATE_ASC: {
                    return VoucherOrderByEnum.EXPIRATION_DATE_ASC;
                }
                case EXPIRATION_DATE_DESC: {
                    return VoucherOrderByEnum.EXPIRATION_DATE_DESC;
                }
            }
        }
        return null;
    }

    public GeneralVoucherQuery toVoucherQuery(VouchersQueryFilters vouchersQueryFilters) {
        GeneralVoucherQuery generalVoucherQuery = this.newBasicVoucherQuery(GeneralVoucherQuery.class, vouchersQueryFilters);
        generalVoucherQuery.setBuyer((UserVO)ModelHelper.voFromString(UserVO.class, (String)vouchersQueryFilters.getBuyer()));
        generalVoucherQuery.setEmail(vouchersQueryFilters.getEmail());
        generalVoucherQuery.setMobilePhone(vouchersQueryFilters.getMobilePhone());
        generalVoucherQuery.setBuyerGroups(ModelHelper.vosFromString(BasicGroupVO.class, vouchersQueryFilters.getBuyerGroups()));
        generalVoucherQuery.setPrinted(vouchersQueryFilters.getPrinted());
        generalVoucherQuery.setTransactionUserGroups(ModelHelper.vosFromString(BasicGroupVO.class, vouchersQueryFilters.getTransactionUserGroups()));
        generalVoucherQuery.setTransactionUser((UserVO)ModelHelper.voFromString(UserVO.class, (String)vouchersQueryFilters.getTransactionUser()));
        generalVoucherQuery.setTransactionPeriod(this.apiHelper.toDatePeriodDTO(vouchersQueryFilters.getTransactionPeriod()));
        generalVoucherQuery.setCustomValues(this.apiHelper.toCustomFieldValuesForSearch(vouchersQueryFilters.getCustomFields()));
        if (CollectionHelper.isNotEmpty(vouchersQueryFilters.getRedeemerGroups())) {
            generalVoucherQuery.setTransactionUserGroups(ModelHelper.vosFromString(BasicGroupVO.class, vouchersQueryFilters.getRedeemerGroups()));
        }
        if (StringHelper.isNotBlank((Object)vouchersQueryFilters.getRedeemer())) {
            generalVoucherQuery.setTransactionUser((UserVO)ModelHelper.voFromString(UserVO.class, (String)vouchersQueryFilters.getRedeemer()));
        }
        if (StringHelper.isNotBlank(vouchersQueryFilters.getRedeemPeriod())) {
            generalVoucherQuery.setTransactionPeriod(this.apiHelper.toDatePeriodDTO(vouchersQueryFilters.getRedeemPeriod()));
        }
        return generalVoucherQuery;
    }

    public VouchersQueryFilters toVoucherQueryFilters(GeneralVoucherQuery generalVoucherQuery) {
        VouchersQueryFilters vouchersQueryFilters = this.newBaseVouchersQueryFilters(VouchersQueryFilters.class, (BasicVoucherQuery)generalVoucherQuery);
        vouchersQueryFilters.setEmail(generalVoucherQuery.getEmail());
        vouchersQueryFilters.setMobilePhone(generalVoucherQuery.getMobilePhone());
        vouchersQueryFilters.setPrinted(generalVoucherQuery.getPrinted());
        vouchersQueryFilters.setBuyer(ModelHelper.stringOrIdFromVO((EntityVO)generalVoucherQuery.getBuyer()));
        CollectionHelper.orEmpty((Set)generalVoucherQuery.getTransactionUserGroups()).stream().map(ModelHelper::stringOrIdFromVO).forEach(vouchersQueryFilters.getTransactionUserGroups()::add);
        vouchersQueryFilters.setTransactionUser(ModelHelper.stringOrIdFromVO((EntityVO)generalVoucherQuery.getTransactionUser()));
        vouchersQueryFilters.setTransactionPeriod(this.apiHelper.toFilter(generalVoucherQuery.getTransactionPeriod()));
        CollectionHelper.orEmpty((Set)generalVoucherQuery.getBuyerGroups()).stream().map(ModelHelper::stringOrIdFromVO).forEach(vouchersQueryFilters.getBuyerGroups()::add);
        vouchersQueryFilters.setCustomFields(this.apiHelper.toFilters(generalVoucherQuery.getCustomValues()));
        vouchersQueryFilters.setRedeemer(vouchersQueryFilters.getTransactionUser());
        vouchersQueryFilters.setRedeemerGroups(vouchersQueryFilters.getTransactionUserGroups());
        vouchersQueryFilters.setRedeemPeriod(this.apiHelper.toFilter(generalVoucherQuery.getTransactionPeriod()));
        return vouchersQueryFilters;
    }

    public VoucherRedeemPreview toVoucherRedeemPreview(RedeemVoucherPreviewVO redeemVoucherPreviewVO) {
        VoucherRedeemPreview voucherRedeemPreview = this.newVoucherTransactionPreview(VoucherRedeemPreview.class, (VoucherTransactionPreviewVO)redeemVoucherPreviewVO, (PerformVoucherTransactionDTO)redeemVoucherPreviewVO.getRedeem());
        voucherRedeemPreview.setKind(VoucherTransactionKind.REDEEM);
        voucherRedeemPreview.setPinInput(this.authApiHelper.toPasswordInput((ICredentialInputDTO)redeemVoucherPreviewVO.getPinInput()));
        voucherRedeemPreview.setRedeem(this.toRedeemVoucher(redeemVoucherPreviewVO.getRedeem()));
        voucherRedeemPreview.setCanSendPin(redeemVoucherPreviewVO.isCanSendPin());
        return voucherRedeemPreview;
    }

    public VoucherRedeemResult toVoucherRedeemResult(VoucherTransactionResultVO voucherTransactionResultVO) {
        VoucherRedeemResult voucherRedeemResult = this.newVoucherTransactionResult(VoucherRedeemResult.class, voucherTransactionResultVO);
        if (voucherRedeemResult.getPayment() != null) {
            voucherRedeemResult.setPaymentId(voucherRedeemResult.getPayment().getId());
        }
        return voucherRedeemResult;
    }

    public VoucherResult toVoucherResult(VoucherVO voucherVO, VoucherRelationEnum voucherRelationEnum) {
        if (voucherVO == null) {
            return null;
        }
        return this.newVoucherResult(VoucherResult.class, voucherVO, voucherRelationEnum);
    }

    public VoucherSendingPreview toVoucherSendingPreview(BuyVoucherPreviewVO buyVoucherPreviewVO) {
        VoucherSendingPreview voucherSendingPreview = this.newBaseVoucherBuyingPreview(VoucherSendingPreview.class, buyVoucherPreviewVO);
        voucherSendingPreview.setOwner(this.usersApiHelper.toUser((BasicUserVO)buyVoucherPreviewVO.getOwner()));
        voucherSendingPreview.setSendVoucher(this.toSendVoucher((SendVoucherDTO)buyVoucherPreviewVO.getParams()));
        return voucherSendingPreview;
    }

    public VoucherStatus toVoucherStatus(VoucherStatusEnum voucherStatusEnum) {
        if (voucherStatusEnum != null) {
            switch (voucherStatusEnum) {
                case ACTIVATION_EXPIRED: {
                    return VoucherStatus.ACTIVATION_EXPIRED;
                }
                case BLOCKED: {
                    return VoucherStatus.BLOCKED;
                }
                case CANCELED: {
                    return VoucherStatus.CANCELED;
                }
                case EXPIRED: {
                    return VoucherStatus.EXPIRED;
                }
                case OPEN: {
                    return VoucherStatus.OPEN;
                }
                case PENDING: {
                    return VoucherStatus.PENDING;
                }
                case REDEEMED: {
                    return VoucherStatus.REDEEMED;
                }
                case INACTIVE: {
                    return VoucherStatus.INACTIVE;
                }
            }
        }
        return null;
    }

    public VoucherStatusEnum toVoucherStatusEnum(VoucherStatus voucherStatus) {
        if (voucherStatus != null) {
            switch (voucherStatus) {
                case ACTIVATION_EXPIRED: {
                    return VoucherStatusEnum.ACTIVATION_EXPIRED;
                }
                case BLOCKED: {
                    return VoucherStatusEnum.BLOCKED;
                }
                case CANCELED: {
                    return VoucherStatusEnum.CANCELED;
                }
                case EXPIRED: {
                    return VoucherStatusEnum.EXPIRED;
                }
                case OPEN: {
                    return VoucherStatusEnum.OPEN;
                }
                case PENDING: {
                    return VoucherStatusEnum.PENDING;
                }
                case REDEEMED: {
                    return VoucherStatusEnum.REDEEMED;
                }
                case INACTIVE: {
                    return VoucherStatusEnum.INACTIVE;
                }
            }
        }
        return null;
    }

    public VoucherTopUpPreview toVoucherTopUpPreview(TopUpVoucherPreviewVO topUpVoucherPreviewVO) {
        TopUpVoucherDTO topUpVoucherDTO = topUpVoucherPreviewVO.getTopUp();
        VoucherTopUpPreview voucherTopUpPreview = this.newVoucherTransactionPreview(VoucherTopUpPreview.class, (VoucherTransactionPreviewVO)topUpVoucherPreviewVO, (PerformVoucherTransactionDTO)topUpVoucherDTO);
        voucherTopUpPreview.setKind(VoucherTransactionKind.TOP_UP);
        voucherTopUpPreview.setConfirmationPasswordInput(this.authApiHelper.toPasswordInput((ICredentialInputDTO)topUpVoucherPreviewVO.getConfirmationPasswordInput()));
        voucherTopUpPreview.setFormattedMobilePhone(topUpVoucherPreviewVO.getFormattedMobilePhone());
        voucherTopUpPreview.setOwner(this.usersApiHelper.toUser((BasicUserVO)topUpVoucherPreviewVO.getOwner()));
        voucherTopUpPreview.setTopUp(this.toTopUpVoucher(topUpVoucherDTO));
        voucherTopUpPreview.setVoucherCustomValues(this.apiHelper.toCustomFieldValuesList(topUpVoucherDTO.getCustomValues()));
        return voucherTopUpPreview;
    }

    public VoucherTransaction toVoucherTransaction(VoucherTransactionVO voucherTransactionVO) {
        if (voucherTransactionVO == null) {
            return null;
        }
        VoucherTransaction voucherTransaction = this.apiHelper.newEntity(VoucherTransaction.class, voucherTransactionVO);
        voucherTransaction.setUser(this.usersApiHelper.toUser((BasicUserVO)voucherTransactionVO.getUser()));
        voucherTransaction.setDate(voucherTransactionVO.getDate());
        voucherTransaction.setAmount(voucherTransactionVO.getAmount());
        voucherTransaction.setBy(this.usersApiHelper.toUser(voucherTransactionVO.getBy()));
        voucherTransaction.setPayment(this.transactionsApiHelper.toTransaction((TransactionVO)voucherTransactionVO.getTransaction()));
        return voucherTransaction;
    }

    public VoucherTransactionDataParams toVoucherTransactionDataParams(String string, String string2) {
        VoucherTransactionDataParams voucherTransactionDataParams = new VoucherTransactionDataParams();
        voucherTransactionDataParams.setUser((UserLocatorVO)ModelHelper.voFromString(UserLocatorVO.class, (String)string));
        voucherTransactionDataParams.setToken(string2);
        return voucherTransactionDataParams;
    }

    public VoucherTransactionResult toVoucherTransactionResult(VoucherTransactionResultVO voucherTransactionResultVO) {
        if (voucherTransactionResultVO == null) {
            return null;
        }
        return this.newVoucherTransactionResult(VoucherTransactionResult.class, voucherTransactionResultVO);
    }

    public VoucherTransactionsQuery toVoucherTransactionsQuery(String string2, UserVoucherTransactionsQueryFilters userVoucherTransactionsQueryFilters) {
        VoucherTransactionsQuery voucherTransactionsQuery = this.apiHelper.newQuery(VoucherTransactionsQuery.class, userVoucherTransactionsQueryFilters);
        voucherTransactionsQuery.setNatures(CollectionHelper.orEmpty(userVoucherTransactionsQueryFilters.getKinds()).stream().map(this::toVoucherTransactionNature).collect(Collectors.toSet()));
        if (userVoucherTransactionsQueryFilters.getKind() != null) {
            voucherTransactionsQuery.setNatures(EnumSet.of(this.toVoucherTransactionNature(userVoucherTransactionsQueryFilters.getKind())));
        }
        voucherTransactionsQuery.setUser((UserLocatorVO)ModelHelper.voFromString(UserLocatorVO.class, (String)string2));
        voucherTransactionsQuery.setBy((BasicUserVO)ModelHelper.voFromString(UserLocatorVO.class, (String)userVoucherTransactionsQueryFilters.getBy()));
        voucherTransactionsQuery.setAmountRange(this.apiHelper.toDecimalRangeDTO(userVoucherTransactionsQueryFilters.getAmountRange()));
        voucherTransactionsQuery.setDatePeriod(this.apiHelper.toDatePeriodDTO(userVoucherTransactionsQueryFilters.getDatePeriod()));
        voucherTransactionsQuery.setTypes(CollectionHelper.orEmpty(userVoucherTransactionsQueryFilters.getTypes()).stream().map(string -> (VoucherTypeVO)ModelHelper.voFromString(VoucherTypeVO.class, (String)string)).collect(Collectors.toSet()));
        return voucherTransactionsQuery;
    }

    public VoucherTransactionsQuery toVoucherTransactionsQueryDeprecated(String string2, UserVouchersQueryFilters userVouchersQueryFilters) {
        VoucherTransactionsQuery voucherTransactionsQuery = this.apiHelper.newQuery(VoucherTransactionsQuery.class, userVouchersQueryFilters);
        voucherTransactionsQuery.setUser((UserLocatorVO)ModelHelper.voFromString(UserLocatorVO.class, (String)string2));
        voucherTransactionsQuery.setAmountRange(this.apiHelper.toDecimalRangeDTO(userVouchersQueryFilters.getAmountRange()));
        voucherTransactionsQuery.setDatePeriod(this.apiHelper.toDatePeriodDTO(userVouchersQueryFilters.getRedeemPeriod()));
        voucherTransactionsQuery.setTypes(CollectionHelper.orEmpty(userVouchersQueryFilters.getTypes()).stream().map(string -> (VoucherTypeVO)ModelHelper.voFromString(VoucherTypeVO.class, (String)string)).collect(Collectors.toSet()));
        return voucherTransactionsQuery;
    }

    public VoucherTransactionView toVoucherTransactionView(VoucherTransactionData voucherTransactionData) {
        VoucherTransactionView voucherTransactionView = this.newVoucherTransactionResult(VoucherTransactionView.class, voucherTransactionData.getVoucherTransaction());
        voucherTransactionView.setChargebackOf(this.toVoucherTransaction(voucherTransactionData.getChargebackOf()));
        voucherTransactionView.setChargedBackBy(this.toVoucherTransaction(voucherTransactionData.getChargedBackBy()));
        CollectionHelper.orEmpty((List)voucherTransactionData.getExportFormats()).stream().map(this.apiHelper::toExportFormat).forEach(voucherTransactionView.getExportFormats()::add);
        return voucherTransactionView;
    }

    public VoucherType toVoucherType(VoucherTypeVO voucherTypeVO) {
        if (voucherTypeVO == null) {
            return null;
        }
        VoucherType voucherType = this.newVoucherType(VoucherType.class, voucherTypeVO);
        return voucherType;
    }

    public VoucherTypeDetailed toVoucherTypeDetailed(VoucherTypeDetailedVO voucherTypeDetailedVO) {
        if (voucherTypeDetailedVO == null) {
            return null;
        }
        VoucherTypeDetailed voucherTypeDetailed = this.newVoucherType(VoucherTypeDetailed.class, (VoucherTypeVO)voucherTypeDetailedVO);
        voucherTypeDetailed.setGift(this.toVoucherGiftEnum(voucherTypeDetailedVO.getGift()));
        voucherTypeDetailed.setVoucherDescription(voucherTypeDetailedVO.getVoucherDescription());
        voucherTypeDetailed.setAllowPartialRedeems(voucherTypeDetailedVO.isAllowPartialRedeems());
        voucherTypeDetailed.setMaxVouchersPerBuy(voucherTypeDetailedVO.getMaxVouchersPerBuy());
        CollectionHelper.orEmpty((List)voucherTypeDetailedVO.getRedeemAllowedGroups()).stream().map(this.groupsApiHelper::toGroup).forEach(voucherTypeDetailed.getRedeemAllowedGroups()::add);
        CollectionHelper.orEmpty((List)voucherTypeDetailedVO.getRedeemAllowedUsers()).stream().map(this.usersApiHelper::toUser).forEach(voucherTypeDetailed.getRedeemAllowedUsers()::add);
        return voucherTypeDetailed;
    }

    public VoucherView toVoucherView(VoucherData voucherData) {
        if (voucherData == null) {
            return null;
        }
        VoucherVO voucherVO = voucherData.getVoucher();
        VoucherPackVO voucherPackVO = voucherVO.getPack();
        VoucherView voucherView = this.newVoucherResult(VoucherView.class, voucherVO, null);
        voucherView.setTitle(voucherPackVO.getType().getVoucherTitle());
        voucherView.setDescription(voucherData.getVoucher().getPack().getType().getVoucherDescription());
        voucherView.setCreationType(this.toVoucherCreationTypeEnum(voucherPackVO.getCreationType()));
        voucherView.setBuy(this.transactionsApiHelper.toTransaction((TransactionVO)voucherData.getBuy()));
        CollectionHelper.orEmpty((List)voucherPackVO.getType().getRedeemAllowedGroups()).stream().map(this.groupsApiHelper::toGroup).forEach(voucherView.getRedeemAllowedGroups()::add);
        CollectionHelper.orEmpty((List)voucherPackVO.getType().getRedeemAllowedUsers()).stream().map(this.usersApiHelper::toUser).forEach(voucherView.getRedeemAllowedUsers()::add);
        voucherView.setAllowPartialRedeems(voucherPackVO.getType().isAllowPartialRedeems());
        voucherView.setExpirationDateComments(voucherData.getExpirationDateComments());
        voucherView.setRefundDate(voucherData.getRefundDate());
        voucherView.setShowConfiguration(voucherData.isShowConfiguration());
        voucherView.setShowType(voucherData.isShowType());
        voucherView.setShowQrCode(voucherData.isShowQrCode());
        voucherView.setCancelAction(this.toVoucherCancelActionEnum(voucherData.getCancelAction()));
        voucherView.setRedeemAfterDateReached(voucherData.isRedeemAfterDateReached());
        voucherView.setRefund(this.transactionsApiHelper.toTransaction((TransactionVO)voucherData.getRefund()));
        voucherView.setConfirmationPasswordInput(this.authApiHelper.toPasswordInput((ICredentialInputDTO)voucherData.getConfirmationPasswordInput()));
        voucherView.setPinStatusForRedeem(this.toPinStatusForRedeemEnum(voucherData.getPinStatusForRedeem()));
        voucherView.setPin(voucherData.getPin());
        voucherView.setPinInput(this.authApiHelper.toPasswordInput((ICredentialInputDTO)voucherData.getPinInput()));
        voucherView.setEmail(voucherVO.getEmail());
        voucherView.setMobilePhone(voucherData.getMobilePhone());
        voucherView.setEnableNotifications(voucherData.isEnableNotifications());
        voucherView.setSendMessage(voucherData.getSendMessage());
        voucherView.setCanChangeExpirationDate(voucherData.isCanChangeExpirationDate());
        voucherView.setCanAssign(voucherData.isCanAssign());
        voucherView.setCanResendEmail(voucherData.isCanResendEmail());
        voucherView.setCanChangeNotificationSettings(voucherData.isCanChangeNotificationSettings());
        voucherView.setPhoneConfiguration(this.phonesApiHelper.toPhoneConfiguration(voucherData.getPhoneConfiguration()));
        voucherView.setRequireOldPinForChange(voucherData.isRequireOldPinForChange());
        voucherView.setCanChangePin(voucherData.isCanChangePin());
        voucherView.setCanUnblockPin(voucherData.isCanUnblockPin());
        CollectionHelper.orEmpty((List)voucherData.getExportFormats()).stream().map(this.apiHelper::toExportFormat).forEach(voucherView.getExportFormats()::add);
        voucherView.setSingleRedeem(this.toVoucherTransaction(voucherData.getSingleRedeem()));
        voucherView.setHasTransactions(voucherData.isHasTransactions());
        CollectionHelper.orEmpty((List)voucherData.getCustomValues()).stream().map(this.apiHelper::toCustomFieldValue).forEach(voucherView.getCustomValues()::add);
        voucherView.setTopUpEnabled(voucherData.isTopUpEnabled());
        VoucherTransactionVO voucherTransactionVO = voucherData.getSingleRedeem();
        if (voucherTransactionVO != null) {
            voucherView.setRedeemDate(voucherTransactionVO.getDate());
            voucherView.setRedeem(this.transactionsApiHelper.toTransaction((TransactionVO)voucherTransactionVO.getTransaction()));
        }
        return voucherView;
    }

    private <P extends BaseVoucherBuyingPreview> P newBaseVoucherBuyingPreview(Class<P> clazz, BuyVoucherPreviewVO buyVoucherPreviewVO) {
        BaseVoucherBuyingPreview baseVoucherBuyingPreview = (BaseVoucherBuyingPreview)ClassHelper.instantiate(clazz);
        baseVoucherBuyingPreview.setUser(this.usersApiHelper.toUser((BasicUserVO)buyVoucherPreviewVO.getUser()));
        baseVoucherBuyingPreview.setType(this.toVoucherTypeDetailed(buyVoucherPreviewVO.getType()));
        baseVoucherBuyingPreview.setPaymentPreview(this.paymentsApiHelper.toPaymentPreview((BaseInternalPaymentPreviewVO)buyVoucherPreviewVO.getPaymentPreview(), "SYSTEM"));
        baseVoucherBuyingPreview.setConfirmationPasswordInput(this.authApiHelper.toPasswordInput((ICredentialInputDTO)buyVoucherPreviewVO.getConfirmationPasswordInput()));
        return (P)baseVoucherBuyingPreview;
    }

    private <F extends BaseVouchersQueryFilters> F newBaseVouchersQueryFilters(Class<F> clazz, BasicVoucherQuery basicVoucherQuery) {
        BaseVouchersQueryFilters baseVouchersQueryFilters = (BaseVouchersQueryFilters)this.apiHelper.newQueryFilters(clazz, (QueryParameters)basicVoucherQuery);
        baseVouchersQueryFilters.setAmountRange(this.apiHelper.toFilter(basicVoucherQuery.getAmountRange()));
        baseVouchersQueryFilters.setCreationPeriod(this.apiHelper.toFilter(basicVoucherQuery.getCreationPeriod()));
        baseVouchersQueryFilters.setExpirationPeriod(this.apiHelper.toFilter(basicVoucherQuery.getExpirationPeriod()));
        CollectionHelper.orEmpty((Set)basicVoucherQuery.getStatuses()).stream().map(this::toVoucherStatusEnum).forEach(baseVouchersQueryFilters.getStatuses()::add);
        baseVouchersQueryFilters.setToken(basicVoucherQuery.getToken());
        CollectionHelper.orEmpty((Set)basicVoucherQuery.getTypes()).stream().map(ModelHelper::stringOrIdFromVO).forEach(baseVouchersQueryFilters.getTypes()::add);
        baseVouchersQueryFilters.setCreationType(this.toVoucherCreationTypeEnum(basicVoucherQuery.getCreationType()));
        baseVouchersQueryFilters.setOrderBy(this.toVoucherOrderByEnum(basicVoucherQuery.getOrderBy()));
        return (F)baseVouchersQueryFilters;
    }

    private <Q extends BasicVoucherQuery> Q newBasicVoucherQuery(Class<Q> clazz, BaseVouchersQueryFilters baseVouchersQueryFilters) {
        BasicVoucherQuery basicVoucherQuery = (BasicVoucherQuery)this.apiHelper.newQuery(clazz, baseVouchersQueryFilters);
        basicVoucherQuery.setToken(baseVouchersQueryFilters.getToken());
        basicVoucherQuery.setAmountRange(this.apiHelper.toDecimalRangeDTO(baseVouchersQueryFilters.getAmountRange()));
        basicVoucherQuery.setCreationPeriod(this.apiHelper.toDatePeriodDTO(baseVouchersQueryFilters.getCreationPeriod()));
        basicVoucherQuery.setExpirationPeriod(this.apiHelper.toDatePeriodDTO(baseVouchersQueryFilters.getExpirationPeriod()));
        basicVoucherQuery.setStatuses(CollectionHelper.orEmpty(baseVouchersQueryFilters.getStatuses()).stream().map(this::toVoucherStatus).collect(Collectors.toSet()));
        basicVoucherQuery.setTypes(CollectionHelper.orEmpty(baseVouchersQueryFilters.getTypes()).stream().map(string -> (VoucherTypeVO)ModelHelper.voFromString(VoucherTypeVO.class, (String)string)).collect(Collectors.toSet()));
        basicVoucherQuery.setCreationType(this.toVoucherCreationType(baseVouchersQueryFilters.getCreationType()));
        basicVoucherQuery.setOrderBy(this.toVoucherOrderBy(baseVouchersQueryFilters.getOrderBy()));
        return (Q)basicVoucherQuery;
    }

    private <T extends PerformVoucherTransaction> T newPerformVoucherTransaction(Class<T> clazz, PerformVoucherTransactionDTO performVoucherTransactionDTO) {
        PerformVoucherTransaction performVoucherTransaction = (PerformVoucherTransaction)ClassHelper.instantiate(clazz);
        performVoucherTransaction.setAmount(performVoucherTransactionDTO.getAmount());
        performVoucherTransaction.setPaymentCustomValues(this.apiHelper.toCustomFieldValuesMap(performVoucherTransactionDTO.getPaymentCustomValues()));
        return (T)performVoucherTransaction;
    }

    private <V extends Voucher> V newVoucher(Class<V> clazz, VoucherVO voucherVO) {
        VoucherPackVO voucherPackVO = voucherVO.getPack();
        Voucher voucher = (Voucher)this.apiHelper.newEntity(clazz, voucherVO);
        voucher.setType(this.toVoucherType((VoucherTypeVO)voucherPackVO.getType()));
        voucher.setCreationType(this.toVoucherCreationTypeEnum(voucherPackVO.getCreationType()));
        voucher.setToken(voucherVO.getToken());
        voucher.setAmount((BigDecimal)ObjectHelper.defaultValue((Object)voucherVO.getAmount(), (Object)voucherPackVO.getAmount()));
        voucher.setExpirationDate((DateTime)ObjectHelper.defaultValue((Object)voucherVO.getExpirationDate(), (Object)voucherPackVO.getExpirationDate()));
        voucher.setBalance(voucherVO.getBalance());
        voucher.setStatus(this.toVoucherStatusEnum(voucherVO.getStatus()));
        voucher.setEmail(voucherVO.getEmail());
        voucher.setGift(voucherVO.getPack().getGift());
        return (V)voucher;
    }

    private <D extends VoucherBasicData> D newVoucherBasicData(Class<D> clazz, BasicVoucherData basicVoucherData, List<CustomFieldDetailedVO> list) {
        VoucherBasicData voucherBasicData = (VoucherBasicData)ClassHelper.instantiate(clazz);
        voucherBasicData.setType(this.toVoucherTypeDetailed(basicVoucherData.getType()));
        CollectionHelper.orEmpty(list).stream().map(this.apiHelper::toCustomFieldDetailed).forEach(voucherBasicData.getPaymentCustomFields()::add);
        voucherBasicData.setCustomFields(voucherBasicData.getPaymentCustomFields());
        return (D)voucherBasicData;
    }

    private <D extends VoucherCreateData> D newVoucherCreateData(Class<D> clazz, BasicCreateVoucherData basicCreateVoucherData, List<CustomFieldDetailedVO> list) {
        VoucherCreateData voucherCreateData = (VoucherCreateData)this.newVoucherBasicData(clazz, (BasicVoucherData)basicCreateVoucherData, list);
        voucherCreateData.setExpirationDate(basicCreateVoucherData.getExpirationDate());
        voucherCreateData.setMinimumTimeToRedeem(this.apiHelper.toTimeInterval(basicCreateVoucherData.getMinimumTimeToRedeem()));
        voucherCreateData.setRedeemAfterDate(basicCreateVoucherData.getRedeemAfterDate());
        voucherCreateData.setAccount(this.accountsApiHelper.toAccountWithStatus((AccountVO)basicCreateVoucherData.getAccount()));
        CollectionHelper.orEmpty((List)basicCreateVoucherData.getRedeemOnWeekDays()).stream().map(this.apiHelper::toWeekDayEnum).forEach(voucherCreateData.getRedeemOnWeekDays()::add);
        return (D)voucherCreateData;
    }

    private <D extends VoucherBasicDataForTransaction> D newVoucherDataForTransaction(Class<D> clazz, PerformVoucherTransactionData performVoucherTransactionData) {
        VoucherBasicDataForTransaction voucherBasicDataForTransaction = (VoucherBasicDataForTransaction)this.newVoucherBasicData(clazz, (BasicVoucherData)performVoucherTransactionData, performVoucherTransactionData.getPaymentCustomFields());
        voucherBasicDataForTransaction.setUser(this.usersApiHelper.toUser((BasicUserVO)performVoucherTransactionData.getUser()));
        voucherBasicDataForTransaction.setToken(performVoucherTransactionData.getToken());
        voucherBasicDataForTransaction.setAmount(performVoucherTransactionData.getAmount());
        voucherBasicDataForTransaction.setShouldPreview(performVoucherTransactionData.isShouldPreview());
        return (D)voucherBasicDataForTransaction;
    }

    private <V extends VoucherResult> V newVoucherResult(Class<V> clazz, VoucherVO voucherVO, VoucherRelationEnum voucherRelationEnum) {
        VoucherPackVO voucherPackVO = voucherVO.getPack();
        VoucherResult voucherResult = (VoucherResult)this.newVoucher(clazz, voucherVO);
        voucherResult.setCreationDate(voucherPackVO.getCreationDate());
        voucherResult.setRedeemDate(voucherVO.getRedeemDate());
        voucherResult.setOwner(this.usersApiHelper.toUser((BasicUserVO)voucherVO.getOwner()));
        voucherResult.setRedeemBy(this.usersApiHelper.toUser(voucherVO.getRedeemBy()));
        voucherResult.setBuyer(this.usersApiHelper.toUser((BasicUserVO)voucherPackVO.getBuyer()));
        if (voucherResult.getStatus() == VoucherStatusEnum.OPEN) {
            voucherResult.setRedeemAfterDate(voucherPackVO.getRedeemAfterDate());
            CollectionHelper.orEmpty((List)voucherPackVO.getRedeemOnWeekDays()).stream().map(this.apiHelper::toWeekDayEnum).forEach(voucherResult.getRedeemOnWeekDays()::add);
        } else {
            voucherResult.setRedeemOnWeekDays(null);
        }
        return (V)voucherResult;
    }

    private <T extends VoucherTransaction> T newVoucherTransaction(Class<T> clazz, VoucherTransactionVO voucherTransactionVO) {
        VoucherTransaction voucherTransaction = (VoucherTransaction)this.apiHelper.newEntity(clazz, voucherTransactionVO);
        voucherTransaction.setKind(this.toVoucherTransactionKind(voucherTransactionVO.getNature()));
        voucherTransaction.setDate(voucherTransactionVO.getDate());
        voucherTransaction.setAmount(voucherTransactionVO.getAmount());
        voucherTransaction.setPayment(this.transactionsApiHelper.toTransaction((TransactionVO)voucherTransactionVO.getTransaction()));
        voucherTransaction.setUser(this.usersApiHelper.toUser((BasicUserVO)voucherTransactionVO.getUser()));
        voucherTransaction.setBy(this.usersApiHelper.toUser(voucherTransactionVO.getBy()));
        return (T)voucherTransaction;
    }

    private <P extends VoucherTransactionPreview> P newVoucherTransactionPreview(Class<P> clazz, VoucherTransactionPreviewVO voucherTransactionPreviewVO, PerformVoucherTransactionDTO performVoucherTransactionDTO) {
        VoucherTransactionPreview voucherTransactionPreview = (VoucherTransactionPreview)ClassHelper.instantiate(clazz);
        voucherTransactionPreview.setType(this.toVoucherTypeDetailed(voucherTransactionPreviewVO.getType()));
        voucherTransactionPreview.setUser(this.usersApiHelper.toUser((BasicUserVO)voucherTransactionPreviewVO.getUser()));
        voucherTransactionPreview.setToken(voucherTransactionPreviewVO.getToken());
        voucherTransactionPreview.setAmount(voucherTransactionPreviewVO.getAmount());
        voucherTransactionPreview.setPaymentCustomValues(this.apiHelper.toCustomFieldValuesList(performVoucherTransactionDTO.getPaymentCustomValues()));
        return (P)voucherTransactionPreview;
    }

    private <R extends VoucherTransactionResult> R newVoucherTransactionResult(Class<R> clazz, VoucherTransactionResultVO voucherTransactionResultVO) {
        VoucherTransactionResult voucherTransactionResult = (VoucherTransactionResult)this.newVoucherTransaction(clazz, (VoucherTransactionVO)voucherTransactionResultVO);
        voucherTransactionResult.setToken(voucherTransactionResultVO.getToken());
        voucherTransactionResult.setVoucherId(ApiHelper.toId(voucherTransactionResultVO.getVoucherId()));
        voucherTransactionResult.setType(this.toVoucherType(voucherTransactionResultVO.getType()));
        CollectionHelper.orEmpty((List)voucherTransactionResultVO.getCustomValues()).stream().map(this.apiHelper::toCustomFieldValue).forEach(voucherTransactionResult.getCustomValues()::add);
        return (R)voucherTransactionResult;
    }

    private <T extends VoucherType> T newVoucherType(Class<T> clazz, VoucherTypeVO voucherTypeVO) {
        VoucherType voucherType = (VoucherType)this.apiHelper.newEntity(clazz, voucherTypeVO);
        voucherType.setConfiguration(this.toVoucherConfiguration(voucherTypeVO.getConfiguration()));
        voucherType.setVoucherTitle(voucherTypeVO.getVoucherTitle());
        voucherType.setCategory(this.toVoucherCategory(voucherTypeVO.getCategory()));
        voucherType.setImage(this.imagesApiHelper.toImage(voucherTypeVO.getImage()));
        return (T)voucherType;
    }

    private BuyVoucher toBuyVoucher(BuyVouchersDTO buyVouchersDTO) {
        BuyVoucher buyVoucher = new BuyVoucher();
        buyVoucher.setType(ModelHelper.stringOrIdFromVO((EntityVO)buyVouchersDTO.getType()));
        buyVoucher.setGift(buyVouchersDTO.isGift());
        buyVoucher.setAmount(buyVouchersDTO.getAmount());
        buyVoucher.setCount(buyVouchersDTO.getCount());
        buyVoucher.setVoucherCustomValues(this.apiHelper.toCustomFieldValuesMap(buyVouchersDTO.getCustomValues()));
        buyVoucher.setPaymentCustomValues(this.apiHelper.toCustomFieldValuesMap(buyVouchersDTO.getPaymentCustomValues()));
        buyVoucher.setCustomValues(buyVoucher.getPaymentCustomValues());
        return buyVoucher;
    }

    private VoucherPinStatusForRedeemEnum toPinStatusForRedeemEnum(VoucherPinStatusForRedeem voucherPinStatusForRedeem) {
        if (voucherPinStatusForRedeem != null) {
            switch (voucherPinStatusForRedeem) {
                case NOT_USED: {
                    return VoucherPinStatusForRedeemEnum.NOT_USED;
                }
                case SUBSEQUENT: {
                    return VoucherPinStatusForRedeemEnum.SUBSEQUENT;
                }
                case REQUIRED: {
                    return VoucherPinStatusForRedeemEnum.REQUIRED;
                }
                case BLOCKED: {
                    return VoucherPinStatusForRedeemEnum.BLOCKED;
                }
            }
        }
        return null;
    }

    private RedeemVoucher toRedeemVoucher(RedeemVoucherDTO redeemVoucherDTO) {
        RedeemVoucher redeemVoucher = this.newPerformVoucherTransaction(RedeemVoucher.class, (PerformVoucherTransactionDTO)redeemVoucherDTO);
        redeemVoucher.setPin(redeemVoucherDTO.getPin());
        return redeemVoucher;
    }

    private SendVoucher toSendVoucher(SendVoucherDTO sendVoucherDTO) {
        SendVoucher sendVoucher = new SendVoucher();
        sendVoucher.setType(ModelHelper.stringOrIdFromVO((EntityVO)sendVoucherDTO.getType()));
        sendVoucher.setEmail(sendVoucherDTO.getEmail());
        sendVoucher.setAmount(sendVoucherDTO.getAmount());
        sendVoucher.setVoucherCustomValues(this.apiHelper.toCustomFieldValuesMap(sendVoucherDTO.getCustomValues()));
        sendVoucher.setPaymentCustomValues(this.apiHelper.toCustomFieldValuesMap(sendVoucherDTO.getPaymentCustomValues()));
        sendVoucher.setMessage(sendVoucherDTO.getMessage());
        return sendVoucher;
    }

    private TopUpVoucher toTopUpVoucher(TopUpVoucherDTO topUpVoucherDTO) {
        TopUpVoucher topUpVoucher = this.newPerformVoucherTransaction(TopUpVoucher.class, (PerformVoucherTransactionDTO)topUpVoucherDTO);
        topUpVoucher.setEmail(topUpVoucherDTO.getEmail());
        topUpVoucher.setMobilePhone(topUpVoucherDTO.getMobilePhone());
        topUpVoucher.setPin(topUpVoucherDTO.getPin());
        topUpVoucher.setPinConfirmation(topUpVoucherDTO.getPinConfirmation());
        topUpVoucher.setCheckPinConfirmation(true);
        topUpVoucher.setVoucherCustomValues(this.apiHelper.toCustomFieldValuesMap(topUpVoucherDTO.getCustomValues()));
        return topUpVoucher;
    }

    private UserVouchersQueryFilters toUserVoucherQueryFilters(UserVoucherQuery userVoucherQuery) {
        UserVouchersQueryFilters userVouchersQueryFilters = this.apiHelper.newQueryFilters(UserVouchersQueryFilters.class, (QueryParameters)userVoucherQuery);
        userVouchersQueryFilters.setToken(userVoucherQuery.getToken());
        userVouchersQueryFilters.setTypes(CollectionHelper.orEmpty((Set)userVoucherQuery.getTypes()).stream().map(ModelHelper::stringOrIdFromVO).collect(Collectors.toList()));
        userVouchersQueryFilters.setStatuses(CollectionHelper.orEmpty((Set)userVoucherQuery.getStatuses()).stream().map(this::toVoucherStatusEnum).collect(Collectors.toList()));
        userVouchersQueryFilters.setAmountRange(this.apiHelper.toDecimalRangeList(userVoucherQuery.getAmountRange()));
        userVouchersQueryFilters.setCreationType(this.toVoucherCreationTypeEnum(userVoucherQuery.getCreationType()));
        userVouchersQueryFilters.setCreationPeriod(this.apiHelper.toFilter(userVoucherQuery.getCreationPeriod()));
        userVouchersQueryFilters.setExpirationPeriod(this.apiHelper.toFilter(userVoucherQuery.getExpirationPeriod()));
        userVouchersQueryFilters.setOrderBy(this.toVoucherOrderByEnum(userVoucherQuery.getOrderBy()));
        userVouchersQueryFilters.setRelation(VoucherRelationEnum.BOUGHT);
        return userVouchersQueryFilters;
    }

    private UserVouchersQueryFilters toUserVoucherQueryFilters(VoucherTransactionsQuery voucherTransactionsQuery) {
        UserVouchersQueryFilters userVouchersQueryFilters = this.apiHelper.newQueryFilters(UserVouchersQueryFilters.class, (QueryParameters)voucherTransactionsQuery);
        userVouchersQueryFilters.setRelation(VoucherRelationEnum.REDEEMED);
        userVouchersQueryFilters.setTypes(CollectionHelper.orEmpty((Set)voucherTransactionsQuery.getTypes()).stream().map(ModelHelper::stringOrIdFromVO).collect(Collectors.toList()));
        userVouchersQueryFilters.setAmountRange(this.apiHelper.toDecimalRangeList(voucherTransactionsQuery.getAmountRange()));
        userVouchersQueryFilters.setStatuses(null);
        userVouchersQueryFilters.setRedeemPeriod(this.apiHelper.toFilter(voucherTransactionsQuery.getDatePeriod()));
        userVouchersQueryFilters.setRedeemBy(ModelHelper.stringOrIdFromVO((EntityVO)voucherTransactionsQuery.getBy()));
        return userVouchersQueryFilters;
    }

    private UserVoucherTransactionsQueryFilters toUserVoucherTransactionsQueryFilters(VoucherTransactionsQuery voucherTransactionsQuery) {
        UserVoucherTransactionsQueryFilters userVoucherTransactionsQueryFilters = this.apiHelper.newQueryFilters(UserVoucherTransactionsQueryFilters.class, (QueryParameters)voucherTransactionsQuery);
        CollectionHelper.orEmpty((Set)voucherTransactionsQuery.getNatures()).stream().map(this::toVoucherTransactionKind).forEach(userVoucherTransactionsQueryFilters.getKinds()::add);
        if (CollectionHelper.size((Collection)voucherTransactionsQuery.getNatures()) == 1) {
            userVoucherTransactionsQueryFilters.setKind(this.toVoucherTransactionKind((VoucherTransactionNature)CollectionHelper.first((Iterable)voucherTransactionsQuery.getNatures())));
        }
        userVoucherTransactionsQueryFilters.setAmountRange(this.apiHelper.toFilter(voucherTransactionsQuery.getAmountRange()));
        userVoucherTransactionsQueryFilters.setDatePeriod(this.apiHelper.toFilter(voucherTransactionsQuery.getDatePeriod()));
        CollectionHelper.orEmpty((Set)voucherTransactionsQuery.getTypes()).stream().map(ModelHelper::stringOrIdFromVO).forEach(userVoucherTransactionsQueryFilters.getTypes()::add);
        userVoucherTransactionsQueryFilters.setBy(ModelHelper.stringOrIdFromVO((EntityVO)voucherTransactionsQuery.getBy()));
        return userVoucherTransactionsQueryFilters;
    }

    private VoucherGenerationAmountEnum toVoucherGenerationAmountEnum(VoucherGenerationAmount voucherGenerationAmount) {
        if (voucherGenerationAmount != null) {
            switch (voucherGenerationAmount) {
                case GENERATION: {
                    return VoucherGenerationAmountEnum.GENERATION;
                }
                case ACTIVATION: {
                    return VoucherGenerationAmountEnum.ACTIVATION;
                }
                case DYNAMIC: {
                    return VoucherGenerationAmountEnum.DYNAMIC;
                }
            }
        }
        return null;
    }

    private VoucherGenerationStatusEnum toVoucherGenerationStatusEnum(VoucherGenerationStatus voucherGenerationStatus) {
        if (voucherGenerationStatus != null) {
            switch (voucherGenerationStatus) {
                case ACTIVE: {
                    return VoucherGenerationStatusEnum.ACTIVE;
                }
                case BLOCKED: {
                    return VoucherGenerationStatusEnum.BLOCKED;
                }
                case INACTIVE: {
                    return VoucherGenerationStatusEnum.INACTIVE;
                }
            }
        }
        return null;
    }

    private VoucherGiftEnum toVoucherGiftEnum(VoucherGiftOption voucherGiftOption) {
        if (voucherGiftOption != null) {
            switch (voucherGiftOption) {
                case ALWAYS: {
                    return VoucherGiftEnum.ALWAYS;
                }
                case CHOOSE: {
                    return VoucherGiftEnum.CHOOSE;
                }
                case NEVER: {
                    return VoucherGiftEnum.NEVER;
                }
            }
        }
        return null;
    }

    private VoucherPinOnActivationEnum toVoucherPinOnActivationEnum(VoucherPinOnActivation voucherPinOnActivation) {
        if (voucherPinOnActivation != null) {
            switch (voucherPinOnActivation) {
                case NONE: {
                    return VoucherPinOnActivationEnum.NONE;
                }
                case SEND: {
                    return VoucherPinOnActivationEnum.SEND;
                }
                case INPUT: {
                    return VoucherPinOnActivationEnum.INPUT;
                }
            }
        }
        return null;
    }

    private VoucherTransactionKind toVoucherTransactionKind(VoucherTransactionNature voucherTransactionNature) {
        if (voucherTransactionNature != null) {
            switch (voucherTransactionNature) {
                case REDEEM: {
                    return VoucherTransactionKind.REDEEM;
                }
                case TOP_UP: {
                    return VoucherTransactionKind.TOP_UP;
                }
                case CHARGEBACK: {
                    return VoucherTransactionKind.CHARGEBACK;
                }
            }
        }
        return null;
    }

    private VoucherTransactionNature toVoucherTransactionNature(VoucherTransactionKind voucherTransactionKind) {
        if (voucherTransactionKind != null) {
            switch (voucherTransactionKind) {
                case REDEEM: {
                    return VoucherTransactionNature.REDEEM;
                }
                case TOP_UP: {
                    return VoucherTransactionNature.TOP_UP;
                }
                case CHARGEBACK: {
                    return VoucherTransactionNature.CHARGEBACK;
                }
            }
        }
        return null;
    }
}

