/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.helpers;

import org.cyclos.model.marketplace.webshopsettings.AdWebShopSettingDTO;
import org.cyclos.model.marketplace.webshopsettings.AdWebShopSettingData;
import org.cyclos.model.marketplace.webshopsettings.AdWebShopSettingVO;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.model.users.users.UserVO;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.model.utils.NumberGenerationDTO;
import org.cyclos.web.rest.helpers.UsersApiHelper;
import org.cyclos.web.rest.model.WebshopSettings;
import org.cyclos.web.rest.model.WebshopSettingsDetailed;
import org.cyclos.web.rest.model.WebshopSettingsView;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WebshopSettingsApiHelper {
    @Autowired
    private UsersApiHelper usersApiHelper;

    public AdWebShopSettingDTO toAdWebShopSettingDTO(String string, WebshopSettingsDetailed webshopSettingsDetailed) {
        AdWebShopSettingDTO adWebShopSettingDTO = new AdWebShopSettingDTO();
        adWebShopSettingDTO.setOwner((UserVO)ModelHelper.voFromString(UserVO.class, (String)string));
        adWebShopSettingDTO.setProductNumberGenerated(Boolean.TRUE.equals(webshopSettingsDetailed.getProductNumberGenerated()));
        adWebShopSettingDTO.setProductNumberMask(webshopSettingsDetailed.getProductNumberMask());
        adWebShopSettingDTO.setEnableOrderNumber(Boolean.TRUE.equals(webshopSettingsDetailed.getCustomOrderNumberFormat()));
        if (adWebShopSettingDTO.isEnableOrderNumber()) {
            NumberGenerationDTO numberGenerationDTO = new NumberGenerationDTO();
            numberGenerationDTO.setPrefix(webshopSettingsDetailed.getOrderNumberPrefix());
            numberGenerationDTO.setPadLength(webshopSettingsDetailed.getOrderNumberInnerLength());
            numberGenerationDTO.setSuffix(webshopSettingsDetailed.getOrderNumberSuffix());
            adWebShopSettingDTO.setOrderNumber(numberGenerationDTO);
        }
        return adWebShopSettingDTO;
    }

    public WebshopSettings toWebshopSettings(AdWebShopSettingVO adWebShopSettingVO) {
        if (adWebShopSettingVO == null) {
            return null;
        }
        WebshopSettings webshopSettings = new WebshopSettings();
        webshopSettings.setProductNumberGenerated(adWebShopSettingVO.isProductNumberGenerated());
        webshopSettings.setProductNumberMask(adWebShopSettingVO.getProductNumberMask());
        return webshopSettings;
    }

    public WebshopSettingsView toWebshopSettingsView(AdWebShopSettingData adWebShopSettingData) {
        AdWebShopSettingDTO adWebShopSettingDTO = adWebShopSettingData.getSetting();
        WebshopSettingsView webshopSettingsView = this.fill(new WebshopSettingsView(), adWebShopSettingDTO);
        webshopSettingsView.setUser(this.usersApiHelper.toUser((BasicUserVO)adWebShopSettingDTO.getOwner()));
        webshopSettingsView.setCanEdit(adWebShopSettingData.isCanEdit());
        webshopSettingsView.setCustomOrderNumberFormat(adWebShopSettingDTO.isEnableOrderNumber());
        NumberGenerationDTO numberGenerationDTO = adWebShopSettingDTO.getOrderNumber();
        if (numberGenerationDTO != null) {
            webshopSettingsView.setOrderNumberPrefix(numberGenerationDTO.getPrefix());
            webshopSettingsView.setOrderNumberInnerLength(numberGenerationDTO.getPadLength());
            webshopSettingsView.setOrderNumberSuffix(numberGenerationDTO.getSuffix());
        }
        return webshopSettingsView;
    }

    private <T extends WebshopSettings> T fill(T t, AdWebShopSettingDTO adWebShopSettingDTO) {
        t.setProductNumberGenerated(adWebShopSettingDTO.isProductNumberGenerated());
        t.setProductNumberMask(adWebShopSettingDTO.getProductNumberMask());
        return t;
    }
}

