/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.cyclos.utils.DateTime;
import org.cyclos.web.rest.model.PaymentRequestSchedulingEnum;
import org.cyclos.web.rest.model.PerformInternalTransaction;
import org.cyclos.web.rest.model.RestModel;
import org.cyclos.web.rest.model.TimeInterval;

public class SendPaymentRequest
extends PerformInternalTransaction
implements RestModel {
    private BigDecimal amount;
    private String description;
    private String currency;
    private String type;
    private Map<String, String> customValues = new HashMap<String, String>();
    private String subject;
    private String fromName;
    private String toName;
    private DateTime expirationDate;
    private Boolean firstInstallmentIsImmediate;
    private Integer installmentsCount;
    private PaymentRequestSchedulingEnum scheduling;
    private Integer occurrencesCount;
    private Boolean firstOccurrenceIsImmediate;
    private TimeInterval occurrenceInterval = null;
    public static final String AMOUNT = "amount";
    public static final String DESCRIPTION = "description";
    public static final String CURRENCY = "currency";
    public static final String TYPE = "type";
    public static final String CUSTOM_VALUES = "customValues";
    public static final String SUBJECT = "subject";
    public static final String FROM_NAME = "fromName";
    public static final String TO_NAME = "toName";
    public static final String EXPIRATION_DATE = "expirationDate";
    public static final String FIRST_INSTALLMENT_IS_IMMEDIATE = "firstInstallmentIsImmediate";
    public static final String INSTALLMENTS_COUNT = "installmentsCount";
    public static final String SCHEDULING = "scheduling";
    public static final String OCCURRENCES_COUNT = "occurrencesCount";
    public static final String FIRST_OCCURRENCE_IS_IMMEDIATE = "firstOccurrenceIsImmediate";
    public static final String OCCURRENCE_INTERVAL = "occurrenceInterval";

    @Override
    @JsonProperty(value="amount")
    public BigDecimal getAmount() {
        return this.amount;
    }

    @Override
    public void setAmount(BigDecimal bigDecimal) {
        this.amount = bigDecimal;
    }

    @Override
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String string) {
        this.description = string;
    }

    @Override
    @JsonProperty(value="currency")
    public String getCurrency() {
        return this.currency;
    }

    @Override
    public void setCurrency(String string) {
        this.currency = string;
    }

    @Override
    @JsonProperty(value="type")
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(String string) {
        this.type = string;
    }

    @Override
    @JsonProperty(value="customValues")
    public Map<String, String> getCustomValues() {
        return this.customValues;
    }

    @Override
    public void setCustomValues(Map<String, String> map) {
        this.customValues = map;
    }

    @Override
    @JsonProperty(value="subject")
    public String getSubject() {
        return this.subject;
    }

    @Override
    public void setSubject(String string) {
        this.subject = string;
    }

    @Override
    @JsonProperty(value="fromName")
    public String getFromName() {
        return this.fromName;
    }

    @Override
    public void setFromName(String string) {
        this.fromName = string;
    }

    @Override
    @JsonProperty(value="toName")
    public String getToName() {
        return this.toName;
    }

    @Override
    public void setToName(String string) {
        this.toName = string;
    }

    @JsonProperty(value="expirationDate")
    public DateTime getExpirationDate() {
        return this.expirationDate;
    }

    public void setExpirationDate(DateTime dateTime) {
        this.expirationDate = dateTime;
    }

    @JsonProperty(value="firstInstallmentIsImmediate")
    public Boolean getFirstInstallmentIsImmediate() {
        return this.firstInstallmentIsImmediate;
    }

    public void setFirstInstallmentIsImmediate(Boolean bl) {
        this.firstInstallmentIsImmediate = bl;
    }

    @JsonProperty(value="installmentsCount")
    public Integer getInstallmentsCount() {
        return this.installmentsCount;
    }

    public void setInstallmentsCount(Integer n) {
        this.installmentsCount = n;
    }

    @JsonProperty(value="scheduling")
    public PaymentRequestSchedulingEnum getScheduling() {
        return this.scheduling;
    }

    public void setScheduling(PaymentRequestSchedulingEnum paymentRequestSchedulingEnum) {
        this.scheduling = paymentRequestSchedulingEnum;
    }

    @JsonProperty(value="occurrencesCount")
    public Integer getOccurrencesCount() {
        return this.occurrencesCount;
    }

    public void setOccurrencesCount(Integer n) {
        this.occurrencesCount = n;
    }

    @JsonProperty(value="firstOccurrenceIsImmediate")
    public Boolean getFirstOccurrenceIsImmediate() {
        return this.firstOccurrenceIsImmediate;
    }

    public void setFirstOccurrenceIsImmediate(Boolean bl) {
        this.firstOccurrenceIsImmediate = bl;
    }

    @JsonProperty(value="occurrenceInterval")
    public TimeInterval getOccurrenceInterval() {
        return this.occurrenceInterval;
    }

    public void setOccurrenceInterval(TimeInterval timeInterval) {
        this.occurrenceInterval = timeInterval;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof SendPaymentRequest)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        SendPaymentRequest sendPaymentRequest = (SendPaymentRequest)object;
        return Objects.equals(this.amount, sendPaymentRequest.amount) && Objects.equals(this.description, sendPaymentRequest.description) && Objects.equals(this.currency, sendPaymentRequest.currency) && Objects.equals(this.type, sendPaymentRequest.type) && Objects.equals(this.customValues, sendPaymentRequest.customValues) && Objects.equals(this.subject, sendPaymentRequest.subject) && Objects.equals(this.fromName, sendPaymentRequest.fromName) && Objects.equals(this.toName, sendPaymentRequest.toName) && Objects.equals(this.expirationDate, sendPaymentRequest.expirationDate) && Objects.equals(this.firstInstallmentIsImmediate, sendPaymentRequest.firstInstallmentIsImmediate) && Objects.equals(this.installmentsCount, sendPaymentRequest.installmentsCount) && Objects.equals(this.scheduling, sendPaymentRequest.scheduling) && Objects.equals(this.occurrencesCount, sendPaymentRequest.occurrencesCount) && Objects.equals(this.firstOccurrenceIsImmediate, sendPaymentRequest.firstOccurrenceIsImmediate) && Objects.equals(this.occurrenceInterval, sendPaymentRequest.occurrenceInterval);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.amount, this.description, this.currency, this.type, this.customValues, this.subject, this.fromName, this.toName, this.expirationDate, this.firstInstallmentIsImmediate, this.installmentsCount, this.scheduling, this.occurrencesCount, this.firstOccurrenceIsImmediate, this.occurrenceInterval);
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("class SendPaymentRequest {\n");
        stringBuilder.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        stringBuilder.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        stringBuilder.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        stringBuilder.append("    currency: ").append(this.toIndentedString(this.currency)).append("\n");
        stringBuilder.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        stringBuilder.append("    customValues: ").append(this.toIndentedString(this.customValues)).append("\n");
        stringBuilder.append("    subject: ").append(this.toIndentedString(this.subject)).append("\n");
        stringBuilder.append("    fromName: ").append(this.toIndentedString(this.fromName)).append("\n");
        stringBuilder.append("    toName: ").append(this.toIndentedString(this.toName)).append("\n");
        stringBuilder.append("    expirationDate: ").append(this.toIndentedString(this.expirationDate)).append("\n");
        stringBuilder.append("    firstInstallmentIsImmediate: ").append(this.toIndentedString(this.firstInstallmentIsImmediate)).append("\n");
        stringBuilder.append("    installmentsCount: ").append(this.toIndentedString(this.installmentsCount)).append("\n");
        stringBuilder.append("    scheduling: ").append(this.toIndentedString(this.scheduling)).append("\n");
        stringBuilder.append("    occurrencesCount: ").append(this.toIndentedString(this.occurrencesCount)).append("\n");
        stringBuilder.append("    firstOccurrenceIsImmediate: ").append(this.toIndentedString(this.firstOccurrenceIsImmediate)).append("\n");
        stringBuilder.append("    occurrenceInterval: ").append(this.toIndentedString(this.occurrenceInterval)).append("\n");
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private String toIndentedString(Object object) {
        if (object == null) {
            return "null";
        }
        return object.toString().replace("\n", "\n    ");
    }
}

