/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rpc;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.openmbean.InvalidOpenTypeException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.cyclos.model.DataAccessException;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.ValidationException;
import org.cyclos.model.access.InvalidSessionDataException;
import org.cyclos.model.access.LoginException;
import org.cyclos.model.access.PermissionDeniedException;
import org.cyclos.model.utils.Transaction;
import org.cyclos.model.utils.TransactionLevel;
import org.cyclos.server.utils.ClassHelper;
import org.cyclos.utils.ContentType;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.StringHelper;
import org.cyclos.web.rpc.InvalidInputException;
import org.cyclos.web.rpc.InvalidOperationException;
import org.cyclos.web.rpc.InvalidParameterException;
import org.cyclos.web.rpc.InvalidParametersException;
import org.cyclos.web.rpc.InvalidRequestException;
import org.cyclos.web.rpc.WebRpcContentHandler;
import org.cyclos.web.rpc.WebRpcRequest;
import org.springframework.http.HttpMethod;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.web.HttpRequestHandler;

public class WebRpcRequestHandler<T>
implements HttpRequestHandler {
    public static final String ROOT_PATH = "/web-rpc/";
    private static final Logger LOG = LogManager.getLogger(WebRpcRequestHandler.class);
    private static final List<String> PARAM_ENCODINGS = Arrays.asList("application/x-www-form-urlencoded", "multipart/form-data");
    private final Class<T> serviceInterface;
    private final T service;
    private final WebRpcContentHandler contentHandler;
    private final Map<String, Method> methods;
    private final Map<Method, Boolean> allowGets;

    public static int resolveStatusCode(Throwable throwable) {
        try {
            throw throwable;
        }
        catch (ValidationException | InvalidInputException | InvalidOperationException | InvalidParameterException | InvalidParametersException | InvalidRequestException object) {
            return 400;
        }
        catch (InvalidSessionDataException | LoginException | PermissionDeniedException throwable2) {
            return 403;
        }
        catch (InvalidOpenTypeException | EntityNotFoundException throwable3) {
            return 404;
        }
        catch (Throwable throwable4) {
            return 500;
        }
    }

    public WebRpcRequestHandler(Class<T> clazz, T t, WebRpcContentHandler webRpcContentHandler) {
        this.serviceInterface = clazz;
        this.service = t;
        this.contentHandler = webRpcContentHandler;
        this.methods = new HashMap<String, Method>();
        this.allowGets = new HashMap<Method, Boolean>();
        for (Method method : clazz.getMethods()) {
            TransactionLevel transactionLevel;
            Transaction transaction = method.getAnnotation(Transaction.class);
            TransactionLevel transactionLevel2 = transactionLevel = transaction == null ? null : transaction.value();
            if (transactionLevel == null) continue;
            this.methods.put(method.getName(), method);
            this.allowGets.put(method, transactionLevel != TransactionLevel.READ_WRITE);
        }
    }

    public void handleRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        ServletServerHttpRequest servletServerHttpRequest = new ServletServerHttpRequest(httpServletRequest);
        Object object = null;
        Throwable throwable = null;
        WebRpcRequest webRpcRequest = null;
        try {
            webRpcRequest = this.readRequest(servletServerHttpRequest);
        }
        catch (IOException | RuntimeException exception) {
            LOG.error("Error reading the WEB-RPC request", (Throwable)exception);
            throwable = exception;
        }
        if (throwable == null) {
            try {
                object = webRpcRequest.getMethod().invoke(this.service, webRpcRequest.getParameters());
            }
            catch (Throwable throwable2) {
                throwable = this.translate(throwable2);
            }
        }
        httpServletResponse.setStatus(throwable == null ? 200 : WebRpcRequestHandler.resolveStatusCode(throwable));
        httpServletResponse.setContentType(ContentType.JSON.getMimeType());
        httpServletResponse.setCharacterEncoding("UTF-8");
        this.writeOut(webRpcRequest, object, throwable, (OutputStream)httpServletResponse.getOutputStream());
    }

    protected void writeOut(WebRpcRequest webRpcRequest, Object object, Throwable throwable, OutputStream outputStream) throws IOException {
        if (throwable != null) {
            this.contentHandler.writeError(webRpcRequest, throwable, outputStream);
        } else {
            this.contentHandler.writeResponse(webRpcRequest, object, outputStream);
        }
    }

    private WebRpcRequest readRequest(ServletServerHttpRequest servletServerHttpRequest) throws IOException {
        boolean bl;
        HttpServletRequest httpServletRequest = servletServerHttpRequest.getServletRequest();
        String string = servletServerHttpRequest.getURI().toString();
        int n = string.indexOf(ROOT_PATH);
        if (n < 0) {
            throw new InvalidRequestException("Not a web-rpc request");
        }
        HttpMethod httpMethod = servletServerHttpRequest.getMethod();
        boolean bl2 = httpMethod == HttpMethod.GET;
        boolean bl3 = httpMethod == HttpMethod.POST;
        InputStream inputStream = servletServerHttpRequest.getBody();
        Object object = StringUtils.removeEnd((String)StringUtils.substringAfter((String)StringUtils.substringBefore((String)string, (String)"?"), (String)ROOT_PATH), (String)"/") + "/";
        int n2 = ((String)object).indexOf(47);
        object = ((String)object).substring(n2 + 1);
        n2 = ((String)object).indexOf(47);
        String string2 = n2 < 0 ? null : ((String)object).substring(0, n2);
        object = StringUtils.strip((String)((String)object).substring(n2 + 1), (String)"/");
        if (string2 == null) {
            if (!bl3) {
                throw new InvalidRequestException("Invalid HTTP method. Allowed: POST");
            }
            return this.contentHandler.readRequest(this.serviceInterface, inputStream);
        }
        Method method = this.methods.get(string2);
        if (method == null && (method = this.methods.get("get" + StringUtils.capitalize((String)string2))) == null) {
            throw new InvalidOperationException(this.serviceInterface, string2);
        }
        boolean bl4 = Boolean.TRUE.equals(this.allowGets.get(method));
        if (!(bl4 && bl2 || bl3)) {
            throw new InvalidRequestException("Invalid HTTP method. Allowed: " + (bl4 ? "GET, POST" : "POST"));
        }
        Type[] typeArray = method.getGenericParameterTypes();
        boolean bl5 = bl = typeArray.length > 1;
        if (bl3) {
            String string3 = (String)ObjectHelper.defaultValue((Object)StringUtils.lowerCase((String)httpServletRequest.getContentType()), (Object)ContentType.JSON.getMimeType());
            String string4 = StringUtils.substringBefore((String)string3, (String)";");
            if (!bl && PARAM_ENCODINGS.contains(string4)) {
                return this.contentHandler.readRequest(this.serviceInterface, method, httpServletRequest.getParameterMap());
            }
            return this.contentHandler.readRequest(this.serviceInterface, method, inputStream);
        }
        if (bl2 && !((String)object).isEmpty()) {
            List list = StringHelper.splitTrimming((String)object, (String)"/");
            if (list.size() != typeArray.length) {
                throw new InvalidParametersException(typeArray, list.size());
            }
            Object[] objectArray = new Object[typeArray.length];
            for (int i = 0; i < typeArray.length; ++i) {
                objectArray[i] = this.contentHandler.parseArgument(this.serviceInterface, method, i, (String)list.get(i));
            }
            return new WebRpcRequest(method, objectArray);
        }
        if (bl2 && !bl) {
            return this.contentHandler.readRequest(this.serviceInterface, method, httpServletRequest.getParameterMap());
        }
        throw new InvalidRequestException("Invalid web-rpc request");
    }

    private Throwable translate(Throwable throwable) {
        if (throwable instanceof InvocationTargetException) {
            throwable = ((InvocationTargetException)throwable).getTargetException();
        }
        if (throwable instanceof DataAccessException) {
            return (Throwable)ClassHelper.convert((Object)throwable, throwable.getClass());
        }
        return throwable;
    }
}

