/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rpc;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.cyclos.services.RemotePath;
import org.cyclos.web.root.RequestServiceFactoryBean;
import org.cyclos.web.rpc.WebRpcContentHandler;
import org.cyclos.web.rpc.WebRpcRequestHandler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.handler.AbstractUrlHandlerMapping;

@Component
public class WebRpcServiceExporter
extends AbstractUrlHandlerMapping {
    @Autowired
    private WebRpcContentHandler contentHandler;

    @PostConstruct
    public void initialize() {
        HashSet<ApplicationContext> hashSet = new HashSet<ApplicationContext>();
        for (ApplicationContext applicationContext = this.getApplicationContext(); applicationContext != null && !hashSet.contains(applicationContext); applicationContext = applicationContext.getParent()) {
            this.exportServices(applicationContext);
            hashSet.add(applicationContext);
        }
    }

    protected <T> void exportService(String string, Class<T> clazz, T t) {
        WebRpcRequestHandler<T> webRpcRequestHandler = new WebRpcRequestHandler<T>(clazz, t, this.contentHandler);
        String string2 = "/web-rpc/";
        this.registerHandler(string2 + string, webRpcRequestHandler);
        this.registerHandler(string2 + string + "/**", webRpcRequestHandler);
        String string3 = StringUtils.removeEnd((String)string, (String)"Service");
        this.registerHandler(string2 + string3, webRpcRequestHandler);
        this.registerHandler(string2 + string3 + "/**", webRpcRequestHandler);
        String string4 = string3 + "s";
        this.registerHandler(string2 + string4, webRpcRequestHandler);
        this.registerHandler(string2 + string4 + "/**", webRpcRequestHandler);
        List list = ClassUtils.getAllInterfaces(t.getClass());
        for (Class clazz2 : list) {
            RemotePath remotePath = clazz2.getAnnotation(RemotePath.class);
            if (remotePath == null) continue;
            this.registerHandler(string2 + "/" + remotePath.value(), webRpcRequestHandler);
            this.registerHandler(string2 + "/" + remotePath.value() + "/**", webRpcRequestHandler);
        }
    }

    protected void exportServices(ApplicationContext applicationContext) {
        Map map = applicationContext.getBeansOfType(RequestServiceFactoryBean.class, false, false);
        for (Map.Entry entry : map.entrySet()) {
            String string = (String)entry.getKey();
            if (string.startsWith("&")) {
                string = string.substring(1);
            }
            if (string.startsWith("internal")) continue;
            RequestServiceFactoryBean requestServiceFactoryBean = (RequestServiceFactoryBean)entry.getValue();
            this.exportService(string, requestServiceFactoryBean.getServiceInterface(), requestServiceFactoryBean.getObject());
        }
    }
}

