/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.model.access;

import org.cyclos.model.general.GeneralKeys;
import org.cyclos.model.system.SystemKeys;
import org.cyclos.utils.EnumMessageKeyResolver;
import org.cyclos.utils.HasMessageKey;
import org.cyclos.utils.MessageKey;

public enum CredentialType implements HasMessageKey
{
    PASSWORD,
    DEVICE,
    TOTP,
    PIN;


    public static EnumMessageKeyResolver<CredentialType> resolverForChannelConfiguration() {
        return credentialType -> {
            switch (credentialType.ordinal()) {
                case 1: {
                    return SystemKeys.ChannelConfigurations.CREDENTIALS_DEVICE;
                }
                case 0: {
                    return SystemKeys.ChannelConfigurations.CREDENTIALS_PASSWORD;
                }
                case 2: {
                    return SystemKeys.ChannelConfigurations.CREDENTIALS_TOTP;
                }
            }
            return null;
        };
    }

    public static EnumMessageKeyResolver<CredentialType> resolverForConfirmationText() {
        return credentialType -> {
            switch (credentialType.ordinal()) {
                case 1: {
                    return GeneralKeys.Ui.ACTION_CONFIRMATION_MODE_DEVICE;
                }
                case 0: {
                    return GeneralKeys.Ui.ACTION_CONFIRMATION_MODE_PASSWORD;
                }
                case 2: {
                    return GeneralKeys.Ui.ACTION_CONFIRMATION_MODE_TOTP;
                }
            }
            return null;
        };
    }

    @Override
    public MessageKey getMessageKey() {
        switch (this.ordinal()) {
            case 1: {
                return GeneralKeys.Ui.ACTION_CONFIRMATION_MODE_DEVICE;
            }
            case 0: {
                return GeneralKeys.Ui.ACTION_CONFIRMATION_MODE_PASSWORD;
            }
            case 2: {
                return GeneralKeys.Ui.ACTION_CONFIRMATION_MODE_TOTP;
            }
        }
        throw new IllegalStateException();
    }

    public boolean isManualInput() {
        return this != DEVICE;
    }
}

