/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.model.access;

import org.cyclos.model.access.SecurityElement;
import org.cyclos.model.users.UsersKeys;
import org.cyclos.utils.EnumMessageKeyResolver;

public enum Role implements SecurityElement
{
    ADMIN,
    GLOBAL_ADMIN,
    NETWORK_ADMIN,
    BROKER,
    MEMBER,
    OPERATOR,
    ALIAS_OPERATOR,
    RESTRICTED_OPERATOR;

    private static EnumMessageKeyResolver<Role> resolverForConnectedUsers;

    public static Role[] basic() {
        return new Role[]{ADMIN, BROKER, MEMBER, OPERATOR};
    }

    public static EnumMessageKeyResolver<Role> resolverForConnectedUsers() {
        if (resolverForConnectedUsers == null) {
            resolverForConnectedUsers = role -> {
                switch (role.ordinal()) {
                    case 0: 
                    case 1: 
                    case 2: {
                        return UsersKeys.Users.SHOW_CONNECTED_ADMIN;
                    }
                    case 3: {
                        return UsersKeys.Users.SHOW_CONNECTED_BROKER;
                    }
                    case 4: {
                        return UsersKeys.Users.SHOW_CONNECTED_MEMBER;
                    }
                    case 5: 
                    case 6: 
                    case 7: {
                        return UsersKeys.Users.SHOW_CONNECTED_OPERATOR;
                    }
                }
                return null;
            };
        }
        return resolverForConnectedUsers;
    }

    public static Role[] userManager() {
        return new Role[]{ADMIN, BROKER};
    }

    public boolean isBasic() {
        return this == ADMIN || this == BROKER || this == MEMBER || this == OPERATOR;
    }

    public boolean isUserManager() {
        return this == ADMIN || this == BROKER;
    }
}

