/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.model.access.identityproviders;

import org.cyclos.model.access.AccessKeys;
import org.cyclos.model.access.identityproviders.IdentityProviderColors;
import org.cyclos.model.access.identityproviders.IdentityProviderProtocol;
import org.cyclos.utils.HasMessageKey;
import org.cyclos.utils.MessageKey;

public enum IdentityProviderType implements HasMessageKey
{
    GOOGLE(IdentityProviderColors.google(), "https://accounts.google.com/.well-known/openid-configuration"),
    FACEBOOK(IdentityProviderColors.facebook()),
    TWITTER(IdentityProviderColors.twitter()),
    LINKED_IN(IdentityProviderColors.linkedIn()),
    MICROSOFT(IdentityProviderColors.microsoft()),
    YAHOO(IdentityProviderColors.yahoo(), "https://login.yahoo.com/.well-known/openid-configuration"),
    OIDC(IdentityProviderColors.oidc(), null);

    private final IdentityProviderProtocol protocol;
    private final IdentityProviderColors colors;
    private final String discoveryUrl;

    private IdentityProviderType(IdentityProviderColors identityProviderColors) {
        this.protocol = IdentityProviderProtocol.OAUTH;
        this.colors = identityProviderColors;
        this.discoveryUrl = null;
    }

    private IdentityProviderType(IdentityProviderColors identityProviderColors, String string2) {
        this.protocol = IdentityProviderProtocol.OIDC;
        this.colors = identityProviderColors;
        this.discoveryUrl = string2;
    }

    public String getBackgroundColor() {
        return this.colors == null ? null : this.colors.getBackground();
    }

    public String getBorderColor() {
        return this.colors == null ? null : this.colors.getBorder();
    }

    public String getDiscoveryUrl() {
        return this.discoveryUrl;
    }

    @Override
    public MessageKey getMessageKey() {
        switch (this.ordinal()) {
            case 1: {
                return AccessKeys.IdentityProviders.TYPE_FACEBOOK;
            }
            case 0: {
                return AccessKeys.IdentityProviders.TYPE_GOOGLE;
            }
            case 3: {
                return AccessKeys.IdentityProviders.TYPE_LINKED_IN;
            }
            case 6: {
                return AccessKeys.IdentityProviders.TYPE_OIDC;
            }
            case 2: {
                return AccessKeys.IdentityProviders.TYPE_TWITTER;
            }
            case 4: {
                return AccessKeys.IdentityProviders.TYPE_MICROSOFT;
            }
            case 5: {
                return AccessKeys.IdentityProviders.TYPE_YAHOO;
            }
        }
        return null;
    }

    public IdentityProviderProtocol getProtocol() {
        return this.protocol;
    }

    public String getTextColor() {
        return this.colors == null ? null : this.colors.getText();
    }
}

