/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.model.access.passwords;

import java.util.EnumSet;
import org.cyclos.model.IllegalActionException;
import org.cyclos.model.access.AccessKeys;
import org.cyclos.model.access.passwords.PasswordStatus;
import org.cyclos.model.access.passwordtypes.PasswordMode;
import org.cyclos.utils.HasMessageKey;
import org.cyclos.utils.MessageKey;

public enum PasswordAction implements HasMessageKey
{
    ACTIVATE(EnumSet.of(PasswordMode.GENERATED), EnumSet.of(PasswordStatus.NEVER_CREATED, PasswordStatus.PENDING, PasswordStatus.EXPIRED, PasswordStatus.RESET)),
    ALLOW_ACTIVATION(EnumSet.of(PasswordMode.GENERATED), EnumSet.of(PasswordStatus.NEVER_CREATED)),
    CHANGE(EnumSet.of(PasswordMode.GENERATED, PasswordMode.MANUAL), EnumSet.of(PasswordStatus.ACTIVE, new PasswordStatus[]{PasswordStatus.NEVER_CREATED, PasswordStatus.EXPIRED, PasswordStatus.RESET, PasswordStatus.DISABLED, PasswordStatus.ACTIVE, PasswordStatus.TEMPORARILY_BLOCKED, PasswordStatus.INDEFINITELY_BLOCKED})),
    DISABLE(EnumSet.of(PasswordMode.GENERATED, PasswordMode.MANUAL, PasswordMode.OTP), EnumSet.of(PasswordStatus.ACTIVE, PasswordStatus.PENDING, PasswordStatus.NEVER_CREATED)),
    ENABLE(EnumSet.of(PasswordMode.GENERATED, PasswordMode.MANUAL, PasswordMode.OTP), EnumSet.of(PasswordStatus.DISABLED)),
    RESET(EnumSet.of(PasswordMode.GENERATED), EnumSet.of(PasswordStatus.DISABLED, new PasswordStatus[]{PasswordStatus.NEVER_CREATED, PasswordStatus.PENDING, PasswordStatus.ACTIVE, PasswordStatus.TEMPORARILY_BLOCKED, PasswordStatus.INDEFINITELY_BLOCKED})),
    RESET_AND_SEND(EnumSet.of(PasswordMode.GENERATED, PasswordMode.MANUAL), EnumSet.of(PasswordStatus.NEVER_CREATED, new PasswordStatus[]{PasswordStatus.DISABLED, PasswordStatus.PENDING, PasswordStatus.ACTIVE, PasswordStatus.TEMPORARILY_BLOCKED, PasswordStatus.INDEFINITELY_BLOCKED, PasswordStatus.EXPIRED, PasswordStatus.RESET})),
    UNBLOCK(EnumSet.of(PasswordMode.GENERATED, PasswordMode.MANUAL, PasswordMode.OTP), EnumSet.of(PasswordStatus.TEMPORARILY_BLOCKED, PasswordStatus.INDEFINITELY_BLOCKED));

    private final EnumSet<PasswordMode> allowedModes;
    private final EnumSet<PasswordStatus> allowedStatuses;

    private PasswordAction(EnumSet<PasswordMode> enumSet, EnumSet<PasswordStatus> enumSet2) {
        this.allowedModes = enumSet;
        this.allowedStatuses = enumSet2;
    }

    public boolean allowed(PasswordMode passwordMode) {
        return passwordMode != null && this.allowedModes.contains(passwordMode);
    }

    public boolean allowed(PasswordMode passwordMode, PasswordStatus passwordStatus) {
        return this.allowed(passwordStatus) && this.allowed(passwordMode);
    }

    public boolean allowed(PasswordStatus passwordStatus) {
        return passwordStatus != null && this.allowedStatuses.contains(passwordStatus);
    }

    public void checkAllowed(PasswordMode passwordMode) {
        if (!this.allowed(passwordMode)) {
            throw new IllegalActionException();
        }
    }

    public void checkAllowed(PasswordStatus passwordStatus) {
        if (!this.allowed(passwordStatus)) {
            throw new IllegalActionException();
        }
    }

    @Override
    public MessageKey getMessageKey() {
        switch (this.ordinal()) {
            case 0: {
                return AccessKeys.Passwords.ACTION_ACTIVATE;
            }
            case 1: {
                return AccessKeys.Passwords.ACTION_ALLOW_ACTIVATION;
            }
            case 2: {
                return AccessKeys.Passwords.ACTION_CHANGE;
            }
            case 3: {
                return AccessKeys.Passwords.ACTION_DISABLE;
            }
            case 4: {
                return AccessKeys.Passwords.ACTION_ENABLE;
            }
            case 5: {
                return AccessKeys.Passwords.ACTION_RESET;
            }
            case 6: {
                return AccessKeys.Passwords.ACTION_RESET_AND_SEND;
            }
            case 7: {
                return AccessKeys.Passwords.ACTION_UNBLOCK;
            }
        }
        return null;
    }
}

