/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.model.banking.transactions;

import org.cyclos.model.EntityVO;
import org.cyclos.model.access.devices.CreateDeviceConfirmationParams;
import org.cyclos.model.access.devices.DeviceConfirmationField;
import org.cyclos.model.access.devices.DeviceConfirmationFieldType;
import org.cyclos.model.access.devices.DeviceConfirmationType;
import org.cyclos.model.banking.transactions.PerformInternalTransactionDTO;
import org.cyclos.model.utils.DeviceConfirmationParamsBuilder;

public enum PerformPaymentConfirmationField implements DeviceConfirmationField
{
    FROM(DeviceConfirmationFieldType.ACCOUNT_OWNER),
    TO(DeviceConfirmationFieldType.ACCOUNT_OWNER),
    TYPE(DeviceConfirmationFieldType.PAYMENT_TYPE),
    AMOUNT(DeviceConfirmationFieldType.CURRENCY_AMOUNT);

    private DeviceConfirmationFieldType type;

    public static CreateDeviceConfirmationParams confirmation(PerformInternalTransactionDTO performInternalTransactionDTO) {
        return DeviceConfirmationParamsBuilder.builder(DeviceConfirmationType.PERFORM_PAYMENT).field((DeviceConfirmationField)FROM, performInternalTransactionDTO.getOwner()).field((DeviceConfirmationField)TO, performInternalTransactionDTO.getSubject()).field((DeviceConfirmationField)TYPE, (EntityVO)performInternalTransactionDTO.getType()).field((DeviceConfirmationField)AMOUNT, performInternalTransactionDTO.getAmount()).build();
    }

    private PerformPaymentConfirmationField(DeviceConfirmationFieldType deviceConfirmationFieldType) {
        this.type = deviceConfirmationFieldType;
    }

    @Override
    public DeviceConfirmationField[] dependOn() {
        if (this == AMOUNT) {
            return new DeviceConfirmationField[]{TYPE};
        }
        return DeviceConfirmationField.super.dependOn();
    }

    @Override
    public DeviceConfirmationFieldType type() {
        return this.type;
    }
}

