/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.model.banking.transactions;

import org.cyclos.model.banking.BankingKeys;
import org.cyclos.model.banking.transactions.TransactionStatus;
import org.cyclos.utils.MessageKey;

public enum TicketStatus implements TransactionStatus
{
    OPEN,
    APPROVED,
    PROCESSED,
    CANCELED,
    EXPIRED;


    @Override
    public MessageKey getMessageKey() {
        switch (this.ordinal()) {
            case 0: {
                return BankingKeys.Transactions.STATUS_OPEN;
            }
            case 1: {
                return BankingKeys.Transactions.STATUS_APPROVED;
            }
            case 2: {
                return BankingKeys.Transactions.STATUS_PROCESSED;
            }
            case 3: {
                return BankingKeys.Transactions.STATUS_CANCELED;
            }
            case 4: {
                return BankingKeys.Transactions.STATUS_EXPIRED;
            }
        }
        return null;
    }

    public boolean isFinal() {
        return this == PROCESSED || this == CANCELED || this == EXPIRED;
    }
}

