/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.model.messaging.notifications;

import org.cyclos.model.access.Role;
import org.cyclos.model.messaging.MessagingKeys;
import org.cyclos.model.messaging.notifications.AccountNotificationCategory;
import org.cyclos.model.messaging.notifications.NotificationEntityType;
import org.cyclos.model.messaging.notifications.NotificationRootType;
import org.cyclos.model.messaging.notifications.OperatorNotificationPropagation;
import org.cyclos.model.messaging.notifications.UserNotificationType;
import org.cyclos.utils.EnumMessageKeyResolver;
import org.cyclos.utils.MessageKey;

public enum AccountNotificationType implements UserNotificationType
{
    LIMIT_CHANGE(AccountNotificationCategory.ACCOUNT),
    TICKET_WEBHOOK_FAILED(AccountNotificationCategory.TICKET),
    SMS_PERFORMED_PAYMENT(AccountNotificationCategory.PERFORMED_TRANSACTION, OperatorNotificationPropagation.ALL_OPERATORS),
    ALL_NON_SMS_PERFORMED_PAYMENTS(AccountNotificationCategory.PERFORMED_TRANSACTION, OperatorNotificationPropagation.ALL_OPERATORS),
    PAYMENT_PERFORMED_CHARGED_BACK(AccountNotificationCategory.RECEIVED_TRANSACTION, OperatorNotificationPropagation.ALL_OPERATORS),
    PAYMENT_RECEIVED(AccountNotificationCategory.RECEIVED_TRANSACTION, OperatorNotificationPropagation.ALL_OPERATORS),
    PAYMENT_RECEIVED_CHARGED_BACK(AccountNotificationCategory.PERFORMED_TRANSACTION, OperatorNotificationPropagation.ALL_OPERATORS),
    PAYMENT_AWAITING_AUTHORIZATION(AccountNotificationCategory.ACCOUNT),
    AUTHORIZED_PAYMENT_CANCELED(AccountNotificationCategory.PERFORMED_TRANSACTION, OperatorNotificationPropagation.OPERATOR_AND_OWNER),
    AUTHORIZED_PAYMENT_DENIED(AccountNotificationCategory.PERFORMED_TRANSACTION, OperatorNotificationPropagation.OPERATOR_AND_OWNER),
    AUTHORIZED_PAYMENT_EXPIRED(AccountNotificationCategory.PERFORMED_TRANSACTION, OperatorNotificationPropagation.OPERATOR_AND_OWNER),
    AUTHORIZED_PAYMENT_SUCCEEDED(AccountNotificationCategory.PERFORMED_TRANSACTION, OperatorNotificationPropagation.OPERATOR_AND_OWNER),
    OPERATOR_AUTHORIZED_PAYMENT_CANCELED(AccountNotificationCategory.OPERATOR_AUTHORIZED_PAYMENT, OperatorNotificationPropagation.CUSTOM),
    OPERATOR_PAYMENT_AWAITING_AUTHORIZATION(AccountNotificationCategory.OPERATOR_AUTHORIZED_PAYMENT, OperatorNotificationPropagation.CUSTOM),
    OPERATOR_AUTHORIZED_PAYMENT_DENIED(AccountNotificationCategory.OPERATOR_AUTHORIZED_PAYMENT, OperatorNotificationPropagation.CUSTOM),
    OPERATOR_AUTHORIZED_PAYMENT_EXPIRED(AccountNotificationCategory.OPERATOR_AUTHORIZED_PAYMENT, OperatorNotificationPropagation.CUSTOM),
    OPERATOR_AUTHORIZED_PAYMENT_SUCCEEDED(AccountNotificationCategory.OPERATOR_AUTHORIZED_PAYMENT, OperatorNotificationPropagation.CUSTOM),
    OPERATOR_AUTHORIZED_PAYMENT_APPROVED_STILL_PENDING(AccountNotificationCategory.OPERATOR_AUTHORIZED_PAYMENT, OperatorNotificationPropagation.CUSTOM),
    RECURRING_PAYMENT_FAILED(AccountNotificationCategory.PERFORMED_TRANSACTION, OperatorNotificationPropagation.OPERATOR_AND_OWNER),
    RECURRING_PAYMENT_OCCURRENCE_PROCESSED(AccountNotificationCategory.PERFORMED_TRANSACTION, OperatorNotificationPropagation.OPERATOR_AND_OWNER),
    INCOMING_RECURRING_PAYMENT_RECEIVED(AccountNotificationCategory.RECEIVED_TRANSACTION, OperatorNotificationPropagation.ALL_OPERATORS),
    INCOMING_RECURRING_PAYMENT_FAILED(AccountNotificationCategory.RECEIVED_TRANSACTION, OperatorNotificationPropagation.OPERATOR_AND_OWNER),
    INCOMING_RECURRING_PAYMENT_CANCELED(AccountNotificationCategory.RECEIVED_TRANSACTION, OperatorNotificationPropagation.OPERATOR_AND_OWNER),
    SCHEDULED_PAYMENT_FAILED(AccountNotificationCategory.PERFORMED_TRANSACTION, OperatorNotificationPropagation.OPERATOR_AND_OWNER),
    SCHEDULED_PAYMENT_INSTALLMENT_PROCESSED(AccountNotificationCategory.PERFORMED_TRANSACTION, OperatorNotificationPropagation.OPERATOR_AND_OWNER),
    INCOMING_SCHEDULED_PAYMENT_RECEIVED(AccountNotificationCategory.RECEIVED_TRANSACTION, OperatorNotificationPropagation.ALL_OPERATORS),
    INCOMING_SCHEDULED_PAYMENT_FAILED(AccountNotificationCategory.RECEIVED_TRANSACTION, OperatorNotificationPropagation.OPERATOR_AND_OWNER),
    INCOMING_SCHEDULED_PAYMENT_CANCELED(AccountNotificationCategory.RECEIVED_TRANSACTION, OperatorNotificationPropagation.OPERATOR_AND_OWNER),
    PAYMENT_REQUEST_RECEIVED(AccountNotificationCategory.PERFORMED_TRANSACTION, OperatorNotificationPropagation.OPERATOR_AND_OWNER),
    PAYMENT_REQUEST_EXPIRATION_DATE_CHANGED(AccountNotificationCategory.PERFORMED_TRANSACTION, OperatorNotificationPropagation.OPERATOR_AND_OWNER),
    SENT_PAYMENT_REQUEST_EXPIRATION_DATE_CHANGED(AccountNotificationCategory.RECEIVED_TRANSACTION),
    PAYMENT_REQUEST_PROCESSED(AccountNotificationCategory.RECEIVED_TRANSACTION, OperatorNotificationPropagation.OPERATOR_AND_OWNER),
    PAYMENT_REQUEST_EXPIRED(AccountNotificationCategory.PERFORMED_TRANSACTION, OperatorNotificationPropagation.OPERATOR_AND_OWNER),
    PAYMENT_REQUEST_DENIED(AccountNotificationCategory.RECEIVED_TRANSACTION, OperatorNotificationPropagation.OPERATOR_AND_OWNER),
    PAYMENT_REQUEST_CANCELED(AccountNotificationCategory.PERFORMED_TRANSACTION, OperatorNotificationPropagation.OPERATOR_AND_OWNER),
    SCHEDULED_PAYMENT_REQUEST_FAILED(AccountNotificationCategory.PERFORMED_TRANSACTION, OperatorNotificationPropagation.OPERATOR_AND_OWNER),
    EXTERNAL_PAYMENT_PERFORMED_FAILED(AccountNotificationCategory.PERFORMED_TRANSACTION, OperatorNotificationPropagation.OPERATOR_AND_OWNER),
    EXTERNAL_PAYMENT_RECEIVED_FAILED(AccountNotificationCategory.RECEIVED_TRANSACTION, OperatorNotificationPropagation.OWNER_ONLY),
    EXTERNAL_PAYMENT_EXPIRED(AccountNotificationCategory.PERFORMED_TRANSACTION, OperatorNotificationPropagation.OPERATOR_AND_OWNER),
    VOUCHER_ABOUT_TO_EXPIRE(AccountNotificationCategory.VOUCHER),
    VOUCHER_EXPIRED(AccountNotificationCategory.VOUCHER),
    VOUCHER_ASSIGNED(AccountNotificationCategory.VOUCHER),
    VOUCHER_EXPIRATION_DATE_CHANGED(AccountNotificationCategory.VOUCHER),
    VOUCHER_REDEEM(AccountNotificationCategory.VOUCHER),
    VOUCHER_TOP_UP(AccountNotificationCategory.VOUCHER),
    VOUCHER_PIN_BLOCKED(AccountNotificationCategory.VOUCHER);

    private static EnumMessageKeyResolver<AccountNotificationType> resolverForSms;
    private static EnumMessageKeyResolver<AccountNotificationType> resolverForText;
    public static final String PREFIX;
    private final AccountNotificationCategory category;
    private final OperatorNotificationPropagation propagation;

    public static EnumMessageKeyResolver<AccountNotificationType> resolverForSms() {
        if (resolverForSms == null) {
            resolverForSms = accountNotificationType -> {
                switch (accountNotificationType.ordinal()) {
                    case 0: {
                        return MessagingKeys.Notifications.USER_LIMIT_CHANGE_SMS;
                    }
                    case 2: {
                        return MessagingKeys.Notifications.USER_SMS_PERFORMED_PAYMENT_SMS;
                    }
                    case 3: {
                        return MessagingKeys.Notifications.USER_ALL_NON_SMS_PERFORMED_PAYMENTS_SMS;
                    }
                    case 4: {
                        return MessagingKeys.Notifications.USER_PAYMENT_PERFORMED_CHARGED_BACK_SMS;
                    }
                    case 5: {
                        return MessagingKeys.Notifications.USER_PAYMENT_RECEIVED_SMS;
                    }
                    case 6: {
                        return MessagingKeys.Notifications.USER_PAYMENT_RECEIVED_CHARGED_BACK_SMS;
                    }
                    case 7: {
                        return MessagingKeys.Notifications.USER_PAYMENT_AWAITING_AUTHORIZATION_SMS;
                    }
                    case 1: {
                        return MessagingKeys.Notifications.USER_TICKET_WEBHOOK_FAILED_SMS;
                    }
                    case 8: {
                        return MessagingKeys.Notifications.USER_AUTHORIZED_PAYMENT_CANCELED_SMS;
                    }
                    case 9: {
                        return MessagingKeys.Notifications.USER_AUTHORIZED_PAYMENT_DENIED_SMS;
                    }
                    case 10: {
                        return MessagingKeys.Notifications.USER_AUTHORIZED_PAYMENT_EXPIRED_SMS;
                    }
                    case 11: {
                        return MessagingKeys.Notifications.USER_AUTHORIZED_PAYMENT_SUCCEEDED_SMS;
                    }
                    case 18: {
                        return MessagingKeys.Notifications.USER_RECURRING_PAYMENT_FAILED_SMS;
                    }
                    case 19: {
                        return MessagingKeys.Notifications.USER_RECURRING_PAYMENT_OCCURRENCE_PROCESSED_SMS;
                    }
                    case 20: {
                        return MessagingKeys.Notifications.USER_INCOMING_RECURRING_PAYMENT_RECEIVED_SMS;
                    }
                    case 21: {
                        return MessagingKeys.Notifications.USER_INCOMING_RECURRING_PAYMENT_FAILED_SMS;
                    }
                    case 22: {
                        return MessagingKeys.Notifications.USER_INCOMING_RECURRING_PAYMENT_CANCELED_SMS;
                    }
                    case 23: {
                        return MessagingKeys.Notifications.USER_SCHEDULED_PAYMENT_FAILED_SMS;
                    }
                    case 24: {
                        return MessagingKeys.Notifications.USER_SCHEDULED_PAYMENT_INSTALLMENT_PROCESSED_SMS;
                    }
                    case 25: {
                        return MessagingKeys.Notifications.USER_INCOMING_SCHEDULED_PAYMENT_RECEIVED_SMS;
                    }
                    case 26: {
                        return MessagingKeys.Notifications.USER_INCOMING_SCHEDULED_PAYMENT_FAILED_SMS;
                    }
                    case 27: {
                        return MessagingKeys.Notifications.USER_INCOMING_SCHEDULED_PAYMENT_CANCELED_SMS;
                    }
                    case 28: {
                        return MessagingKeys.Notifications.USER_PAYMENT_REQUEST_RECEIVED_SMS;
                    }
                    case 29: {
                        return MessagingKeys.Notifications.USER_PAYMENT_REQUEST_EXPIRATION_DATE_CHANGED_SMS;
                    }
                    case 30: {
                        return MessagingKeys.Notifications.USER_SENT_PAYMENT_REQUEST_EXPIRATION_DATE_CHANGED_SMS;
                    }
                    case 31: {
                        return MessagingKeys.Notifications.USER_PAYMENT_REQUEST_PROCESSED_SMS;
                    }
                    case 32: {
                        return MessagingKeys.Notifications.USER_PAYMENT_REQUEST_EXPIRED_SMS;
                    }
                    case 33: {
                        return MessagingKeys.Notifications.USER_PAYMENT_REQUEST_DENIED_SMS;
                    }
                    case 34: {
                        return MessagingKeys.Notifications.USER_PAYMENT_REQUEST_CANCELED_SMS;
                    }
                    case 35: {
                        return MessagingKeys.Notifications.USER_SCHEDULED_PAYMENT_REQUEST_FAILED_SMS;
                    }
                    case 36: {
                        return MessagingKeys.Notifications.USER_EXTERNAL_PAYMENT_PERFORMED_FAILED_SMS;
                    }
                    case 37: {
                        return MessagingKeys.Notifications.USER_EXTERNAL_PAYMENT_RECEIVED_FAILED_SMS;
                    }
                    case 38: {
                        return MessagingKeys.Notifications.USER_EXTERNAL_PAYMENT_EXPIRED_SMS;
                    }
                    case 13: {
                        return MessagingKeys.Notifications.USER_OPERATOR_PAYMENT_AWAITING_AUTHORIZATION_SMS;
                    }
                    case 17: {
                        return MessagingKeys.Notifications.USER_OPERATOR_AUTHORIZED_PAYMENT_APPROVED_STILL_PENDING_SMS;
                    }
                    case 12: {
                        return MessagingKeys.Notifications.USER_OPERATOR_AUTHORIZED_PAYMENT_CANCELED_SMS;
                    }
                    case 14: {
                        return MessagingKeys.Notifications.USER_OPERATOR_AUTHORIZED_PAYMENT_DENIED_SMS;
                    }
                    case 15: {
                        return MessagingKeys.Notifications.USER_OPERATOR_AUTHORIZED_PAYMENT_EXPIRED_SMS;
                    }
                    case 16: {
                        return MessagingKeys.Notifications.USER_OPERATOR_AUTHORIZED_PAYMENT_SUCCEEDED_SMS;
                    }
                    case 41: {
                        return MessagingKeys.Notifications.USER_VOUCHER_ASSIGNED_SMS;
                    }
                    case 39: {
                        return MessagingKeys.Notifications.USER_VOUCHER_ABOUT_TO_EXPIRE_SMS;
                    }
                    case 40: {
                        return MessagingKeys.Notifications.USER_VOUCHER_EXPIRED_SMS;
                    }
                    case 42: {
                        return MessagingKeys.Notifications.USER_VOUCHER_EXPIRATION_DATE_CHANGED_SMS;
                    }
                    case 45: {
                        return MessagingKeys.Notifications.USER_VOUCHER_PIN_BLOCKED_SMS;
                    }
                    case 43: {
                        return MessagingKeys.Notifications.USER_VOUCHER_REDEEM_SMS;
                    }
                    case 44: {
                        return MessagingKeys.Notifications.USER_VOUCHER_TOP_UP_SMS;
                    }
                }
                return null;
            };
        }
        return resolverForSms;
    }

    public static EnumMessageKeyResolver<AccountNotificationType> resolverForText() {
        if (resolverForText == null) {
            resolverForText = accountNotificationType -> {
                switch (accountNotificationType.ordinal()) {
                    case 0: {
                        return MessagingKeys.Notifications.USER_LIMIT_CHANGE_TEXT;
                    }
                    case 2: {
                        return MessagingKeys.Notifications.USER_SMS_PERFORMED_PAYMENT_TEXT;
                    }
                    case 3: {
                        return MessagingKeys.Notifications.USER_ALL_NON_SMS_PERFORMED_PAYMENTS_TEXT;
                    }
                    case 4: {
                        return MessagingKeys.Notifications.USER_PAYMENT_PERFORMED_CHARGED_BACK_TEXT;
                    }
                    case 5: {
                        return MessagingKeys.Notifications.USER_PAYMENT_RECEIVED_TEXT;
                    }
                    case 6: {
                        return MessagingKeys.Notifications.USER_PAYMENT_RECEIVED_CHARGED_BACK_TEXT;
                    }
                    case 7: {
                        return MessagingKeys.Notifications.USER_PAYMENT_AWAITING_AUTHORIZATION_TEXT;
                    }
                    case 1: {
                        return MessagingKeys.Notifications.USER_TICKET_WEBHOOK_FAILED_TEXT;
                    }
                    case 8: {
                        return MessagingKeys.Notifications.USER_AUTHORIZED_PAYMENT_CANCELED_TEXT;
                    }
                    case 9: {
                        return MessagingKeys.Notifications.USER_AUTHORIZED_PAYMENT_DENIED_TEXT;
                    }
                    case 10: {
                        return MessagingKeys.Notifications.USER_AUTHORIZED_PAYMENT_EXPIRED_TEXT;
                    }
                    case 11: {
                        return MessagingKeys.Notifications.USER_AUTHORIZED_PAYMENT_SUCCEEDED_TEXT;
                    }
                    case 18: {
                        return MessagingKeys.Notifications.USER_RECURRING_PAYMENT_FAILED_TEXT;
                    }
                    case 19: {
                        return MessagingKeys.Notifications.USER_RECURRING_PAYMENT_OCCURRENCE_PROCESSED_TEXT;
                    }
                    case 20: {
                        return MessagingKeys.Notifications.USER_INCOMING_RECURRING_PAYMENT_RECEIVED_TEXT;
                    }
                    case 21: {
                        return MessagingKeys.Notifications.USER_INCOMING_RECURRING_PAYMENT_FAILED_TEXT;
                    }
                    case 22: {
                        return MessagingKeys.Notifications.USER_INCOMING_RECURRING_PAYMENT_CANCELED_TEXT;
                    }
                    case 23: {
                        return MessagingKeys.Notifications.USER_SCHEDULED_PAYMENT_FAILED_TEXT;
                    }
                    case 24: {
                        return MessagingKeys.Notifications.USER_SCHEDULED_PAYMENT_INSTALLMENT_PROCESSED_TEXT;
                    }
                    case 25: {
                        return MessagingKeys.Notifications.USER_INCOMING_SCHEDULED_PAYMENT_RECEIVED_TEXT;
                    }
                    case 26: {
                        return MessagingKeys.Notifications.USER_INCOMING_SCHEDULED_PAYMENT_FAILED_TEXT;
                    }
                    case 27: {
                        return MessagingKeys.Notifications.USER_INCOMING_SCHEDULED_PAYMENT_CANCELED_TEXT;
                    }
                    case 28: {
                        return MessagingKeys.Notifications.USER_PAYMENT_REQUEST_RECEIVED_TEXT;
                    }
                    case 29: {
                        return MessagingKeys.Notifications.USER_PAYMENT_REQUEST_EXPIRATION_DATE_CHANGED_TEXT;
                    }
                    case 30: {
                        return MessagingKeys.Notifications.USER_SENT_PAYMENT_REQUEST_EXPIRATION_DATE_CHANGED_TEXT;
                    }
                    case 31: {
                        return MessagingKeys.Notifications.USER_PAYMENT_REQUEST_PROCESSED_TEXT;
                    }
                    case 32: {
                        return MessagingKeys.Notifications.USER_PAYMENT_REQUEST_EXPIRED_TEXT;
                    }
                    case 33: {
                        return MessagingKeys.Notifications.USER_PAYMENT_REQUEST_DENIED_TEXT;
                    }
                    case 34: {
                        return MessagingKeys.Notifications.USER_PAYMENT_REQUEST_CANCELED_TEXT;
                    }
                    case 35: {
                        return MessagingKeys.Notifications.USER_SCHEDULED_PAYMENT_REQUEST_FAILED_TEXT;
                    }
                    case 36: {
                        return MessagingKeys.Notifications.USER_EXTERNAL_PAYMENT_PERFORMED_FAILED_TEXT;
                    }
                    case 37: {
                        return MessagingKeys.Notifications.USER_EXTERNAL_PAYMENT_RECEIVED_FAILED_TEXT;
                    }
                    case 38: {
                        return MessagingKeys.Notifications.USER_EXTERNAL_PAYMENT_EXPIRED_TEXT;
                    }
                    case 13: {
                        return MessagingKeys.Notifications.USER_OPERATOR_PAYMENT_AWAITING_AUTHORIZATION_TEXT;
                    }
                    case 17: {
                        return MessagingKeys.Notifications.USER_OPERATOR_AUTHORIZED_PAYMENT_APPROVED_STILL_PENDING_TEXT;
                    }
                    case 12: {
                        return MessagingKeys.Notifications.USER_OPERATOR_AUTHORIZED_PAYMENT_CANCELED_TEXT;
                    }
                    case 14: {
                        return MessagingKeys.Notifications.USER_OPERATOR_AUTHORIZED_PAYMENT_DENIED_TEXT;
                    }
                    case 15: {
                        return MessagingKeys.Notifications.USER_OPERATOR_AUTHORIZED_PAYMENT_EXPIRED_TEXT;
                    }
                    case 16: {
                        return MessagingKeys.Notifications.USER_OPERATOR_AUTHORIZED_PAYMENT_SUCCEEDED_TEXT;
                    }
                    case 41: {
                        return MessagingKeys.Notifications.USER_VOUCHER_ASSIGNED_TEXT;
                    }
                    case 39: {
                        return MessagingKeys.Notifications.USER_VOUCHER_ABOUT_TO_EXPIRE_TEXT;
                    }
                    case 40: {
                        return MessagingKeys.Notifications.USER_VOUCHER_EXPIRED_TEXT;
                    }
                    case 42: {
                        return MessagingKeys.Notifications.USER_VOUCHER_EXPIRATION_DATE_CHANGED_TEXT;
                    }
                    case 45: {
                        return MessagingKeys.Notifications.USER_VOUCHER_PIN_BLOCKED_TEXT;
                    }
                    case 43: {
                        return MessagingKeys.Notifications.USER_VOUCHER_REDEEM_TEXT;
                    }
                    case 44: {
                        return MessagingKeys.Notifications.USER_VOUCHER_TOP_UP_TEXT;
                    }
                }
                return null;
            };
        }
        return resolverForText;
    }

    private AccountNotificationType(AccountNotificationCategory accountNotificationCategory) {
        this(accountNotificationCategory, OperatorNotificationPropagation.OWNER_ONLY);
    }

    private AccountNotificationType(AccountNotificationCategory accountNotificationCategory, OperatorNotificationPropagation operatorNotificationPropagation) {
        this.category = accountNotificationCategory;
        this.propagation = operatorNotificationPropagation;
    }

    public AccountNotificationCategory getCategory() {
        return this.category;
    }

    @Override
    public MessageKey getKeyForSms() {
        return AccountNotificationType.resolverForSms().resolveKey(this);
    }

    @Override
    public MessageKey getKeyForText() {
        return AccountNotificationType.resolverForText().resolveKey(this);
    }

    @Override
    public MessageKey getMessageKey() {
        switch (this.ordinal()) {
            case 0: {
                return MessagingKeys.Notifications.USER_LIMIT_CHANGE;
            }
            case 2: {
                return MessagingKeys.Notifications.USER_SMS_PERFORMED_PAYMENT;
            }
            case 3: {
                return MessagingKeys.Notifications.USER_ALL_NON_SMS_PERFORMED_PAYMENTS;
            }
            case 4: {
                return MessagingKeys.Notifications.USER_PAYMENT_PERFORMED_CHARGED_BACK;
            }
            case 5: {
                return MessagingKeys.Notifications.USER_PAYMENT_RECEIVED;
            }
            case 6: {
                return MessagingKeys.Notifications.USER_PAYMENT_RECEIVED_CHARGED_BACK;
            }
            case 7: {
                return MessagingKeys.Notifications.USER_PAYMENT_AWAITING_AUTHORIZATION;
            }
            case 1: {
                return MessagingKeys.Notifications.USER_TICKET_WEBHOOK_FAILED;
            }
            case 8: {
                return MessagingKeys.Notifications.USER_AUTHORIZED_PAYMENT_CANCELED;
            }
            case 9: {
                return MessagingKeys.Notifications.USER_AUTHORIZED_PAYMENT_DENIED;
            }
            case 10: {
                return MessagingKeys.Notifications.USER_AUTHORIZED_PAYMENT_EXPIRED;
            }
            case 11: {
                return MessagingKeys.Notifications.USER_AUTHORIZED_PAYMENT_SUCCEEDED;
            }
            case 18: {
                return MessagingKeys.Notifications.USER_RECURRING_PAYMENT_FAILED;
            }
            case 19: {
                return MessagingKeys.Notifications.USER_RECURRING_PAYMENT_OCCURRENCE_PROCESSED;
            }
            case 20: {
                return MessagingKeys.Notifications.USER_INCOMING_RECURRING_PAYMENT_RECEIVED;
            }
            case 21: {
                return MessagingKeys.Notifications.USER_INCOMING_RECURRING_PAYMENT_FAILED;
            }
            case 22: {
                return MessagingKeys.Notifications.USER_INCOMING_RECURRING_PAYMENT_CANCELED;
            }
            case 23: {
                return MessagingKeys.Notifications.USER_SCHEDULED_PAYMENT_FAILED;
            }
            case 24: {
                return MessagingKeys.Notifications.USER_SCHEDULED_PAYMENT_INSTALLMENT_PROCESSED;
            }
            case 25: {
                return MessagingKeys.Notifications.USER_INCOMING_SCHEDULED_PAYMENT_RECEIVED;
            }
            case 26: {
                return MessagingKeys.Notifications.USER_INCOMING_SCHEDULED_PAYMENT_FAILED;
            }
            case 27: {
                return MessagingKeys.Notifications.USER_INCOMING_SCHEDULED_PAYMENT_CANCELED;
            }
            case 28: {
                return MessagingKeys.Notifications.USER_PAYMENT_REQUEST_RECEIVED;
            }
            case 29: {
                return MessagingKeys.Notifications.USER_PAYMENT_REQUEST_EXPIRATION_DATE_CHANGED;
            }
            case 30: {
                return MessagingKeys.Notifications.USER_SENT_PAYMENT_REQUEST_EXPIRATION_DATE_CHANGED;
            }
            case 31: {
                return MessagingKeys.Notifications.USER_PAYMENT_REQUEST_PROCESSED;
            }
            case 32: {
                return MessagingKeys.Notifications.USER_PAYMENT_REQUEST_EXPIRED;
            }
            case 33: {
                return MessagingKeys.Notifications.USER_PAYMENT_REQUEST_DENIED;
            }
            case 34: {
                return MessagingKeys.Notifications.USER_PAYMENT_REQUEST_CANCELED;
            }
            case 35: {
                return MessagingKeys.Notifications.USER_SCHEDULED_PAYMENT_REQUEST_FAILED;
            }
            case 36: {
                return MessagingKeys.Notifications.USER_EXTERNAL_PAYMENT_PERFORMED_FAILED;
            }
            case 37: {
                return MessagingKeys.Notifications.USER_EXTERNAL_PAYMENT_RECEIVED_FAILED;
            }
            case 38: {
                return MessagingKeys.Notifications.USER_EXTERNAL_PAYMENT_EXPIRED;
            }
            case 13: {
                return MessagingKeys.Notifications.USER_OPERATOR_PAYMENT_AWAITING_AUTHORIZATION;
            }
            case 17: {
                return MessagingKeys.Notifications.USER_OPERATOR_AUTHORIZED_PAYMENT_APPROVED_STILL_PENDING;
            }
            case 12: {
                return MessagingKeys.Notifications.USER_OPERATOR_AUTHORIZED_PAYMENT_CANCELED;
            }
            case 14: {
                return MessagingKeys.Notifications.USER_OPERATOR_AUTHORIZED_PAYMENT_DENIED;
            }
            case 15: {
                return MessagingKeys.Notifications.USER_OPERATOR_AUTHORIZED_PAYMENT_EXPIRED;
            }
            case 16: {
                return MessagingKeys.Notifications.USER_OPERATOR_AUTHORIZED_PAYMENT_SUCCEEDED;
            }
            case 41: {
                return MessagingKeys.Notifications.USER_VOUCHER_ASSIGNED;
            }
            case 39: {
                return MessagingKeys.Notifications.USER_VOUCHER_ABOUT_TO_EXPIRE;
            }
            case 40: {
                return MessagingKeys.Notifications.USER_VOUCHER_EXPIRED;
            }
            case 42: {
                return MessagingKeys.Notifications.USER_VOUCHER_EXPIRATION_DATE_CHANGED;
            }
            case 45: {
                return MessagingKeys.Notifications.USER_VOUCHER_PIN_BLOCKED;
            }
            case 43: {
                return MessagingKeys.Notifications.USER_VOUCHER_REDEEM;
            }
            case 44: {
                return MessagingKeys.Notifications.USER_VOUCHER_TOP_UP;
            }
        }
        return null;
    }

    @Override
    public NotificationEntityType getNotificationEntityType() {
        switch (this.ordinal()) {
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                return NotificationEntityType.TRANSACTION;
            }
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 45: {
                return NotificationEntityType.VOUCHER;
            }
            case 43: 
            case 44: {
                return NotificationEntityType.VOUCHER_TRANSACTION;
            }
            case 4: 
            case 5: 
            case 6: 
            case 19: {
                return NotificationEntityType.TRANSFER;
            }
            case 0: {
                return NotificationEntityType.ACCOUNT;
            }
        }
        return null;
    }

    @Override
    public OperatorNotificationPropagation getPropagation() {
        return this.propagation;
    }

    @Override
    public Role getRole() {
        return Role.MEMBER;
    }

    @Override
    public NotificationRootType getRootType() {
        return NotificationRootType.ACCOUNT;
    }

    public String prefix() {
        return PREFIX;
    }

    static {
        PREFIX = NotificationRootType.ACCOUNT.name();
    }
}

