/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.model.messaging.notifications;

import org.cyclos.model.access.Role;
import org.cyclos.model.messaging.MessagingKeys;
import org.cyclos.model.messaging.notifications.NotificationEntityType;
import org.cyclos.model.messaging.notifications.NotificationRootType;
import org.cyclos.model.messaging.notifications.OperatorNotificationPropagation;
import org.cyclos.model.messaging.notifications.UserNotificationType;
import org.cyclos.utils.EnumMessageKeyResolver;
import org.cyclos.utils.MessageKey;

public enum PersonalNotificationType implements UserNotificationType
{
    PASSWORD_STATUS_CHANGED(OperatorNotificationPropagation.DESTINATION_ONLY),
    USER_STATUS_CHANGED(OperatorNotificationPropagation.DESTINATION_ONLY),
    NEW_TOKEN(OperatorNotificationPropagation.DESTINATION_ONLY),
    NEW_TOKEN_PENDING_ACTIVATION(OperatorNotificationPropagation.DESTINATION_ONLY),
    TOKEN_STATUS_CHANGED(OperatorNotificationPropagation.DESTINATION_ONLY),
    BROKER_UNASSIGNED(OperatorNotificationPropagation.OWNER_ONLY),
    BROKER_ASSIGNED(OperatorNotificationPropagation.OWNER_ONLY),
    MAX_SMS_PER_MONTH_REACHED(OperatorNotificationPropagation.OWNER_ONLY);

    private static EnumMessageKeyResolver<PersonalNotificationType> resolverForSms;
    private static EnumMessageKeyResolver<PersonalNotificationType> resolverForText;
    public static final String PREFIX;
    private final OperatorNotificationPropagation propagation;

    public static EnumMessageKeyResolver<PersonalNotificationType> resolverForSms() {
        if (resolverForSms == null) {
            resolverForSms = personalNotificationType -> {
                switch (personalNotificationType.ordinal()) {
                    case 7: {
                        return MessagingKeys.Notifications.USER_MAX_SMS_PER_MONTH_REACHED_SMS;
                    }
                    case 0: {
                        return MessagingKeys.Notifications.USER_PASSWORD_STATUS_CHANGED_SMS;
                    }
                    case 5: {
                        return MessagingKeys.Notifications.USER_BROKER_UNASSIGNED_SMS;
                    }
                    case 6: {
                        return MessagingKeys.Notifications.USER_BROKER_ASSIGNED_SMS;
                    }
                    case 1: {
                        return MessagingKeys.Notifications.USER_USER_STATUS_CHANGED_SMS;
                    }
                    case 2: {
                        return MessagingKeys.Notifications.USER_NEW_TOKEN_SMS;
                    }
                    case 3: {
                        return MessagingKeys.Notifications.USER_NEW_TOKEN_PENDING_ACTIVATION_SMS;
                    }
                    case 4: {
                        return MessagingKeys.Notifications.USER_TOKEN_STATUS_CHANGED_SMS;
                    }
                }
                return null;
            };
        }
        return resolverForSms;
    }

    public static EnumMessageKeyResolver<PersonalNotificationType> resolverForText() {
        if (resolverForText == null) {
            resolverForText = personalNotificationType -> {
                switch (personalNotificationType.ordinal()) {
                    case 7: {
                        return MessagingKeys.Notifications.USER_MAX_SMS_PER_MONTH_REACHED_TEXT;
                    }
                    case 0: {
                        return MessagingKeys.Notifications.USER_PASSWORD_STATUS_CHANGED_TEXT;
                    }
                    case 5: {
                        return MessagingKeys.Notifications.USER_BROKER_UNASSIGNED_TEXT;
                    }
                    case 6: {
                        return MessagingKeys.Notifications.USER_BROKER_ASSIGNED_TEXT;
                    }
                    case 1: {
                        return MessagingKeys.Notifications.USER_USER_STATUS_CHANGED_TEXT;
                    }
                    case 2: {
                        return MessagingKeys.Notifications.USER_NEW_TOKEN_TEXT;
                    }
                    case 3: {
                        return MessagingKeys.Notifications.USER_NEW_TOKEN_PENDING_ACTIVATION_TEXT;
                    }
                    case 4: {
                        return MessagingKeys.Notifications.USER_TOKEN_STATUS_CHANGED_TEXT;
                    }
                }
                return null;
            };
        }
        return resolverForText;
    }

    private PersonalNotificationType(OperatorNotificationPropagation operatorNotificationPropagation) {
        this.propagation = operatorNotificationPropagation;
    }

    @Override
    public MessageKey getKeyForSms() {
        return PersonalNotificationType.resolverForSms().resolveKey(this);
    }

    @Override
    public MessageKey getKeyForText() {
        return PersonalNotificationType.resolverForText().resolveKey(this);
    }

    @Override
    public MessageKey getMessageKey() {
        switch (this.ordinal()) {
            case 7: {
                return MessagingKeys.Notifications.USER_MAX_SMS_PER_MONTH_REACHED;
            }
            case 0: {
                return MessagingKeys.Notifications.USER_PASSWORD_STATUS_CHANGED;
            }
            case 5: {
                return MessagingKeys.Notifications.USER_BROKER_UNASSIGNED;
            }
            case 6: {
                return MessagingKeys.Notifications.USER_BROKER_ASSIGNED;
            }
            case 1: {
                return MessagingKeys.Notifications.USER_USER_STATUS_CHANGED;
            }
            case 2: {
                return MessagingKeys.Notifications.USER_NEW_TOKEN;
            }
            case 3: {
                return MessagingKeys.Notifications.USER_NEW_TOKEN_PENDING_ACTIVATION;
            }
            case 4: {
                return MessagingKeys.Notifications.USER_TOKEN_STATUS_CHANGED;
            }
        }
        return null;
    }

    @Override
    public NotificationEntityType getNotificationEntityType() {
        switch (this.ordinal()) {
            case 1: 
            case 5: 
            case 6: 
            case 7: {
                return NotificationEntityType.USER;
            }
            case 2: 
            case 3: 
            case 4: {
                return NotificationEntityType.TOKEN;
            }
            case 0: {
                return NotificationEntityType.PASSWORD_TYPE;
            }
        }
        return null;
    }

    @Override
    public OperatorNotificationPropagation getPropagation() {
        return this.propagation;
    }

    @Override
    public Role getRole() {
        return Role.MEMBER;
    }

    @Override
    public NotificationRootType getRootType() {
        return NotificationRootType.PERSONAL;
    }

    public String prefix() {
        return PREFIX;
    }

    static {
        PREFIX = NotificationRootType.PERSONAL.name();
    }
}

